/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collection;
import java.util.List;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.spi.IndexQueryFactory;
import org.forgerock.opendj.ldap.spi.Indexer;

abstract class AbstractMatchingRuleImpl
implements MatchingRuleImpl {
    AbstractMatchingRuleImpl() {
    }

    static DefaultAssertion named(String indexID, ByteSequence normalizedAssertionValue) {
        return new DefaultAssertion(indexID, normalizedAssertionValue);
    }

    String keyToHumanReadableString(ByteSequence key) {
        return key.toByteString().toHexString();
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence assertionValue) throws DecodeException {
        return Assertion.UNDEFINED_ASSERTION;
    }

    @Override
    public Assertion getSubstringAssertion(Schema schema, ByteSequence subInitial, List<? extends ByteSequence> subAnyElements, ByteSequence subFinal) throws DecodeException {
        return Assertion.UNDEFINED_ASSERTION;
    }

    @Override
    public Assertion getGreaterOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        return Assertion.UNDEFINED_ASSERTION;
    }

    @Override
    public Assertion getLessOrEqualAssertion(Schema schema, ByteSequence value) throws DecodeException {
        return Assertion.UNDEFINED_ASSERTION;
    }

    final class DefaultIndexer
    implements Indexer {
        private final String indexID;

        DefaultIndexer(String indexID) {
            this.indexID = indexID;
        }

        @Override
        public void createKeys(Schema schema, ByteSequence value, Collection<ByteString> keys) throws DecodeException {
            keys.add(AbstractMatchingRuleImpl.this.normalizeAttributeValue(schema, value));
        }

        @Override
        public String keyToHumanReadableString(ByteSequence key) {
            return AbstractMatchingRuleImpl.this.keyToHumanReadableString(key);
        }

        @Override
        public String getIndexID() {
            return this.indexID;
        }
    }

    private static final class DefaultAssertion
    implements Assertion {
        private final String indexID;
        private final ByteSequence normalizedAssertionValue;

        private DefaultAssertion(String indexID, ByteSequence normalizedAssertionValue) {
            this.indexID = indexID;
            this.normalizedAssertionValue = normalizedAssertionValue;
        }

        @Override
        public ConditionResult matches(ByteSequence normalizedAttributeValue) {
            return ConditionResult.valueOf(this.normalizedAssertionValue.equals(normalizedAttributeValue));
        }

        @Override
        public <T> T createIndexQuery(IndexQueryFactory<T> factory) throws DecodeException {
            return factory.createExactMatchQuery(this.indexID, this.normalizedAssertionValue);
        }
    }
}

