/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.Result;

public abstract class AbstractExtendedResultDecoder<S extends ExtendedResult>
implements ExtendedResultDecoder<S> {
    protected AbstractExtendedResultDecoder() {
    }

    @Override
    public S adaptDecodeException(DecodeException exception) {
        S adaptedResult = this.newExtendedErrorResult(ResultCode.PROTOCOL_ERROR, "", exception.getMessage());
        adaptedResult.setCause(exception.getCause());
        return adaptedResult;
    }

    @Override
    public <R extends ExtendedResult> LdapResultHandler<S> adaptExtendedResultHandler(final ExtendedRequest<R> request, final LdapResultHandler<? super R> resultHandler, final DecodeOptions options) {
        return new LdapResultHandler<S>(){

            @Override
            public void handleException(LdapException error) {
                Result result = error.getResult();
                Object adaptedResult = request.getResultDecoder().newExtendedErrorResult(result.getResultCode(), result.getMatchedDN(), result.getDiagnosticMessage());
                adaptedResult.setCause(result.getCause());
                resultHandler.handleException(LdapException.newLdapException(adaptedResult));
            }

            @Override
            public void handleResult(S result) {
                try {
                    Object adaptedResult = request.getResultDecoder().decodeExtendedResult((ExtendedResult)result, options);
                    resultHandler.handleResult(adaptedResult);
                }
                catch (DecodeException e) {
                    Object adaptedResult = request.getResultDecoder().adaptDecodeException(e);
                    resultHandler.handleException(LdapException.newLdapException(adaptedResult));
                }
            }
        };
    }

    @Override
    public abstract S decodeExtendedResult(ExtendedResult var1, DecodeOptions var2) throws DecodeException;

    @Override
    public abstract S newExtendedErrorResult(ResultCode var1, String var2, String var3);
}

