/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import org.forgerock.opendj.ldap.ConnectionSecurityLayer;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.BindClient;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequestImpl;
import org.forgerock.opendj.ldap.responses.BindResult;

class BindClientImpl
implements BindClient,
ConnectionSecurityLayer {
    private final GenericBindRequest nextBindRequest;

    BindClientImpl(BindRequest initialBindRequest) {
        this.nextBindRequest = new GenericBindRequestImpl(initialBindRequest.getName(), initialBindRequest.getAuthenticationType(), new byte[0], this);
        for (Control control : initialBindRequest.getControls()) {
            this.nextBindRequest.addControl(control);
        }
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean evaluateResult(BindResult result) throws LdapException {
        return true;
    }

    @Override
    public ConnectionSecurityLayer getConnectionSecurityLayer() {
        return null;
    }

    @Override
    public final GenericBindRequest nextBindRequest() {
        return this.nextBindRequest;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws LdapException {
        byte[] copy = new byte[len];
        System.arraycopy(incoming, offset, copy, 0, len);
        return copy;
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws LdapException {
        byte[] copy = new byte[len];
        System.arraycopy(outgoing, offset, copy, 0, len);
        return copy;
    }

    final BindClient setNextAuthenticationValue(byte[] authenticationValue) {
        this.nextBindRequest.setAuthenticationValue(authenticationValue);
        return this;
    }
}

