/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.ReferenceCountedObject;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.TimeoutEventListener;

public final class TimeoutChecker {
    public static final ReferenceCountedObject<TimeoutChecker> TIMEOUT_CHECKER = new ReferenceCountedObject<TimeoutChecker>(){

        @Override
        protected void destroyInstance(TimeoutChecker instance) {
            instance.shutdown();
        }

        @Override
        protected TimeoutChecker newInstance() {
            return new TimeoutChecker();
        }
    };
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final Object stateLock = new Object();
    private final Set<TimeoutEventListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile boolean shutdownRequested;
    private volatile long pendingListenerMinDelay = Long.MAX_VALUE;

    private TimeoutChecker() {
        Thread checkerThread = new Thread("OpenDJ LDAP SDK Timeout Checker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.debug(LocalizableMessage.raw((CharSequence)"Timeout Checker Starting", (Object[])new Object[0]));
                while (!TimeoutChecker.this.shutdownRequested) {
                    long currentTime = System.currentTimeMillis();
                    long delay = Long.MAX_VALUE;
                    TimeoutChecker.this.pendingListenerMinDelay = Long.MAX_VALUE;
                    for (TimeoutEventListener listener : TimeoutChecker.this.listeners) {
                        logger.trace(LocalizableMessage.raw((CharSequence)"Checking connection %s delay = %d", (Object[])new Object[]{listener, delay}));
                        long newDelay = listener.handleTimeout(currentTime);
                        if (newDelay <= 0L) continue;
                        delay = Math.min(newDelay, delay);
                    }
                    try {
                        Object i$ = TimeoutChecker.this.stateLock;
                        synchronized (i$) {
                            delay = Math.min(TimeoutChecker.this.pendingListenerMinDelay, delay);
                            if (TimeoutChecker.this.shutdownRequested) {
                                break;
                            }
                            if (delay <= 0L) {
                                TimeoutChecker.this.stateLock.wait();
                            } else {
                                TimeoutChecker.this.stateLock.wait(delay);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        TimeoutChecker.this.shutdownRequested = true;
                    }
                }
            }
        };
        checkerThread.setDaemon(true);
        checkerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TimeoutEventListener listener) {
        long timeout = listener.getTimeout();
        if (timeout > 0L) {
            this.listeners.add(listener);
            Object object = this.stateLock;
            synchronized (object) {
                this.pendingListenerMinDelay = Math.min(this.pendingListenerMinDelay, timeout);
                this.stateLock.notifyAll();
            }
        }
    }

    public void removeListener(TimeoutEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        Object object = this.stateLock;
        synchronized (object) {
            this.shutdownRequested = true;
            this.stateLock.notifyAll();
        }
    }
}

