/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import java.io.Closeable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import javax.net.ssl.SSLContext;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.AuthenticationException;
import org.forgerock.opendj.ldap.CancelledResultException;
import org.forgerock.opendj.ldap.CommonLDAPOptions;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TimeoutResultException;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.StartTLSExtendedRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldap.spi.ConnectionState;
import org.forgerock.opendj.ldap.spi.LDAPConnectionFactoryImpl;
import org.forgerock.opendj.ldap.spi.LDAPConnectionImpl;
import org.forgerock.opendj.ldap.spi.LdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.PromiseImpl;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.time.Duration;
import org.forgerock.util.time.TimeService;

public final class LDAPConnectionFactory
extends CommonLDAPOptions
implements ConnectionFactory {
    public static final Option<BindRequest> AUTHN_BIND_REQUEST = Option.of(BindRequest.class, null);
    public static final Option<Duration> CONNECT_TIMEOUT = Option.withDefault((Object)new Duration(Long.valueOf(LDAPConnectionFactory.getIntProperty("org.forgerock.opendj.io.connectTimeout", 10000)), TimeUnit.MILLISECONDS));
    public static final Option<Boolean> HEARTBEAT_ENABLED = Option.withDefault((Object)false);
    public static final Option<Duration> HEARTBEAT_INTERVAL = Option.withDefault((Object)new Duration(Long.valueOf(10L), TimeUnit.SECONDS));
    public static final Option<ScheduledExecutorService> HEARTBEAT_SCHEDULER = Option.of(ScheduledExecutorService.class, null);
    public static final Option<Duration> HEARTBEAT_TIMEOUT = Option.withDefault((Object)new Duration(Long.valueOf(3L), TimeUnit.SECONDS));
    public static final Option<Duration> REQUEST_TIMEOUT = Option.withDefault((Object)new Duration(Long.valueOf(LDAPConnectionFactory.getIntProperty("org.forgerock.opendj.io.requestTimeout", LDAPConnectionFactory.getIntProperty("org.forgerock.opendj.io.timeout", 0))), TimeUnit.MILLISECONDS));
    public static final Option<SSLContext> SSL_CONTEXT = Option.of(SSLContext.class, null);
    public static final Option<List<String>> SSL_ENABLED_CIPHER_SUITES = Option.of(List.class, Collections.emptyList());
    public static final Option<List<String>> SSL_ENABLED_PROTOCOLS = Option.of(List.class, Collections.emptyList());
    public static final Option<Boolean> SSL_USE_STARTTLS = Option.withDefault((Object)false);
    private static final SearchRequest DEFAULT_HEARTBEAT = Requests.unmodifiableSearchRequest(Requests.newSearchRequest("", SearchScope.BASE_OBJECT, "(objectClass=*)", "1.1"));
    public static final Option<SearchRequest> HEARTBEAT_SEARCH_REQUEST = Option.of(SearchRequest.class, (Object)DEFAULT_HEARTBEAT);
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final long connectTimeoutMS;
    private final long heartBeatDelayMS;
    private final Boolean heartBeatEnabled;
    private final SearchRequest heartBeatRequest;
    private final long heartBeatTimeoutMS;
    private final long heartBeatintervalMS;
    private final LDAPConnectionFactoryImpl impl;
    private final BindRequest initialBindRequest;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final Options options;
    private final TransportProvider provider;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private final ReferenceCountedObject.Reference scheduler;
    private final SSLContext sslContext;
    private final List<String> sslEnabledCipherSuites;
    private final List<String> sslEnabledProtocols;
    private final boolean sslUseStartTLS;
    private final List<ConnectionImpl> validConnections = new LinkedList<ConnectionImpl>();
    TimeService timeService = TimeService.SYSTEM;
    private final Runnable sendHeartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            boolean heartBeatSent = false;
            for (ConnectionImpl connection : LDAPConnectionFactory.this.getValidConnections()) {
                heartBeatSent |= connection.sendHeartBeat();
            }
            if (heartBeatSent) {
                ((ScheduledExecutorService)LDAPConnectionFactory.this.scheduler.get()).schedule(LDAPConnectionFactory.this.checkHeartBeatRunnable, LDAPConnectionFactory.this.heartBeatTimeoutMS, TimeUnit.MILLISECONDS);
            }
        }
    };
    private final Runnable checkHeartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            for (ConnectionImpl connection : LDAPConnectionFactory.this.getValidConnections()) {
                connection.checkForHeartBeat();
            }
        }
    };
    private ScheduledFuture<?> heartBeatFuture;

    public LDAPConnectionFactory(String host, int port) {
        this(host, port, Options.defaultOptions());
    }

    public LDAPConnectionFactory(String host, int port, Options options) {
        Reject.ifNull((Object[])new Object[]{host, options});
        this.connectTimeoutMS = ((Duration)options.get(CONNECT_TIMEOUT)).to(TimeUnit.MILLISECONDS);
        Reject.ifTrue((this.connectTimeoutMS < 0L ? 1 : 0) != 0, (String)"connect timeout must be >= 0");
        Reject.ifTrue((((Duration)options.get(REQUEST_TIMEOUT)).getValue() < 0L ? 1 : 0) != 0, (String)"request timeout must be >= 0");
        this.heartBeatEnabled = (Boolean)options.get(HEARTBEAT_ENABLED);
        this.heartBeatintervalMS = ((Duration)options.get(HEARTBEAT_INTERVAL)).to(TimeUnit.MILLISECONDS);
        this.heartBeatTimeoutMS = ((Duration)options.get(HEARTBEAT_TIMEOUT)).to(TimeUnit.MILLISECONDS);
        this.heartBeatDelayMS = this.heartBeatintervalMS / 2L;
        this.heartBeatRequest = (SearchRequest)options.get(HEARTBEAT_SEARCH_REQUEST);
        if (this.heartBeatEnabled.booleanValue()) {
            Reject.ifTrue((this.heartBeatintervalMS <= 0L ? 1 : 0) != 0, (String)"heart-beat interval must be positive");
            Reject.ifTrue((this.heartBeatTimeoutMS <= 0L ? 1 : 0) != 0, (String)"heart-beat timeout must be positive");
        }
        this.provider = LDAPConnectionFactory.getTransportProvider(options);
        this.scheduler = StaticUtils.DEFAULT_SCHEDULER.acquireIfNull((ScheduledExecutorService)options.get(HEARTBEAT_SCHEDULER));
        this.impl = this.provider.getLDAPConnectionFactory(host, port, options);
        this.initialBindRequest = (BindRequest)options.get(AUTHN_BIND_REQUEST);
        this.sslContext = (SSLContext)options.get(SSL_CONTEXT);
        this.sslUseStartTLS = (Boolean)options.get(SSL_USE_STARTTLS);
        this.sslEnabledProtocols = (List)options.get(SSL_ENABLED_PROTOCOLS);
        this.sslEnabledCipherSuites = (List)options.get(SSL_ENABLED_CIPHER_SUITES);
        this.options = Options.copyOf((Options)options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            List<ConnectionImpl> list = this.validConnections;
            synchronized (list) {
                if (!this.validConnections.isEmpty()) {
                    logger.debug(LocalizableMessage.raw((CharSequence)"HeartbeatConnectionFactory '%s' is closing while %d active connections remain", (Object[])new Object[]{this, this.validConnections.size()}));
                }
            }
            this.releaseScheduler();
            this.impl.close();
        }
    }

    @Override
    public Connection getConnection() throws LdapException {
        return (Connection)this.getConnectionAsync().getOrThrowUninterruptibly();
    }

    @Override
    public Promise<Connection, LdapException> getConnectionAsync() {
        this.acquireScheduler();
        final PromiseImpl promise = PromiseImpl.create();
        final AtomicReference<LDAPConnectionImpl> connectionHolder = new AtomicReference<LDAPConnectionImpl>();
        final ScheduledFuture<?> timeoutFuture = this.connectTimeoutMS > 0L ? ((ScheduledExecutorService)this.scheduler.get()).schedule(new Runnable(){

            @Override
            public void run() {
                if (promise.tryHandleException((Exception)LDAPConnectionFactory.this.newConnectTimeoutError())) {
                    Utils.closeSilently((Closeable[])new Closeable[]{(Closeable)connectionHolder.get()});
                    LDAPConnectionFactory.this.releaseScheduler();
                }
            }
        }, this.connectTimeoutMS, TimeUnit.MILLISECONDS) : null;
        this.impl.getConnectionAsync().then((Function)new Function<LDAPConnectionImpl, LDAPConnectionImpl, LdapException>(){

            public LDAPConnectionImpl apply(LDAPConnectionImpl connection) throws LdapException {
                connectionHolder.set(connection);
                return connection;
            }
        }).thenAsync(this.performStartTLSIfNeeded()).thenAsync(this.performSSLHandShakeIfNeeded(connectionHolder)).thenAsync(this.performInitialBindIfNeeded(connectionHolder)).thenAsync(this.performInitialHeartBeatIfNeeded(connectionHolder)).thenOnResult((ResultHandler)new ResultHandler<Result>(){

            public void handleResult(Result result) {
                LDAPConnectionImpl connection;
                ConnectionImpl connectionImpl;
                if (timeoutFuture != null) {
                    timeoutFuture.cancel(false);
                }
                if (!promise.tryHandleResult((Object)LDAPConnectionFactory.this.registerConnection(connectionImpl = new ConnectionImpl(connection = (LDAPConnectionImpl)connectionHolder.get())))) {
                    connectionImpl.close();
                }
            }
        }).thenOnException((ExceptionHandler)new ExceptionHandler<LdapException>(){

            public void handleException(LdapException e) {
                LdapException connectException;
                if (timeoutFuture != null) {
                    timeoutFuture.cancel(false);
                }
                if (promise.tryHandleException((Exception)(connectException = e instanceof ConnectionException || e instanceof AuthenticationException ? e : (e instanceof TimeoutResultException ? LDAPConnectionFactory.this.newHeartBeatTimeoutError() : LdapException.newLdapException(ResultCode.CLIENT_SIDE_SERVER_DOWN, (CharSequence)CoreMessages.HBCF_HEARTBEAT_FAILED.get(), e))))) {
                    Utils.closeSilently((Closeable[])new Closeable[]{(Closeable)connectionHolder.get()});
                    LDAPConnectionFactory.this.releaseScheduler();
                }
            }
        });
        return promise;
    }

    public String getHostName() {
        return this.impl.getHostName();
    }

    public int getPort() {
        return this.impl.getPort();
    }

    public String getProviderName() {
        return this.provider.getName();
    }

    public String toString() {
        return "LDAPConnectionFactory(provider=`" + this.getProviderName() + ", host='" + this.getHostName() + "', port=" + this.getPort() + ", options=" + this.options + ")";
    }

    private void acquireScheduler() {
        this.referenceCount.incrementAndGet();
        if (this.isClosed.get()) {
            this.releaseScheduler();
            throw new IllegalStateException("Attempted to get a connection on closed factory");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionImpl[] getValidConnections() {
        List<ConnectionImpl> list = this.validConnections;
        synchronized (list) {
            return this.validConnections.toArray(new ConnectionImpl[this.validConnections.size()]);
        }
    }

    private LdapException newConnectTimeoutError() {
        LocalizableMessage msg = CoreMessages.LDAP_CONNECTION_CONNECT_TIMEOUT.get((Object)this.impl.getSocketAddress(), (Object)this.connectTimeoutMS);
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, msg.toString());
    }

    private LdapException newHeartBeatTimeoutError() {
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_SERVER_DOWN, (CharSequence)CoreMessages.HBCF_HEARTBEAT_TIMEOUT.get((Object)this.heartBeatTimeoutMS));
    }

    private AsyncFunction<Void, BindResult, LdapException> performInitialBindIfNeeded(final AtomicReference<LDAPConnectionImpl> connectionHolder) {
        return new AsyncFunction<Void, BindResult, LdapException>(){

            public Promise<BindResult, LdapException> apply(Void ignored) throws LdapException {
                if (LDAPConnectionFactory.this.initialBindRequest != null) {
                    return ((LDAPConnectionImpl)connectionHolder.get()).bindAsync(LDAPConnectionFactory.this.initialBindRequest, null);
                }
                return Promises.newResultPromise((Object)Responses.newBindResult(ResultCode.SUCCESS));
            }
        };
    }

    private AsyncFunction<BindResult, Result, LdapException> performInitialHeartBeatIfNeeded(final AtomicReference<LDAPConnectionImpl> connectionHolder) {
        return new AsyncFunction<BindResult, Result, LdapException>(){

            public Promise<Result, LdapException> apply(BindResult ignored) throws LdapException {
                if (LDAPConnectionFactory.this.heartBeatEnabled.booleanValue() && LDAPConnectionFactory.this.sslContext == null && LDAPConnectionFactory.this.initialBindRequest == null) {
                    return ((LDAPConnectionImpl)connectionHolder.get()).searchAsync(LDAPConnectionFactory.this.heartBeatRequest, null, null);
                }
                return Promises.newResultPromise((Object)Responses.newResult(ResultCode.SUCCESS));
            }
        };
    }

    private AsyncFunction<ExtendedResult, Void, LdapException> performSSLHandShakeIfNeeded(final AtomicReference<LDAPConnectionImpl> connectionHolder) {
        return new AsyncFunction<ExtendedResult, Void, LdapException>(){

            public Promise<Void, LdapException> apply(ExtendedResult extendedResult) throws LdapException {
                if (LDAPConnectionFactory.this.sslContext != null && !LDAPConnectionFactory.this.sslUseStartTLS) {
                    return ((LDAPConnectionImpl)connectionHolder.get()).enableTLS(LDAPConnectionFactory.this.sslContext, LDAPConnectionFactory.this.sslEnabledProtocols, LDAPConnectionFactory.this.sslEnabledCipherSuites);
                }
                return Promises.newResultPromise(null);
            }
        };
    }

    private AsyncFunction<LDAPConnectionImpl, ExtendedResult, LdapException> performStartTLSIfNeeded() {
        return new AsyncFunction<LDAPConnectionImpl, ExtendedResult, LdapException>(){

            public Promise<ExtendedResult, LdapException> apply(LDAPConnectionImpl connection) throws LdapException {
                if (LDAPConnectionFactory.this.sslContext != null && LDAPConnectionFactory.this.sslUseStartTLS) {
                    StartTLSExtendedRequest startTLS = Requests.newStartTLSExtendedRequest(LDAPConnectionFactory.this.sslContext).addEnabledCipherSuite(LDAPConnectionFactory.this.sslEnabledCipherSuites).addEnabledProtocol(LDAPConnectionFactory.this.sslEnabledProtocols);
                    return connection.extendedRequestAsync(startTLS, null);
                }
                return Promises.newResultPromise((Object)Responses.newGenericExtendedResult(ResultCode.SUCCESS));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection registerConnection(ConnectionImpl heartBeatConnection) {
        List<ConnectionImpl> list = this.validConnections;
        synchronized (list) {
            if (this.heartBeatEnabled.booleanValue() && this.validConnections.isEmpty()) {
                this.heartBeatFuture = ((ScheduledExecutorService)this.scheduler.get()).scheduleWithFixedDelay(this.sendHeartBeatRunnable, 0L, this.heartBeatintervalMS, TimeUnit.MILLISECONDS);
            }
            this.validConnections.add(heartBeatConnection);
        }
        return heartBeatConnection;
    }

    private void releaseScheduler() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.scheduler.release();
        }
    }

    private final class ConnectionImpl
    extends AbstractAsynchronousConnection
    implements ConnectionEventListener {
        private final LDAPConnectionImpl connectionImpl;
        private final Queue<Runnable> pendingBindOrStartTLSRequests = new ConcurrentLinkedQueue<Runnable>();
        private final Queue<LdapResultHandler<?>> pendingResults = new ConcurrentLinkedQueue();
        private final ConnectionState state = new ConnectionState();
        private final Sync sync = new Sync();
        private volatile long lastResponseTimestamp;

        private ConnectionImpl(LDAPConnectionImpl connectionImpl) {
            this.lastResponseTimestamp = LDAPConnectionFactory.this.timeService.now();
            this.connectionImpl = connectionImpl;
            connectionImpl.addConnectionEventListener(this);
        }

        @Override
        public LdapPromise<Void> abandonAsync(AbandonRequest request) {
            return this.connectionImpl.abandonAsync(request);
        }

        @Override
        public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.addAsync(request, intermediateResponseHandler));
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.state.addConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<BindResult> bindAsync(final BindRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            if (this.sync.tryLockShared()) {
                return this.timestampBindOrStartTLSPromise(this.connectionImpl.bindAsync(request, intermediateResponseHandler));
            }
            return this.enqueueBindOrStartTLSPromise(new AsyncFunction<Void, BindResult, LdapException>(){

                public Promise<BindResult, LdapException> apply(Void value) throws LdapException {
                    return ConnectionImpl.this.timestampBindOrStartTLSPromise(ConnectionImpl.this.connectionImpl.bindAsync(request, intermediateResponseHandler));
                }
            });
        }

        @Override
        public void close() {
            this.handleConnectionClosed();
            this.connectionImpl.close();
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.handleConnectionClosed();
            this.connectionImpl.close(request, reason);
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.compareAsync(request, intermediateResponseHandler));
        }

        @Override
        public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.deleteAsync(request, intermediateResponseHandler));
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(final ExtendedRequest<R> request, final IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            if (!this.isStartTLSRequest(request)) {
                return this.timestampPromise(this.connectionImpl.extendedRequestAsync(request, intermediateResponseHandler));
            }
            if (this.sync.tryLockShared()) {
                return this.timestampBindOrStartTLSPromise(this.connectionImpl.extendedRequestAsync(request, intermediateResponseHandler));
            }
            return this.enqueueBindOrStartTLSPromise(new AsyncFunction<Void, R, LdapException>(){

                public Promise<R, LdapException> apply(Void value) throws LdapException {
                    return ConnectionImpl.this.timestampBindOrStartTLSPromise(ConnectionImpl.this.connectionImpl.extendedRequestAsync(request, intermediateResponseHandler));
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleConnectionClosed() {
            if (this.state.notifyConnectionClosed()) {
                this.failPendingResults(LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED, (CharSequence)CoreMessages.HBCF_CONNECTION_CLOSED_BY_CLIENT.get()));
                List list = LDAPConnectionFactory.this.validConnections;
                synchronized (list) {
                    this.connectionImpl.removeConnectionEventListener(this);
                    LDAPConnectionFactory.this.validConnections.remove(this);
                    if (LDAPConnectionFactory.this.heartBeatEnabled.booleanValue() && LDAPConnectionFactory.this.validConnections.isEmpty()) {
                        LDAPConnectionFactory.this.heartBeatFuture.cancel(false);
                    }
                }
                LDAPConnectionFactory.this.releaseScheduler();
            }
        }

        @Override
        public void handleConnectionError(boolean isDisconnectNotification, LdapException error) {
            if (this.state.notifyConnectionError(isDisconnectNotification, error)) {
                this.failPendingResults(error);
            }
        }

        @Override
        public void handleUnsolicitedNotification(ExtendedResult notification) {
            this.timestamp(notification);
            this.state.notifyUnsolicitedNotification(notification);
        }

        @Override
        public boolean isClosed() {
            return this.state.isClosed();
        }

        @Override
        public boolean isValid() {
            return this.state.isValid() && this.connectionImpl.isValid();
        }

        @Override
        public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.modifyAsync(request, intermediateResponseHandler));
        }

        @Override
        public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            return this.timestampPromise(this.connectionImpl.modifyDNAsync(request, intermediateResponseHandler));
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.state.removeConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, final SearchResultHandler searchHandler) {
            if (this.hasConnectionErrorOccurred()) {
                return this.newConnectionErrorPromise();
            }
            final AtomicBoolean searchDone = new AtomicBoolean();
            SearchResultHandler entryHandler = new SearchResultHandler(){

                @Override
                public synchronized boolean handleEntry(SearchResultEntry entry) {
                    if (!searchDone.get()) {
                        ConnectionImpl.this.timestamp(entry);
                        if (searchHandler != null) {
                            searchHandler.handleEntry(entry);
                        }
                    }
                    return true;
                }

                @Override
                public synchronized boolean handleReference(SearchResultReference reference) {
                    if (!searchDone.get()) {
                        ConnectionImpl.this.timestamp(reference);
                        if (searchHandler != null) {
                            searchHandler.handleReference(reference);
                        }
                    }
                    return true;
                }
            };
            return this.timestampPromise(this.connectionImpl.searchAsync(request, intermediateResponseHandler, entryHandler).thenOnResultOrException(new Runnable(){

                @Override
                public void run() {
                    searchDone.getAndSet(true);
                }
            }));
        }

        @Override
        public String toString() {
            return this.connectionImpl.toString();
        }

        private void checkForHeartBeat() {
            long currentTimeMillis;
            if (this.sync.isHeld() && this.lastResponseTimestamp < (currentTimeMillis = LDAPConnectionFactory.this.timeService.now()) - LDAPConnectionFactory.this.heartBeatTimeoutMS) {
                logger.warn(LocalizableMessage.raw((CharSequence)"No heartbeat detected for connection '%s'", (Object[])new Object[]{this.connectionImpl}));
                this.handleConnectionError(false, LDAPConnectionFactory.this.newHeartBeatTimeoutError());
            }
        }

        private boolean hasConnectionErrorOccurred() {
            return this.state.getConnectionError() != null;
        }

        private <R extends Result> LdapPromise<R> enqueueBindOrStartTLSPromise(AsyncFunction<Void, R, LdapException> doRequest) {
            final LdapPromiseImpl promise = LdapPromiseImpl.newLdapPromiseImpl();
            final LdapPromise result = promise.thenAsync((AsyncFunction)doRequest);
            this.pendingBindOrStartTLSRequests.offer(new Runnable(){

                @Override
                public void run() {
                    if (!result.isCancelled()) {
                        ConnectionImpl.this.sync.lockShared();
                        promise.handleResult(null);
                    }
                }
            });
            this.flushPendingBindOrStartTLSRequests();
            return result;
        }

        private void failPendingResults(LdapException error) {
            LdapResultHandler<?> pendingResult;
            while ((pendingResult = this.pendingResults.peek()) != null) {
                pendingResult.handleException(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushPendingBindOrStartTLSRequests() {
            if (!this.pendingBindOrStartTLSRequests.isEmpty() && this.sync.tryLockShared()) {
                try {
                    Runnable pendingRequest;
                    while ((pendingRequest = this.pendingBindOrStartTLSRequests.poll()) != null) {
                        pendingRequest.run();
                    }
                }
                finally {
                    this.sync.unlockShared();
                }
            }
        }

        private boolean isStartTLSRequest(ExtendedRequest<?> request) {
            return request.getOID().equals("1.3.6.1.4.1.1466.20037");
        }

        private <R> LdapPromise<R> newConnectionErrorPromise() {
            return LdapPromises.newFailedLdapPromise(this.state.getConnectionError());
        }

        private void releaseBindOrStartTLSLock() {
            this.sync.unlockShared();
        }

        private void releaseHeartBeatLock() {
            this.sync.unlockExclusively();
            this.flushPendingBindOrStartTLSRequests();
        }

        private boolean sendHeartBeat() {
            if (!this.state.isValid()) {
                return false;
            }
            long currentTimeMillis = LDAPConnectionFactory.this.timeService.now();
            if (currentTimeMillis < this.lastResponseTimestamp + LDAPConnectionFactory.this.heartBeatDelayMS) {
                return false;
            }
            if (this.sync.tryLockExclusively()) {
                try {
                    this.connectionImpl.searchAsync(LDAPConnectionFactory.this.heartBeatRequest, null, new SearchResultHandler(){

                        @Override
                        public boolean handleEntry(SearchResultEntry entry) {
                            ConnectionImpl.this.timestamp(entry);
                            return true;
                        }

                        @Override
                        public boolean handleReference(SearchResultReference reference) {
                            ConnectionImpl.this.timestamp(reference);
                            return true;
                        }
                    }).thenOnResult(new ResultHandler<Result>(){

                        public void handleResult(Result result) {
                            ConnectionImpl.this.timestamp(result);
                            ConnectionImpl.this.releaseHeartBeatLock();
                        }
                    }).thenOnException(new ExceptionHandler<LdapException>(){

                        public void handleException(LdapException exception) {
                            if (!(exception instanceof CancelledResultException)) {
                                logger.debug(LocalizableMessage.raw((CharSequence)"Heartbeat failed for connection factory '%s'", (Object[])new Object[]{LDAPConnectionFactory.this, exception}));
                                ConnectionImpl.this.timestamp(exception);
                            }
                            ConnectionImpl.this.releaseHeartBeatLock();
                        }
                    });
                }
                catch (IllegalStateException e) {
                    this.releaseHeartBeatLock();
                }
            }
            return true;
        }

        private <R> R timestamp(R response) {
            if (!(response instanceof ConnectionException)) {
                this.lastResponseTimestamp = LDAPConnectionFactory.this.timeService.now();
            }
            return response;
        }

        private <R extends Result> LdapPromise<R> timestampBindOrStartTLSPromise(LdapPromise<R> wrappedPromise) {
            return this.timestampPromise(wrappedPromise).thenOnResultOrException(new Runnable(){

                @Override
                public void run() {
                    ConnectionImpl.this.releaseBindOrStartTLSLock();
                }
            });
        }

        private <R extends Result> LdapPromise<R> timestampPromise(LdapPromise<R> wrappedPromise) {
            final LdapPromiseImplWrapper<R> outerPromise = new LdapPromiseImplWrapper<R>(wrappedPromise);
            this.pendingResults.add(outerPromise);
            wrappedPromise.thenOnResult(new ResultHandler<R>(){

                public void handleResult(R result) {
                    outerPromise.handleResult(result);
                    ConnectionImpl.this.timestamp(result);
                }
            }).thenOnException(new ExceptionHandler<LdapException>(){

                public void handleException(LdapException exception) {
                    outerPromise.handleException(exception);
                    ConnectionImpl.this.timestamp(exception);
                }
            });
            outerPromise.thenOnResultOrException(new Runnable(){

                @Override
                public void run() {
                    ConnectionImpl.this.pendingResults.remove(outerPromise);
                }
            });
            if (this.hasConnectionErrorOccurred()) {
                outerPromise.handleException(this.state.getConnectionError());
            }
            return outerPromise;
        }

        private class LdapPromiseImplWrapper<R>
        extends LdapPromiseImpl<R> {
            protected LdapPromiseImplWrapper(final LdapPromise<R> wrappedPromise) {
                super(new PromiseImpl<R, LdapException>(){

                    protected LdapException tryCancel(boolean mayInterruptIfRunning) {
                        wrappedPromise.cancel(mayInterruptIfRunning);
                        return null;
                    }
                }, wrappedPromise.getRequestID());
            }
        }
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int LOCKED_EXCLUSIVELY = -1;
        private static final int UNLOCKED = 0;
        private static final long serialVersionUID = -3590428415442668336L;

        private Sync() {
        }

        boolean isHeld() {
            return this.getState() != 0;
        }

        void lockShared() {
            this.acquireShared(1);
        }

        boolean tryLockExclusively() {
            return this.tryAcquire(0);
        }

        boolean tryLockShared() {
            return this.tryAcquireShared(1) > 0;
        }

        void unlockExclusively() {
            this.release(0);
        }

        void unlockShared() {
            this.releaseShared(0);
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() == -1;
        }

        @Override
        protected boolean tryAcquire(int ignored) {
            if (this.compareAndSetState(0, -1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected int tryAcquireShared(int readers) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != -1) continue;
                return -1;
            } while (!this.compareAndSetState(state, newState = state + readers));
            return newState;
        }

        @Override
        protected boolean tryRelease(int ignored) {
            if (this.getState() != -1) {
                throw new IllegalMonitorStateException();
            }
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        protected boolean tryReleaseShared(int ignored) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != 0 && state != -1) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(state, newState = state - 1));
            return newState == 0;
        }
    }
}

