/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.services.routing;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.forgerock.services.context.Context;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.services.routing.RouteMatch;
import org.forgerock.services.routing.RouteMatcher;
import org.forgerock.util.Pair;

public abstract class AbstractRouter<T extends AbstractRouter<T, R, H>, R, H> {
    private final Map<RouteMatcher<R>, H> routes = new ConcurrentHashMap<RouteMatcher<R>, H>();
    private volatile H defaultRoute;

    protected AbstractRouter() {
    }

    protected AbstractRouter(AbstractRouter<T, R, H> router) {
        this.defaultRoute = router.defaultRoute;
        this.addAllRoutes(router);
    }

    protected abstract T getThis();

    final Map<RouteMatcher<R>, H> getRoutes() {
        return Collections.unmodifiableMap(this.routes);
    }

    public final T addAllRoutes(T router) {
        if (this != router) {
            for (Map.Entry<RouteMatcher<R>, H> route : ((AbstractRouter)router).getRoutes().entrySet()) {
                this.addRoute(route.getKey(), route.getValue());
            }
        }
        return this.getThis();
    }

    public final T addRoute(RouteMatcher<R> matcher, H handler) {
        this.routes.put(matcher, handler);
        return this.getThis();
    }

    public final T setDefaultRoute(H handler) {
        this.defaultRoute = handler;
        return this.getThis();
    }

    final H getDefaultRoute() {
        return this.defaultRoute;
    }

    public final T removeAllRoutes() {
        this.routes.clear();
        return this.getThis();
    }

    @SafeVarargs
    public final boolean removeRoute(RouteMatcher<R> ... routes) {
        boolean isModified = false;
        for (RouteMatcher<R> route : routes) {
            isModified |= this.routes.remove(route) != null;
        }
        return isModified;
    }

    protected Pair<Context, H> getBestRoute(Context context, R request) throws IncomparableRouteMatchException {
        Object handler = null;
        RouteMatch bestMatch = null;
        for (Map.Entry<RouteMatcher<R>, H> route : this.routes.entrySet()) {
            RouteMatch result = route.getKey().evaluate(context, request);
            if (result == null || !result.isBetterMatchThan(bestMatch)) continue;
            handler = route.getValue();
            bestMatch = result;
        }
        if (bestMatch != null) {
            return Pair.of((Object)bestMatch.decorateContext(context), handler);
        }
        handler = this.defaultRoute;
        if (handler != null) {
            return Pair.of((Object)context, handler);
        }
        return null;
    }
}

