/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import com.forgerock.opendj.ldap.config.ConfigMessages;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.DecodingException;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.util.Reject;

public class ServerManagedObjectDecodingException
extends DecodingException {
    private static final long serialVersionUID = 1598401431084729853L;
    private final Collection<PropertyException> causes;
    private final ServerManagedObject<?> partialManagedObject;

    private static LocalizableMessage createMessage(ServerManagedObject<?> partialManagedObject, Collection<PropertyException> causes) {
        Reject.ifNull(causes);
        Reject.ifFalse((!causes.isEmpty() ? 1 : 0) != 0, (String)"causes should nnot be empty");
        ManagedObjectDefinition<?, ?> d = partialManagedObject.getManagedObjectDefinition();
        if (causes.size() == 1) {
            return ConfigMessages.ERR_MANAGED_OBJECT_DECODING_EXCEPTION_SINGLE.get((Object)d.getUserFriendlyName(), (Object)causes.iterator().next().getMessageObject());
        }
        LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
        boolean isFirst = true;
        for (PropertyException cause : causes) {
            if (!isFirst) {
                builder.append((CharSequence)"; ");
            }
            builder.append(cause.getMessageObject());
            isFirst = false;
        }
        return ConfigMessages.ERR_MANAGED_OBJECT_DECODING_EXCEPTION_PLURAL.get((Object)d.getUserFriendlyName(), (Object)builder.toMessage());
    }

    public ServerManagedObjectDecodingException(ServerManagedObject<?> partialManagedObject, Collection<PropertyException> causes) {
        super(ServerManagedObjectDecodingException.createMessage(partialManagedObject, causes));
        this.partialManagedObject = partialManagedObject;
        this.causes = Collections.unmodifiableList(new LinkedList<PropertyException>(causes));
    }

    public Collection<PropertyException> getCauses() {
        return this.causes;
    }

    public ServerManagedObject<?> getPartialManagedObject() {
        return this.partialManagedObject;
    }
}

