/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.server;

import com.forgerock.opendj.ldap.config.ConfigMessages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.DecodingException;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.util.Reject;

public class ConstraintViolationException
extends DecodingException {
    private static final long serialVersionUID = -4902443848460011875L;
    private final ServerManagedObject<?> managedObject;
    private final Collection<LocalizableMessage> messages;

    private static LocalizableMessage getDefaultMessage(Collection<LocalizableMessage> messages) {
        Reject.ifNull(messages);
        Reject.ifFalse((!messages.isEmpty() ? 1 : 0) != 0, (String)"messages should not be empty");
        if (messages.size() == 1) {
            return ConfigMessages.ERR_CONSTRAINT_VIOLATION_EXCEPTION_SINGLE.get((Object)messages.iterator().next());
        }
        return ConfigMessages.ERR_CONSTRAINT_VIOLATION_EXCEPTION_PLURAL.get((Object)ConstraintViolationException.getSingleMessage(messages));
    }

    private static LocalizableMessage getSingleMessage(Collection<LocalizableMessage> messages) {
        if (messages.size() == 1) {
            return messages.iterator().next();
        }
        LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
        boolean isFirst = true;
        for (LocalizableMessage m : messages) {
            if (!isFirst) {
                builder.append((CharSequence)";  ");
            }
            builder.append(m);
            isFirst = false;
        }
        return builder.toMessage();
    }

    public ConstraintViolationException(ServerManagedObject<?> managedObject, Collection<LocalizableMessage> messages) {
        super(ConstraintViolationException.getDefaultMessage(messages));
        this.managedObject = managedObject;
        this.messages = new ArrayList<LocalizableMessage>(messages);
    }

    public ConstraintViolationException(ServerManagedObject<?> managedObject, LocalizableMessage message) {
        this(managedObject, Collections.singleton(message));
    }

    public Collection<LocalizableMessage> getMessages() {
        return Collections.unmodifiableCollection(this.messages);
    }

    public LocalizableMessage getMessagesAsSingleMessage() {
        return ConstraintViolationException.getSingleMessage(this.messages);
    }

    public ServerManagedObject<?> getManagedObject() {
        return this.managedObject;
    }
}

