/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.HelpCallback;
import com.forgerock.opendj.cli.Menu;
import com.forgerock.opendj.cli.MenuBuilder;
import com.forgerock.opendj.cli.MenuCallback;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.TableBuilder;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TextTablePrinter;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.config.AbsoluteInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AggregationPropertyDefinition;
import org.forgerock.opendj.config.AliasDefaultBehaviorProvider;
import org.forgerock.opendj.config.BooleanPropertyDefinition;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.DefaultBehaviorProviderVisitor;
import org.forgerock.opendj.config.DefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.EnumPropertyDefinition;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionUsageBuilder;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.RelativeInheritedDefaultBehaviorProvider;
import org.forgerock.opendj.config.UndefinedDefaultBehaviorProvider;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.dsconfig.ArgumentExceptionFactory;
import org.forgerock.opendj.config.dsconfig.CreateSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.DSConfig;
import org.forgerock.opendj.config.dsconfig.HelpSubCommandHandler;
import org.forgerock.opendj.config.dsconfig.PropertyEditorModification;
import org.forgerock.opendj.config.dsconfig.PropertyValuePrinter;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.util.Reject;

final class PropertyValueEditor {
    private static final int MULTI_COLUMN_THRESHOLD = 8;
    private final ConsoleApplication app;
    private final ManagementContext context;
    private final List<PropertyEditorModification<?>> mods = new ArrayList();
    private boolean isLastChoiceReset;

    private static void displayPropertyHeader(ConsoleApplication app, PropertyDefinition<?> pd) {
        app.println();
        app.println();
        app.println(DsconfigMessages.INFO_EDITOR_HEADING_CONFIGURE_PROPERTY.get((Object)pd.getName()));
        app.println();
        app.println(pd.getSynopsis(), 4);
        if (pd.getDescription() != null) {
            app.println();
            app.println(pd.getDescription(), 4);
        }
    }

    private static <T> void displayPropertySyntax(ConsoleApplication app, PropertyDefinition<T> d) {
        PropertyDefinitionUsageBuilder b = new PropertyDefinitionUsageBuilder(true);
        TableBuilder builder = new TableBuilder();
        builder.startRow();
        builder.appendCell((Object)DsconfigMessages.INFO_EDITOR_HEADING_SYNTAX.get());
        builder.appendCell((Object)b.getUsage(d));
        TextTablePrinter printer = new TextTablePrinter((OutputStream)app.getErrorStream());
        printer.setDisplayHeadings(false);
        printer.setIndentWidth(4);
        printer.setColumnWidth(1, 0);
        builder.print((TablePrinter)printer);
    }

    private static <T> void displayPropertyValues(ConsoleApplication app, PropertyDefinition<T> pd, Collection<T> values) {
        TableBuilder builder = new TableBuilder();
        PropertyValuePrinter valuePrinter = new PropertyValuePrinter(null, null, false);
        int sz = values.size();
        boolean useMultipleColumns = sz >= 8;
        int rows = sz;
        if (useMultipleColumns) {
            rows /= 2;
            rows += sz % 2;
        }
        ArrayList<T> vl = new ArrayList<T>(values);
        int i = 0;
        int j = rows;
        while (i < rows) {
            builder.startRow();
            builder.appendCell((Object)"*)");
            builder.appendCell((Object)valuePrinter.print(pd, vl.get(i)));
            if (useMultipleColumns && j < sz) {
                builder.appendCell();
                builder.appendCell((Object)"*)");
                builder.appendCell((Object)valuePrinter.print(pd, vl.get(j)));
            }
            ++i;
            ++j;
        }
        TextTablePrinter printer = new TextTablePrinter((OutputStream)app.getErrorStream());
        printer.setDisplayHeadings(false);
        printer.setIndentWidth(4);
        printer.setColumnWidth(1, 0);
        if (useMultipleColumns) {
            printer.setColumnWidth(2, 2);
            printer.setColumnWidth(4, 0);
        }
        builder.print((TablePrinter)printer);
    }

    private static <T> LocalizableMessage getPropertyValues(PropertyDefinition<T> pd, Collection<T> values) {
        if (values.isEmpty()) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            LocalizableMessage content = query.getAliasDescription();
            if (content != null) {
                return content;
            }
            return LocalizableMessage.raw((CharSequence)"-", (Object[])new Object[0]);
        }
        PropertyValuePrinter printer = new PropertyValuePrinter(null, null, false);
        LocalizableMessageBuilder builder = new LocalizableMessageBuilder();
        boolean isFirst = true;
        for (T value : values) {
            if (!isFirst) {
                builder.append((CharSequence)", ");
            }
            builder.append(printer.print(pd, value));
            isFirst = false;
        }
        return builder.toMessage();
    }

    private static <T> LocalizableMessage getPropertyValues(PropertyDefinition<T> pd, ManagedObject<?> mo) {
        SortedSet<T> values = mo.getPropertyValues(pd);
        return PropertyValueEditor.getPropertyValues(pd, values);
    }

    private static <T> SortedSet<T> readPropertyValues(ConsoleApplication app, ManagedObjectDefinition<?, ?> d, PropertyDefinition<T> pd) throws ClientException {
        TreeSet<T> values = new TreeSet<T>(pd);
        PropertyValueEditor.readPropertyValues(app, d, pd, values);
        return values;
    }

    private static <T> void readPropertyValues(ConsoleApplication app, ManagedObjectDefinition<?, ?> d, PropertyDefinition<T> pd, SortedSet<T> values) throws ClientException {
        T value;
        String s;
        LocalizableMessage prompt;
        if (values.isEmpty()) {
            while (true) {
                try {
                    prompt = pd.hasOption(PropertyOption.MANDATORY) ? DsconfigMessages.INFO_EDITOR_PROMPT_READ_FIRST_VALUE.get((Object)pd.getName()) : DsconfigMessages.INFO_EDITOR_PROMPT_READ_FIRST_VALUE_OPTIONAL.get((Object)pd.getName());
                    app.println();
                    s = app.readLineOfInput(prompt);
                    if (s.trim().length() == 0 && !pd.hasOption(PropertyOption.MANDATORY)) {
                        return;
                    }
                    value = pd.decodeValue(s);
                    if (values.contains(value)) {
                        app.println();
                        app.println(DsconfigMessages.ERR_EDITOR_READ_FIRST_DUPLICATE.get((Object)s));
                        break;
                    }
                    values.add(value);
                }
                catch (PropertyException e) {
                    app.errPrintln();
                    app.errPrintln(ArgumentExceptionFactory.adaptPropertyException(e, d).getMessageObject());
                    continue;
                }
                break;
            }
        }
        if (pd.hasOption(PropertyOption.MULTI_VALUED)) {
            while (true) {
                try {
                    while (true) {
                        prompt = DsconfigMessages.INFO_EDITOR_PROMPT_READ_NEXT_VALUE.get((Object)pd.getName());
                        app.println();
                        s = app.readLineOfInput(prompt);
                        if (s.trim().length() == 0) {
                            return;
                        }
                        value = pd.decodeValue(s);
                        if (values.contains(value)) {
                            app.println();
                            app.println(DsconfigMessages.ERR_EDITOR_READ_NEXT_DUPLICATE.get((Object)s));
                            continue;
                        }
                        values.add(value);
                    }
                }
                catch (PropertyException e) {
                    app.errPrintln();
                    app.errPrintln(ArgumentExceptionFactory.adaptPropertyException(e, d).getMessageObject());
                    app.errPrintln();
                    continue;
                }
                break;
            }
        }
    }

    public PropertyValueEditor(ConsoleApplication app, ManagementContext context) {
        this.app = app;
        this.context = context;
    }

    public MenuResult<Void> edit(ManagedObject<?> mo, Collection<PropertyDefinition<?>> c, boolean isCreate) throws ClientException {
        MenuResult result;
        block9: {
            for (PropertyDefinition<?> pd : c) {
                MandatoryPropertyInitializer mpi;
                MenuResult<Void> result2;
                if (!pd.hasOption(PropertyOption.MANDATORY) || !mo.getPropertyValues(pd).isEmpty() || (result2 = (mpi = new MandatoryPropertyInitializer(mo, pd)).invoke(this.app)).isSuccess()) continue;
                return result2;
            }
            do {
                MenuBuilder builder = new MenuBuilder(this.app);
                String ufn = mo.getManagedObjectPath().getName();
                if (ufn == null) {
                    ufn = mo.getManagedObjectDefinition().getUserFriendlyName().toString();
                }
                builder.setPrompt(DsconfigMessages.INFO_EDITOR_HEADING_CONFIGURE_COMPONENT.get((Object)ufn));
                LocalizableMessage heading1 = DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_NAME.get();
                LocalizableMessage heading2 = DsconfigMessages.INFO_DSCFG_HEADING_PROPERTY_VALUE.get();
                builder.setColumnHeadings(new LocalizableMessage[]{heading1, heading2});
                builder.setColumnWidths(new Integer[]{null, 0});
                for (PropertyDefinition<?> pd : c) {
                    boolean isReadOnly = pd.hasOption(PropertyOption.MONITORING);
                    if (!isCreate && pd.hasOption(PropertyOption.READ_ONLY)) {
                        isReadOnly = true;
                    }
                    PropertyDefinitionVisitor callback = isReadOnly ? new ReadOnlyPropertyViewer(mo, pd) : (pd.hasOption(PropertyOption.MULTI_VALUED) ? new MultiValuedPropertyEditor(mo, pd) : new SingleValuedPropertyEditor(mo, pd));
                    LocalizableMessage values = PropertyValueEditor.getPropertyValues(pd, mo);
                    builder.addNumberedOption(LocalizableMessage.raw((CharSequence)"%s", (Object[])new Object[]{pd.getName()}), (MenuCallback)callback, new LocalizableMessage[]{values});
                }
                ComponentHelpCallback helpCallback = new ComponentHelpCallback(mo, c);
                builder.addHelpOption((HelpCallback)helpCallback);
                if (isCreate) {
                    builder.addCharOption(DsconfigMessages.INFO_EDITOR_OPTION_FINISH_KEY.get(), DsconfigMessages.INFO_EDITOR_OPTION_FINISH_CREATE_COMPONENT.get((Object)ufn), MenuResult.success((Object)true));
                } else {
                    builder.addCharOption(DsconfigMessages.INFO_EDITOR_OPTION_FINISH_KEY.get(), DsconfigMessages.INFO_EDITOR_OPTION_FINISH_MODIFY_COMPONENT.get((Object)ufn), MenuResult.success((Object)true));
                }
                builder.setDefault(DsconfigMessages.INFO_EDITOR_OPTION_FINISH_KEY.get(), MenuResult.success((Object)true));
                if (this.app.isMenuDrivenMode()) {
                    builder.addCancelOption(false);
                }
                builder.addQuitOption();
                this.app.println();
                this.app.println();
                Menu menu = builder.toMenu();
                result = menu.run();
                if (!result.isSuccess()) break block9;
            } while (!((Boolean)result.getValue()).booleanValue());
            return MenuResult.success();
        }
        if (result.isCancel()) {
            return MenuResult.cancel();
        }
        return MenuResult.quit();
    }

    private <T> void registerModification(PropertyDefinition<T> pd, SortedSet<T> newValues, SortedSet<T> previousValues) {
        if (this.isLastChoiceReset) {
            this.registerResetModification(pd, previousValues);
        } else if (!newValues.equals(previousValues)) {
            if (newValues.containsAll(previousValues)) {
                if (newValues.size() <= 1) {
                    this.registerSetModification(pd, newValues, previousValues);
                } else {
                    this.registerAddModification(pd, newValues, previousValues);
                }
            } else if (previousValues.containsAll(newValues)) {
                this.registerRemoveModification(pd, newValues, previousValues);
            } else if (newValues.size() <= 1) {
                this.registerSetModification(pd, newValues, previousValues);
            } else {
                TreeSet<T> removedValues = new TreeSet<T>(previousValues);
                removedValues.removeAll(newValues);
                PropertyEditorModification<T> removeMod = PropertyEditorModification.createRemoveModification(pd, removedValues, previousValues);
                this.addModification(removeMod);
                TreeSet<T> retainedValues = new TreeSet<T>(previousValues);
                retainedValues.retainAll(newValues);
                TreeSet<T> addedValues = new TreeSet<T>(newValues);
                addedValues.removeAll(retainedValues);
                PropertyEditorModification<T> addMod = PropertyEditorModification.createAddModification(pd, addedValues, retainedValues);
                this.addModification(addMod);
            }
        }
    }

    private <T> void registerResetModification(PropertyDefinition<T> pd, SortedSet<T> previousValues) {
        TreeSet<T> originalValues;
        PropertyEditorModification<?> mod = this.getModification(pd);
        if (mod != null) {
            originalValues = new TreeSet<T>(pd);
            this.castAndAddValues(originalValues, mod.getOriginalValues(), pd);
            this.removeModification(mod);
        } else {
            originalValues = new TreeSet<T>(previousValues);
        }
        this.addModification(PropertyEditorModification.createResetModification(pd, originalValues));
    }

    private <T> void registerSetModification(PropertyDefinition<T> pd, SortedSet<T> newValues, SortedSet<T> previousValues) {
        TreeSet<T> originalValues;
        PropertyEditorModification<?> mod = this.getModification(pd);
        if (mod != null) {
            originalValues = new TreeSet<T>(pd);
            this.castAndAddValues(originalValues, mod.getOriginalValues(), pd);
            this.removeModification(mod);
        } else {
            originalValues = new TreeSet<T>(previousValues);
        }
        this.addModification(PropertyEditorModification.createSetModification(pd, newValues, originalValues));
    }

    private <T> void registerAddModification(PropertyDefinition<T> pd, SortedSet<T> newValues, SortedSet<T> previousValues) {
        PropertyEditorModification<T> newMod;
        PropertyEditorModification<?> mod = this.getModification(pd);
        if (mod != null) {
            TreeSet<T> originalValues = new TreeSet<T>(pd);
            this.castAndAddValues(originalValues, mod.getOriginalValues(), pd);
            if (mod.getType() == PropertyEditorModification.Type.ADD) {
                TreeSet<T> addedValues = new TreeSet<T>(newValues);
                addedValues.removeAll(originalValues);
                newMod = PropertyEditorModification.createAddModification(pd, addedValues, originalValues);
            } else {
                newMod = PropertyEditorModification.createSetModification(pd, new TreeSet<T>(newValues), originalValues);
            }
            this.removeModification(mod);
        } else {
            TreeSet<T> originalValues = new TreeSet<T>(previousValues);
            TreeSet<T> addedValues = new TreeSet<T>(newValues);
            addedValues.removeAll(originalValues);
            newMod = PropertyEditorModification.createAddModification(pd, addedValues, originalValues);
        }
        this.addModification(newMod);
    }

    private <T> void registerRemoveModification(PropertyDefinition<T> pd, SortedSet<T> newValues, SortedSet<T> previousValues) {
        PropertyEditorModification<T> newMod;
        PropertyEditorModification<?> mod = this.getModification(pd);
        if (mod != null) {
            TreeSet<T> originalValues = new TreeSet<T>(pd);
            this.castAndAddValues(originalValues, mod.getOriginalValues(), pd);
            if (newValues.isEmpty()) {
                newMod = PropertyEditorModification.createRemoveModification(pd, originalValues, originalValues);
            } else if (mod.getType() == PropertyEditorModification.Type.REMOVE) {
                TreeSet<T> removedValues = new TreeSet<T>(originalValues);
                removedValues.removeAll(newValues);
                newMod = PropertyEditorModification.createRemoveModification(pd, removedValues, originalValues);
            } else {
                newMod = PropertyEditorModification.createSetModification(pd, new TreeSet<T>(newValues), originalValues);
            }
            this.removeModification(mod);
        } else {
            TreeSet<T> originalValues = new TreeSet<T>(previousValues);
            TreeSet<T> removedValues = new TreeSet<T>(originalValues);
            removedValues.removeAll(newValues);
            newMod = PropertyEditorModification.createRemoveModification(pd, removedValues, originalValues);
        }
        this.addModification(newMod);
    }

    public Collection<PropertyEditorModification<?>> getModifications() {
        return this.mods;
    }

    public void resetModifications() {
        this.mods.clear();
    }

    private <T> void addModification(PropertyEditorModification<T> mod) {
        this.mods.add(mod);
    }

    private <T> boolean removeModification(PropertyEditorModification<T> mod) {
        return this.mods.remove(mod);
    }

    private <T> PropertyEditorModification<?> getModification(PropertyDefinition<T> pd) {
        PropertyEditorModification<?> mod = null;
        for (PropertyEditorModification<?> m : this.mods) {
            if (!pd.equals(m.getPropertyDefinition())) continue;
            mod = m;
            break;
        }
        return mod;
    }

    private <T> void castAndAddValues(Collection<T> destination, Collection<?> source, PropertyDefinition<T> pd) {
        for (Object o : source) {
            destination.add(pd.castValue(o));
        }
    }

    private final class SingleValuedPropertyEditor
    extends PropertyDefinitionVisitor<MenuResult<Boolean>, Void>
    implements MenuCallback<Boolean> {
        private ClientException e;
        private final ManagedObject<?> mo;
        private final PropertyDefinition<?> pd;

        private SingleValuedPropertyEditor(ManagedObject<?> mo, PropertyDefinition<?> pd) {
            Reject.ifFalse((!pd.hasOption(PropertyOption.MULTI_VALUED) ? 1 : 0) != 0);
            this.mo = mo;
            this.pd = pd;
        }

        public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
            PropertyValueEditor.displayPropertyHeader(app, this.pd);
            MenuResult<Boolean> result = this.pd.accept(this, null);
            if (this.e != null) {
                throw this.e;
            }
            return result;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> MenuResult<Boolean> visitAggregation(AggregationPropertyDefinition<C, S> d, Void p) {
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setMultipleColumnThreshold(8);
            builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get((Object)d.getName()));
            DefaultBehaviorQuery<String> query = DefaultBehaviorQuery.query(d);
            SortedSet<String> currentValues = this.mo.getPropertyValues(d);
            SortedSet<String> defaultValues = this.mo.getPropertyDefaultValues(d);
            String currentValue = currentValues.isEmpty() ? null : currentValues.first();
            String defaultValue = defaultValues.isEmpty() ? null : defaultValues.first();
            LocalizableMessage option = this.getKeepDefaultValuesMenuOption(d);
            builder.addNumberedOption(option, MenuResult.cancel(), new LocalizableMessage[0]);
            builder.setDefault(LocalizableMessage.raw((CharSequence)"1", (Object[])new Object[0]), MenuResult.cancel());
            TreeSet<String> values = new TreeSet<String>(d);
            ManagedObjectPath<?, ?> path = d.getParentPath();
            InstantiableRelationDefinition<C, S> rd = d.getRelationDefinition();
            try {
                values.addAll(Arrays.asList(PropertyValueEditor.this.context.listManagedObjects(path, rd)));
            }
            catch (AuthorizationException e) {
                this.e = new ClientException(ReturnCode.CLIENT_SIDE_PARAM_ERROR, LocalizableMessage.raw((CharSequence)e.getMessage(), (Object[])new Object[0]));
                return MenuResult.quit();
            }
            catch (ManagedObjectNotFoundException e) {
                this.e = new ClientException(ReturnCode.NO_SUCH_OBJECT, e.getMessageObject());
                return MenuResult.cancel();
            }
            catch (LdapException e) {
                this.e = new ClientException(ReturnCode.APPLICATION_ERROR, LocalizableMessage.raw((CharSequence)e.getMessage(), (Object[])new Object[0]));
                return MenuResult.quit();
            }
            LocalizableMessage ufn = rd.getUserFriendlyName();
            for (String value : values) {
                if (currentValue != null && d.compare(value, currentValue) == 0) continue;
                LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                option = value.equals(defaultValue) && query.isDefined() ? DsconfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_COMPONENT.get((Object)ufn, (Object)svalue) : DsconfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_COMPONENT.get((Object)ufn, (Object)svalue);
                builder.addNumberedOption(option, MenuResult.success((Object)value), new LocalizableMessage[0]);
            }
            CreateComponentCallback callback = new CreateComponentCallback(d);
            builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_CREATE_A_NEW_COMPONENT.get((Object)ufn), callback, new LocalizableMessage[0]);
            if (this.mo.isPropertyPresent(d) && !query.isDefined() && (option = this.getResetToDefaultValuesMenuOption(d)) != null) {
                builder.addNumberedOption(option, MenuResult.success(), new LocalizableMessage[0]);
            }
            return this.runMenu(d, builder);
        }

        @Override
        public MenuResult<Boolean> visitBoolean(BooleanPropertyDefinition d, Void p) {
            LocalizableMessage svalue;
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get((Object)d.getName()));
            DefaultBehaviorQuery<Boolean> query = DefaultBehaviorQuery.query(d);
            SortedSet<Boolean> currentValues = this.mo.getPropertyValues(d);
            SortedSet<Boolean> defaultValues = this.mo.getPropertyDefaultValues(d);
            Boolean currentValue = currentValues.isEmpty() ? null : currentValues.first();
            Boolean defaultValue = defaultValues.isEmpty() ? null : defaultValues.first();
            LocalizableMessage option = this.getKeepDefaultValuesMenuOption(d);
            builder.addNumberedOption(option, MenuResult.cancel(), new LocalizableMessage[0]);
            builder.setDefault(LocalizableMessage.raw((CharSequence)"1", (Object[])new Object[0]), MenuResult.cancel());
            if (!Boolean.TRUE.equals(currentValue)) {
                svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(true));
                option = Boolean.TRUE.equals(defaultValue) ? DsconfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_VALUE.get((Object)svalue) : DsconfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_VALUE.get((Object)svalue);
                builder.addNumberedOption(option, MenuResult.success((Object)true), new LocalizableMessage[0]);
            }
            if (!Boolean.FALSE.equals(currentValue)) {
                svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(false));
                option = Boolean.FALSE.equals(defaultValue) ? DsconfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_VALUE.get((Object)svalue) : DsconfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_VALUE.get((Object)svalue);
                builder.addNumberedOption(option, MenuResult.success((Object)false), new LocalizableMessage[0]);
            }
            if (this.mo.isPropertyPresent(d) && !query.isDefined() && (option = this.getResetToDefaultValuesMenuOption(d)) != null) {
                builder.addNumberedOption(option, MenuResult.success(), new LocalizableMessage[0]);
            }
            return this.runMenu(d, builder);
        }

        @Override
        public <E extends Enum<E>> MenuResult<Boolean> visitEnum(EnumPropertyDefinition<E> d, Void p) {
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setMultipleColumnThreshold(8);
            builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get((Object)d.getName()));
            DefaultBehaviorQuery<E> query = DefaultBehaviorQuery.query(d);
            SortedSet<E> currentValues = this.mo.getPropertyValues(d);
            SortedSet<E> defaultValues = this.mo.getPropertyDefaultValues(d);
            Enum currentValue = currentValues.isEmpty() ? null : (Enum)currentValues.first();
            Enum defaultValue = defaultValues.isEmpty() ? null : (Enum)defaultValues.first();
            LocalizableMessage option = this.getKeepDefaultValuesMenuOption(d);
            builder.addNumberedOption(option, MenuResult.cancel(), new LocalizableMessage[0]);
            builder.setDefault(LocalizableMessage.raw((CharSequence)"1", (Object[])new Object[0]), MenuResult.cancel());
            TreeSet<E> values = new TreeSet<E>(d);
            values.addAll(EnumSet.allOf(d.getEnumClass()));
            for (Enum value : values) {
                if (value.equals(currentValue) && query.isDefined()) continue;
                LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                option = value.equals(defaultValue) && query.isDefined() ? DsconfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_DEFAULT_VALUE.get((Object)svalue) : DsconfigMessages.INFO_EDITOR_OPTION_CHANGE_TO_VALUE.get((Object)svalue);
                builder.addNumberedOption(option, MenuResult.success((Object)value), new LocalizableMessage[0]);
            }
            if (this.mo.isPropertyPresent(d) && !query.isDefined() && (option = this.getResetToDefaultValuesMenuOption(d)) != null) {
                builder.addNumberedOption(option, MenuResult.success(), new LocalizableMessage[0]);
            }
            return this.runMenu(d, builder);
        }

        @Override
        public <T> MenuResult<Boolean> visitUnknown(final PropertyDefinition<T> d, Void p) {
            PropertyValueEditor.this.app.println();
            PropertyValueEditor.displayPropertySyntax(PropertyValueEditor.this.app, d);
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get((Object)d.getName()));
            LocalizableMessage option = this.getKeepDefaultValuesMenuOption(d);
            builder.addNumberedOption(option, MenuResult.cancel(), new LocalizableMessage[0]);
            builder.setDefault(LocalizableMessage.raw((CharSequence)"1", (Object[])new Object[0]), MenuResult.cancel());
            builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_CHANGE_VALUE.get(), new MenuCallback<T>(){

                public MenuResult<T> invoke(ConsoleApplication app) throws ClientException {
                    app.println();
                    SortedSet values = PropertyValueEditor.readPropertyValues(app, SingleValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d);
                    return MenuResult.success((Collection)values);
                }
            }, new LocalizableMessage[0]);
            if (this.mo.isPropertyPresent(d) && (option = this.getResetToDefaultValuesMenuOption(d)) != null) {
                builder.addNumberedOption(option, MenuResult.success(), new LocalizableMessage[0]);
            }
            return this.runMenu(d, builder);
        }

        private <T> LocalizableMessage getKeepDefaultValuesMenuOption(PropertyDefinition<T> pd) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            SortedSet<T> currentValues = this.mo.getPropertyValues(pd);
            SortedSet<T> defaultValues = this.mo.getPropertyDefaultValues(pd);
            if (query.isDefined() && currentValues.equals(defaultValues)) {
                LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, currentValues);
                return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUE.get((Object)svalue);
            }
            if (this.mo.isPropertyPresent(pd)) {
                LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, currentValues);
                return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_VALUE.get((Object)svalue);
            }
            if (query.isAlias()) {
                return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_ALIAS.get((Object)query.getAliasDescription());
            }
            if (query.isInherited()) {
                if (defaultValues.isEmpty()) {
                    if (query.getAliasDescription() != null) {
                        return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS.get((Object)query.getAliasDescription());
                    }
                    return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                }
                LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUE.get((Object)svalue);
            }
            return DsconfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
        }

        private <T> LocalizableMessage getResetToDefaultValuesMenuOption(PropertyDefinition<T> pd) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            SortedSet<T> currentValues = this.mo.getPropertyValues(pd);
            SortedSet<T> defaultValues = this.mo.getPropertyDefaultValues(pd);
            boolean isMandatory = pd.hasOption(PropertyOption.MANDATORY);
            if (!isMandatory && query.isAlias()) {
                return DsconfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_ALIAS.get((Object)query.getAliasDescription());
            }
            if (query.isDefined()) {
                if (!currentValues.equals(defaultValues)) {
                    LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                    return DsconfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_VALUE.get((Object)svalue);
                }
                return null;
            }
            if (!isMandatory && query.isInherited()) {
                if (defaultValues.isEmpty()) {
                    if (query.getAliasDescription() != null) {
                        return DsconfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS.get((Object)query.getAliasDescription());
                    }
                    return DsconfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                }
                LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                return DsconfigMessages.INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUE.get((Object)svalue);
            }
            if (!isMandatory && query.isUndefined()) {
                return DsconfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
            }
            return null;
        }

        private <T> MenuResult<Boolean> runMenu(PropertyDefinition<T> d, MenuBuilder<T> builder) {
            MenuResult result;
            builder.addHelpOption((HelpCallback)new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            builder.addQuitOption();
            Menu menu = builder.toMenu();
            try {
                PropertyValueEditor.this.app.println();
                result = menu.run();
            }
            catch (ClientException e) {
                this.e = e;
                return null;
            }
            if (result.isSuccess()) {
                Collection values = result.getValues();
                TreeSet<T> newValues = new TreeSet<T>(d);
                newValues.addAll(values);
                TreeSet<T> oldValues = new TreeSet<T>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, values);
                PropertyValueEditor.this.isLastChoiceReset = values.isEmpty();
                PropertyValueEditor.this.registerModification(d, newValues, oldValues);
                PropertyValueEditor.this.app.println();
                PropertyValueEditor.this.app.pressReturnToContinue();
                return MenuResult.success((Object)false);
            }
            if (result.isCancel()) {
                PropertyValueEditor.this.app.println();
                PropertyValueEditor.this.app.pressReturnToContinue();
                return MenuResult.success((Object)false);
            }
            return MenuResult.quit();
        }
    }

    private final class ReadOnlyPropertyViewer
    extends PropertyDefinitionVisitor<MenuResult<Boolean>, Void>
    implements MenuCallback<Boolean> {
        private ClientException e;
        private final ManagedObject<?> mo;
        private final PropertyDefinition<?> pd;

        private ReadOnlyPropertyViewer(ManagedObject<?> mo, PropertyDefinition<?> pd) {
            this.mo = mo;
            this.pd = pd;
        }

        public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
            MenuResult<Boolean> result = this.pd.accept(this, null);
            if (this.e != null) {
                throw this.e;
            }
            return result;
        }

        @Override
        public <T> MenuResult<Boolean> visitUnknown(PropertyDefinition<T> pd, Void p) {
            boolean result;
            SortedSet<T> values = this.mo.getPropertyValues(pd);
            PropertyValueEditor.this.app.println();
            PropertyValueEditor.this.app.println();
            switch (values.size()) {
                case 0: {
                    DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
                    LocalizableMessage aliasDescription = query.getAliasDescription();
                    if (aliasDescription != null) {
                        PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_READ_ONLY_ALIAS.get((Object)pd.getName(), (Object)aliasDescription));
                        break;
                    }
                    PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_READ_ONLY_ALIAS_UNDEFINED.get((Object)pd.getName()));
                    break;
                }
                case 1: {
                    LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, this.mo);
                    PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_READ_ONLY_VALUE.get((Object)pd.getName(), (Object)svalue));
                    break;
                }
                default: {
                    PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_READ_ONLY_VALUES.get((Object)pd.getName()));
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.displayPropertyValues(PropertyValueEditor.this.app, pd, values);
                }
            }
            PropertyValueEditor.this.app.println();
            try {
                result = PropertyValueEditor.this.app.confirmAction(DsconfigMessages.INFO_EDITOR_PROMPT_READ_ONLY.get(), false);
            }
            catch (ClientException e) {
                this.e = e;
                return null;
            }
            if (result) {
                PropertyValueEditor.this.app.println();
                HelpSubCommandHandler.displayVerboseSingleProperty(PropertyValueEditor.this.app, this.mo.getManagedObjectDefinition(), pd.getName());
                PropertyValueEditor.this.app.println();
                PropertyValueEditor.this.app.pressReturnToContinue();
            }
            return MenuResult.again();
        }
    }

    private static final class PropertyHelpCallback
    implements HelpCallback {
        private final ManagedObjectDefinition<?, ?> d;
        private final PropertyDefinition<?> pd;

        private PropertyHelpCallback(ManagedObjectDefinition<?, ?> d, PropertyDefinition<?> pd) {
            this.d = d;
            this.pd = pd;
        }

        public void display(ConsoleApplication app) {
            app.println();
            HelpSubCommandHandler.displayVerboseSingleProperty(app, this.d, this.pd.getName());
            app.println();
            app.pressReturnToContinue();
        }
    }

    private final class MultiValuedPropertyEditor
    extends PropertyDefinitionVisitor<MenuResult<Boolean>, Void>
    implements MenuCallback<Boolean> {
        private ClientException e;
        private final ManagedObject<?> mo;
        private final PropertyDefinition<?> pd;

        private MultiValuedPropertyEditor(ManagedObject<?> mo, PropertyDefinition<?> pd) {
            Reject.ifFalse((boolean)pd.hasOption(PropertyOption.MULTI_VALUED));
            this.mo = mo;
            this.pd = pd;
        }

        public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
            PropertyValueEditor.displayPropertyHeader(app, this.pd);
            MenuResult<Boolean> result = this.pd.accept(this, null);
            if (this.e != null) {
                throw this.e;
            }
            return result;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> MenuResult<Boolean> visitAggregation(final AggregationPropertyDefinition<C, S> d, Void p) {
            MenuCallback<Boolean> removeCallback;
            MenuCallback<Boolean> addCallback;
            MenuResult<Boolean> result;
            SortedSet<String> defaultValues = this.mo.getPropertyDefaultValues(d);
            SortedSet<String> oldValues = this.mo.getPropertyValues(d);
            final SortedSet<String> currentValues = this.mo.getPropertyValues(d);
            final InstantiableRelationDefinition<C, S> rd = d.getRelationDefinition();
            final LocalizableMessage ufpn = rd.getUserFriendlyPluralName();
            boolean isFirst = true;
            do {
                if (!isFirst) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_CONFIGURE_PROPERTY_CONT.get((Object)d.getName()));
                } else {
                    isFirst = false;
                }
                if (currentValues.size() > 1) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_COMPONENT_SUMMARY.get((Object)d.getName(), (Object)ufpn));
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.displayPropertyValues(PropertyValueEditor.this.app, d, currentValues);
                }
                final TreeSet<String> values = new TreeSet<String>(d);
                ManagedObjectPath<?, ?> path = d.getParentPath();
                try {
                    values.addAll(Arrays.asList(PropertyValueEditor.this.context.listManagedObjects(path, rd)));
                }
                catch (AuthorizationException e) {
                    this.e = new ClientException(ReturnCode.CLIENT_SIDE_PARAM_ERROR, LocalizableMessage.raw((CharSequence)e.getMessage(), (Object[])new Object[0]));
                    return MenuResult.quit();
                }
                catch (ManagedObjectNotFoundException e) {
                    this.e = new ClientException(ReturnCode.NO_SUCH_OBJECT, e.getMessageObject());
                    return MenuResult.cancel();
                }
                catch (LdapException e) {
                    this.e = new ClientException(ReturnCode.APPLICATION_ERROR, LocalizableMessage.raw((CharSequence)e.getMessage(), (Object[])new Object[0]));
                    return MenuResult.quit();
                }
                addCallback = null;
                values.removeAll(currentValues);
                if (!values.isEmpty()) {
                    addCallback = new MenuCallback<Boolean>(){

                        public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
                            MenuBuilder builder = new MenuBuilder(app);
                            builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_COMPONENTS_ADD.get((Object)ufpn));
                            builder.setAllowMultiSelect(true);
                            builder.setMultipleColumnThreshold(8);
                            for (String value : values) {
                                LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                                builder.addNumberedOption(svalue, MenuResult.success((Object)value), new LocalizableMessage[0]);
                            }
                            CreateComponentCallback callback = new CreateComponentCallback(d);
                            builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_CREATE_A_NEW_COMPONENT.get((Object)rd.getUserFriendlyName()), callback, new LocalizableMessage[0]);
                            if (values.size() > 1) {
                                builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_ADD_ALL_COMPONENTS.get((Object)ufpn), MenuResult.success((Collection)values), new LocalizableMessage[0]);
                            }
                            builder.addHelpOption((HelpCallback)new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                            builder.addCancelOption(true);
                            builder.addQuitOption();
                            app.println();
                            app.println();
                            Menu menu = builder.toMenu();
                            MenuResult result = menu.run();
                            if (result.isSuccess()) {
                                Collection addedValues = result.getValues();
                                currentValues.addAll(addedValues);
                                PropertyValueEditor.this.isLastChoiceReset = false;
                                app.println();
                                app.pressReturnToContinue();
                                return MenuResult.success((Object)false);
                            }
                            if (result.isCancel()) {
                                app.println();
                                app.pressReturnToContinue();
                                return MenuResult.success((Object)false);
                            }
                            return MenuResult.quit();
                        }
                    };
                }
                removeCallback = new MenuCallback<Boolean>(){

                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
                        MenuBuilder builder = new MenuBuilder(app);
                        builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_COMPONENTS_REMOVE.get((Object)ufpn));
                        builder.setAllowMultiSelect(true);
                        builder.setMultipleColumnThreshold(8);
                        for (String value : currentValues) {
                            LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                            builder.addNumberedOption(svalue, MenuResult.success((Object)value), new LocalizableMessage[0]);
                        }
                        builder.addHelpOption((HelpCallback)new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                        builder.addCancelOption(true);
                        builder.addQuitOption();
                        app.println();
                        app.println();
                        Menu menu = builder.toMenu();
                        MenuResult result = menu.run();
                        if (result.isSuccess()) {
                            Collection removedValues = result.getValues();
                            currentValues.removeAll(removedValues);
                            PropertyValueEditor.this.isLastChoiceReset = false;
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success((Object)false);
                        }
                        if (result.isCancel()) {
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success((Object)false);
                        }
                        return MenuResult.quit();
                    }
                };
            } while ((result = this.runMenu(d, PropertyValueEditor.this.app, defaultValues, oldValues, currentValues, addCallback, removeCallback)).isAgain());
            return result;
        }

        @Override
        public <T extends Enum<T>> MenuResult<Boolean> visitEnum(final EnumPropertyDefinition<T> d, Void p) {
            MenuCallback<Boolean> removeCallback;
            MenuCallback<Boolean> addCallback;
            MenuResult<Boolean> result;
            SortedSet<T> defaultValues = this.mo.getPropertyDefaultValues(d);
            SortedSet<T> oldValues = this.mo.getPropertyValues(d);
            final SortedSet<T> currentValues = this.mo.getPropertyValues(d);
            boolean isFirst = true;
            do {
                if (!isFirst) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_CONFIGURE_PROPERTY_CONT.get((Object)d.getName()));
                } else {
                    isFirst = false;
                }
                if (currentValues.size() > 1) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_VALUES_SUMMARY.get((Object)d.getName()));
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.displayPropertyValues(PropertyValueEditor.this.app, d, currentValues);
                }
                addCallback = null;
                final EnumSet<T> values = EnumSet.allOf(d.getEnumClass());
                values.removeAll(currentValues);
                if (!values.isEmpty()) {
                    addCallback = new MenuCallback<Boolean>(){

                        public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
                            MenuBuilder builder = new MenuBuilder(app);
                            builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUES_ADD.get());
                            builder.setAllowMultiSelect(true);
                            builder.setMultipleColumnThreshold(8);
                            for (Enum value : values) {
                                LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                                builder.addNumberedOption(svalue, MenuResult.success((Object)value), new LocalizableMessage[0]);
                            }
                            if (values.size() > 1) {
                                builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_ADD_ALL_VALUES.get(), MenuResult.success((Collection)values), new LocalizableMessage[0]);
                            }
                            builder.addHelpOption((HelpCallback)new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                            builder.addCancelOption(true);
                            builder.addQuitOption();
                            app.println();
                            app.println();
                            Menu menu = builder.toMenu();
                            MenuResult result = menu.run();
                            if (result.isSuccess()) {
                                Collection addedValues = result.getValues();
                                currentValues.addAll(addedValues);
                                PropertyValueEditor.this.isLastChoiceReset = false;
                                app.println();
                                app.pressReturnToContinue();
                                return MenuResult.success((Object)false);
                            }
                            if (result.isCancel()) {
                                app.println();
                                app.pressReturnToContinue();
                                return MenuResult.success((Object)false);
                            }
                            return MenuResult.quit();
                        }
                    };
                }
                removeCallback = new MenuCallback<Boolean>(){

                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
                        MenuBuilder builder = new MenuBuilder(app);
                        builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUES_REMOVE.get());
                        builder.setAllowMultiSelect(true);
                        builder.setMultipleColumnThreshold(8);
                        for (Enum value : currentValues) {
                            LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                            builder.addNumberedOption(svalue, MenuResult.success((Object)value), new LocalizableMessage[0]);
                        }
                        builder.addHelpOption((HelpCallback)new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                        builder.addCancelOption(true);
                        builder.addQuitOption();
                        app.println();
                        app.println();
                        Menu menu = builder.toMenu();
                        MenuResult result = menu.run();
                        if (result.isSuccess()) {
                            Collection removedValues = result.getValues();
                            currentValues.removeAll(removedValues);
                            PropertyValueEditor.this.isLastChoiceReset = false;
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success((Object)false);
                        }
                        if (result.isCancel()) {
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success((Object)false);
                        }
                        return MenuResult.quit();
                    }
                };
            } while ((result = this.runMenu(d, PropertyValueEditor.this.app, defaultValues, oldValues, currentValues, addCallback, removeCallback)).isAgain());
            return result;
        }

        @Override
        public <T> MenuResult<Boolean> visitUnknown(final PropertyDefinition<T> d, Void p) {
            MenuCallback<Boolean> removeCallback;
            MenuCallback<Boolean> addCallback;
            MenuResult<Boolean> result;
            PropertyValueEditor.this.app.println();
            PropertyValueEditor.displayPropertySyntax(PropertyValueEditor.this.app, d);
            SortedSet<T> defaultValues = this.mo.getPropertyDefaultValues(d);
            SortedSet<T> oldValues = this.mo.getPropertyValues(d);
            final SortedSet<T> currentValues = this.mo.getPropertyValues(d);
            boolean isFirst = true;
            do {
                if (!isFirst) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_CONFIGURE_PROPERTY_CONT.get((Object)d.getName()));
                } else {
                    isFirst = false;
                }
                if (currentValues.size() > 1) {
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.this.app.println(DsconfigMessages.INFO_EDITOR_HEADING_VALUES_SUMMARY.get((Object)d.getName()));
                    PropertyValueEditor.this.app.println();
                    PropertyValueEditor.displayPropertyValues(PropertyValueEditor.this.app, d, currentValues);
                }
                addCallback = new MenuCallback<Boolean>(){

                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
                        app.println();
                        TreeSet previousValues = new TreeSet(currentValues);
                        PropertyValueEditor.readPropertyValues(app, MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d, currentValues);
                        TreeSet addedValues = new TreeSet(currentValues);
                        addedValues.removeAll(previousValues);
                        PropertyValueEditor.this.isLastChoiceReset = false;
                        return MenuResult.success((Object)false);
                    }
                };
                removeCallback = new MenuCallback<Boolean>(){

                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
                        MenuBuilder builder = new MenuBuilder(app);
                        builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUES_REMOVE.get());
                        builder.setAllowMultiSelect(true);
                        builder.setMultipleColumnThreshold(8);
                        for (Object value : currentValues) {
                            LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                            builder.addNumberedOption(svalue, MenuResult.success(value), new LocalizableMessage[0]);
                        }
                        builder.addHelpOption((HelpCallback)new PropertyHelpCallback(MultiValuedPropertyEditor.this.mo.getManagedObjectDefinition(), d));
                        builder.addCancelOption(true);
                        builder.addQuitOption();
                        app.println();
                        app.println();
                        Menu menu = builder.toMenu();
                        MenuResult result = menu.run();
                        if (result.isSuccess()) {
                            Collection removedValues = result.getValues();
                            currentValues.removeAll(removedValues);
                            PropertyValueEditor.this.isLastChoiceReset = false;
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success((Object)false);
                        }
                        if (result.isCancel()) {
                            app.println();
                            app.pressReturnToContinue();
                            return MenuResult.success((Object)false);
                        }
                        return MenuResult.quit();
                    }
                };
            } while ((result = this.runMenu(d, PropertyValueEditor.this.app, defaultValues, oldValues, currentValues, addCallback, removeCallback)).isAgain());
            return result;
        }

        private <T> LocalizableMessage getKeepDefaultValuesMenuOption(PropertyDefinition<T> pd, SortedSet<T> defaultValues, SortedSet<T> oldValues, SortedSet<T> currentValues) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            boolean isModified = !currentValues.equals(oldValues);
            boolean isDefault = currentValues.equals(defaultValues);
            if (isModified) {
                switch (currentValues.size()) {
                    case 0: {
                        if (query.isAlias()) {
                            return DsconfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_ALIAS.get((Object)query.getAliasDescription());
                        }
                        if (query.isInherited()) {
                            if (query.getAliasDescription() != null) {
                                return DsconfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_INHERITED_ALIAS.get((Object)query.getAliasDescription());
                            }
                            return DsconfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                        }
                        return DsconfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
                    }
                    case 1: {
                        LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, currentValues);
                        if (isDefault) {
                            if (query.isInherited()) {
                                return DsconfigMessages.INFO_EDITOR_OPTION_USE_INHERITED_DEFAULT_VALUE.get((Object)svalue);
                            }
                            return DsconfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_VALUE.get((Object)svalue);
                        }
                        return DsconfigMessages.INFO_EDITOR_OPTION_USE_VALUE.get((Object)svalue);
                    }
                }
                if (isDefault) {
                    if (query.isInherited()) {
                        return DsconfigMessages.INFO_EDITOR_OPTION_USE_INHERITED_DEFAULT_VALUES.get();
                    }
                    return DsconfigMessages.INFO_EDITOR_OPTION_USE_DEFAULT_VALUES.get();
                }
                return DsconfigMessages.INFO_EDITOR_OPTION_USE_VALUES.get();
            }
            switch (currentValues.size()) {
                case 0: {
                    if (query.isAlias()) {
                        return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_ALIAS.get((Object)query.getAliasDescription());
                    }
                    if (query.isInherited()) {
                        if (query.getAliasDescription() != null) {
                            return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS.get((Object)query.getAliasDescription());
                        }
                        return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                    }
                    return DsconfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
                }
                case 1: {
                    LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, currentValues);
                    if (isDefault) {
                        if (query.isInherited()) {
                            return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUE.get((Object)svalue);
                        }
                        return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUE.get((Object)svalue);
                    }
                    return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_VALUE.get((Object)svalue);
                }
            }
            if (isDefault) {
                if (query.isInherited()) {
                    return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_INHERITED_DEFAULT_VALUES.get();
                }
                return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_DEFAULT_VALUES.get();
            }
            return DsconfigMessages.INFO_EDITOR_OPTION_KEEP_VALUES.get();
        }

        private <T> LocalizableMessage getResetToDefaultValuesMenuOption(PropertyDefinition<T> pd, SortedSet<T> defaultValues, SortedSet<T> currentValues) {
            DefaultBehaviorQuery<T> query = DefaultBehaviorQuery.query(pd);
            boolean isMandatory = pd.hasOption(PropertyOption.MANDATORY);
            if (!isMandatory && query.isAlias()) {
                return DsconfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_ALIAS.get((Object)query.getAliasDescription());
            }
            if (query.isDefined()) {
                if (!currentValues.equals(defaultValues)) {
                    LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                    if (defaultValues.size() > 1) {
                        return DsconfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_VALUES.get((Object)svalue);
                    }
                    return DsconfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_VALUE.get((Object)svalue);
                }
                return null;
            }
            if (!isMandatory && query.isInherited()) {
                if (defaultValues.isEmpty()) {
                    if (query.getAliasDescription() != null) {
                        return DsconfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS.get((Object)query.getAliasDescription());
                    }
                    return DsconfigMessages.INFO_EDITOR_OPTION_RESET_DEFAULT_INHERITED_ALIAS_UNDEFINED.get();
                }
                LocalizableMessage svalue = PropertyValueEditor.getPropertyValues(pd, defaultValues);
                if (defaultValues.size() > 1) {
                    return DsconfigMessages.INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUES.get((Object)svalue);
                }
                return DsconfigMessages.INFO_EDITOR_OPTION_RESET_INHERITED_DEFAULT_VALUE.get((Object)svalue);
            }
            if (!isMandatory && query.isUndefined()) {
                return DsconfigMessages.INFO_EDITOR_OPTION_LEAVE_UNDEFINED.get();
            }
            return null;
        }

        private <T> MenuResult<Boolean> runMenu(PropertyDefinition<T> d, ConsoleApplication app, final SortedSet<T> defaultValues, final SortedSet<T> oldValues, final SortedSet<T> currentValues, MenuCallback<Boolean> addCallback, MenuCallback<Boolean> removeCallback) {
            MenuResult result;
            Object callback;
            MenuBuilder builder = new MenuBuilder(app);
            builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_MODIFY_MENU.get((Object)d.getName()));
            if (!d.hasOption(PropertyOption.MANDATORY) || !currentValues.isEmpty()) {
                MenuResult result2 = !oldValues.equals(currentValues) ? MenuResult.success((Object)true) : MenuResult.cancel();
                LocalizableMessage option = this.getKeepDefaultValuesMenuOption(d, defaultValues, oldValues, currentValues);
                builder.addNumberedOption(option, result2, new LocalizableMessage[0]);
                builder.setDefault(LocalizableMessage.raw((CharSequence)"1", (Object[])new Object[0]), result2);
            }
            if (addCallback != null) {
                int i = builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_ADD_ONE_OR_MORE_VALUES.get(), addCallback, new LocalizableMessage[0]);
                if (d.hasOption(PropertyOption.MANDATORY) && currentValues.isEmpty()) {
                    builder.setDefault(LocalizableMessage.raw((CharSequence)"%d", (Object[])new Object[]{i}), addCallback);
                }
            }
            if (!currentValues.isEmpty()) {
                builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_REMOVE_ONE_OR_MORE_VALUES.get(), removeCallback, new LocalizableMessage[0]);
            }
            LocalizableMessage resetOption = null;
            if (!currentValues.equals(defaultValues)) {
                resetOption = this.getResetToDefaultValuesMenuOption(d, defaultValues, currentValues);
            }
            if (!(currentValues.isEmpty() || resetOption != null && defaultValues.isEmpty())) {
                callback = new MenuCallback<Boolean>(){

                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
                        PropertyValueEditor.this.isLastChoiceReset = false;
                        currentValues.clear();
                        app.println();
                        app.pressReturnToContinue();
                        return MenuResult.success((Object)false);
                    }
                };
                builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_REMOVE_ALL_VALUES.get(), (MenuCallback)callback, new LocalizableMessage[0]);
            }
            if (resetOption != null) {
                callback = new MenuCallback<Boolean>(){

                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
                        currentValues.clear();
                        currentValues.addAll(defaultValues);
                        PropertyValueEditor.this.isLastChoiceReset = true;
                        app.println();
                        app.pressReturnToContinue();
                        return MenuResult.success((Object)false);
                    }
                };
                builder.addNumberedOption(resetOption, (MenuCallback)callback, new LocalizableMessage[0]);
            }
            if (!oldValues.equals(currentValues)) {
                callback = new MenuCallback<Boolean>(){

                    public MenuResult<Boolean> invoke(ConsoleApplication app) throws ClientException {
                        currentValues.clear();
                        currentValues.addAll(oldValues);
                        PropertyValueEditor.this.isLastChoiceReset = false;
                        app.println();
                        app.pressReturnToContinue();
                        return MenuResult.success((Object)false);
                    }
                };
                builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_REVERT_CHANGES.get(), (MenuCallback)callback, new LocalizableMessage[0]);
            }
            builder.addHelpOption((HelpCallback)new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            builder.addQuitOption();
            Menu menu = builder.toMenu();
            try {
                app.println();
                result = menu.run();
            }
            catch (ClientException e) {
                this.e = e;
                return null;
            }
            if (result.isSuccess()) {
                if (((Boolean)result.getValue()).booleanValue()) {
                    this.mo.setPropertyValues(d, currentValues);
                    PropertyValueEditor.this.registerModification(d, currentValues, oldValues);
                    app.println();
                    app.pressReturnToContinue();
                    return MenuResult.success((Object)false);
                }
                app.println();
                return MenuResult.again();
            }
            if (result.isCancel()) {
                app.println();
                app.pressReturnToContinue();
                return MenuResult.success((Object)false);
            }
            return MenuResult.quit();
        }
    }

    private final class MandatoryPropertyInitializer
    extends PropertyDefinitionVisitor<MenuResult<Void>, Void>
    implements MenuCallback<Void> {
        private ClientException e;
        private final ManagedObject<?> mo;
        private final PropertyDefinition<?> pd;

        private MandatoryPropertyInitializer(ManagedObject<?> mo, PropertyDefinition<?> pd) {
            this.mo = mo;
            this.pd = pd;
        }

        public MenuResult<Void> invoke(ConsoleApplication app) throws ClientException {
            PropertyValueEditor.displayPropertyHeader(app, this.pd);
            MenuResult<Void> result = this.pd.accept(this, null);
            if (this.e != null) {
                throw this.e;
            }
            return result;
        }

        @Override
        public <C extends ConfigurationClient, S extends Configuration> MenuResult<Void> visitAggregation(AggregationPropertyDefinition<C, S> d, Void p) {
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setMultipleColumnThreshold(8);
            InstantiableRelationDefinition<C, S> rd = d.getRelationDefinition();
            if (d.hasOption(PropertyOption.MULTI_VALUED)) {
                builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_COMPONENT_MULTI.get((Object)rd.getUserFriendlyPluralName(), (Object)d.getName()));
                builder.setAllowMultiSelect(true);
            } else {
                builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_COMPONENT_SINGLE.get((Object)rd.getUserFriendlyName(), (Object)d.getName()));
            }
            TreeSet<String> values = new TreeSet<String>(d);
            ManagedObjectPath<?, ?> path = d.getParentPath();
            try {
                values.addAll(Arrays.asList(PropertyValueEditor.this.context.listManagedObjects(path, rd)));
            }
            catch (AuthorizationException e) {
                this.e = new ClientException(ReturnCode.CLIENT_SIDE_PARAM_ERROR, LocalizableMessage.raw((CharSequence)e.getMessage(), (Object[])new Object[0]));
                return MenuResult.quit();
            }
            catch (ManagedObjectNotFoundException e) {
                this.e = new ClientException(ReturnCode.NO_SUCH_OBJECT, e.getMessageObject());
                return MenuResult.cancel();
            }
            catch (LdapException e) {
                this.e = new ClientException(ReturnCode.APPLICATION_ERROR, LocalizableMessage.raw((CharSequence)e.getMessage(), (Object[])new Object[0]));
                return MenuResult.quit();
            }
            for (String value : values) {
                LocalizableMessage option = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                builder.addNumberedOption(option, MenuResult.success((Object)value), new LocalizableMessage[0]);
            }
            CreateComponentCallback callback = new CreateComponentCallback(d);
            builder.addNumberedOption(DsconfigMessages.INFO_EDITOR_OPTION_CREATE_A_NEW_COMPONENT.get((Object)rd.getUserFriendlyName()), callback, new LocalizableMessage[0]);
            builder.addHelpOption((HelpCallback)new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            if (PropertyValueEditor.this.app.isMenuDrivenMode()) {
                builder.addCancelOption(true);
            }
            builder.addQuitOption();
            Menu menu = builder.toMenu();
            try {
                PropertyValueEditor.this.app.println();
                MenuResult result = menu.run();
                if (result.isQuit()) {
                    return MenuResult.quit();
                }
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
                Collection newValues = result.getValues();
                TreeSet<String> oldValues = new TreeSet<String>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, newValues);
                PropertyValueEditor.this.isLastChoiceReset = false;
                PropertyValueEditor.this.registerModification(d, new TreeSet(newValues), oldValues);
                return MenuResult.success();
            }
            catch (ClientException e) {
                this.e = e;
                return MenuResult.cancel();
            }
        }

        @Override
        public MenuResult<Void> visitBoolean(BooleanPropertyDefinition d, Void p) {
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUE_SINGLE.get((Object)d.getName()));
            builder.addNumberedOption(DsconfigMessages.INFO_VALUE_TRUE.get(), MenuResult.success((Object)true), new LocalizableMessage[0]);
            builder.addNumberedOption(DsconfigMessages.INFO_VALUE_FALSE.get(), MenuResult.success((Object)false), new LocalizableMessage[0]);
            builder.addHelpOption((HelpCallback)new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            if (PropertyValueEditor.this.app.isMenuDrivenMode()) {
                builder.addCancelOption(true);
            }
            builder.addQuitOption();
            Menu menu = builder.toMenu();
            try {
                PropertyValueEditor.this.app.println();
                MenuResult result = menu.run();
                if (result.isQuit()) {
                    return MenuResult.quit();
                }
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
                Collection newValues = result.getValues();
                TreeSet<Boolean> oldValues = new TreeSet<Boolean>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, newValues);
                PropertyValueEditor.this.isLastChoiceReset = false;
                PropertyValueEditor.this.registerModification(d, new TreeSet(newValues), oldValues);
                return MenuResult.success();
            }
            catch (ClientException e) {
                this.e = e;
                return MenuResult.cancel();
            }
        }

        @Override
        public <E extends Enum<E>> MenuResult<Void> visitEnum(EnumPropertyDefinition<E> d, Void x) {
            MenuBuilder builder = new MenuBuilder(PropertyValueEditor.this.app);
            builder.setMultipleColumnThreshold(8);
            if (d.hasOption(PropertyOption.MULTI_VALUED)) {
                builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUE_MULTI.get((Object)d.getName()));
                builder.setAllowMultiSelect(true);
            } else {
                builder.setPrompt(DsconfigMessages.INFO_EDITOR_PROMPT_SELECT_VALUE_SINGLE.get((Object)d.getName()));
            }
            TreeSet<E> values = new TreeSet<E>(d);
            values.addAll(EnumSet.allOf(d.getEnumClass()));
            for (Enum value : values) {
                LocalizableMessage option = PropertyValueEditor.getPropertyValues(d, Collections.singleton(value));
                builder.addNumberedOption(option, MenuResult.success((Object)value), new LocalizableMessage[0]);
            }
            builder.addHelpOption((HelpCallback)new PropertyHelpCallback(this.mo.getManagedObjectDefinition(), d));
            if (PropertyValueEditor.this.app.isMenuDrivenMode()) {
                builder.addCancelOption(true);
            }
            builder.addQuitOption();
            Menu menu = builder.toMenu();
            try {
                PropertyValueEditor.this.app.println();
                MenuResult result = menu.run();
                if (result.isQuit()) {
                    return MenuResult.quit();
                }
                if (result.isCancel()) {
                    return MenuResult.cancel();
                }
                Collection newValues = result.getValues();
                TreeSet<E> oldValues = new TreeSet<E>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, newValues);
                PropertyValueEditor.this.isLastChoiceReset = false;
                PropertyValueEditor.this.registerModification(d, new TreeSet(newValues), oldValues);
                return MenuResult.success();
            }
            catch (ClientException e) {
                this.e = e;
                return MenuResult.cancel();
            }
        }

        @Override
        public <T> MenuResult<Void> visitUnknown(PropertyDefinition<T> d, Void p) {
            PropertyValueEditor.this.app.println();
            PropertyValueEditor.displayPropertySyntax(PropertyValueEditor.this.app, d);
            try {
                SortedSet values = PropertyValueEditor.readPropertyValues(PropertyValueEditor.this.app, this.mo.getManagedObjectDefinition(), d);
                TreeSet<T> oldValues = new TreeSet<T>(this.mo.getPropertyValues(d));
                this.mo.setPropertyValues(d, values);
                PropertyValueEditor.this.isLastChoiceReset = false;
                PropertyValueEditor.this.registerModification(d, values, oldValues);
                return MenuResult.success();
            }
            catch (ClientException e) {
                this.e = e;
                return MenuResult.cancel();
            }
        }
    }

    private static final class DefaultBehaviorQuery<T> {
        private final LocalizableMessage aliasDescription;
        private final Type type;

        public static <T> DefaultBehaviorQuery<T> query(PropertyDefinition<T> pd) {
            DefaultBehaviorProviderVisitor visitor = new DefaultBehaviorProviderVisitor<T, DefaultBehaviorQuery<T>, PropertyDefinition<T>>(){

                @Override
                public DefaultBehaviorQuery<T> visitAbsoluteInherited(AbsoluteInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
                    String propertyName = d.getPropertyName();
                    PropertyDefinition<?> pd2 = mod.getPropertyDefinition(propertyName);
                    DefaultBehaviorQuery<?> query = DefaultBehaviorQuery.query(pd2);
                    return new DefaultBehaviorQuery(Type.INHERITED, query.getAliasDescription());
                }

                @Override
                public DefaultBehaviorQuery<T> visitAlias(AliasDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    return new DefaultBehaviorQuery(Type.ALIAS, d.getSynopsis());
                }

                @Override
                public DefaultBehaviorQuery<T> visitDefined(DefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    return new DefaultBehaviorQuery(Type.DEFINED, null);
                }

                @Override
                public DefaultBehaviorQuery<T> visitRelativeInherited(RelativeInheritedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    AbstractManagedObjectDefinition<?, ?> mod = d.getManagedObjectDefinition();
                    String propertyName = d.getPropertyName();
                    PropertyDefinition<?> pd2 = mod.getPropertyDefinition(propertyName);
                    DefaultBehaviorQuery<?> query = DefaultBehaviorQuery.query(pd2);
                    return new DefaultBehaviorQuery(Type.INHERITED, query.getAliasDescription());
                }

                @Override
                public DefaultBehaviorQuery<T> visitUndefined(UndefinedDefaultBehaviorProvider<T> d, PropertyDefinition<T> p) {
                    return new DefaultBehaviorQuery(Type.UNDEFINED, null);
                }
            };
            return (DefaultBehaviorQuery)pd.getDefaultBehaviorProvider().accept(visitor, pd);
        }

        private DefaultBehaviorQuery(Type type, LocalizableMessage aliasDescription) {
            this.type = type;
            this.aliasDescription = aliasDescription;
        }

        public LocalizableMessage getAliasDescription() {
            return this.aliasDescription;
        }

        public boolean isAlias() {
            return this.type == Type.ALIAS;
        }

        public boolean isDefined() {
            return this.type == Type.DEFINED;
        }

        public boolean isInherited() {
            return this.type == Type.INHERITED;
        }

        public boolean isUndefined() {
            return this.type == Type.UNDEFINED;
        }

        private static enum Type {
            ALIAS,
            DEFINED,
            INHERITED,
            UNDEFINED;

        }
    }

    private static final class ComponentHelpCallback
    implements HelpCallback {
        private final ManagedObject<?> mo;
        private final Collection<PropertyDefinition<?>> properties;

        private ComponentHelpCallback(ManagedObject<?> mo, Collection<PropertyDefinition<?>> c) {
            this.mo = mo;
            this.properties = c;
        }

        public void display(ConsoleApplication app) {
            app.println();
            HelpSubCommandHandler.displaySingleComponent(app, this.mo, this.properties);
            app.println();
            app.pressReturnToContinue();
        }
    }

    private final class CreateComponentCallback<C extends ConfigurationClient, S extends Configuration>
    implements MenuCallback<String> {
        private final AggregationPropertyDefinition<C, S> pd;

        private CreateComponentCallback(AggregationPropertyDefinition<C, S> pd) {
            this.pd = pd;
        }

        public MenuResult<String> invoke(ConsoleApplication app) throws ClientException {
            try {
                ManagedObject<?> parent;
                InstantiableRelationDefinition<C, S> rd = this.pd.getRelationDefinition();
                ManagedObjectPath<?, ?> path = this.pd.getParentPath();
                LocalizableMessage ufn = rd.getUserFriendlyName();
                try {
                    parent = PropertyValueEditor.this.context.getManagedObject(path);
                }
                catch (AuthorizationException e) {
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_AUTHZ.get((Object)ufn);
                    throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
                }
                catch (DefinitionDecodingException e) {
                    LocalizableMessage pufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get((Object)pufn, (Object)pufn, (Object)pufn);
                    throw new ClientException(ReturnCode.OTHER, msg);
                }
                catch (ManagedObjectDecodingException e) {
                    LocalizableMessage pufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get((Object)pufn);
                    throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
                }
                catch (LdapException e) {
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_CREATE_CE.get((Object)ufn, (Object)e.getMessage());
                    throw new ClientException(ReturnCode.CLIENT_SIDE_SERVER_DOWN, msg);
                }
                catch (ManagedObjectNotFoundException e) {
                    LocalizableMessage pufn = path.getManagedObjectDefinition().getUserFriendlyName();
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get((Object)pufn);
                    return DSConfig.interactivePrintOrThrowError(app, msg, ReturnCode.NO_SUCH_OBJECT);
                }
                app.println();
                app.println();
                return CreateSubCommandHandler.createManagedObject(app, PropertyValueEditor.this.context, parent, rd);
            }
            catch (ClientException e) {
                app.errPrintln();
                app.errPrintln(e.getMessageObject());
                app.errPrintln();
                app.pressReturnToContinue();
                return MenuResult.cancel();
            }
        }
    }
}

