/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.dsconfig;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.ClientException;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.MenuResult;
import com.forgerock.opendj.cli.ReturnCode;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.SubCommand;
import com.forgerock.opendj.cli.SubCommandArgumentParser;
import com.forgerock.opendj.cli.TableBuilder;
import com.forgerock.opendj.cli.TablePrinter;
import com.forgerock.opendj.cli.TextTablePrinter;
import com.forgerock.opendj.dsconfig.DsconfigMessages;
import java.io.OutputStream;
import java.util.List;
import java.util.SortedMap;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SetRelationDefinition;
import org.forgerock.opendj.config.client.ConcurrentModificationException;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.client.OperationRejectedException;
import org.forgerock.opendj.config.dsconfig.DSConfig;
import org.forgerock.opendj.config.dsconfig.LDAPManagementContextFactory;
import org.forgerock.opendj.config.dsconfig.SubCommandHandler;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.LdapException;

final class DeleteSubCommandHandler
extends SubCommandHandler {
    private static final String OPTION_DSCFG_LONG_FORCE = "force";
    private static final char OPTION_DSCFG_SHORT_FORCE = 'f';
    private final BooleanArgument forceArgument;
    private final List<StringArgument> namingArgs;
    private final ManagedObjectPath<?, ?> path;
    private final RelationDefinition<?, ?> relation;
    private final SubCommand subCommand;

    public static DeleteSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, InstantiableRelationDefinition<?, ?> r) throws ArgumentException {
        return new DeleteSubCommandHandler(parser, p, r, p.child(r, "DUMMY"));
    }

    public static DeleteSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, OptionalRelationDefinition<?, ?> r) throws ArgumentException {
        return new DeleteSubCommandHandler(parser, p, r, p.child(r));
    }

    public static DeleteSubCommandHandler create(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, SetRelationDefinition<?, ?> r) throws ArgumentException {
        return new DeleteSubCommandHandler(parser, p, r, p.child(r));
    }

    private DeleteSubCommandHandler(SubCommandArgumentParser parser, ManagedObjectPath<?, ?> p, RelationDefinition<?, ?> r, ManagedObjectPath<?, ?> c) throws ArgumentException {
        this.path = p;
        this.relation = r;
        String name = "delete-" + r.getName();
        LocalizableMessage ufpn = r.getChildDefinition().getUserFriendlyPluralName();
        LocalizableMessage description = DsconfigMessages.INFO_DSCFG_DESCRIPTION_SUBCMD_DELETE.get((Object)ufpn);
        this.subCommand = new SubCommand(parser, name, false, 0, 0, null, description);
        this.namingArgs = this.createNamingArgs(this.subCommand, c, false);
        this.forceArgument = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)OPTION_DSCFG_LONG_FORCE).shortIdentifier(Character.valueOf('f'))).description(DsconfigMessages.INFO_DSCFG_DESCRIPTION_FORCE.get((Object)ufpn))).buildAndAddToSubCommand(this.subCommand);
        this.addTags(this.relation.getChildDefinition().getAllTags());
    }

    public RelationDefinition<?, ?> getRelationDefinition() {
        return this.relation;
    }

    @Override
    public SubCommand getSubCommand() {
        return this.subCommand;
    }

    @Override
    public MenuResult<Integer> run(ConsoleApplication app, LDAPManagementContextFactory factory) throws ArgumentException, ClientException {
        LocalizableMessage ufn;
        block33: {
            MenuResult<ManagedObject<?>> result;
            List<String> names = this.getNamingArgValues(app, this.namingArgs);
            this.getCommandBuilder().clearArguments();
            this.setCommandBuilderUseful(false);
            ManagementContext context = factory.getManagementContext(app);
            ufn = this.relation.getUserFriendlyName();
            try {
                result = this.getManagedObject(app, context, this.path, names);
            }
            catch (AuthorizationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_DELETE_AUTHZ.get((Object)ufn);
                throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
            }
            catch (DefinitionDecodingException e) {
                LocalizableMessage pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_DDE.get((Object)pufn, (Object)pufn, (Object)pufn);
                throw new ClientException(ReturnCode.OTHER, msg);
            }
            catch (ManagedObjectDecodingException e) {
                LocalizableMessage pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MODE.get((Object)pufn);
                throw new ClientException(ReturnCode.OTHER, msg, (Throwable)e);
            }
            catch (ConcurrentModificationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_DELETE_CME.get((Object)ufn);
                throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
            }
            catch (ManagedObjectNotFoundException e) {
                if (!this.forceArgument.isPresent()) {
                    LocalizableMessage pufn = this.path.getManagedObjectDefinition().getUserFriendlyName();
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_GET_PARENT_MONFE.get((Object)pufn);
                    return DSConfig.interactivePrintOrThrowError(app, msg, ReturnCode.NO_SUCH_OBJECT);
                }
                return MenuResult.success((Object)0);
            }
            catch (LdapException e) {
                throw new ClientException(ReturnCode.OTHER, LocalizableMessage.raw((CharSequence)e.getLocalizedMessage(), (Object[])new Object[0]));
            }
            if (result.isQuit()) {
                if (!app.isMenuDrivenMode()) {
                    app.println();
                    app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_DELETE_FAIL.get((Object)ufn));
                }
                return MenuResult.quit();
            }
            if (result.isCancel()) {
                return MenuResult.cancel();
            }
            ManagedObject parent = (ManagedObject)result.getValue();
            try {
                if (this.relation instanceof InstantiableRelationDefinition || this.relation instanceof SetRelationDefinition) {
                    String childName = names.get(names.size() - 1);
                    if (childName == null) {
                        MenuResult<String> sresult = this.readChildName(app, parent, this.relation, null);
                        if (sresult.isQuit()) {
                            if (!app.isMenuDrivenMode()) {
                                app.println();
                                app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_DELETE_FAIL.get((Object)ufn));
                            }
                            return MenuResult.quit();
                        }
                        if (sresult.isCancel()) {
                            return MenuResult.cancel();
                        }
                        childName = (String)sresult.getValue();
                    } else if (this.relation instanceof SetRelationDefinition) {
                        String name = childName.trim();
                        SortedMap<String, ManagedObjectDefinition<?, ?>> types = DeleteSubCommandHandler.getSubTypes(this.relation.getChildDefinition());
                        ManagedObjectDefinition cd = (ManagedObjectDefinition)types.get(name);
                        if (cd == null) {
                            String typeUsage = DeleteSubCommandHandler.getSubTypesUsage(this.relation.getChildDefinition());
                            LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_SUB_TYPE_UNRECOGNIZED.get((Object)name, (Object)this.relation.getUserFriendlyName(), (Object)typeUsage);
                            throw new ArgumentException(msg);
                        }
                        childName = cd.getName();
                    }
                    if (this.confirmDeletion(app)) {
                        this.setCommandBuilderUseful(true);
                        if (this.relation instanceof InstantiableRelationDefinition) {
                            parent.removeChild((InstantiableRelationDefinition)this.relation, childName);
                        } else {
                            parent.removeChild((SetRelationDefinition)this.relation, childName);
                        }
                        break block33;
                    }
                    return MenuResult.cancel();
                }
                if (!(this.relation instanceof OptionalRelationDefinition)) break block33;
                OptionalRelationDefinition orelation = (OptionalRelationDefinition)this.relation;
                if (this.confirmDeletion(app)) {
                    this.setCommandBuilderUseful(true);
                    parent.removeChild(orelation);
                    break block33;
                }
                return MenuResult.cancel();
            }
            catch (AuthorizationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_DELETE_AUTHZ.get((Object)ufn);
                throw new ClientException(ReturnCode.INSUFFICIENT_ACCESS_RIGHTS, msg);
            }
            catch (OperationRejectedException e) {
                LocalizableMessage msg;
                LocalizableMessage localizableMessage = msg = e.getMessages().size() == 1 ? DsconfigMessages.ERR_DSCFG_ERROR_DELETE_ORE_SINGLE.get((Object)ufn) : DsconfigMessages.ERR_DSCFG_ERROR_DELETE_ORE_PLURAL.get((Object)ufn);
                if (app.isInteractive()) {
                    app.errPrintln();
                    app.errPrintln(msg);
                    app.errPrintln();
                    TableBuilder builder = new TableBuilder();
                    for (LocalizableMessage reason : e.getMessages()) {
                        builder.startRow();
                        builder.appendCell((Object)"*");
                        builder.appendCell((Object)reason);
                    }
                    TextTablePrinter printer = new TextTablePrinter((OutputStream)app.getErrorStream());
                    printer.setDisplayHeadings(false);
                    printer.setColumnWidth(1, 0);
                    printer.setIndentWidth(4);
                    builder.print((TablePrinter)printer);
                    return MenuResult.cancel();
                }
                throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg, (Throwable)e);
            }
            catch (ManagedObjectNotFoundException e) {
                if (!this.forceArgument.isPresent()) {
                    LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_DELETE_MONFE.get((Object)ufn);
                    throw new ClientException(ReturnCode.NO_SUCH_OBJECT, msg);
                }
            }
            catch (ConcurrentModificationException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_DELETE_CME.get((Object)ufn);
                throw new ClientException(ReturnCode.CONSTRAINT_VIOLATION, msg);
            }
            catch (LdapException e) {
                LocalizableMessage msg = DsconfigMessages.ERR_DSCFG_ERROR_DELETE_CE.get((Object)ufn, (Object)e.getMessage());
                throw new ClientException(ReturnCode.CLIENT_SIDE_SERVER_DOWN, msg);
            }
        }
        for (StringArgument arg : this.namingArgs) {
            if (!arg.isPresent()) continue;
            this.getCommandBuilder().addArgument((Argument)arg);
        }
        app.println();
        app.println(DsconfigMessages.INFO_DSCFG_CONFIRM_DELETE_SUCCESS.get((Object)ufn));
        return MenuResult.success((Object)0);
    }

    private boolean confirmDeletion(ConsoleApplication app) throws ClientException {
        if (app.isInteractive()) {
            app.println();
            if (!app.confirmAction(DsconfigMessages.INFO_DSCFG_CONFIRM_DELETE.get((Object)this.relation.getUserFriendlyName()), false)) {
                app.errPrintln(DsconfigMessages.INFO_DSCFG_CONFIRM_DELETE_FAIL.get((Object)this.relation.getUserFriendlyName()));
                return false;
            }
        }
        return true;
    }
}

