/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config.conditions;

import java.util.Collection;
import java.util.SortedSet;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.conditions.Condition;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.util.Reject;

public final class ContainsCondition
implements Condition {
    private Impl<?> impl;
    private final String propertyName;
    private final String propertyStringValue;

    public ContainsCondition(String propertyName, String stringValue) {
        Reject.ifNull((Object)propertyName, (String)stringValue);
        this.propertyName = propertyName;
        this.propertyStringValue = stringValue;
    }

    @Override
    public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws LdapException {
        return this.impl.evaluate(context, managedObject);
    }

    @Override
    public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
        return this.impl.evaluate(managedObject);
    }

    public void setPropertyValue(ManagedObject<?> managedObject) {
        ((Impl)this.impl).setPropertyValue(managedObject);
    }

    @Override
    public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        this.buildImpl(d.getPropertyDefinition(this.propertyName));
    }

    private <T> void buildImpl(PropertyDefinition<T> pd) {
        T value = pd.decodeValue(this.propertyStringValue);
        this.impl = new Impl(pd, value);
    }

    public PropertyDefinition<?> getPropertyDefinition() {
        return this.impl.pd;
    }

    public Object getValue() {
        return this.impl.value;
    }

    private static final class Impl<T>
    implements Condition {
        final PropertyDefinition<T> pd;
        final T value;

        private Impl(PropertyDefinition<T> pd, T value) {
            this.pd = pd;
            this.value = value;
        }

        @Override
        public boolean evaluate(ManagementContext context, ManagedObject<?> managedObject) throws LdapException {
            SortedSet<T> values = managedObject.getPropertyValues(this.pd);
            return values.contains(this.value);
        }

        @Override
        public boolean evaluate(ServerManagedObject<?> managedObject) throws ConfigException {
            Collection values = managedObject.getPropertyValues((PropertyDefinition)this.pd);
            return values.contains(this.value);
        }

        @Override
        public void initialize(AbstractManagedObjectDefinition<?, ?> d) throws Exception {
        }

        private void setPropertyValue(ManagedObject<?> managedObject) {
            managedObject.setPropertyValue(this.pd, this.value);
        }
    }
}

