/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.EnumSet;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.opendj.config.SizeUnit;
import org.forgerock.util.Reject;

public final class SizePropertyDefinition
extends PropertyDefinition<Long> {
    private static final String UNLIMITED = "unlimited";
    private final long lowerLimit;
    private final Long upperLimit;
    private final boolean allowUnlimited;

    public static Builder createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private SizePropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Long> defaultBehavior, Long lowerLimit, Long upperLimit, boolean allowUnlimited) {
        super(d, Long.class, propertyName, options, adminAction, defaultBehavior);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.allowUnlimited = allowUnlimited;
    }

    public long getLowerLimit() {
        return this.lowerLimit;
    }

    public Long getUpperLimit() {
        return this.upperLimit;
    }

    public boolean isAllowUnlimited() {
        return this.allowUnlimited;
    }

    @Override
    public void validateValue(Long value) {
        Reject.ifNull((Object)value);
        if (!this.allowUnlimited && value < this.lowerLimit) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        if (value >= 0L && value < this.lowerLimit) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        if (this.upperLimit != null && value > this.upperLimit) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public String encodeValue(Long value) {
        Reject.ifNull((Object)value);
        if (this.allowUnlimited && value < 0L) {
            return UNLIMITED;
        }
        StringBuilder builder = new StringBuilder();
        SizeUnit unit = SizeUnit.getBestFitUnitExact(value);
        builder.append((long)unit.fromBytes(value));
        builder.append(' ');
        builder.append((Object)unit);
        return builder.toString();
    }

    @Override
    public Long decodeValue(String value) {
        Long i;
        Reject.ifNull((Object)value);
        if (this.allowUnlimited && UNLIMITED.equalsIgnoreCase(value.trim())) {
            return -1L;
        }
        try {
            i = SizeUnit.parseValue(value, SizeUnit.BYTES);
        }
        catch (NumberFormatException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        try {
            this.validateValue(i);
        }
        catch (PropertyException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
        return i;
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitSize(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, Long value, P p) {
        return v.visitSize(this, value, p);
    }

    @Override
    public void toString(StringBuilder builder) {
        super.toString(builder);
        builder.append(" lowerLimit=");
        builder.append(this.lowerLimit);
        if (this.upperLimit != null) {
            builder.append(" upperLimit=");
            builder.append(this.upperLimit);
        }
        builder.append(" allowUnlimited=");
        builder.append(this.allowUnlimited);
    }

    @Override
    public int compare(Long o1, Long o2) {
        return o1.compareTo(o2);
    }

    public static final class Builder
    extends PropertyDefinition.AbstractBuilder<Long, SizePropertyDefinition> {
        private long lowerLimit;
        private Long upperLimit;
        private boolean allowUnlimited;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setLowerLimit(long lowerLimit) {
            if (lowerLimit < 0L) {
                throw new IllegalArgumentException("Negative lower limit");
            }
            if (this.upperLimit != null && lowerLimit > this.upperLimit) {
                throw new IllegalArgumentException("Lower limit greater than upper limit");
            }
            this.lowerLimit = lowerLimit;
        }

        public final void setLowerLimit(String lowerLimit) {
            this.setLowerLimit(SizeUnit.parseValue(lowerLimit, SizeUnit.BYTES));
        }

        public final void setUpperLimit(Long upperLimit) {
            if (upperLimit != null) {
                if (upperLimit < 0L) {
                    throw new IllegalArgumentException("Negative upper limit");
                }
                if (this.lowerLimit > upperLimit) {
                    throw new IllegalArgumentException("Lower limit greater than upper limit");
                }
            }
            this.upperLimit = upperLimit;
        }

        public final void setUpperLimit(String upperLimit) {
            this.setUpperLimit(upperLimit != null ? Long.valueOf(SizeUnit.parseValue(upperLimit, SizeUnit.BYTES)) : null);
        }

        public final void setAllowUnlimited(boolean allowUnlimited) {
            this.allowUnlimited = allowUnlimited;
        }

        @Override
        protected SizePropertyDefinition buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<Long> defaultBehavior) {
            return new SizePropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.lowerLimit, this.upperLimit, this.allowUnlimited);
        }
    }
}

