/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.ConfigurationFramework;

public final class ManagedObjectDefinitionI18NResource {
    private static final Map<String, ManagedObjectDefinitionI18NResource> INSTANCES = new HashMap<String, ManagedObjectDefinitionI18NResource>();
    private final Map<AbstractManagedObjectDefinition<?, ?>, Map<Locale, ResourceBundle>> resources = new HashMap();
    private final String prefix;

    public static ManagedObjectDefinitionI18NResource getInstance() {
        return ManagedObjectDefinitionI18NResource.getInstance("config.messages");
    }

    public static ManagedObjectDefinitionI18NResource getInstanceForProfile(String profile) {
        return ManagedObjectDefinitionI18NResource.getInstance("config.profiles." + profile);
    }

    private static synchronized ManagedObjectDefinitionI18NResource getInstance(String prefix) {
        ManagedObjectDefinitionI18NResource instance = INSTANCES.get(prefix);
        if (instance == null) {
            instance = new ManagedObjectDefinitionI18NResource(prefix);
            INSTANCES.put(prefix, instance);
        }
        return instance;
    }

    private ManagedObjectDefinitionI18NResource(String prefix) {
        this.prefix = prefix;
    }

    public LocalizableMessage getMessage(AbstractManagedObjectDefinition<?, ?> d, String key) {
        return this.getMessage(d, key, Locale.getDefault(), (String[])null);
    }

    public LocalizableMessage getMessage(AbstractManagedObjectDefinition<?, ?> d, String key, Locale locale) {
        return this.getMessage(d, key, locale, (String[])null);
    }

    public LocalizableMessage getMessage(AbstractManagedObjectDefinition<?, ?> d, String key, Locale locale, String ... args) {
        ResourceBundle resource = this.getResourceBundle(d, locale);
        if (args != null) {
            return LocalizableMessage.raw((CharSequence)resource.getString(key), (Object[])args);
        }
        return LocalizableMessage.raw((CharSequence)resource.getString(key), (Object[])new Object[0]);
    }

    public LocalizableMessage getMessage(AbstractManagedObjectDefinition<?, ?> d, String key, String ... args) {
        return this.getMessage(d, key, Locale.getDefault(), args);
    }

    synchronized void removeResourceBundle(AbstractManagedObjectDefinition<?, ?> d) {
        this.removeResourceBundle(d, Locale.getDefault());
    }

    synchronized void removeResourceBundle(AbstractManagedObjectDefinition<?, ?> d, Locale locale) {
        Map<Locale, ResourceBundle> map = this.resources.get(d);
        if (map != null) {
            map.remove(locale);
        }
    }

    synchronized void setResourceBundle(AbstractManagedObjectDefinition<?, ?> d, ResourceBundle resoureBundle) {
        this.setResourceBundle(d, Locale.getDefault(), resoureBundle);
    }

    synchronized void setResourceBundle(AbstractManagedObjectDefinition<?, ?> d, Locale locale, ResourceBundle resoureBundle) {
        this.getMapping(d).put(locale, resoureBundle);
    }

    private synchronized ResourceBundle getResourceBundle(AbstractManagedObjectDefinition<?, ?> d, Locale locale) {
        if (d.isTop()) {
            throw new UnsupportedOperationException("I18n resources are not available for the Top configuration definition");
        }
        Map<Locale, ResourceBundle> map = this.getMapping(d);
        ResourceBundle resourceBundle = map.get(locale);
        if (resourceBundle == null) {
            String baseName = this.prefix + "." + d.getClass().getName();
            resourceBundle = ResourceBundle.getBundle(baseName, locale, ConfigurationFramework.getInstance().getClassLoader());
            map.put(locale, resourceBundle);
        }
        return resourceBundle;
    }

    private Map<Locale, ResourceBundle> getMapping(AbstractManagedObjectDefinition<?, ?> d) {
        Map<Locale, ResourceBundle> map = this.resources.get(d);
        if (map == null) {
            map = new HashMap<Locale, ResourceBundle>();
            this.resources.put(d, map);
        }
        return map;
    }
}

