/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.config;

import com.forgerock.opendj.ldap.config.ConfigMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.config.AbstractManagedObjectDefinition;
import org.forgerock.opendj.config.AdministratorAction;
import org.forgerock.opendj.config.Configuration;
import org.forgerock.opendj.config.ConfigurationClient;
import org.forgerock.opendj.config.Constraint;
import org.forgerock.opendj.config.DefaultBehaviorProvider;
import org.forgerock.opendj.config.DefinitionDecodingException;
import org.forgerock.opendj.config.InstantiableRelationDefinition;
import org.forgerock.opendj.config.ManagedObjectDefinitionI18NResource;
import org.forgerock.opendj.config.ManagedObjectNotFoundException;
import org.forgerock.opendj.config.ManagedObjectPath;
import org.forgerock.opendj.config.OperationsException;
import org.forgerock.opendj.config.OptionalRelationDefinition;
import org.forgerock.opendj.config.PropertyDefinition;
import org.forgerock.opendj.config.PropertyDefinitionVisitor;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.config.PropertyOption;
import org.forgerock.opendj.config.PropertyValueVisitor;
import org.forgerock.opendj.config.Reference;
import org.forgerock.opendj.config.RelationDefinition;
import org.forgerock.opendj.config.SingletonRelationDefinition;
import org.forgerock.opendj.config.client.ClientConstraintHandler;
import org.forgerock.opendj.config.client.ManagedObject;
import org.forgerock.opendj.config.client.ManagedObjectDecodingException;
import org.forgerock.opendj.config.client.ManagementContext;
import org.forgerock.opendj.config.conditions.Condition;
import org.forgerock.opendj.config.conditions.Conditions;
import org.forgerock.opendj.config.server.ConfigChangeResult;
import org.forgerock.opendj.config.server.ConfigException;
import org.forgerock.opendj.config.server.ConfigurationDeleteListener;
import org.forgerock.opendj.config.server.ServerConstraintHandler;
import org.forgerock.opendj.config.server.ServerManagedObject;
import org.forgerock.opendj.config.server.ServerManagedObjectChangeListener;
import org.forgerock.opendj.config.server.ServerManagementContext;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.server.config.meta.RootCfgDefn;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AggregationPropertyDefinition<C extends ConfigurationClient, S extends Configuration>
extends PropertyDefinition<String> {
    private static final Logger debugLogger = LoggerFactory.getLogger(AggregationPropertyDefinition.class);
    private final Map<DN, List<ReferentialIntegrityChangeListener>> changeListeners = new HashMap<DN, List<ReferentialIntegrityChangeListener>>();
    private final Map<DN, List<ReferentialIntegrityDeleteListener>> deleteListeners = new HashMap<DN, List<ReferentialIntegrityDeleteListener>>();
    private ManagedObjectPath<?, ?> parentPath;
    private final String parentPathString;
    private final String rdName;
    private InstantiableRelationDefinition<C, S> relationDefinition;
    private final Constraint sourceConstraint;
    private final Condition targetIsEnabledCondition;
    private final Condition targetNeedsEnablingCondition;

    public static <C extends ConfigurationClient, S extends Configuration> Builder<C, S> createBuilder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
        return new Builder(d, propertyName);
    }

    private AggregationPropertyDefinition(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior, String parentPathString, String rdName, Condition targetNeedsEnablingCondition, Condition targetIsEnabledCondition) {
        super(d, String.class, propertyName, options, adminAction, defaultBehavior);
        this.parentPathString = parentPathString;
        this.rdName = rdName;
        this.targetNeedsEnablingCondition = targetNeedsEnablingCondition;
        this.targetIsEnabledCondition = targetIsEnabledCondition;
        this.sourceConstraint = new Constraint(){

            @Override
            public Collection<ClientConstraintHandler> getClientConstraintHandlers() {
                SourceClientHandler handler = new SourceClientHandler();
                return Collections.singleton(handler);
            }

            @Override
            public Collection<ServerConstraintHandler> getServerConstraintHandlers() {
                ServerHandler handler = new ServerHandler();
                return Collections.singleton(handler);
            }
        };
    }

    @Override
    public <R, P> R accept(PropertyDefinitionVisitor<R, P> v, P p) {
        return v.visitAggregation(this, p);
    }

    @Override
    public <R, P> R accept(PropertyValueVisitor<R, P> v, String value, P p) {
        return v.visitAggregation(this, value, p);
    }

    @Override
    public String decodeValue(String value) {
        Reject.ifNull((Object)value);
        try {
            this.validateValue(value);
            return value;
        }
        catch (PropertyException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    public final DN getChildDN(String name) {
        return this.getChildPath(name).toDN();
    }

    public final ManagedObjectPath<C, S> getChildPath(String name) {
        return this.parentPath.child(this.relationDefinition, name);
    }

    public final ManagedObjectPath<?, ?> getParentPath() {
        return this.parentPath;
    }

    public final InstantiableRelationDefinition<C, S> getRelationDefinition() {
        return this.relationDefinition;
    }

    public final Constraint getSourceConstraint() {
        return this.sourceConstraint;
    }

    public final LocalizableMessage getSourceConstraintSynopsis() {
        return this.getSourceConstraintSynopsis(Locale.getDefault());
    }

    public final LocalizableMessage getSourceConstraintSynopsis(Locale locale) {
        ManagedObjectDefinitionI18NResource resource = ManagedObjectDefinitionI18NResource.getInstance();
        String property = "property." + this.getName() + ".syntax.aggregation.constraint-synopsis";
        try {
            return resource.getMessage(this.getManagedObjectDefinition(), property, locale);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public final Condition getTargetIsEnabledCondition() {
        return this.targetIsEnabledCondition;
    }

    public final Condition getTargetNeedsEnablingCondition() {
        return this.targetNeedsEnablingCondition;
    }

    @Override
    public String normalizeValue(String value) {
        try {
            Reference<C, S> reference = Reference.parseName(this.parentPath, this.relationDefinition, value);
            return reference.getNormalizedName();
        }
        catch (IllegalArgumentException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public void toString(StringBuilder builder) {
        super.toString(builder);
        builder.append(" parentPath=");
        builder.append(this.parentPath);
        builder.append(" relationDefinition=");
        builder.append(this.relationDefinition.getName());
        builder.append(" targetNeedsEnablingCondition=");
        builder.append(this.targetNeedsEnablingCondition);
        builder.append(" targetIsEnabledCondition=");
        builder.append(this.targetIsEnabledCondition);
    }

    @Override
    public void validateValue(String value) {
        try {
            Reference.parseName(this.parentPath, this.relationDefinition, value);
        }
        catch (IllegalArgumentException e) {
            throw PropertyException.illegalPropertyValueException(this, value);
        }
    }

    @Override
    public void initialize() throws Exception {
        this.parentPath = ManagedObjectPath.valueOf(this.parentPathString);
        AbstractManagedObjectDefinition<?, ?> parent = this.parentPath.getManagedObjectDefinition();
        RelationDefinition<?, ?> rd = parent.getRelationDefinition(this.rdName);
        this.relationDefinition = (InstantiableRelationDefinition)rd;
        this.targetNeedsEnablingCondition.initialize(this.getManagedObjectDefinition());
        this.targetIsEnabledCondition.initialize(rd.getChildDefinition());
        Constraint constraint = new Constraint(){

            @Override
            public Collection<ClientConstraintHandler> getClientConstraintHandlers() {
                TargetClientHandler handler = new TargetClientHandler();
                return Collections.singleton(handler);
            }

            @Override
            public Collection<ServerConstraintHandler> getServerConstraintHandlers() {
                return Collections.emptyList();
            }
        };
        rd.getChildDefinition().registerConstraint(constraint);
    }

    private class TargetClientHandler
    extends ClientConstraintHandler {
        private TargetClientHandler() {
        }

        @Override
        public boolean isDeleteAcceptable(ManagementContext context, ManagedObjectPath<?, ?> path, Collection<LocalizableMessage> unacceptableReasons) throws LdapException {
            boolean isAcceptable = true;
            for (ManagedObject<?> mo : this.findReferences(context, AggregationPropertyDefinition.this.getManagedObjectDefinition(), path.getName())) {
                LocalizableMessage uName1 = mo.getManagedObjectDefinition().getUserFriendlyName();
                LocalizableMessage uName2 = AggregationPropertyDefinition.this.getManagedObjectDefinition().getUserFriendlyName();
                String moName = mo.getManagedObjectPath().getName();
                LocalizableMessage msg = moName != null ? ConfigMessages.ERR_CLIENT_REFINT_CANNOT_DELETE_WITH_NAME.get((Object)AggregationPropertyDefinition.this.getName(), (Object)uName1, (Object)moName, (Object)uName2) : ConfigMessages.ERR_CLIENT_REFINT_CANNOT_DELETE_WITHOUT_NAME.get((Object)AggregationPropertyDefinition.this.getName(), (Object)uName1, (Object)uName2);
                unacceptableReasons.add(msg);
                isAcceptable = false;
            }
            return isAcceptable;
        }

        @Override
        public boolean isModifyAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<LocalizableMessage> unacceptableReasons) throws LdapException {
            if (AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(context, managedObject)) {
                return true;
            }
            boolean isAcceptable = true;
            for (ManagedObject<?> mo : this.findReferences(context, AggregationPropertyDefinition.this.getManagedObjectDefinition(), managedObject.getManagedObjectPath().getName())) {
                if (!AggregationPropertyDefinition.this.targetNeedsEnablingCondition.evaluate(context, mo)) continue;
                LocalizableMessage uName1 = managedObject.getManagedObjectDefinition().getUserFriendlyName();
                LocalizableMessage uName2 = mo.getManagedObjectDefinition().getUserFriendlyName();
                String moName = mo.getManagedObjectPath().getName();
                LocalizableMessage msg = moName != null ? ConfigMessages.ERR_CLIENT_REFINT_CANNOT_DISABLE_WITH_NAME.get((Object)uName1, (Object)AggregationPropertyDefinition.this.getName(), (Object)uName2, (Object)moName) : ConfigMessages.ERR_CLIENT_REFINT_CANNOT_DISABLE_WITHOUT_NAME.get((Object)uName1, (Object)AggregationPropertyDefinition.this.getName(), (Object)uName2);
                unacceptableReasons.add(msg);
                isAcceptable = false;
            }
            return isAcceptable;
        }

        private <C1 extends ConfigurationClient> List<ManagedObject<? extends C1>> findReferences(ManagementContext context, AbstractManagedObjectDefinition<C1, ?> mod, String name) throws LdapException {
            List<ManagedObject<C1>> instances = this.findInstances(context, mod);
            Iterator<ManagedObject<C1>> i = instances.iterator();
            while (i.hasNext()) {
                ManagedObject<C1> mo = i.next();
                boolean hasReference = false;
                for (String value : mo.getPropertyValues(AggregationPropertyDefinition.this)) {
                    if (AggregationPropertyDefinition.this.compare(value, name) != 0) continue;
                    hasReference = true;
                    break;
                }
                if (hasReference) continue;
                i.remove();
            }
            return instances;
        }

        private <C1 extends ConfigurationClient> List<ManagedObject<? extends C1>> findInstances(ManagementContext context, AbstractManagedObjectDefinition<C1, ?> mod) throws LdapException {
            LinkedList<ManagedObject<C1>> instances = new LinkedList<ManagedObject<C1>>();
            if (mod == RootCfgDefn.getInstance()) {
                instances.add(context.getRootConfigurationManagedObject());
            } else {
                for (RelationDefinition<C1, ?> rd : mod.getAllReverseRelationDefinitions()) {
                    for (ManagedObject<?> parent : this.findInstances(context, rd.getParentDefinition())) {
                        try {
                            ManagedObject mo;
                            if (rd instanceof SingletonRelationDefinition) {
                                SingletonRelationDefinition srd = (SingletonRelationDefinition)rd;
                                mo = parent.getChild(srd);
                                if (!mo.getManagedObjectDefinition().isChildOf(mod)) continue;
                                instances.add(mo);
                                continue;
                            }
                            if (rd instanceof OptionalRelationDefinition) {
                                OptionalRelationDefinition ord = (OptionalRelationDefinition)rd;
                                mo = parent.getChild(ord);
                                if (!mo.getManagedObjectDefinition().isChildOf(mod)) continue;
                                instances.add(mo);
                                continue;
                            }
                            if (!(rd instanceof InstantiableRelationDefinition)) continue;
                            InstantiableRelationDefinition ird = (InstantiableRelationDefinition)rd;
                            for (String name : parent.listChildren(ird)) {
                                ManagedObject mo2 = parent.getChild(ird, name);
                                if (!mo2.getManagedObjectDefinition().isChildOf(mod)) continue;
                                instances.add(mo2);
                            }
                        }
                        catch (OperationsException operationsException) {
                        }
                    }
                }
            }
            return instances;
        }
    }

    private class SourceClientHandler
    extends ClientConstraintHandler {
        private SourceClientHandler() {
        }

        @Override
        public boolean isAddAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<LocalizableMessage> unacceptableReasons) throws LdapException {
            boolean needsEnabling = AggregationPropertyDefinition.this.targetNeedsEnablingCondition.evaluate(context, managedObject);
            boolean isAcceptable = true;
            LocalizableMessage ufn = AggregationPropertyDefinition.this.getRelationDefinition().getUserFriendlyName();
            for (String name : managedObject.getPropertyValues(AggregationPropertyDefinition.this)) {
                LocalizableMessage msg;
                ManagedObject ref;
                ManagedObjectPath path = AggregationPropertyDefinition.this.getChildPath(name);
                try {
                    ref = context.getManagedObject(path);
                }
                catch (DefinitionDecodingException | ManagedObjectDecodingException e) {
                    msg = ConfigMessages.ERR_CLIENT_REFINT_TARGET_INVALID.get((Object)ufn, (Object)name, (Object)AggregationPropertyDefinition.this.getName(), (Object)e.getMessageObject());
                    unacceptableReasons.add(msg);
                    isAcceptable = false;
                    continue;
                }
                catch (ManagedObjectNotFoundException e) {
                    msg = ConfigMessages.ERR_CLIENT_REFINT_TARGET_DANGLING_REFERENCE.get((Object)ufn, (Object)name, (Object)AggregationPropertyDefinition.this.getName());
                    unacceptableReasons.add(msg);
                    isAcceptable = false;
                    continue;
                }
                if (!needsEnabling || AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(context, ref)) continue;
                LocalizableMessage msg2 = ConfigMessages.ERR_CLIENT_REFINT_TARGET_DISABLED.get((Object)ufn, (Object)name, (Object)AggregationPropertyDefinition.this.getName());
                unacceptableReasons.add(msg2);
                isAcceptable = false;
            }
            return isAcceptable;
        }

        @Override
        public boolean isModifyAcceptable(ManagementContext context, ManagedObject<?> managedObject, Collection<LocalizableMessage> unacceptableReasons) throws LdapException {
            return this.isAddAcceptable(context, managedObject, unacceptableReasons);
        }
    }

    private class ServerHandler
    extends ServerConstraintHandler {
        private ServerHandler() {
        }

        @Override
        public boolean isUsable(ServerManagedObject<?> managedObject, Collection<LocalizableMessage> unacceptableReasons) throws ConfigException {
            Collection names = managedObject.getPropertyValues((PropertyDefinition)AggregationPropertyDefinition.this);
            ServerManagementContext context = managedObject.getServerContext();
            LocalizableMessage thisUFN = managedObject.getManagedObjectDefinition().getUserFriendlyName();
            String thisDN = managedObject.getDN().toString();
            LocalizableMessage thatUFN = AggregationPropertyDefinition.this.getRelationDefinition().getUserFriendlyName();
            boolean isUsable = true;
            boolean needsEnabling = AggregationPropertyDefinition.this.targetNeedsEnablingCondition.evaluate(managedObject);
            for (String name : names) {
                ManagedObjectPath path = AggregationPropertyDefinition.this.getChildPath(name);
                String thatDN = path.toDN().toString();
                if (!context.managedObjectExists(path)) {
                    LocalizableMessage msg = ConfigMessages.ERR_SERVER_REFINT_DANGLING_REFERENCE.get((Object)name, (Object)AggregationPropertyDefinition.this.getName(), (Object)thisUFN, (Object)thisDN, (Object)thatUFN, (Object)thatDN);
                    unacceptableReasons.add(msg);
                    isUsable = false;
                    continue;
                }
                if (!needsEnabling) continue;
                ServerManagedObject ref = context.getManagedObject(path);
                if (AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(ref)) continue;
                LocalizableMessage msg = ConfigMessages.ERR_SERVER_REFINT_TARGET_DISABLED.get((Object)name, (Object)AggregationPropertyDefinition.this.getName(), (Object)thisUFN, (Object)thisDN, (Object)thatUFN, (Object)thatDN);
                unacceptableReasons.add(msg);
                isUsable = false;
            }
            return isUsable;
        }

        @Override
        public void performPostAdd(ServerManagedObject<?> managedObject) throws ConfigException {
            this.performPostDelete(managedObject);
            LocalizableMessage thisUFN = managedObject.getManagedObjectDefinition().getUserFriendlyName();
            String thisDN = managedObject.getDN().toString();
            LocalizableMessage thatUFN = AggregationPropertyDefinition.this.getRelationDefinition().getUserFriendlyName();
            boolean needsChangeListeners = AggregationPropertyDefinition.this.targetNeedsEnablingCondition.evaluate(managedObject);
            ServerManagementContext context = managedObject.getServerContext();
            ManagedObjectPath<?, ?> parentPath = AggregationPropertyDefinition.this.getParentPath();
            ServerManagedObject parent = context.getManagedObject(parentPath);
            LinkedList<ReferentialIntegrityDeleteListener> dlist = new LinkedList<ReferentialIntegrityDeleteListener>();
            AggregationPropertyDefinition.this.deleteListeners.put(managedObject.getDN(), dlist);
            LinkedList<ReferentialIntegrityChangeListener> clist = new LinkedList<ReferentialIntegrityChangeListener>();
            AggregationPropertyDefinition.this.changeListeners.put(managedObject.getDN(), clist);
            for (String name : managedObject.getPropertyValues((PropertyDefinition)AggregationPropertyDefinition.this)) {
                ManagedObjectPath path = AggregationPropertyDefinition.this.getChildPath(name);
                DN dn = path.toDN();
                String thatDN = dn.toString();
                LocalizableMessage msg = ConfigMessages.ERR_SERVER_REFINT_CANNOT_DELETE.get((Object)thatUFN, (Object)thatDN, (Object)AggregationPropertyDefinition.this.getName(), (Object)thisUFN, (Object)thisDN);
                ReferentialIntegrityDeleteListener dl = new ReferentialIntegrityDeleteListener(dn, msg);
                parent.registerDeleteListener(AggregationPropertyDefinition.this.getRelationDefinition(), dl);
                dlist.add(dl);
                if (!needsChangeListeners) continue;
                ServerManagedObject ref = context.getManagedObject(path);
                msg = ConfigMessages.ERR_SERVER_REFINT_CANNOT_DISABLE.get((Object)thatUFN, (Object)thatDN, (Object)AggregationPropertyDefinition.this.getName(), (Object)thisUFN, (Object)thisDN);
                ReferentialIntegrityChangeListener cl = new ReferentialIntegrityChangeListener(path, msg);
                ref.registerChangeListener(cl);
                clist.add(cl);
            }
        }

        @Override
        public void performPostDelete(ServerManagedObject<?> managedObject) throws ConfigException {
            ServerManagementContext context = managedObject.getServerContext();
            DN dn = managedObject.getDN();
            ManagedObjectPath<?, ?> parentPath = AggregationPropertyDefinition.this.getParentPath();
            ServerManagedObject parent = context.getManagedObject(parentPath);
            if (AggregationPropertyDefinition.this.deleteListeners.containsKey(dn)) {
                for (ReferentialIntegrityDeleteListener dl : (List)AggregationPropertyDefinition.this.deleteListeners.get(dn)) {
                    parent.deregisterDeleteListener(AggregationPropertyDefinition.this.getRelationDefinition(), dl);
                }
                AggregationPropertyDefinition.this.deleteListeners.remove(dn);
            }
            if (AggregationPropertyDefinition.this.changeListeners.containsKey(dn)) {
                for (ReferentialIntegrityChangeListener cl : (List)AggregationPropertyDefinition.this.changeListeners.get(dn)) {
                    ManagedObjectPath path = cl.getManagedObjectPath();
                    ServerManagedObject ref = context.getManagedObject(path);
                    ref.deregisterChangeListener(cl);
                }
                AggregationPropertyDefinition.this.changeListeners.remove(dn);
            }
        }

        @Override
        public void performPostModify(ServerManagedObject<?> managedObject) throws ConfigException {
            this.performPostDelete(managedObject);
            this.performPostAdd(managedObject);
        }
    }

    private final class ReferentialIntegrityDeleteListener
    implements ConfigurationDeleteListener<S> {
        private final DN dn;
        private final LocalizableMessage message;

        private ReferentialIntegrityDeleteListener(DN dn, LocalizableMessage message) {
            this.dn = dn;
            this.message = message;
        }

        @Override
        public ConfigChangeResult applyConfigurationDelete(S configuration) {
            if (configuration.dn().equals((Object)this.dn)) {
                throw new IllegalStateException("Attempting to delete a referenced " + AggregationPropertyDefinition.this.relationDefinition.getChildDefinition().getUserFriendlyName());
            }
            return new ConfigChangeResult();
        }

        @Override
        public boolean isConfigurationDeleteAcceptable(S configuration, List<LocalizableMessage> unacceptableReasons) {
            if (configuration.dn().equals((Object)this.dn)) {
                unacceptableReasons.add(this.message);
                return false;
            }
            return true;
        }
    }

    private final class ReferentialIntegrityChangeListener
    implements ServerManagedObjectChangeListener<S> {
        private final LocalizableMessage message;
        private final ManagedObjectPath<C, S> path;

        private ReferentialIntegrityChangeListener(ManagedObjectPath<C, S> path, LocalizableMessage message) {
            this.path = path;
            this.message = message;
        }

        @Override
        public ConfigChangeResult applyConfigurationChange(ServerManagedObject<? extends S> mo) {
            try {
                if (AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(mo)) {
                    return new ConfigChangeResult();
                }
            }
            catch (ConfigException configException) {
                // empty catch block
            }
            throw new IllegalStateException("Attempting to disable a referenced " + AggregationPropertyDefinition.this.relationDefinition.getChildDefinition().getUserFriendlyName());
        }

        @Override
        public boolean isConfigurationChangeAcceptable(ServerManagedObject<? extends S> mo, List<LocalizableMessage> unacceptableReasons) {
            try {
                if (!AggregationPropertyDefinition.this.targetIsEnabledCondition.evaluate(mo)) {
                    unacceptableReasons.add(this.message);
                    return false;
                }
                return true;
            }
            catch (ConfigException e) {
                debugLogger.trace("Unable to perform post add", (Throwable)e);
                LocalizableMessage message = ConfigMessages.ERR_REFINT_UNABLE_TO_EVALUATE_TARGET_CONDITION.get((Object)mo.getManagedObjectDefinition().getUserFriendlyName(), (Object)String.valueOf(mo.getDN()), (Object)StaticUtils.getExceptionMessage((Throwable)e));
                LocalizedLogger logger = LocalizedLogger.getLocalizedLogger((String)ConfigMessages.ERR_REFINT_UNABLE_TO_EVALUATE_TARGET_CONDITION.resourceName());
                logger.error(message);
                unacceptableReasons.add(message);
                return false;
            }
        }

        private ManagedObjectPath<C, S> getManagedObjectPath() {
            return this.path;
        }
    }

    public static final class Builder<C extends ConfigurationClient, S extends Configuration>
    extends PropertyDefinition.AbstractBuilder<String, AggregationPropertyDefinition<C, S>> {
        private String parentPathString;
        private String rdName;
        private Condition targetIsEnabledCondition = Conditions.TRUE;
        private Condition targetNeedsEnablingCondition = Conditions.TRUE;

        private Builder(AbstractManagedObjectDefinition<?, ?> d, String propertyName) {
            super(d, propertyName);
        }

        public final void setParentPath(String pathString) {
            this.parentPathString = pathString;
        }

        public final void setRelationDefinition(String rdName) {
            this.rdName = rdName;
        }

        public final void setTargetIsEnabledCondition(Condition condition) {
            this.targetIsEnabledCondition = condition;
        }

        public final void setTargetNeedsEnablingCondition(Condition condition) {
            this.targetNeedsEnablingCondition = condition;
        }

        @Override
        protected AggregationPropertyDefinition<C, S> buildInstance(AbstractManagedObjectDefinition<?, ?> d, String propertyName, EnumSet<PropertyOption> options, AdministratorAction adminAction, DefaultBehaviorProvider<String> defaultBehavior) {
            if (this.parentPathString == null) {
                throw new IllegalStateException("Parent path undefined");
            }
            if (this.rdName == null) {
                throw new IllegalStateException("Relation definition undefined");
            }
            return new AggregationPropertyDefinition(d, propertyName, options, adminAction, defaultBehavior, this.parentPathString, this.rdName, this.targetNeedsEnablingCondition, this.targetIsEnabledCondition);
        }
    }
}

