/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.forgerock.json.JsonValue;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;

final class Utils {
    private static final Function<Object, ByteString, NeverThrowsException> BASE64_TO_BYTESTRING = new Function<Object, ByteString, NeverThrowsException>(){

        public ByteString apply(Object value) {
            return ByteString.valueOfBase64((String)String.valueOf(value));
        }
    };
    private static final Function<ByteString, String, NeverThrowsException> BYTESTRING_TO_BASE64 = new Function<ByteString, String, NeverThrowsException>(){

        public String apply(ByteString value) {
            return value.toBase64String();
        }
    };

    static Object attributeToJson(Attribute a) {
        Function<ByteString, Object, NeverThrowsException> f = Utils.byteStringToJson(a.getAttributeDescription());
        boolean isSingleValued = a.getAttributeDescription().getAttributeType().isSingleValue();
        return isSingleValued ? a.parse().as(f) : Utils.asList(a.parse().asSetOf(f, new Object[0]));
    }

    static Function<Object, ByteString, NeverThrowsException> base64ToByteString() {
        return BASE64_TO_BYTESTRING;
    }

    static Function<ByteString, String, NeverThrowsException> byteStringToBase64() {
        return BYTESTRING_TO_BASE64;
    }

    static Function<ByteString, Object, NeverThrowsException> byteStringToJson(final AttributeDescription ad) {
        return new Function<ByteString, Object, NeverThrowsException>(){

            public Object apply(ByteString value) {
                Syntax syntax = ad.getAttributeType().getSyntax();
                if (syntax.equals((Object)CoreSchema.getBooleanSyntax())) {
                    return Functions.byteStringToBoolean().apply((Object)value);
                }
                if (syntax.equals((Object)CoreSchema.getIntegerSyntax())) {
                    return Functions.byteStringToLong().apply((Object)value);
                }
                if (syntax.equals((Object)CoreSchema.getGeneralizedTimeSyntax())) {
                    return DatatypeConverter.printDateTime((Calendar)((GeneralizedTime)Functions.byteStringToGeneralizedTime().apply((Object)value)).toCalendar());
                }
                return Functions.byteStringToString().apply((Object)value);
            }
        };
    }

    static <T> T ensureNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return object;
    }

    static <T> T ensureNotNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    static String getAttributeName(Attribute a) {
        return a.getAttributeDescription().withoutOption("binary").toString();
    }

    static String i18n(String format, Object ... args) {
        return String.format(format, args);
    }

    static boolean isJSONPrimitive(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number;
    }

    static boolean isNullOrEmpty(JsonValue v) {
        return v == null || v.isNull() || v.isList() && v.size() == 0;
    }

    static Attribute jsonToAttribute(Object value, AttributeDescription ad) {
        return Utils.jsonToAttribute(value, ad, Utils.jsonToByteString(ad));
    }

    static Attribute jsonToAttribute(Object value, AttributeDescription ad, Function<Object, ByteString, NeverThrowsException> f) {
        if (Utils.isJSONPrimitive(value)) {
            return new LinkedAttribute(ad, f.apply(value));
        }
        if (value instanceof Collection) {
            LinkedAttribute a = new LinkedAttribute(ad);
            for (Object o : (Collection)value) {
                a.add((ByteString)f.apply(o));
            }
            return a;
        }
        throw new IllegalArgumentException("Unrecognized type of JSON value: " + value.getClass().getName());
    }

    static Function<Object, ByteString, NeverThrowsException> jsonToByteString(final AttributeDescription ad) {
        return new Function<Object, ByteString, NeverThrowsException>(){

            public ByteString apply(Object value) {
                if (Utils.isJSONPrimitive(value)) {
                    Syntax syntax = ad.getAttributeType().getSyntax();
                    if (syntax.equals((Object)CoreSchema.getGeneralizedTimeSyntax())) {
                        return ByteString.valueOfObject((Object)GeneralizedTime.valueOf((Calendar)DatatypeConverter.parseDateTime((String)value.toString())));
                    }
                    return ByteString.valueOfObject((Object)value);
                }
                throw new IllegalArgumentException("Unrecognized type of JSON value: " + value.getClass().getName());
            }
        };
    }

    static Filter toFilter(boolean value) {
        return value ? Filter.alwaysTrue() : Filter.alwaysFalse();
    }

    static Filter toFilter(FilterType type, String ldapAttribute, ByteString valueAssertion) {
        switch (type) {
            case CONTAINS: {
                return Filter.substrings((String)ldapAttribute, null, Collections.singleton(valueAssertion), null);
            }
            case STARTS_WITH: {
                return Filter.substrings((String)ldapAttribute, (Object)valueAssertion, null, null);
            }
            case EQUAL_TO: {
                return Filter.equality((String)ldapAttribute, (Object)valueAssertion);
            }
            case GREATER_THAN: {
                return Filter.greaterThan((String)ldapAttribute, (Object)valueAssertion);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return Filter.greaterOrEqual((String)ldapAttribute, (Object)valueAssertion);
            }
            case LESS_THAN: {
                return Filter.lessThan((String)ldapAttribute, (Object)valueAssertion);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return Filter.lessOrEqual((String)ldapAttribute, (Object)valueAssertion);
            }
            case PRESENT: {
                return Filter.present((String)ldapAttribute);
            }
        }
        return Filter.alwaysFalse();
    }

    static String toLowerCase(String s) {
        return s != null ? s.toLowerCase(Locale.ENGLISH) : null;
    }

    private static <T> List<T> asList(Collection<T> c) {
        if (c instanceof List) {
            return (List)c;
        }
        return new ArrayList<T>(c);
    }

    private Utils() {
    }
}

