/*
 * Decompiled with CFR 0.152.
 */
package com.persistit;

import com.persistit.Exchange;
import com.persistit.Key;
import com.persistit.KeyFilter;
import com.persistit.Value;
import com.persistit.exception.PersistitException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class PersistitMap<K, V>
extends AbstractMap<K, V>
implements SortedMap<K, V> {
    private final Exchange _ex;
    private long _sizeGeneration;
    private int _size;
    private boolean _allowConcurrentModification = false;
    private Key _fromKey;
    private Key _toKey;
    private volatile transient Set<K> _keySet = null;
    private volatile transient Collection<V> _values = null;
    private volatile transient Set<Map.Entry<K, V>> _entrySet;

    public PersistitMap(Exchange ex) {
        this._ex = new Exchange(ex);
        this._ex.append(Key.BEFORE);
        this._sizeGeneration = -1L;
    }

    private PersistitMap(PersistitMap<K, V> pm, boolean useFrom, Object fromKey, boolean useTo, Object toKey) {
        Key key;
        this._ex = new Exchange(pm._ex);
        this._sizeGeneration = -1L;
        if (useFrom) {
            key = new Key(this._ex.getKey());
            try {
                key.to(fromKey);
            }
            catch (UnsupportedOperationException use) {
                throw new ClassCastException(fromKey != null ? fromKey.getClass().getName() : null);
            }
            if (pm._fromKey != null && pm._fromKey.compareTo(key) > 0 || pm._toKey != null && pm._toKey.compareTo(key) < 0) {
                throw new IllegalArgumentException("Key " + fromKey + " is outside submap range");
            }
            this._fromKey = key;
        } else {
            this._fromKey = pm._fromKey;
        }
        if (useTo) {
            key = new Key(this._ex.getKey());
            try {
                key.to(toKey);
            }
            catch (UnsupportedOperationException use) {
                throw new ClassCastException(toKey != null ? toKey.getClass().getName() : null);
            }
            if (pm._fromKey != null && pm._fromKey.compareTo(key) > 0 || pm._toKey != null && pm._toKey.compareTo(key) < 0) {
                throw new IllegalArgumentException("Key " + toKey + " is outside submap range");
            }
            this._toKey = key;
        } else {
            this._toKey = pm._toKey;
        }
    }

    public boolean isAllowConcurrentModification() {
        return this._allowConcurrentModification;
    }

    public void setAllowConcurrentModification(boolean allow) {
        this._allowConcurrentModification = allow;
    }

    private void toLeftEdge() {
        if (this._fromKey == null) {
            this._ex.to(Key.BEFORE);
        } else {
            this._fromKey.copyTo(this._ex.getKey());
        }
    }

    private void toRightEdge() {
        if (this._toKey == null) {
            this._ex.to(Key.AFTER);
        } else {
            this._toKey.copyTo(this._ex.getKey());
        }
    }

    private boolean toKey(Object key) {
        try {
            this._ex.to(key);
            if (this._fromKey != null && this._fromKey.compareTo(this._ex.getKey()) > 0) {
                return false;
            }
            return this._toKey == null || this._toKey.compareTo(this._ex.getKey()) >= 0;
        }
        catch (UnsupportedOperationException uoe) {
            throw new ClassCastException(key != null ? key.getClass().getName() : null);
        }
    }

    @Override
    public synchronized int size() {
        if (this._ex.getChangeCount() == this._sizeGeneration) {
            return this._size;
        }
        int size = 0;
        try {
            this.toLeftEdge();
            while (this._ex.traverse(size == 0 ? Key.GTEQ : Key.GT, false, 0) && (this._toKey == null || this._ex.getKey().compareTo(this._toKey) < 0)) {
                if (size >= 0x7FFFFFFE) continue;
                ++size;
            }
            this._size = size;
            this._sizeGeneration = this._ex.getChangeCount();
            return this._size;
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    @Override
    public synchronized boolean isEmpty() {
        if (this._ex.getChangeCount() == this._sizeGeneration) {
            return this._size == 0;
        }
        try {
            this.toLeftEdge();
            if (this._ex.traverse(Key.GTEQ, false)) {
                if (this._toKey != null && this._ex.getKey().compareTo(this._toKey) >= 0) {
                    this._size = 0;
                    this._sizeGeneration = this._ex.getChangeCount();
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        Value lookupValue = new Value(this._ex.getPersistitInstance());
        try {
            lookupValue.put(value);
            this.toLeftEdge();
            while (this._ex.next()) {
                if (this._toKey != null && this._ex.getKey().compareTo(this._toKey) >= 0) {
                    return false;
                }
                if (!lookupValue.equals(this._ex.getValue())) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw new PersistitMapException(exception);
        }
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        try {
            if (!this.toKey(key)) {
                return false;
            }
            return this._ex.isValueDefined();
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    @Override
    public synchronized V get(Object key) {
        try {
            if (!this.toKey(key)) {
                return null;
            }
            this._ex.fetch();
            if (!this._ex.getValue().isDefined()) {
                return null;
            }
            Object value = this._ex.getValue().get();
            return (V)value;
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    @Override
    public synchronized V put(K key, V value) {
        try {
            if (!this.toKey(key)) {
                throw new IllegalArgumentException("Key " + key + " is out of submap range");
            }
            long changeCount = this._sizeGeneration;
            Object result = null;
            this._ex.getValue().put(value);
            this._ex.fetchAndStore();
            if (this._ex.getValue().isDefined()) {
                result = this._ex.getValue().get();
            } else {
                this.adjustSize(changeCount, 1);
            }
            return (V)result;
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    public synchronized void putFast(Object key, Object value) {
        try {
            if (!this.toKey(key)) {
                throw new IllegalArgumentException("Key " + key + " is out of submap range");
            }
            this._ex.getValue().put(value);
            this._ex.store();
            this._sizeGeneration = -1L;
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    @Override
    public synchronized V remove(Object key) {
        try {
            if (!this.toKey(key)) {
                throw new IllegalArgumentException("Key " + key + " is out of submap range");
            }
            long changeCount = this._sizeGeneration;
            boolean removed = this._ex.fetchAndRemove();
            Object result = null;
            if (removed) {
                this.adjustSize(changeCount, -1);
                if (this._ex.getValue().isDefined()) {
                    result = this._ex.getValue().get();
                }
            }
            return (V)result;
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    public synchronized void removeFast(Object key) {
        try {
            if (!this.toKey(key)) {
                throw new IllegalArgumentException("Key " + key + " is out of submap range");
            }
            long changeCount = this._sizeGeneration;
            boolean removed = this._ex.remove();
            if (removed) {
                this.adjustSize(changeCount, -1);
            }
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    private void adjustSize(long changeCount, int delta) {
        if (this._sizeGeneration >= 0L) {
            if (this._ex.getChangeCount() == changeCount + 1L) {
                this._size += delta;
                this._sizeGeneration = this._ex.getChangeCount();
            } else {
                this._sizeGeneration = -1L;
            }
        }
    }

    @Override
    public synchronized void putAll(Map t) {
        for (Map.Entry entry : t.entrySet()) {
            this.putFast(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized void clear() {
        try {
            this.toLeftEdge();
            Key key = new Key(this._ex.getKey());
            if (this._toKey == null) {
                key.to(Key.AFTER);
            } else {
                this._toKey.copyTo(key);
            }
            this._ex.removeKeyRange(this._ex.getKey(), key);
            this._size = 0;
            this._sizeGeneration = this._ex.getChangeCount();
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    @Override
    public Set<K> keySet() {
        if (this._keySet == null) {
            this._keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new ExchangeKeyIterator(PersistitMap.this, PersistitMap.this._allowConcurrentModification);
                }

                @Override
                public int size() {
                    return PersistitMap.this.size();
                }

                @Override
                public boolean contains(Object k) {
                    return PersistitMap.this.containsKey(k);
                }
            };
        }
        return this._keySet;
    }

    @Override
    public Collection<V> values() {
        if (this._values == null) {
            this._values = new AbstractSet<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new ExchangeValueIterator(PersistitMap.this, PersistitMap.this._allowConcurrentModification);
                }

                @Override
                public int size() {
                    return PersistitMap.this.size();
                }

                @Override
                public boolean contains(Object v) {
                    return PersistitMap.this.containsValue(v);
                }
            };
        }
        return this._values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return new ExchangeEntryIterator(PersistitMap.this, PersistitMap.this._allowConcurrentModification);
                }

                @Override
                public int size() {
                    return PersistitMap.this.size();
                }

                @Override
                public boolean contains(Object v) {
                    return PersistitMap.this.containsValue(v);
                }
            };
        }
        return this._entrySet;
    }

    @Override
    public Comparator<K> comparator() {
        return null;
    }

    @Override
    public SortedMap<K, V> subMap(Object fromKey, Object toKey) {
        return new PersistitMap<K, V>(this, true, fromKey, true, toKey);
    }

    @Override
    public SortedMap<K, V> headMap(Object toKey) {
        return new PersistitMap<K, V>(this, false, null, true, toKey);
    }

    @Override
    public SortedMap<K, V> tailMap(Object fromKey) {
        return new PersistitMap<K, V>(this, true, fromKey, false, null);
    }

    @Override
    public K firstKey() {
        this.toLeftEdge();
        try {
            if (this._ex.traverse(this._fromKey == null ? Key.GT : Key.GTEQ, false, -1) && (this._toKey == null || this._toKey.compareTo(this._ex.getKey()) > 0)) {
                return (K)this._ex.getKey().decode();
            }
            throw new NoSuchElementException();
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    @Override
    public K lastKey() {
        this.toRightEdge();
        try {
            if (this._ex.traverse(Key.LT, false, -1) && (this._fromKey == null || this._fromKey.compareTo(this._ex.getKey()) <= 0)) {
                return (K)this._ex.getKey().decode();
            }
            throw new NoSuchElementException();
        }
        catch (PersistitException de) {
            throw new PersistitMapException(de);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return "PersistitMap(" + this._ex + ")";
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public abstract class ExchangeIterator<E>
    implements Iterator<E> {
        PersistitMap<K, V> _pm;
        Exchange _iteratorExchange;
        boolean _allowCM;
        Key.Direction _direction = Key.GT;
        long _changeCount;
        boolean _okToRemove;
        KeyFilter _keyFilter;
        boolean _traversed;
        boolean _hasNext;
        Key _trailingKey;

        ExchangeIterator(PersistitMap<K, V> pm, boolean allowConcurrentModification) {
            this._pm = pm;
            this._iteratorExchange = new Exchange(PersistitMap.this._ex);
            this._iteratorExchange.to(Key.BEFORE);
            this._trailingKey = new Key(this._iteratorExchange.getKey());
            this._traversed = false;
            if (PersistitMap.this._fromKey != null) {
                PersistitMap.this._fromKey.copyTo(this._iteratorExchange.getKey());
            }
            this._changeCount = this._iteratorExchange.getChangeCount();
            this._allowCM = allowConcurrentModification;
        }

        public void setDirection(Key.Direction direction) {
            if (direction != Key.GT && direction != Key.LT) {
                throw new IllegalArgumentException("Must be GT or LT");
            }
            this._direction = direction;
        }

        public Key.Direction getDirection() {
            return this._direction;
        }

        public KeyFilter getKeyFilter() {
            return this._keyFilter;
        }

        public void setFilterTerm(KeyFilter.Term term) {
            if (term == null) {
                this._keyFilter = null;
            } else {
                Key key = this._iteratorExchange.getKey();
                Key spareKey = this._iteratorExchange.getAuxiliaryKey1();
                key.copyTo(spareKey);
                int depth = spareKey.getDepth();
                spareKey.cut();
                this._keyFilter = new KeyFilter(spareKey).append(term).limit(depth, depth);
            }
        }

        @Override
        public synchronized boolean hasNext() {
            if (!this._traversed) {
                this._hasNext = this.traverse();
                this._traversed = true;
            }
            return this._hasNext;
        }

        protected synchronized void nextEntry() {
            if (!this._traversed && !this.traverse() || this._traversed && !this._hasNext) {
                throw new NoSuchElementException();
            }
            if (!this._allowCM && this._iteratorExchange.getChangeCount() != this._changeCount) {
                this._changeCount = this._iteratorExchange.getChangeCount();
                throw new ConcurrentModificationException();
            }
            this._traversed = false;
            this._okToRemove = true;
        }

        @Override
        public synchronized void remove() {
            if (!this._okToRemove) {
                throw new IllegalStateException();
            }
            if (!this._allowCM && this._iteratorExchange.getChangeCount() != this._changeCount) {
                this._changeCount = this._iteratorExchange.getChangeCount();
                throw new ConcurrentModificationException();
            }
            boolean removed = false;
            long changeCount = this._iteratorExchange.getChangeCount();
            if (this._traversed) {
                this._trailingKey.copyTo(this._iteratorExchange.getKey());
                this._traversed = false;
            }
            try {
                removed = this._iteratorExchange.remove();
            }
            catch (PersistitException e) {
                throw new PersistitMapException(e);
            }
            if (!removed) {
                throw new NoSuchElementException();
            }
            this._pm.adjustSize(changeCount, -1);
            if (!this._allowCM && this._iteratorExchange.getChangeCount() != changeCount + 1L) {
                this._changeCount = this._iteratorExchange.getChangeCount();
                throw new ConcurrentModificationException();
            }
            this._changeCount = this._iteratorExchange.getChangeCount();
            this._okToRemove = false;
        }

        private boolean traverse() {
            try {
                this._iteratorExchange.getKey().copyTo(this._trailingKey);
                boolean result = this._iteratorExchange.traverse(this._direction, this._keyFilter, Integer.MAX_VALUE);
                if (!result || PersistitMap.this._toKey == null) {
                    return result;
                }
                return PersistitMap.this._toKey.compareTo(this._iteratorExchange.getKey()) <= 0;
            }
            catch (PersistitException de) {
                throw new PersistitMapException(de);
            }
        }
    }

    private final class ExchangeEntryIterator
    extends ExchangeIterator<Map.Entry<K, V>> {
        protected ExchangeEntryIterator(PersistitMap<K, V> pm, boolean allowConcurrentModification) {
            super(pm, allowConcurrentModification);
        }

        @Override
        public Map.Entry<K, V> next() {
            this.nextEntry();
            this._iteratorExchange.getKey().indexTo(-1);
            return new ExchangeEntry(this._iteratorExchange.getKey().decode(), this._iteratorExchange.getValue().get(), this);
        }
    }

    private final class ExchangeKeyIterator
    extends ExchangeIterator<K> {
        protected ExchangeKeyIterator(PersistitMap<K, V> pm, boolean allowConcurrentModification) {
            super(pm, allowConcurrentModification);
        }

        @Override
        public K next() {
            this.nextEntry();
            this._iteratorExchange.getKey().indexTo(-1);
            return this._iteratorExchange.getKey().decode();
        }
    }

    private final class ExchangeValueIterator
    extends ExchangeIterator<V> {
        protected ExchangeValueIterator(PersistitMap<K, V> pm, boolean allowConcurrentModification) {
            super(pm, allowConcurrentModification);
        }

        @Override
        public V next() {
            this.nextEntry();
            return this._iteratorExchange.getValue().get();
        }
    }

    public class ExchangeEntry<K, V>
    implements Map.Entry<K, V> {
        private final K _key;
        private final V _value;
        private final ExchangeIterator<Map.Entry<K, V>> _iterator;

        private ExchangeEntry(K key, V value, ExchangeIterator<Map.Entry<K, V>> iterator) {
            this._key = key;
            this._value = value;
            this._iterator = iterator;
        }

        @Override
        public K getKey() {
            return this._key;
        }

        @Override
        public V getValue() {
            return this._value;
        }

        @Override
        public synchronized V setValue(V value) {
            V result = null;
            try {
                PersistitMap.this._ex.to(this._key);
                PersistitMap.this._ex.getValue().put(value);
                long changeCount = PersistitMap.this._ex.getChangeCount();
                PersistitMap.this._ex.fetchAndStore();
                if (!PersistitMap.this._ex.getValue().isDefined()) {
                    ++changeCount;
                }
                this._iterator._changeCount = changeCount;
                result = this._value;
            }
            catch (PersistitException pe) {
                throw new PersistitMapException(pe);
            }
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                return (entry.getKey() == null ? this._key == null : entry.getKey().equals(this._key)) && (entry.getValue() == null ? this._value == null : entry.getValue().equals(this._value));
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this._key == null ? 0 : this._key.hashCode()) ^ (this._value == null ? 0 : this._value.hashCode());
        }
    }

    public static class PersistitMapException
    extends RuntimeException {
        private static final long serialVersionUID = 7257161738800744724L;
        Exception _exception;

        PersistitMapException(Exception ee) {
            this._exception = ee;
        }

        @Override
        public Throwable getCause() {
            return this._exception;
        }
    }
}

