/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.handlers.csv;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.forgerock.audit.Audit;
import org.forgerock.audit.events.AuditEventHelper;
import org.forgerock.audit.events.EventTopicsMetaData;
import org.forgerock.audit.events.handlers.AuditEventHandlerBase;
import org.forgerock.audit.handlers.csv.CsvAuditEventHandlerConfiguration;
import org.forgerock.audit.handlers.csv.CsvSecureMapReader;
import org.forgerock.audit.handlers.csv.CsvWriter;
import org.forgerock.audit.handlers.csv.SecureCsvWriter;
import org.forgerock.audit.handlers.csv.StandardCsvWriter;
import org.forgerock.audit.providers.KeyStoreHandlerProvider;
import org.forgerock.audit.retention.TimeStampFileNamingPolicy;
import org.forgerock.audit.secure.JcaKeyStoreHandler;
import org.forgerock.audit.secure.KeyStoreHandler;
import org.forgerock.audit.util.JsonSchemaUtils;
import org.forgerock.audit.util.JsonValueUtils;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.QueryFilters;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.CsvMapReader;
import org.supercsv.io.ICsvMapReader;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.quote.AlwaysQuoteMode;
import org.supercsv.quote.QuoteMode;
import org.supercsv.util.CsvContext;

public class CsvAuditEventHandler
extends AuditEventHandlerBase {
    private static final Logger logger = LoggerFactory.getLogger(CsvAuditEventHandler.class);
    public static final String ROTATE_FILE_ACTION_NAME = "rotate";
    static final String SECURE_CSV_FILENAME_PREFIX = "tamper-evident-";
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Random random;
    private final CsvAuditEventHandlerConfiguration configuration;
    private final CsvPreference csvPreference;
    private final ConcurrentMap<String, CsvWriter> writers = new ConcurrentHashMap<String, CsvWriter>();
    private final Map<String, Set<String>> fieldOrderByTopic;
    private final Map<String, JsonPointer> jsonPointerByField;
    private final Map<String, String> fieldDotNotationByField;
    private KeyStoreHandler keyStoreHandler;

    @Inject
    public CsvAuditEventHandler(CsvAuditEventHandlerConfiguration configuration, EventTopicsMetaData eventTopicsMetaData, @Audit KeyStoreHandlerProvider keyStoreHandlerProvider) {
        super(configuration.getName(), eventTopicsMetaData, configuration.getTopics(), configuration.isEnabled());
        this.configuration = configuration;
        this.csvPreference = this.createCsvPreference(this.configuration);
        CsvAuditEventHandlerConfiguration.CsvSecurity security = configuration.getSecurity();
        if (security.isEnabled()) {
            Duration duration = security.getSignatureIntervalDuration();
            Reject.ifTrue((duration.isZero() || duration.isUnlimited() ? 1 : 0) != 0, (String)"The signature interval can't be zero or unlimited");
            if (security.getKeyStoreHandlerName() != null) {
                this.keyStoreHandler = keyStoreHandlerProvider.getKeystoreHandler(security.getKeyStoreHandlerName());
            } else {
                try {
                    this.keyStoreHandler = new JcaKeyStoreHandler("JCEKS", security.getFilename(), security.getPassword());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to create secure storage from file: " + security.getFilename(), e);
                }
            }
        }
        HashMap<String, Set<String>> fieldOrderByTopic = new HashMap<String, Set<String>>();
        HashMap<String, JsonPointer> jsonPointerByField = new HashMap<String, JsonPointer>();
        HashMap<String, String> fieldDotNotationByField = new HashMap<String, String>();
        for (String topic : this.eventTopicsMetaData.getTopics()) {
            try {
                Set<String> fieldOrder = this.getFieldOrder(topic, this.eventTopicsMetaData);
                for (String field : fieldOrder) {
                    if (jsonPointerByField.containsKey(field)) continue;
                    jsonPointerByField.put(field, new JsonPointer(field));
                    fieldDotNotationByField.put(field, AuditEventHelper.jsonPointerToDotNotation((String)field));
                }
                fieldOrderByTopic.put(topic, Collections.unmodifiableSet(fieldOrder));
            }
            catch (ResourceException e) {
                logger.error(topic + " topic schema meta-data misconfigured.");
            }
        }
        this.fieldOrderByTopic = Collections.unmodifiableMap(fieldOrderByTopic);
        this.jsonPointerByField = Collections.unmodifiableMap(jsonPointerByField);
        this.fieldDotNotationByField = Collections.unmodifiableMap(fieldDotNotationByField);
    }

    private CsvPreference createCsvPreference(CsvAuditEventHandlerConfiguration config) {
        return new CsvPreference.Builder(config.getFormatting().getQuoteChar(), (int)config.getFormatting().getDelimiterChar(), config.getFormatting().getEndOfLineSymbols()).useQuoteMode((QuoteMode)new AlwaysQuoteMode()).build();
    }

    public void startup() throws ResourceException {
        logger.trace("Audit logging to: {}", (Object)this.configuration.getLogDirectory());
        File file = new File(this.configuration.getLogDirectory());
        if (!file.isDirectory()) {
            if (file.exists()) {
                logger.warn("Specified path is file but should be a directory: {}", (Object)this.configuration.getLogDirectory());
            } else if (!file.mkdirs()) {
                logger.warn("Unable to create audit directory in the path: {}", (Object)this.configuration.getLogDirectory());
            }
        }
        for (String topic : this.eventTopicsMetaData.getTopics()) {
            File auditLogFile = this.getAuditLogFile(topic);
            try {
                this.openWriter(topic, auditLogFile);
            }
            catch (IOException e) {
                logger.error("Error when creating audit file: {}", (Object)auditLogFile, (Object)e);
            }
        }
    }

    public void shutdown() throws ResourceException {
        this.cleanup();
    }

    public Promise<ResourceResponse, ResourceException> publishEvent(Context context, String topic, JsonValue event) {
        try {
            this.checkTopic(topic);
            this.publishEventWithRetry(topic, event);
            return Responses.newResourceResponse((String)event.get("_id").asString(), null, (JsonValue)event).asPromise();
        }
        catch (ResourceException e) {
            return e.asPromise();
        }
    }

    private void checkTopic(String topic) throws ResourceException {
        JsonValue auditEventProperties = AuditEventHelper.getAuditEventProperties((JsonValue)this.eventTopicsMetaData.getSchema(topic));
        if (auditEventProperties == null || auditEventProperties.isNull()) {
            throw new InternalServerErrorException("No audit event properties defined for audit event: " + topic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishEventWithRetry(String topic, JsonValue event) throws ResourceException {
        CsvWriter csvWriter = this.getWriter(topic);
        try {
            this.writeEvent(topic, csvWriter, event);
        }
        catch (IOException ex) {
            CsvWriter newCsvWriter;
            logger.debug("IOException while writing ({})", (Object)ex.getMessage());
            CsvAuditEventHandler csvAuditEventHandler = this;
            synchronized (csvAuditEventHandler) {
                newCsvWriter = (CsvWriter)this.writers.get(topic);
                if (newCsvWriter == csvWriter) {
                    newCsvWriter = this.resetAndReopenWriter(topic, false);
                    logger.debug("Resetting writer");
                } else {
                    logger.debug("Writer reset by another thread");
                }
            }
            try {
                this.writeEvent(topic, newCsvWriter, event);
            }
            catch (IOException e) {
                throw new BadRequestException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsvWriter getWriter(String topic) throws BadRequestException {
        CsvWriter csvWriter = (CsvWriter)this.writers.get(topic);
        if (csvWriter == null) {
            logger.debug("CSV file writer for {} topic is null; checking for reset by another thread", (Object)topic);
            CsvAuditEventHandler csvAuditEventHandler = this;
            synchronized (csvAuditEventHandler) {
                csvWriter = (CsvWriter)this.writers.get(topic);
                if (csvWriter == null) {
                    logger.debug("CSV file writer for {} topic not reset by another thread; resetting", (Object)topic);
                    csvWriter = this.resetAndReopenWriter(topic, false);
                }
            }
        }
        return csvWriter;
    }

    private CsvWriter writeEvent(String topic, CsvWriter csvWriter, JsonValue event) throws IOException {
        this.writeEntry(topic, csvWriter, event);
        CsvAuditEventHandlerConfiguration.EventBufferingConfiguration bufferConfig = this.configuration.getBuffering();
        if (!bufferConfig.isEnabled() || !bufferConfig.isAutoFlush()) {
            csvWriter.flush();
        }
        return csvWriter;
    }

    private Set<String> getFieldOrder(String topic, EventTopicsMetaData eventTopicsMetaData) throws ResourceException {
        LinkedHashSet<String> fieldOrder = new LinkedHashSet<String>();
        fieldOrder.addAll(JsonSchemaUtils.generateJsonPointers((JsonValue)AuditEventHelper.getAuditEventSchema((JsonValue)eventTopicsMetaData.getSchema(topic))));
        return fieldOrder;
    }

    private synchronized CsvWriter openWriter(String topic, File auditFile) throws IOException {
        CsvWriter writer = this.createCsvWriter(auditFile, topic);
        this.writers.put(topic, writer);
        return writer;
    }

    private synchronized CsvWriter createCsvWriter(File auditFile, String topic) throws IOException {
        String[] headers = this.buildHeaders((Collection<String>)this.fieldOrderByTopic.get(topic));
        if (this.configuration.getSecurity().isEnabled()) {
            return new SecureCsvWriter(auditFile, headers, this.csvPreference, this.configuration, this.keyStoreHandler, random);
        }
        return new StandardCsvWriter(auditFile, headers, this.csvPreference, this.configuration);
    }

    private ICsvMapReader createCsvMapReader(File auditFile) throws IOException {
        CsvMapReader csvReader = new CsvMapReader((Reader)new FileReader(auditFile), this.csvPreference);
        if (this.configuration.getSecurity().isEnabled()) {
            return new CsvSecureMapReader((ICsvMapReader)csvReader);
        }
        return csvReader;
    }

    private String[] buildHeaders(Collection<String> fieldOrder) {
        String[] headers = new String[fieldOrder.size()];
        fieldOrder.toArray(headers);
        for (int i = 0; i < headers.length; ++i) {
            headers[i] = AuditEventHelper.jsonPointerToDotNotation((String)headers[i]);
        }
        return headers;
    }

    public Promise<QueryResponse, ResourceException> queryEvents(Context context, String topic, QueryRequest query, QueryResourceHandler handler) {
        try {
            for (JsonValue value : this.getEntries(topic, (QueryFilter<JsonPointer>)query.getQueryFilter())) {
                handler.handleResource(Responses.newResourceResponse((String)value.get("_id").asString(), null, (JsonValue)value));
            }
            return Responses.newQueryResponse().asPromise();
        }
        catch (Exception e) {
            return new BadRequestException((Throwable)e).asPromise();
        }
    }

    public Promise<ResourceResponse, ResourceException> readEvent(Context context, String topic, String resourceId) {
        try {
            Set<JsonValue> entry = this.getEntries(topic, (QueryFilter<JsonPointer>)QueryFilters.parse((String)("/_id eq \"" + resourceId + "\"")));
            if (entry.isEmpty()) {
                throw new NotFoundException(topic + " audit log not found");
            }
            JsonValue resource = entry.iterator().next();
            return Responses.newResourceResponse((String)resource.get("_id").asString(), null, (JsonValue)resource).asPromise();
        }
        catch (ResourceException e) {
            return e.asPromise();
        }
        catch (IOException e) {
            return new BadRequestException((Throwable)e).asPromise();
        }
    }

    public Promise<ActionResponse, ResourceException> handleAction(Context context, String topic, ActionRequest request) {
        try {
            String action = request.getAction();
            if (topic == null) {
                return new BadRequestException(String.format("Topic is required for action %s", action)).asPromise();
            }
            if (action.equals(ROTATE_FILE_ACTION_NAME)) {
                return this.handleRotateAction(topic).asPromise();
            }
            String error = String.format("This action is unknown for the CSV handler: %s", action);
            return new BadRequestException(error).asPromise();
        }
        catch (BadRequestException e) {
            return e.asPromise();
        }
    }

    private ActionResponse handleRotateAction(String topic) throws BadRequestException {
        block5: {
            CsvWriter csvWriter = (CsvWriter)this.writers.get(topic);
            if (csvWriter == null) {
                logger.debug("Unable to rotate file for topic: {}", (Object)topic);
                throw new BadRequestException("Unable to rotate file for topic: " + topic);
            }
            if (this.configuration.getFileRotation().isRotationEnabled()) {
                try {
                    if (!csvWriter.forceRotation()) {
                        throw new BadRequestException("Unable to rotate file for topic: " + topic);
                    }
                    break block5;
                }
                catch (IOException e) {
                    throw new BadRequestException("Error when rotating file for topic: " + topic, (Throwable)e);
                }
            }
            this.resetAndReopenWriter(topic, true);
        }
        return Responses.newActionResponse((JsonValue)JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"rotated", (Object)"true")})));
    }

    private File getAuditLogFile(String type) {
        String prefix = this.configuration.getSecurity().isEnabled() ? SECURE_CSV_FILENAME_PREFIX : "";
        return new File(this.configuration.getLogDirectory(), prefix + type + ".csv");
    }

    private void writeEntry(String topic, CsvWriter csvWriter, JsonValue obj) throws IOException {
        Set<String> fieldOrder = this.fieldOrderByTopic.get(topic);
        HashMap<String, String> cells = new HashMap<String, String>(fieldOrder.size());
        for (String key : fieldOrder) {
            String value = JsonValueUtils.extractValueAsString((JsonValue)obj, (String)key);
            if (value == null || value.isEmpty()) continue;
            cells.put(this.fieldDotNotationByField.get(key), value);
        }
        csvWriter.writeEvent(cells);
    }

    private synchronized CsvWriter resetAndReopenWriter(String topic, boolean forceRotation) throws BadRequestException {
        this.closeWriter(topic);
        try {
            TimeStampFileNamingPolicy namingPolicy;
            File rotatedFile;
            File auditLogFile = this.getAuditLogFile(topic);
            if (forceRotation && !auditLogFile.renameTo(rotatedFile = (namingPolicy = new TimeStampFileNamingPolicy(auditLogFile, null, null)).getNextName())) {
                throw new BadRequestException(String.format("Unable to rename file %s to %s when rotating", auditLogFile, rotatedFile));
            }
            return this.openWriter(topic, auditLogFile);
        }
        catch (IOException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    private synchronized void closeWriter(String topic) {
        CsvWriter writerToClose = (CsvWriter)this.writers.remove(topic);
        if (writerToClose != null) {
            try {
                writerToClose.close();
            }
            catch (Exception ex) {
                logger.debug("File writer close in closeWriter reported failure ", (Throwable)ex);
            }
        }
    }

    private Set<JsonValue> getEntries(String auditEntryType, QueryFilter<JsonPointer> queryFilter) throws IOException {
        File auditFile = this.getAuditLogFile(auditEntryType);
        HashSet<JsonValue> results = new HashSet<JsonValue>();
        if (queryFilter == null) {
            queryFilter = QueryFilter.alwaysTrue();
        }
        if (auditFile.exists()) {
            try (ICsvMapReader reader = this.createCsvMapReader(auditFile);){
                Map<String, Object> entry;
                String[] header = this.convertDotNotationToSlashes(reader.getHeader(true));
                CellProcessor[] processors = this.createCellProcessors(auditEntryType, header);
                while ((entry = reader.read(header, processors)) != null) {
                    JsonValue jsonEntry = JsonValueUtils.expand(entry = this.convertDotNotationToSlashes(entry));
                    if (!((Boolean)queryFilter.accept(JsonValueUtils.JSONVALUE_FILTER_VISITOR, (Object)jsonEntry)).booleanValue()) continue;
                    results.add(jsonEntry);
                }
            }
        }
        return results;
    }

    private CellProcessor[] createCellProcessors(String auditEntryType, String[] headers) throws ResourceException {
        ArrayList<Optional> cellProcessors = new ArrayList<Optional>();
        JsonValue auditEvent = this.eventTopicsMetaData.getSchema(auditEntryType);
        for (String header : headers) {
            String propertyType = AuditEventHelper.getPropertyType((JsonValue)auditEvent, (JsonPointer)new JsonPointer(header));
            if (propertyType.equals("object") || propertyType.equals("array")) {
                cellProcessors.add(new Optional((CellProcessor)new ParseJsonValue()));
                continue;
            }
            cellProcessors.add(new Optional());
        }
        return cellProcessors.toArray(new CellProcessor[cellProcessors.size()]);
    }

    private synchronized void cleanup() throws ResourceException {
        try {
            for (CsvWriter csvWriter : this.writers.values()) {
                if (csvWriter == null) continue;
                csvWriter.flush();
                csvWriter.close();
            }
        }
        catch (IOException e) {
            logger.error("Unable to close filewriters during {} cleanup", (Object)((Object)((Object)this)).getClass().getName(), (Object)e);
            throw new InternalServerErrorException("Unable to close filewriters during " + ((Object)((Object)this)).getClass().getName() + " cleanup", (Throwable)e);
        }
    }

    private Map<String, Object> convertDotNotationToSlashes(Map<String, Object> entries) {
        LinkedHashMap<String, Object> newEntry = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            String key = AuditEventHelper.dotNotationToJsonPointer((String)entry.getKey());
            newEntry.put(key, entry.getValue());
        }
        return newEntry;
    }

    private String[] convertDotNotationToSlashes(String[] entries) {
        String[] result = new String[entries.length];
        for (int i = 0; i < entries.length; ++i) {
            result[i] = AuditEventHelper.dotNotationToJsonPointer((String)entries[i]);
        }
        return result;
    }

    static {
        try {
            random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
    }

    public class ParseJsonValue
    implements CellProcessor {
        public Object execute(Object value, CsvContext context) {
            JsonValue jv = null;
            if (((String)value).startsWith("{") && ((String)value).endsWith("}")) {
                try {
                    jv = new JsonValue(mapper.readValue((String)value, Map.class));
                }
                catch (Exception e) {
                    logger.debug("Error parsing JSON string: " + e.getMessage());
                }
            } else if (((String)value).startsWith("[") && ((String)value).endsWith("]")) {
                try {
                    jv = new JsonValue(mapper.readValue((String)value, List.class));
                }
                catch (Exception e) {
                    logger.debug("Error parsing JSON string: " + e.getMessage());
                }
            }
            if (jv == null) {
                return value;
            }
            return jv.getObject();
        }
    }
}

