/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.http.routing.ApiVersionRouterContext;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.http.routing.Version;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Requests;
import org.forgerock.json.resource.ResourceApiVersionRoutingFilter;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.RouteMatchers;
import org.forgerock.json.resource.SingletonResourceProvider;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.services.routing.AbstractRouter;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.services.routing.RouteMatcher;
import org.forgerock.util.Pair;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public class Router
extends AbstractRouter<Router, Request, RequestHandler>
implements RequestHandler {
    public Router() {
    }

    public Router(AbstractRouter<Router, Request, RequestHandler> router) {
        super(router);
    }

    protected Router getThis() {
        return this;
    }

    public RouteMatcher<Request> addRoute(UriTemplate uriTemplate, CollectionResourceProvider provider) {
        RouteMatcher<Request> routeMatcher = RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, uriTemplate.template);
        this.addRoute(routeMatcher, Resources.newCollection(provider));
        return routeMatcher;
    }

    public RouteMatcher<Request> addRoute(UriTemplate uriTemplate, SingletonResourceProvider provider) {
        RouteMatcher<Request> routeMatcher = RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, uriTemplate.template);
        this.addRoute(routeMatcher, Resources.newSingleton(provider));
        return routeMatcher;
    }

    public RouteMatcher<Request> addRoute(RoutingMode mode, UriTemplate uriTemplate, RequestHandler handler) {
        RouteMatcher<Request> routeMatcher = RouteMatchers.requestUriMatcher(mode, uriTemplate.template);
        this.addRoute(routeMatcher, handler);
        return routeMatcher;
    }

    public static UriTemplate uriTemplate(String template) {
        return new UriTemplate(template);
    }

    public RouteMatcher<Request> addRoute(Version version, CollectionResourceProvider provider) {
        return this.addRoute(version, Resources.newCollection(provider));
    }

    public RouteMatcher<Request> addRoute(Version version, SingletonResourceProvider provider) {
        return this.addRoute(version, Resources.newSingleton(provider));
    }

    public RouteMatcher<Request> addRoute(Version version, RequestHandler handler) {
        RouteMatcher<Request> routeMatcher = RouteMatchers.requestResourceApiVersionMatcher(version);
        this.addRoute(routeMatcher, handler);
        return routeMatcher;
    }

    private Pair<Context, RequestHandler> getBestMatch(Context context, Request request) throws ResourceException {
        try {
            Pair bestMatch = this.getBestRoute(context, request);
            if (bestMatch == null) {
                throw new NotFoundException(String.format("Resource '%s' not found", request.getResourcePath()));
            }
            return bestMatch;
        }
        catch (IncomparableRouteMatchException e) {
            throw new InternalServerErrorException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext((Context)bestMatch.getFirst());
            ActionRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfActionRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return ((RequestHandler)bestMatch.getSecond()).handleAction((Context)bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext((Context)bestMatch.getFirst());
            CreateRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfCreateRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return ((RequestHandler)bestMatch.getSecond()).handleCreate((Context)bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext((Context)bestMatch.getFirst());
            DeleteRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfDeleteRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return ((RequestHandler)bestMatch.getSecond()).handleDelete((Context)bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext((Context)bestMatch.getFirst());
            PatchRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfPatchRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return ((RequestHandler)bestMatch.getSecond()).handlePatch((Context)bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, final QueryRequest request, final QueryResourceHandler handler) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            final Context decoratedContext = (Context)bestMatch.getFirst();
            UriRouterContext routerContext = this.getRouterContext(decoratedContext);
            QueryRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfQueryRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            QueryResourceHandler resourceHandler = new QueryResourceHandler(){

                @Override
                public boolean handleResource(ResourceResponse resource) {
                    if (decoratedContext.containsContext(ApiVersionRouterContext.class)) {
                        ApiVersionRouterContext apiVersionRouterContext = (ApiVersionRouterContext)decoratedContext.asContext(ApiVersionRouterContext.class);
                        ResourceApiVersionRoutingFilter.setApiVersionInfo(apiVersionRouterContext, request, resource);
                    }
                    return handler.handleResource(resource);
                }
            };
            return ((RequestHandler)bestMatch.getSecond()).handleQuery(decoratedContext, routedRequest, resourceHandler);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext((Context)bestMatch.getFirst());
            ReadRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfReadRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return ((RequestHandler)bestMatch.getSecond()).handleRead((Context)bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        try {
            Pair<Context, RequestHandler> bestMatch = this.getBestMatch(context, request);
            UriRouterContext routerContext = this.getRouterContext((Context)bestMatch.getFirst());
            UpdateRequest routedRequest = this.wasRouted(context, routerContext) ? Requests.copyOfUpdateRequest(request).setResourcePath(this.getResourcePath(routerContext)) : request;
            return ((RequestHandler)bestMatch.getSecond()).handleUpdate((Context)bestMatch.getFirst(), routedRequest);
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
    }

    private UriRouterContext getRouterContext(Context context) {
        if (context.containsContext(UriRouterContext.class)) {
            return (UriRouterContext)context.asContext(UriRouterContext.class);
        }
        return null;
    }

    private boolean wasRouted(Context originalContext, UriRouterContext routerContext) {
        return routerContext != null && (!originalContext.containsContext(UriRouterContext.class) || routerContext != originalContext.asContext(UriRouterContext.class));
    }

    private String getResourcePath(UriRouterContext routerContext) {
        return routerContext.getRemainingUri();
    }

    public static final class UriTemplate {
        private final String template;

        private UriTemplate(String template) {
            this.template = template;
        }

        public String toString() {
            return this.template;
        }
    }
}

