/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.filter;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.audit.filter.Filter;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Reject;

class ValueOrFieldFilter
implements Filter {
    private final Map<String, List<JsonPointer>> exclusions;

    public ValueOrFieldFilter(Map<String, List<JsonPointer>> exclusions) {
        Reject.ifNull(exclusions);
        this.exclusions = new LinkedHashMap<String, List<JsonPointer>>(exclusions);
    }

    @Override
    public void doFilter(String auditTopic, JsonValue auditEvent) {
        List<JsonPointer> exclusionList = this.exclusions.get(auditTopic);
        if (exclusionList == null || exclusionList.isEmpty()) {
            return;
        }
        for (JsonPointer exclusionPointer : exclusionList) {
            auditEvent.remove(exclusionPointer);
        }
    }
}

