/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit.events.handlers.writers;

import java.io.IOException;
import java.io.Writer;
import org.forgerock.audit.events.handlers.writers.TextWriter;

public class TextWriterAdapter
extends Writer
implements TextWriter {
    private final TextWriter delegate;

    public TextWriterAdapter(TextWriter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.write(new String(cbuf, off, len));
    }

    @Override
    public void write(int c) throws IOException {
        this.write(String.valueOf((char)c));
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(String.valueOf(cbuf));
    }

    @Override
    public void write(String str) throws IOException {
        this.delegate.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.substring(off, off + len));
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public long getBytesWritten() {
        return this.delegate.getBytesWritten();
    }
}

