/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.audit;

import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.forgerock.audit.AuditService;
import org.forgerock.audit.AuditServiceConfiguration;
import org.forgerock.audit.events.handlers.AuditEventHandler;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.ServiceUnavailableException;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.Reject;
import org.forgerock.util.annotations.VisibleForTesting;
import org.forgerock.util.promise.Promise;

public class AuditServiceProxy
implements AuditService {
    public static final String ACTION_PARAM_TARGET_HANDLER = "handler";
    private final ReentrantReadWriteLock delegateLock;
    private AuditService delegate;

    public AuditServiceProxy(AuditService delegate) {
        this(delegate, new ReentrantReadWriteLock());
    }

    @VisibleForTesting
    AuditServiceProxy(AuditService delegate, ReentrantReadWriteLock delegateLock) {
        Reject.ifNull((Object)delegate);
        this.delegate = delegate;
        this.delegateLock = delegateLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelegate(AuditService newDelegate) throws ServiceUnavailableException {
        Reject.ifNull((Object)newDelegate);
        this.obtainWriteLock();
        try {
            AuditService oldDelegate = this.delegate;
            if (oldDelegate == newDelegate) {
                return;
            }
            oldDelegate.shutdown();
            newDelegate.startup();
            this.delegate = newDelegate;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        this.obtainReadLock();
        try {
            Promise<ResourceResponse, ResourceException> promise = this.delegate.handleRead(context, request);
            return promise;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        this.obtainReadLock();
        try {
            Promise<ResourceResponse, ResourceException> promise = this.delegate.handleCreate(context, request);
            return promise;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        this.obtainReadLock();
        try {
            Promise<ResourceResponse, ResourceException> promise = this.delegate.handleUpdate(context, request);
            return promise;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        this.obtainReadLock();
        try {
            Promise<ResourceResponse, ResourceException> promise = this.delegate.handleDelete(context, request);
            return promise;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        this.obtainReadLock();
        try {
            Promise<ResourceResponse, ResourceException> promise = this.delegate.handlePatch(context, request);
            return promise;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
        this.obtainReadLock();
        try {
            Promise<QueryResponse, ResourceException> promise = this.delegate.handleQuery(context, request, handler);
            return promise;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        this.obtainReadLock();
        try {
            Promise<ActionResponse, ResourceException> promise = this.delegate.handleAction(context, request);
            return promise;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditServiceConfiguration getConfig() throws ServiceUnavailableException {
        this.obtainReadLock();
        try {
            AuditServiceConfiguration auditServiceConfiguration = this.delegate.getConfig();
            return auditServiceConfiguration;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuditEventHandler getRegisteredHandler(String handlerName) throws ServiceUnavailableException {
        this.obtainReadLock();
        try {
            AuditEventHandler auditEventHandler = this.delegate.getRegisteredHandler(handlerName);
            return auditEventHandler;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAuditing(String topic) throws ServiceUnavailableException {
        this.obtainReadLock();
        try {
            boolean bl = this.delegate.isAuditing(topic);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getKnownTopics() throws ServiceUnavailableException {
        this.obtainReadLock();
        try {
            Set<String> set = this.delegate.getKnownTopics();
            return set;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this.obtainWriteLock();
        try {
            this.delegate.shutdown();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() throws ServiceUnavailableException {
        this.obtainWriteLock();
        try {
            this.delegate.startup();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        this.obtainReadLock();
        try {
            boolean bl = this.delegate.isRunning();
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    protected final void obtainReadLock() {
        this.delegateLock.readLock().lock();
        if (this.delegateLock.isWriteLockedByCurrentThread()) {
            throw new IllegalStateException("AuditServiceProxy should not be called from delegate shutdown or startup operations");
        }
    }

    protected final void releaseReadLock() {
        this.delegateLock.readLock().unlock();
    }

    protected final void obtainWriteLock() {
        this.delegateLock.writeLock().lock();
    }

    protected final void releaseWriteLock() {
        this.delegateLock.writeLock().unlock();
    }
}

