/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.servlet;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.session.Session;

final class ServletSession
extends AbstractMap<String, Object>
implements Session {
    private final HttpServletRequest request;
    private volatile HttpSession httpSession;
    private final Set<Map.Entry<String, Object>> attributes = new AbstractSet<Map.Entry<String, Object>>(){

        @Override
        public void clear() {
            ServletSession.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Map.Entry && ServletSession.this.containsKey(((Map.Entry)o).getKey());
        }

        @Override
        public boolean isEmpty() {
            return ServletSession.this.isEmpty();
        }

        @Override
        public Iterator<Map.Entry<String, Object>> iterator() {
            return new Iterator<Map.Entry<String, Object>>(){
                final Enumeration<String> names;
                {
                    this.names = ServletSession.this.httpSession != null ? ServletSession.this.httpSession.getAttributeNames() : null;
                }

                @Override
                public boolean hasNext() {
                    return this.names != null && this.names.hasMoreElements();
                }

                @Override
                public Map.Entry<String, Object> next() {
                    if (this.names == null) {
                        throw new NoSuchElementException();
                    }
                    String name = this.names.nextElement();
                    return new AbstractMap.SimpleEntry<String, Object>(name, ServletSession.this.httpSession.getAttribute(name)){
                        private static final long serialVersionUID = -2957899005221454275L;

                        @Override
                        public Object setValue(Object value) {
                            ServletSession.this.put((String)this.getKey(), value);
                            return super.setValue(value);
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            return o instanceof Map.Entry && ServletSession.this.remove(((Map.Entry)o).getKey()) != null;
        }

        @Override
        public int size() {
            return ServletSession.this.size();
        }
    };

    ServletSession(HttpServletRequest request) {
        this.request = request;
        this.httpSession = request.getSession(false);
    }

    @Override
    public void clear() {
        if (this.httpSession != null) {
            Enumeration attributes = this.httpSession.getAttributeNames();
            ArrayList names = new ArrayList();
            while (attributes.hasMoreElements()) {
                names.add(attributes.nextElement());
            }
            for (String name : names) {
                this.httpSession.removeAttribute(name);
            }
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.attributes;
    }

    @Override
    public Object get(Object key) {
        Object value = null;
        if (key instanceof String && this.httpSession != null) {
            value = this.httpSession.getAttribute((String)key);
        }
        return value;
    }

    @Override
    public boolean isEmpty() {
        return this.httpSession == null || !this.httpSession.getAttributeNames().hasMoreElements();
    }

    @Override
    public synchronized Object put(String key, Object value) {
        Object old = this.get(key);
        if (this.httpSession == null) {
            this.httpSession = this.request.getSession(true);
        }
        this.httpSession.setAttribute(key, value);
        return old;
    }

    @Override
    public Object remove(Object key) {
        Object old = this.get(key);
        if (key instanceof String && this.httpSession != null) {
            this.httpSession.removeAttribute((String)key);
        }
        return old;
    }

    @Override
    public int size() {
        int size = 0;
        if (this.httpSession != null) {
            Enumeration attributes = this.httpSession.getAttributeNames();
            while (attributes.hasMoreElements()) {
                attributes.nextElement();
                ++size;
            }
        }
        return size;
    }

    public void save(Response response) throws IOException {
    }
}

