/*
 * The contents of this file are subject to the terms of the Common Development and
 * Distribution License (the License). You may not use this file except in compliance with the
 * License.
 *
 * You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the
 * specific language governing permission and limitations under the License.
 *
 * When distributing Covered Software, include this CDDL Header Notice in each file and include
 * the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL
 * Header, with the fields enclosed by brackets [] replaced by your own identifying
 * information: "Portions Copyright [year] [name of copyright owner]".
 *
 * Copyright 2008 Sun Microsystems, Inc.
 * Portions Copyright 2014-2015 ForgeRock AS.
 */

package org.opends.guitools.controlpanel.ui.components;

import java.awt.event.KeyEvent;

import javax.swing.JButton;
import javax.swing.KeyStroke;

import org.forgerock.i18n.LocalizableMessage;

/**
 * This is a simple extension of the JButton class used to be able to invoke
 * the method processKeyBinding.
 */
public class CellEditorButton extends JButton
{
  private static final long serialVersionUID = -1491628553090264453L;

  /**
   * The constructor of the cell editor button.
   * @param label the label of the button.
   */
  public CellEditorButton(LocalizableMessage label)
  {
    super(label.toString());
  }

  /** {@inheritDoc} */
  public boolean processKeyBinding(KeyStroke ks, KeyEvent e,
      int condition, boolean pressed)
  {
    return super.processKeyBinding(ks, e, condition, pressed);
  }
}
