/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package com.example.opendj.server;



import org.forgerock.opendj.config.server.ConfigurationChangeListener;
import org.forgerock.opendj.server.config.server.PluginCfg;



/**
 * A server-side interface for querying Example Plugin settings.
 * <p>
 * An example "Hello World" plugin.
 */
public interface ExamplePluginCfg extends PluginCfg {

  /**
   * Gets the configuration class associated with this Example Plugin.
   *
   * @return Returns the configuration class associated with this Example Plugin.
   */
  Class<? extends ExamplePluginCfg> configurationClass();



  /**
   * Register to be notified when this Example Plugin is changed.
   *
   * @param listener
   *          The Example Plugin configuration change listener.
   */
  void addExampleChangeListener(ConfigurationChangeListener<ExamplePluginCfg> listener);



  /**
   * Deregister an existing Example Plugin configuration change listener.
   *
   * @param listener
   *          The Example Plugin configuration change listener.
   */
  void removeExampleChangeListener(ConfigurationChangeListener<ExamplePluginCfg> listener);



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the plug-in implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Gets the "message" property.
   * <p>
   * The message to be logged.
   *
   * @return Returns the value of the "message" property.
   */
  String getMessage();

}
