/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package com.example.opendj.client;



import com.example.opendj.server.ExamplePluginCfg;
import org.forgerock.opendj.config.ManagedObjectDefinition;
import org.forgerock.opendj.config.PropertyException;
import org.forgerock.opendj.server.config.client.PluginCfgClient;



/**
 * A client-side interface for reading and modifying Example Plugin
 * settings.
 * <p>
 * An example "Hello World" plugin.
 */
public interface ExamplePluginCfgClient extends PluginCfgClient {

  /**
   * Get the configuration definition associated with this Example Plugin.
   *
   * @return Returns the configuration definition associated with this Example Plugin.
   */
  ManagedObjectDefinition<? extends ExamplePluginCfgClient, ? extends ExamplePluginCfg> definition();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the plug-in implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the plug-in implementation.
   *
   * @param value The value of the "java-class" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setJavaClass(String value) throws PropertyException;



  /**
   * Gets the "message" property.
   * <p>
   * The message to be logged.
   *
   * @return Returns the value of the "message" property.
   */
  String getMessage();



  /**
   * Sets the "message" property.
   * <p>
   * The message to be logged.
   *
   * @param value The value of the "message" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setMessage(String value) throws PropertyException;

}
