/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

final class SimpleBindStrategy
implements AuthenticationStrategy {
    private final ConnectionFactory connectionFactory;
    private final Schema schema;
    private final String bindDNTemplate;

    public SimpleBindStrategy(ConnectionFactory connectionFactory, String bindDNTemplate, Schema schema) {
        this.connectionFactory = (ConnectionFactory)Reject.checkNotNull((Object)connectionFactory, (String)"connectionFactory cannot be null");
        this.bindDNTemplate = (String)Reject.checkNotNull((Object)bindDNTemplate, (String)"bindDNTemplate cannot be null");
        this.schema = (Schema)Reject.checkNotNull((Object)schema, (String)"schema cannot be null");
    }

    @Override
    public Promise<SecurityContext, LdapException> authenticate(String username, String password, Context parentContext) {
        AtomicReference<Connection> connectionHolder = new AtomicReference<Connection>();
        return this.connectionFactory.getConnectionAsync().thenAsync(SimpleBindStrategy.doSimpleBind(connectionHolder, parentContext, username, DN.format((String)this.bindDNTemplate, (Schema)this.schema, (Object[])new Object[]{username}), password)).thenFinally(Utils.close(connectionHolder));
    }

    static AsyncFunction<Connection, SecurityContext, LdapException> doSimpleBind(final AtomicReference<Connection> connectionHolder, final Context parentContext, final String username, final DN bindDN, final String password) {
        return new AsyncFunction<Connection, SecurityContext, LdapException>(){

            public Promise<SecurityContext, LdapException> apply(Connection connection) throws LdapException {
                connectionHolder.set(connection);
                return connection.bindAsync((BindRequest)Requests.newSimpleBindRequest((String)bindDN.toString(), (char[])password.toCharArray())).then((Function)new Function<BindResult, SecurityContext, LdapException>(){

                    public SecurityContext apply(BindResult result) throws LdapException {
                        LinkedHashMap<String, String> authzid = new LinkedHashMap<String, String>(2);
                        authzid.put("dn", bindDN.toString());
                        authzid.put("id", username);
                        return new SecurityContext(parentContext, username, authzid);
                    }
                });
            }
        };
    }
}

