/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import org.forgerock.http.protocol.Headers;
import org.forgerock.util.Function;
import org.forgerock.util.Pair;
import org.forgerock.util.Reject;
import org.forgerock.util.encode.Base64;
import org.forgerock.util.promise.NeverThrowsException;

public final class CredentialExtractors {
    public static final String HTTP_BASIC_AUTH_HEADER = "Authorization";

    private CredentialExtractors() {
    }

    public static Function<Headers, Pair<String, String>, NeverThrowsException> httpBasicExtractor() {
        return HttpBasicExtractor.INSTANCE;
    }

    public static Function<Headers, Pair<String, String>, NeverThrowsException> newCustomHeaderExtractor(String customHeaderUsername, String customHeaderPassword) {
        return new CustomHeaderExtractor(customHeaderUsername, customHeaderPassword);
    }

    private static final class HttpBasicExtractor
    implements Function<Headers, Pair<String, String>, NeverThrowsException> {
        public static final HttpBasicExtractor INSTANCE = new HttpBasicExtractor();

        private HttpBasicExtractor() {
        }

        public Pair<String, String> apply(Headers headers) {
            Pair<String, String> userCredentials;
            String httpBasicAuthHeader = headers.getFirst(CredentialExtractors.HTTP_BASIC_AUTH_HEADER);
            if (httpBasicAuthHeader != null && (userCredentials = this.parseUsernamePassword(httpBasicAuthHeader)) != null) {
                return userCredentials;
            }
            return null;
        }

        private Pair<String, String> parseUsernamePassword(String authHeader) {
            String base64UserCredentials;
            String userCredentials;
            String[] split;
            if (authHeader != null && authHeader.toLowerCase().startsWith("basic") && (split = (userCredentials = new String(Base64.decode((String)(base64UserCredentials = authHeader.substring("basic".length() + 1))))).split(":")).length == 2) {
                return Pair.of((Object)split[0], (Object)split[1]);
            }
            return null;
        }
    }

    private static final class CustomHeaderExtractor
    implements Function<Headers, Pair<String, String>, NeverThrowsException> {
        private final String customHeaderUsername;
        private final String customHeaderPassword;

        public CustomHeaderExtractor(String customHeaderUsername, String customHeaderPassword) {
            this.customHeaderUsername = (String)Reject.checkNotNull((Object)customHeaderUsername, (String)"customHeaderUsername cannot be null");
            this.customHeaderPassword = (String)Reject.checkNotNull((Object)customHeaderPassword, (String)"customHeaderPassword cannot be null");
        }

        public Pair<String, String> apply(Headers headers) {
            String userName = headers.getFirst(this.customHeaderUsername);
            String password = headers.getFirst(this.customHeaderPassword);
            if (userName != null && password != null) {
                return Pair.of((Object)userName, (Object)password);
            }
            return HttpBasicExtractor.INSTANCE.apply(headers);
        }
    }
}

