/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.filter.Filters;
import org.forgerock.http.oauth2.AccessTokenInfo;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.http.oauth2.OAuth2Context;
import org.forgerock.http.oauth2.ResourceAccess;
import org.forgerock.http.oauth2.ResourceServerFilter;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.ResponseException;
import org.forgerock.http.protocol.Status;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.AuthorizationFilter;
import org.forgerock.opendj.rest2ldap.authz.AuthzIdTemplate;
import org.forgerock.opendj.rest2ldap.authz.ConditionalFilters;
import org.forgerock.opendj.rest2ldap.authz.CtsAccessTokenResolver;
import org.forgerock.opendj.rest2ldap.authz.DirectConnectionFilter;
import org.forgerock.opendj.rest2ldap.authz.FileAccessTokenResolver;
import org.forgerock.opendj.rest2ldap.authz.HttpBasicAuthenticationFilter;
import org.forgerock.opendj.rest2ldap.authz.ProxiedAuthV2Filter;
import org.forgerock.opendj.rest2ldap.authz.Rfc7662AccessTokenResolver;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.Function;
import org.forgerock.util.Pair;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.time.TimeService;

public final class Authorization {
    private static final String OAUTH2_AUTHORIZATION_HEADER = "Authorization";

    public static Filter newAuthorizationFilter(Iterable<? extends ConditionalFilters.ConditionalFilter> filters) {
        return new AuthorizationFilter(filters);
    }

    public static ConditionalFilters.ConditionalFilter newConditionalHttpBasicAuthenticationFilter(AuthenticationStrategy authenticationStrategy, final Function<Headers, Pair<String, String>, NeverThrowsException> credentialsExtractor) {
        return ConditionalFilters.newConditionalFilter(new HttpBasicAuthenticationFilter(authenticationStrategy, credentialsExtractor), new ConditionalFilters.Condition(){

            @Override
            public boolean canApplyFilter(Context context, Request request) {
                return credentialsExtractor.apply((Object)request.getHeaders()) != null;
            }
        });
    }

    public static ConditionalFilters.ConditionalFilter newConditionalDirectConnectionFilter(ConnectionFactory connectionFactory) {
        return ConditionalFilters.asConditionalFilter(new DirectConnectionFilter(connectionFactory));
    }

    public static Filter newProxyAuthorizationFilter(ConnectionFactory connectionFactory) {
        return new ProxiedAuthV2Filter(connectionFactory);
    }

    public static AccessTokenResolver newRfc7662AccessTokenResolver(Handler httpClient, URI introspectionEndPointURL, String clientAppId, String clientAppSecret) {
        return new Rfc7662AccessTokenResolver(httpClient, introspectionEndPointURL, clientAppId, clientAppSecret);
    }

    public static AccessTokenResolver newCtsAccessTokenResolver(ConnectionFactory connectionFactory, String ctsBaseDNTemplate) {
        return new CtsAccessTokenResolver(connectionFactory, ctsBaseDNTemplate);
    }

    public static AccessTokenResolver newFileAccessTokenResolver(String tokenFolder) {
        return new FileAccessTokenResolver(tokenFolder);
    }

    public static Filter newOAuth2ResourceServerFilter(String realm, Set<String> scopes, AccessTokenResolver resolver, String authzIdTemplate) {
        return Authorization.createResourceServerFilter(realm, scopes, resolver, authzIdTemplate);
    }

    public static ConditionalFilters.ConditionalFilter newConditionalOAuth2ResourceServerFilter(final String realm, final Set<String> scopes, final AccessTokenResolver resolver, final String authzIdTemplate) {
        return new ConditionalFilters.ConditionalFilter(){

            @Override
            public Filter getFilter() {
                return Authorization.createResourceServerFilter(realm, scopes, resolver, authzIdTemplate);
            }

            @Override
            public ConditionalFilters.Condition getCondition() {
                return new ConditionalFilters.Condition(){

                    @Override
                    public boolean canApplyFilter(Context context, Request request) {
                        return request.getHeaders().containsKey((Object)Authorization.OAUTH2_AUTHORIZATION_HEADER);
                    }
                };
            }
        };
    }

    private static Filter createResourceServerFilter(String realm, final Set<String> scopes, AccessTokenResolver resolver, String authzIdTemplate) {
        Reject.ifTrue((realm == null || realm.isEmpty() ? 1 : 0) != 0, (String)"realm must not be empty");
        Reject.ifNull((Object)resolver, (String)"Access token resolver must not be null");
        Reject.ifTrue((scopes == null || scopes.isEmpty() ? 1 : 0) != 0, (String)"scopes set can not be empty");
        Reject.ifTrue((authzIdTemplate == null || authzIdTemplate.isEmpty() ? 1 : 0) != 0, (String)"Authz id template must not be empty");
        ResourceAccess scopesProvider = new ResourceAccess(){

            public Set<String> getRequiredScopes(Context context, Request request) throws ResponseException {
                return scopes;
            }
        };
        return Filters.chainOf((Filter[])new Filter[]{new ResourceServerFilter(resolver, TimeService.SYSTEM, scopesProvider, realm), Authorization.createSecurityContextInjectionFilter(authzIdTemplate)});
    }

    private static Filter createSecurityContextInjectionFilter(String authzIdTemplate) {
        final AuthzIdTemplate template = new AuthzIdTemplate(authzIdTemplate);
        return new Filter(){

            public Promise<Response, NeverThrowsException> filter(Context context, Request request, Handler next) {
                AccessTokenInfo token = ((OAuth2Context)context.asContext(OAuth2Context.class)).getAccessToken();
                HashMap<String, String> authz = new HashMap<String, String>(1);
                try {
                    authz.put(template.getSecurityContextID(), template.formatAsAuthzId(token.asJsonValue()));
                }
                catch (IllegalArgumentException e) {
                    return Promises.newResultPromise((Object)new Response(Status.INTERNAL_SERVER_ERROR).setCause((Exception)e));
                }
                SecurityContext securityContext = new SecurityContext(context, token.getToken(), authz);
                return next.handle((Context)securityContext, request);
            }
        };
    }

    private Authorization() {
    }
}

