/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.xml.bind.DatatypeConverter;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.rest2ldap.AuthenticatedConnectionContext;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.schema.JsonSchema;
import org.forgerock.services.context.Context;
import org.forgerock.util.Function;
import org.forgerock.util.promise.NeverThrowsException;

final class Utils {
    private static final Function<Object, ByteString, LocalizedIllegalArgumentException> BASE64_TO_BYTESTRING = new Function<Object, ByteString, LocalizedIllegalArgumentException>(){

        public ByteString apply(Object value) {
            return ByteString.valueOfBase64((String)String.valueOf(value));
        }
    };
    private static final Function<ByteString, String, NeverThrowsException> BYTESTRING_TO_BASE64 = new Function<ByteString, String, NeverThrowsException>(){

        public String apply(ByteString value) {
            return value.toBase64String();
        }
    };

    static Function<Object, ByteString, LocalizedIllegalArgumentException> base64ToByteString() {
        return BASE64_TO_BYTESTRING;
    }

    static Function<ByteString, String, NeverThrowsException> byteStringToBase64() {
        return BYTESTRING_TO_BASE64;
    }

    static Function<ByteString, Object, LocalizedIllegalArgumentException> byteStringToJson(final AttributeDescription ad) {
        return new Function<ByteString, Object, LocalizedIllegalArgumentException>(){

            public Object apply(ByteString value) {
                Syntax syntax = ad.getAttributeType().getSyntax();
                if (syntax.equals((Object)CoreSchema.getBooleanSyntax())) {
                    return Functions.byteStringToBoolean().apply((Object)value);
                }
                if (syntax.equals((Object)CoreSchema.getIntegerSyntax())) {
                    return Functions.byteStringToLong().apply((Object)value);
                }
                if (syntax.equals((Object)CoreSchema.getGeneralizedTimeSyntax())) {
                    return DatatypeConverter.printDateTime((Calendar)((GeneralizedTime)Functions.byteStringToGeneralizedTime().apply((Object)value)).toCalendar());
                }
                if (syntax.equals((Object)JsonSchema.getJsonSyntax())) {
                    return JsonSchema.byteStringToJson().apply((Object)value);
                }
                return Functions.byteStringToString().apply((Object)value);
            }
        };
    }

    private static boolean isJsonPrimitive(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Number;
    }

    static boolean isNullOrEmpty(JsonValue v) {
        return v == null || v.isNull() || v.isList() && v.size() == 0;
    }

    static Attribute jsonToAttribute(Object value, AttributeDescription ad, Function<Object, ByteString, ? extends Exception> f) throws Exception {
        if (Utils.isJsonPrimitive(value)) {
            return new LinkedAttribute(ad, f.apply(value));
        }
        if (value instanceof Collection) {
            LinkedAttribute a = new LinkedAttribute(ad);
            for (Object o : (Collection)value) {
                a.add((ByteString)f.apply(o));
            }
            return a;
        }
        throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_UNRECOGNIZED_JSON_VALUE.get((Object)value.getClass().getName()));
    }

    static Function<Object, ByteString, Exception> jsonToByteString(final AttributeDescription ad) {
        return new Function<Object, ByteString, Exception>(){

            public ByteString apply(Object value) throws Exception {
                Syntax syntax = ad.getAttributeType().getSyntax();
                if (Utils.isJsonPrimitive(value)) {
                    if (syntax.equals((Object)CoreSchema.getGeneralizedTimeSyntax())) {
                        return ByteString.valueOfObject((Object)GeneralizedTime.valueOf((Calendar)DatatypeConverter.parseDateTime((String)value.toString())));
                    }
                    return ByteString.valueOfObject((Object)value);
                }
                if (syntax.equals((Object)JsonSchema.getJsonSyntax())) {
                    return (ByteString)JsonSchema.jsonToByteString().apply(value);
                }
                throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_UNRECOGNIZED_JSON_VALUE.get((Object)value.getClass().getName()));
            }
        };
    }

    static Filter toFilter(boolean value) {
        return value ? Filter.alwaysTrue() : Filter.alwaysFalse();
    }

    static Filter toFilter(FilterType type, String ldapAttribute, ByteString valueAssertion) {
        switch (type) {
            case CONTAINS: {
                return Filter.substrings((String)ldapAttribute, null, Collections.singleton(valueAssertion), null);
            }
            case STARTS_WITH: {
                return Filter.substrings((String)ldapAttribute, (Object)valueAssertion, null, null);
            }
            case EQUAL_TO: {
                return Filter.equality((String)ldapAttribute, (Object)valueAssertion);
            }
            case GREATER_THAN: {
                return Filter.greaterThan((String)ldapAttribute, (Object)valueAssertion);
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return Filter.greaterOrEqual((String)ldapAttribute, (Object)valueAssertion);
            }
            case LESS_THAN: {
                return Filter.lessThan((String)ldapAttribute, (Object)valueAssertion);
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return Filter.lessOrEqual((String)ldapAttribute, (Object)valueAssertion);
            }
            case PRESENT: {
                return Filter.present((String)ldapAttribute);
            }
        }
        return Filter.alwaysFalse();
    }

    static String toLowerCase(String s) {
        return s != null ? s.toLowerCase(Locale.ENGLISH) : null;
    }

    static NotSupportedException newNotSupportedException(LocalizableMessage message) {
        return new NotSupportedException(message.toString());
    }

    static JsonValueException newJsonValueException(JsonValue value, LocalizableMessage message) {
        return new JsonValueException(value, message.toString());
    }

    static BadRequestException newBadRequestException(LocalizableMessage message) {
        return Utils.newBadRequestException(message, null);
    }

    static BadRequestException newBadRequestException(LocalizableMessage message, Throwable cause) {
        return new BadRequestException(message.toString(), cause);
    }

    static Connection connectionFrom(Context context) {
        return ((AuthenticatedConnectionContext)context.asContext(AuthenticatedConnectionContext.class)).getConnection();
    }

    private Utils() {
    }
}

