/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import com.forgerock.opendj.util.ManifestUtil;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplication;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.filter.Filters;
import org.forgerock.http.handler.Handlers;
import org.forgerock.http.handler.HttpClientHandler;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.http.oauth2.resolver.CachingAccessTokenResolver;
import org.forgerock.http.oauth2.resolver.OpenAmAccessTokenResolver;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.swagger.OpenApiRequestFilter;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.json.resource.CrestApplication;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.http.CrestHttp;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.KeyManagers;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.ErrorLoggerFilter;
import org.forgerock.opendj.rest2ldap.Rest2LdapJsonConfigurator;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategies;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.Authorization;
import org.forgerock.opendj.rest2ldap.authz.ConditionalFilters;
import org.forgerock.opendj.rest2ldap.authz.CredentialExtractors;
import org.forgerock.util.Factory;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.Pair;
import org.forgerock.util.PerItemEvictionStrategyCache;
import org.forgerock.util.Reject;
import org.forgerock.util.annotations.VisibleForTesting;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.time.Duration;
import org.forgerock.util.time.TimeService;

public class Rest2LdapHttpApplication
implements HttpApplication {
    private static final String DEFAULT_ROOT_FACTORY = "root";
    private static final String DEFAULT_BIND_FACTORY = "bind";
    private static final String RESOLVER_CONFIG_OBJECT = "resolver";
    private static final String REALM = "realm";
    private static final String SCOPES = "requiredScopes";
    private static final String AUTHZID_TEMPLATE = "authzIdTemplate";
    private static final String CACHE_EXPIRATION_DEFAULT = "5 minutes";
    private static final String CACHE_CONFIG_OBJECT = "accessTokenCache";
    private static final String CACHE_ENABLED = "enabled";
    private static final String CACHE_EXPIRATION = "cacheExpiration";
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    protected final File configDirectory;
    protected final Schema schema;
    private final Map<String, ConnectionFactory> connectionFactories = new HashMap<String, ConnectionFactory>();
    private ScheduledExecutorService executorService;
    private final Collection<Closeable> closeableResources = new ArrayList<Closeable>();
    private TrustManager trustManager;
    private X509KeyManager keyManager;

    public Rest2LdapHttpApplication() {
        try {
            URL configUrl = this.getClass().getResource("/config.json");
            this.configDirectory = configUrl != null ? new File(configUrl.toURI()).getParentFile() : null;
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        this.schema = Schema.getDefaultSchema();
    }

    public Rest2LdapHttpApplication(File configDirectory, Schema schema) {
        this.configDirectory = (File)Reject.checkNotNull((Object)configDirectory, (String)"configDirectory cannot be null");
        this.schema = (Schema)Reject.checkNotNull((Object)schema, (String)"schema cannot be null");
    }

    public final Handler start() throws HttpApplicationException {
        try {
            logger.info(Rest2ldapMessages.INFO_REST2LDAP_STARTING.get((Object)this.configDirectory));
            final ScheduledThreadPoolExecutor scheduledExecutor = new ScheduledThreadPoolExecutor(1);
            scheduledExecutor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            scheduledExecutor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            this.closeOnStop(new Closeable(){

                @Override
                public void close() throws IOException {
                    scheduledExecutor.shutdown();
                }
            });
            this.executorService = scheduledExecutor;
            JsonValue config = Rest2LdapJsonConfigurator.readJson(new File(this.configDirectory, "config.json"));
            this.configureSecurity(config.get("security"));
            this.configureConnectionFactories(config.get("ldapConnectionFactories"));
            Filter authorizationFilter = this.buildAuthorizationFilter(config.get("authorization").required());
            return Handlers.chainOf((Handler)Rest2LdapHttpApplication.newHttpHandler(Rest2LdapHttpApplication.configureRest2Ldap(this.configDirectory)), (Filter[])new Filter[]{new OpenApiRequestFilter(), new ErrorLoggerFilter(), authorizationFilter});
        }
        catch (Exception e) {
            LocalizableMessage errorMsg = Rest2ldapMessages.ERR_FAIL_PARSE_CONFIGURATION.get((Object)e.getLocalizedMessage());
            logger.error(errorMsg, (Throwable)e);
            this.stop();
            throw new HttpApplicationException(errorMsg.toString(), (Throwable)e);
        }
    }

    private static RequestHandler configureRest2Ldap(File configDirectory) throws IOException {
        File rest2LdapConfigDirectory = new File(configDirectory, "rest2ldap");
        Options options = Rest2LdapJsonConfigurator.configureOptions(Rest2LdapJsonConfigurator.readJson(new File(rest2LdapConfigDirectory, "rest2ldap.json")));
        File endpointsDirectory = new File(rest2LdapConfigDirectory, "endpoints");
        return Rest2LdapJsonConfigurator.configureEndpoints(endpointsDirectory, options);
    }

    private static Handler newHttpHandler(RequestHandler requestHandler) {
        final org.forgerock.json.resource.ConnectionFactory factory = Resources.newInternalConnectionFactory((RequestHandler)requestHandler);
        return CrestHttp.newHttpHandler((CrestApplication)new CrestApplication(){

            public org.forgerock.json.resource.ConnectionFactory getConnectionFactory() {
                return factory;
            }

            public String getApiId() {
                return "frapi:opendj:rest2ldap";
            }

            public String getApiVersion() {
                return ManifestUtil.getVersionWithRevision((String)"opendj-core");
            }
        });
    }

    private void configureSecurity(JsonValue configuration) {
        this.trustManager = Rest2LdapJsonConfigurator.configureTrustManager(configuration);
        this.keyManager = Rest2LdapJsonConfigurator.configureKeyManager(configuration);
    }

    private void configureConnectionFactories(JsonValue config) {
        config.get(DEFAULT_ROOT_FACTORY).required();
        this.connectionFactories.clear();
        for (String name : config.keys()) {
            this.connectionFactories.put(name, this.closeOnStop(Rest2LdapJsonConfigurator.configureConnectionFactory(config, name, this.trustManager, this.keyManager)));
        }
    }

    private <T extends Closeable> T closeOnStop(T resource) {
        this.closeableResources.add(resource);
        return resource;
    }

    public Factory<Buffer> getBufferFactory() {
        return null;
    }

    public void stop() {
        org.forgerock.util.Utils.closeSilently(this.closeableResources);
        this.closeableResources.clear();
        this.connectionFactories.clear();
        this.executorService = null;
    }

    private Filter buildAuthorizationFilter(JsonValue config) throws HttpApplicationException {
        Set policies = (Set)config.get("policies").as(JsonValueFunctions.setOf((Function)JsonValueFunctions.enumConstant(Policy.class)));
        ArrayList<ConditionalFilters.ConditionalFilter> filters = new ArrayList<ConditionalFilters.ConditionalFilter>(policies.size());
        if (policies.contains((Object)Policy.OAUTH2)) {
            filters.add(this.buildOAuth2Filter(config.get("oauth2")));
        }
        if (policies.contains((Object)Policy.BASIC)) {
            filters.add(this.buildBasicFilter(config.get("basic")));
        }
        if (policies.contains((Object)Policy.ANONYMOUS)) {
            filters.add(this.buildAnonymousFilter(config.get("anonymous")));
        }
        return Authorization.newAuthorizationFilter(filters);
    }

    @VisibleForTesting
    ConditionalFilters.ConditionalFilter buildOAuth2Filter(JsonValue config) throws HttpApplicationException {
        String realm = config.get(REALM).defaultTo((Object)"no_realm").asString();
        Set scopes = (Set)config.get(SCOPES).required().as(JsonValueFunctions.setOf(String.class));
        AccessTokenResolver resolver = this.createCachedTokenResolverIfNeeded(config, this.parseUnderlyingResolver(config));
        String resolverName = config.get(RESOLVER_CONFIG_OBJECT).asString();
        ConditionalFilters.ConditionalFilter oAuth2Filter = Authorization.newConditionalOAuth2ResourceServerFilter(realm, scopes, resolver, config.get(resolverName).get(AUTHZID_TEMPLATE).required().asString());
        return ConditionalFilters.newConditionalFilter(Filters.chainOf((Filter[])new Filter[]{oAuth2Filter.getFilter(), this.newProxyAuthzFilter(this.getConnectionFactory(DEFAULT_ROOT_FACTORY))}), oAuth2Filter.getCondition());
    }

    @VisibleForTesting
    AccessTokenResolver createCachedTokenResolverIfNeeded(JsonValue config, AccessTokenResolver resolver) {
        JsonValue cacheConfig = config.get(CACHE_CONFIG_OBJECT);
        if (cacheConfig.isNull() || !cacheConfig.get(CACHE_ENABLED).defaultTo((Object)Boolean.FALSE).asBoolean().booleanValue()) {
            return resolver;
        }
        Duration expiration = this.parseCacheExpiration(cacheConfig.get(CACHE_EXPIRATION).defaultTo((Object)CACHE_EXPIRATION_DEFAULT));
        PerItemEvictionStrategyCache cache = new PerItemEvictionStrategyCache(this.executorService, expiration);
        cache.setMaxTimeout(expiration);
        return new CachingAccessTokenResolver(TimeService.SYSTEM, resolver, cache);
    }

    @VisibleForTesting
    AccessTokenResolver parseUnderlyingResolver(JsonValue configuration) throws HttpApplicationException {
        JsonValue resolver = configuration.get(RESOLVER_CONFIG_OBJECT).required();
        switch ((OAuth2ResolverType)((Object)resolver.as(JsonValueFunctions.enumConstant(OAuth2ResolverType.class)))) {
            case RFC7662: {
                return this.parseRfc7662Resolver(configuration);
            }
            case OPENAM: {
                JsonValue openAm = configuration.get("openam");
                return new OpenAmAccessTokenResolver((Handler)this.newHttpClientHandler(openAm), TimeService.SYSTEM, openAm.get("endpointUrl").required().asString());
            }
            case CTS: {
                JsonValue cts = configuration.get("cts").required();
                return Authorization.newCtsAccessTokenResolver(this.getConnectionFactory(cts.get("ldapConnectionFactory").defaultTo((Object)DEFAULT_ROOT_FACTORY).asString()), cts.get("baseDn").required().asString());
            }
            case FILE: {
                return Authorization.newFileAccessTokenResolver(configuration.get("file").get("folderPath").required().asString());
            }
        }
        throw Utils.newJsonValueException(resolver, Rest2ldapMessages.ERR_CONFIG_OAUTH2_UNSUPPORTED_ACCESS_TOKEN_RESOLVER.get(resolver.getObject(), (Object)OAuth2ResolverType.listValues()));
    }

    private AccessTokenResolver parseRfc7662Resolver(JsonValue configuration) throws HttpApplicationException {
        JsonValue rfc7662 = configuration.get("rfc7662").required();
        String introspectionEndPointURL = rfc7662.get("endpointUrl").required().asString();
        try {
            return Authorization.newRfc7662AccessTokenResolver((Handler)this.newHttpClientHandler(rfc7662), new URI(introspectionEndPointURL), rfc7662.get("clientId").required().asString(), rfc7662.get("clientSecret").required().asString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(Rest2ldapMessages.ERR_CONIFG_OAUTH2_INVALID_INTROSPECT_URL.get((Object)introspectionEndPointURL, (Object)e.getLocalizedMessage()).toString(), e);
        }
    }

    private HttpClientHandler newHttpClientHandler(JsonValue config) throws HttpApplicationException {
        Options httpOptions = Options.defaultOptions();
        if (this.trustManager != null) {
            httpOptions.set(HttpClientHandler.OPTION_TRUST_MANAGERS, (Object)new TrustManager[]{this.trustManager});
        }
        if (this.keyManager != null) {
            String keyAlias = config.get("sslCertAlias").asString();
            httpOptions.set(HttpClientHandler.OPTION_KEY_MANAGERS, (Object)new KeyManager[]{keyAlias != null ? KeyManagers.useSingleCertificate((String)keyAlias, (X509KeyManager)this.keyManager) : this.keyManager});
        }
        return this.closeOnStop(new HttpClientHandler(httpOptions));
    }

    private Duration parseCacheExpiration(JsonValue expirationJson) {
        try {
            Duration expiration = (Duration)expirationJson.as(JsonValueFunctions.duration());
            if (expiration.isZero() || expiration.isUnlimited()) {
                throw Utils.newJsonValueException(expirationJson, expiration.isZero() ? Rest2ldapMessages.ERR_CONIFG_OAUTH2_CACHE_ZERO_DURATION.get() : Rest2ldapMessages.ERR_CONIFG_OAUTH2_CACHE_UNLIMITED_DURATION.get());
            }
            return expiration;
        }
        catch (Exception e) {
            throw Utils.newJsonValueException(expirationJson, Rest2ldapMessages.ERR_CONFIG_OAUTH2_CACHE_INVALID_DURATION.get((Object)expirationJson.toString()));
        }
    }

    protected Filter newProxyAuthzFilter(ConnectionFactory connectionFactory) {
        return Authorization.newProxyAuthorizationFilter(connectionFactory);
    }

    private ConditionalFilters.ConditionalFilter buildAnonymousFilter(JsonValue config) {
        return this.newAnonymousFilter(this.getConnectionFactory(config.get("ldapConnectionFactory").defaultTo((Object)DEFAULT_ROOT_FACTORY).asString()));
    }

    protected ConditionalFilters.ConditionalFilter newAnonymousFilter(ConnectionFactory connectionFactory) {
        return Authorization.newConditionalDirectConnectionFilter(connectionFactory);
    }

    protected ConnectionFactory getConnectionFactory(String name) {
        return this.connectionFactories.get(name);
    }

    private ConditionalFilters.ConditionalFilter buildBasicFilter(JsonValue config) {
        String bind = config.get(DEFAULT_BIND_FACTORY).required().asString();
        BindStrategy strategy = BindStrategy.valueOf(bind.toUpperCase().replace('-', '_'));
        return this.newBasicAuthenticationFilter(this.buildBindStrategy(strategy, config.get(bind).required()), config.get("supportAltAuthentication").defaultTo((Object)Boolean.FALSE).asBoolean() != false ? CredentialExtractors.newCustomHeaderExtractor(config.get("altAuthenticationUsernameHeader").required().asString(), config.get("altAuthenticationPasswordHeader").required().asString()) : CredentialExtractors.httpBasicExtractor());
    }

    protected ConditionalFilters.ConditionalFilter newBasicAuthenticationFilter(AuthenticationStrategy authenticationStrategy, Function<Headers, Pair<String, String>, NeverThrowsException> credentialsExtractor) {
        ConditionalFilters.ConditionalFilter httpBasicFilter = Authorization.newConditionalHttpBasicAuthenticationFilter(authenticationStrategy, credentialsExtractor);
        return ConditionalFilters.newConditionalFilter(Filters.chainOf((Filter[])new Filter[]{httpBasicFilter.getFilter(), this.newProxyAuthzFilter(this.getConnectionFactory(DEFAULT_ROOT_FACTORY))}), httpBasicFilter.getCondition());
    }

    private AuthenticationStrategy buildBindStrategy(BindStrategy strategy, JsonValue config) {
        switch (strategy) {
            case SIMPLE: {
                return this.buildSimpleBindStrategy(config);
            }
            case SEARCH: {
                return this.buildSearchThenBindStrategy(config);
            }
            case SASL_PLAIN: {
                return this.buildSaslBindStrategy(config);
            }
        }
        throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_CONFIG_UNSUPPORTED_BIND_STRATEGY.get((Object)strategy, (Object)BindStrategy.listValues()));
    }

    private AuthenticationStrategy buildSimpleBindStrategy(JsonValue config) {
        return AuthenticationStrategies.newSimpleBindStrategy(this.getConnectionFactory(config.get("ldapConnectionFactory").defaultTo((Object)DEFAULT_BIND_FACTORY).asString()), this.parseUserNameTemplate(config.get("bindDnTemplate").defaultTo((Object)"%s")), this.schema);
    }

    private AuthenticationStrategy buildSaslBindStrategy(JsonValue config) {
        return AuthenticationStrategies.newSaslPlainStrategy(this.getConnectionFactory(config.get("ldapConnectionFactory").defaultTo((Object)DEFAULT_BIND_FACTORY).asString()), this.schema, this.parseUserNameTemplate(config.get(AUTHZID_TEMPLATE).defaultTo((Object)"u:%s")));
    }

    private AuthenticationStrategy buildSearchThenBindStrategy(JsonValue config) {
        return AuthenticationStrategies.newSearchThenBindStrategy(this.getConnectionFactory(config.get("searchLdapConnectionFactory").defaultTo((Object)DEFAULT_ROOT_FACTORY).asString()), this.getConnectionFactory(config.get("bindLdapConnectionFactory").defaultTo((Object)DEFAULT_BIND_FACTORY).asString()), DN.valueOf((String)config.get("baseDn").required().asString(), (Schema)this.schema), SearchScope.valueOf((String)config.get("scope").required().asString().toLowerCase()), this.parseUserNameTemplate(config.get("filterTemplate").required()));
    }

    private String parseUserNameTemplate(JsonValue template) {
        return template.asString().replace("{username}", "%s");
    }

    private static enum BindStrategy {
        SIMPLE("simple"),
        SEARCH("search"),
        SASL_PLAIN("sasl-plain");

        private final String jsonField;

        private BindStrategy(String jsonField) {
            this.jsonField = jsonField;
        }

        private static String listValues() {
            ArrayList<String> values = new ArrayList<String>();
            for (BindStrategy mapping : BindStrategy.values()) {
                values.add(mapping.jsonField);
            }
            return org.forgerock.util.Utils.joinAsString((String)",", values);
        }
    }

    @VisibleForTesting
    static enum Policy {
        OAUTH2,
        BASIC,
        ANONYMOUS;

    }

    private static enum OAuth2ResolverType {
        RFC7662,
        OPENAM,
        CTS,
        FILE;


        private static String listValues() {
            ArrayList<String> values = new ArrayList<String>();
            for (OAuth2ResolverType value : OAuth2ResolverType.values()) {
                values.add(value.name().toLowerCase());
            }
            return org.forgerock.util.Utils.joinAsString((String)",", values);
        }
    }
}

