/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.forgerock.api.enums.WritePolicy;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.opendj.rest2ldap.WritabilityPolicy;
import org.forgerock.services.context.Context;
import org.forgerock.util.Function;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

abstract class AbstractLdapPropertyMapper<T extends AbstractLdapPropertyMapper<T>>
extends PropertyMapper {
    List<Object> defaultJsonValues = Collections.emptyList();
    final AttributeDescription ldapAttributeName;
    private boolean isRequired;
    private boolean isMultiValued;
    private WritabilityPolicy writabilityPolicy = WritabilityPolicy.READ_WRITE;

    AbstractLdapPropertyMapper(AttributeDescription ldapAttributeName) {
        this.ldapAttributeName = ldapAttributeName;
    }

    public final T isRequired(boolean isRequired) {
        this.isRequired = isRequired;
        return this.getThis();
    }

    public final T isMultiValued(boolean isMultiValued) {
        this.isMultiValued = isMultiValued;
        return this.getThis();
    }

    @Override
    boolean isRequired() {
        return this.isRequired;
    }

    @Override
    boolean isMultiValued() {
        return this.isMultiValued;
    }

    public final T writability(WritabilityPolicy policy) {
        this.writabilityPolicy = policy;
        return this.getThis();
    }

    boolean attributeIsSingleValued() {
        return !this.isMultiValued || this.ldapAttributeName.getAttributeType().isSingleValue();
    }

    @Override
    Promise<List<Attribute>, ResourceException> create(Context context, Resource resource, final JsonPointer path, JsonValue v) {
        return this.getNewLdapAttributes(context, resource, path, v).then((Function)new Function<Attribute, List<Attribute>, ResourceException>(){

            public List<Attribute> apply(Attribute newLDAPAttribute) throws ResourceException {
                if (!AbstractLdapPropertyMapper.this.writabilityPolicy.canCreate(AbstractLdapPropertyMapper.this.ldapAttributeName)) {
                    if (!newLDAPAttribute.isEmpty() && !AbstractLdapPropertyMapper.this.writabilityPolicy.discardWrites()) {
                        throw Utils.newBadRequestException(Rest2ldapMessages.ERR_CREATION_READ_ONLY_FIELD.get((Object)path));
                    }
                    return Collections.emptyList();
                }
                if (newLDAPAttribute.isEmpty()) {
                    if (AbstractLdapPropertyMapper.this.isRequired) {
                        throw Utils.newBadRequestException(Rest2ldapMessages.ERR_MISSING_REQUIRED_FIELD.get((Object)path));
                    }
                    return Collections.emptyList();
                }
                return Collections.singletonList(newLDAPAttribute);
            }
        });
    }

    @Override
    void getLdapAttributes(JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
        ldapAttributes.add(this.ldapAttributeName.toString());
    }

    abstract Promise<Attribute, ResourceException> getNewLdapAttributes(Context var1, Resource var2, JsonPointer var3, List<Object> var4);

    abstract T getThis();

    @Override
    Promise<List<Modification>, ResourceException> patch(Context context, Resource resource, JsonPointer path, PatchOperation operation) {
        try {
            ModificationType modType;
            JsonPointer field = operation.getField();
            JsonValue v = operation.getValue();
            if (!this.writabilityPolicy.canWrite(this.ldapAttributeName)) {
                throw Utils.newBadRequestException(Rest2ldapMessages.ERR_MODIFY_READ_ONLY_FIELD.get((Object)"patch", (Object)path));
            }
            switch (field.size()) {
                case 0: {
                    if (this.attributeIsSingleValued()) {
                        if (!v.isList()) break;
                        throw Utils.newBadRequestException(Rest2ldapMessages.ERR_ARRAY_FOR_SINGLE_VALUED_FIELD.get((Object)path));
                    }
                    if (v.isList() || operation.isIncrement() || v.isNull() && (operation.isReplace() || operation.isRemove())) break;
                    throw Utils.newBadRequestException(Rest2ldapMessages.ERR_NO_ARRAY_FOR_MULTI_VALUED_FIELD.get((Object)path));
                }
                case 1: {
                    String fieldName = field.get(0);
                    if (fieldName.equals("-") && operation.isAdd()) {
                        if (this.attributeIsSingleValued()) {
                            throw Utils.newBadRequestException(Rest2ldapMessages.ERR_PATCH_APPEND_IN_SINGLE_VALUED_FIELD.get((Object)path));
                        }
                        if (!v.isList()) break;
                        throw Utils.newBadRequestException(Rest2ldapMessages.ERR_PATCH_INDEXED_APPEND_TO_MULTI_VALUED_FIELD.get((Object)path.child(fieldName)));
                    }
                    if (fieldName.matches("[0-9]+")) {
                        throw Utils.newNotSupportedException(Rest2ldapMessages.ERR_PATCH_INDEXED_OPERATION.get((Object)path.child(fieldName)));
                    }
                    throw Utils.newBadRequestException(Rest2ldapMessages.ERR_UNRECOGNIZED_FIELD.get((Object)path.child(fieldName)));
                }
                default: {
                    throw Utils.newBadRequestException(Rest2ldapMessages.ERR_UNRECOGNIZED_FIELD.get((Object)path.child(field.get(0))));
                }
            }
            List<Object> newValues = this.asList(v, Collections.emptyList());
            if (operation.isAdd()) {
                ModificationType modificationType = modType = this.attributeIsSingleValued() ? ModificationType.REPLACE : ModificationType.ADD;
                if (newValues.isEmpty()) {
                    throw Utils.newBadRequestException(Rest2ldapMessages.ERR_PATCH_ADD_NO_VALUE_FOR_FIELD.get((Object)path.child(field.get(0))));
                }
            } else if (operation.isRemove()) {
                modType = ModificationType.DELETE;
            } else if (operation.isReplace()) {
                modType = ModificationType.REPLACE;
            } else if (operation.isIncrement()) {
                modType = ModificationType.INCREMENT;
            } else {
                throw Utils.newNotSupportedException(Rest2ldapMessages.ERR_PATCH_UNSUPPORTED_OPERATION.get((Object)operation.getOperation()));
            }
            if (newValues.isEmpty()) {
                if (this.isRequired) {
                    return Promises.newExceptionPromise((Exception)Utils.newBadRequestException(Rest2ldapMessages.ERR_REMOVE_REQUIRED_FIELD.get((Object)"update", (Object)path)));
                }
                return Promises.newResultPromise(Collections.singletonList(new Modification(modType, Attributes.emptyAttribute((AttributeDescription)this.ldapAttributeName))));
            }
            return this.getNewLdapAttributes(context, resource, path, newValues).then((Function)new Function<Attribute, List<Modification>, ResourceException>(){

                public List<Modification> apply(Attribute value) {
                    return Collections.singletonList(new Modification(modType, value));
                }
            });
        }
        catch (RuntimeException e) {
            return Rest2Ldap.asResourceException(e).asPromise();
        }
        catch (ResourceException e) {
            return Promises.newExceptionPromise((Exception)((Object)e));
        }
    }

    @Override
    Promise<List<Modification>, ResourceException> update(Context context, Resource resource, final JsonPointer path, final Entry e, JsonValue v) {
        return this.getNewLdapAttributes(context, resource, path, v).then((Function)new Function<Attribute, List<Modification>, ResourceException>(){

            public List<Modification> apply(Attribute newLDAPAttribute) throws ResourceException {
                Attribute oldLDAPAttribute;
                Attribute tmp = e.getAttribute(AbstractLdapPropertyMapper.this.ldapAttributeName);
                Attribute attribute = oldLDAPAttribute = tmp != null ? tmp : Attributes.emptyAttribute((AttributeDescription)AbstractLdapPropertyMapper.this.ldapAttributeName);
                if (!AbstractLdapPropertyMapper.this.writabilityPolicy.canWrite(AbstractLdapPropertyMapper.this.ldapAttributeName)) {
                    if (newLDAPAttribute.isEmpty() || newLDAPAttribute.equals((Object)oldLDAPAttribute) || AbstractLdapPropertyMapper.this.writabilityPolicy.discardWrites()) {
                        return Collections.emptyList();
                    }
                    throw Utils.newBadRequestException(Rest2ldapMessages.ERR_MODIFY_READ_ONLY_FIELD.get((Object)"update", (Object)path));
                }
                if (oldLDAPAttribute.isEmpty() && newLDAPAttribute.isEmpty()) {
                    return Collections.emptyList();
                }
                if (oldLDAPAttribute.isEmpty()) {
                    return Collections.singletonList(new Modification(ModificationType.REPLACE, newLDAPAttribute));
                }
                if (newLDAPAttribute.isEmpty()) {
                    if (AbstractLdapPropertyMapper.this.isRequired) {
                        throw Utils.newBadRequestException(Rest2ldapMessages.ERR_REMOVE_REQUIRED_FIELD.get((Object)"update", (Object)path));
                    }
                    return Collections.singletonList(new Modification(ModificationType.REPLACE, newLDAPAttribute));
                }
                ArrayList<Modification> modifications = new ArrayList<Modification>(2);
                LinkedAttribute deletedValues = new LinkedAttribute(oldLDAPAttribute);
                deletedValues.removeAll((Collection)newLDAPAttribute);
                if (!deletedValues.isEmpty()) {
                    modifications.add(new Modification(ModificationType.DELETE, (Attribute)deletedValues));
                }
                LinkedAttribute addedValues = new LinkedAttribute(newLDAPAttribute);
                addedValues.removeAll((Collection)oldLDAPAttribute);
                if (!addedValues.isEmpty()) {
                    modifications.add(new Modification(ModificationType.ADD, (Attribute)addedValues));
                }
                return modifications;
            }
        });
    }

    private List<Object> asList(JsonValue v, List<Object> defaultValues) {
        if (Utils.isNullOrEmpty(v)) {
            return defaultValues;
        }
        if (v.isList()) {
            return v.asList();
        }
        return Collections.singletonList(v.getObject());
    }

    private void checkSchema(JsonPointer path, JsonValue v) throws BadRequestException {
        if (this.attributeIsSingleValued()) {
            if (v != null && v.isList()) {
                throw Utils.newBadRequestException(Rest2ldapMessages.ERR_ARRAY_FOR_SINGLE_VALUED_FIELD.get((Object)path));
            }
        } else if (v != null && !v.isList()) {
            throw Utils.newBadRequestException(Rest2ldapMessages.ERR_NO_ARRAY_FOR_MULTI_VALUED_FIELD.get((Object)path));
        }
    }

    private Promise<Attribute, ResourceException> getNewLdapAttributes(Context context, Resource resource, JsonPointer path, JsonValue v) {
        try {
            this.checkSchema(path, v);
            List<Object> newValues = this.asList(v, this.defaultJsonValues);
            if (newValues.isEmpty()) {
                return Promises.newResultPromise((Object)Attributes.emptyAttribute((AttributeDescription)this.ldapAttributeName));
            }
            return this.getNewLdapAttributes(context, resource, path, newValues);
        }
        catch (Exception e) {
            return Rest2Ldap.asResourceException(e).asPromise();
        }
    }

    void putWritabilityProperties(JsonValue jsonSchema) {
        AbstractLdapPropertyMapper.putWritabilityProperties(this.writabilityPolicy, jsonSchema);
    }

    public static void putWritabilityProperties(WritabilityPolicy writabilityPolicy, JsonValue jsonSchema) {
        switch (writabilityPolicy != null ? writabilityPolicy : WritabilityPolicy.READ_WRITE) {
            case CREATE_ONLY: {
                jsonSchema.put("writePolicy", (Object)WritePolicy.WRITE_ON_CREATE.toString());
                jsonSchema.put("errorOnWritePolicyFailure", (Object)true);
                break;
            }
            case CREATE_ONLY_DISCARD_WRITES: {
                jsonSchema.put("writePolicy", (Object)WritePolicy.WRITE_ON_CREATE.toString());
                break;
            }
            case READ_ONLY: {
                jsonSchema.put("readOnly", (Object)true);
                jsonSchema.put("errorOnWritePolicyFailure", (Object)true);
                break;
            }
            case READ_ONLY_DISCARD_WRITES: {
                jsonSchema.put("readOnly", (Object)true);
                break;
            }
        }
    }
}

