/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.rest2ldap.AuthenticatedConnectionContext;
import org.forgerock.opendj.rest2ldap.authz.AbstractAsynchronousConnectionDecorator;
import org.forgerock.opendj.rest2ldap.authz.CachedReadConnectionDecorator;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

final class ProxiedAuthV2Filter
implements Filter {
    private final ConnectionFactory connectionFactory;

    ProxiedAuthV2Filter(ConnectionFactory connectionFactory) {
        this.connectionFactory = (ConnectionFactory)Reject.checkNotNull((Object)connectionFactory, (String)"connectionFactory cannot be null");
    }

    public Promise<Response, NeverThrowsException> filter(final Context context, final Request request, final Handler next) {
        final AtomicReference connectionHolder = new AtomicReference();
        return this.connectionFactory.getConnectionAsync().then((Function)new Function<Connection, Connection, LdapException>(){

            public Connection apply(Connection connection) throws LdapException {
                connectionHolder.set(connection);
                Connection proxiedConnection = ProxiedAuthV2Filter.this.newProxiedConnection(connection, ProxiedAuthV2Filter.this.resolveAuthorizationId((SecurityContext)context.asContext(SecurityContext.class)));
                connectionHolder.set(proxiedConnection);
                return proxiedConnection;
            }
        }).thenAsync((AsyncFunction)new AsyncFunction<Connection, Response, NeverThrowsException>(){

            public Promise<Response, NeverThrowsException> apply(Connection connection) {
                return next.handle((Context)new AuthenticatedConnectionContext(context, connection), request);
            }
        }, Utils.handleConnectionFailure()).thenFinally(Utils.close(connectionHolder));
    }

    private String resolveAuthorizationId(SecurityContext securityContext) throws LdapException {
        Object candidate = securityContext.getAuthorization().get("dn");
        if (candidate != null) {
            return "dn:" + candidate;
        }
        candidate = securityContext.getAuthorization().get("id");
        if (candidate != null) {
            return "u:" + candidate;
        }
        throw LdapException.newLdapException((ResultCode)ResultCode.AUTH_METHOD_NOT_SUPPORTED);
    }

    private Connection newProxiedConnection(Connection baseConnection, String authzId) {
        return new CachedReadConnectionDecorator((Connection)new ProxiedAuthConnectionDecorator(baseConnection, (Control)ProxiedAuthV2RequestControl.newControl((String)authzId)));
    }

    private static final class ProxiedAuthConnectionDecorator
    extends AbstractAsynchronousConnectionDecorator {
        private final Control proxiedAuthzControl;

        ProxiedAuthConnectionDecorator(Connection delegate, Control proxiedAuthzControl) {
            super(delegate);
            this.proxiedAuthzControl = proxiedAuthzControl;
        }

        @Override
        public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.delegate.addAsync(request.addControl(this.proxiedAuthzControl), intermediateResponseHandler);
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.delegate.compareAsync(request.addControl(this.proxiedAuthzControl), intermediateResponseHandler);
        }

        @Override
        public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.delegate.deleteAsync(request.addControl(this.proxiedAuthzControl), intermediateResponseHandler);
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.delegate.extendedRequestAsync(request.addControl(this.proxiedAuthzControl), intermediateResponseHandler);
        }

        @Override
        public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.delegate.modifyAsync(request.addControl(this.proxiedAuthzControl), intermediateResponseHandler);
        }

        @Override
        public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler) {
            return this.delegate.modifyDNAsync(request.addControl(this.proxiedAuthzControl), intermediateResponseHandler);
        }

        @Override
        public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
            return this.delegate.searchAsync(request.addControl(this.proxiedAuthzControl), intermediateResponseHandler, entryHandler);
        }
    }
}

