/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import org.forgerock.http.routing.ResourceApiVersionBehaviourManager;
import org.forgerock.http.routing.RouteMatchers;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.Version;
import org.forgerock.http.util.Json;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.Filter;
import org.forgerock.json.resource.FilterChain;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.Router;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.KeyManagers;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.rest2ldap.AbstractRequestHandler;
import org.forgerock.opendj.rest2ldap.Action;
import org.forgerock.opendj.rest2ldap.JsonPropertyMapper;
import org.forgerock.opendj.rest2ldap.ObjectPropertyMapper;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.ReadOnUpdatePolicy;
import org.forgerock.opendj.rest2ldap.ReferencePropertyMapper;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.SimplePropertyMapper;
import org.forgerock.opendj.rest2ldap.SubResource;
import org.forgerock.opendj.rest2ldap.SubResourceCollection;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.opendj.rest2ldap.WritabilityPolicy;
import org.forgerock.services.context.Context;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.time.Duration;

public final class Rest2LdapJsonConfigurator {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();

    public static Options configureOptions(JsonValue config) {
        Options options = Options.defaultOptions();
        options.set(Rest2Ldap.READ_ON_UPDATE_POLICY, config.get("readOnUpdatePolicy").defaultTo((Object)ReadOnUpdatePolicy.CONTROLS).as(JsonValueFunctions.enumConstant(ReadOnUpdatePolicy.class)));
        options.set(Rest2Ldap.USE_SUBTREE_DELETE, (Object)config.get("useSubtreeDelete").defaultTo((Object)false).asBoolean());
        options.set(Rest2Ldap.USE_PERMISSIVE_MODIFY, (Object)config.get("usePermissiveModify").defaultTo((Object)false).asBoolean());
        options.set(Rest2Ldap.USE_MVCC, (Object)config.get("useMvcc").defaultTo((Object)true).asBoolean());
        options.set(Rest2Ldap.MVCC_ATTRIBUTE, (Object)config.get("mvccAttribute").defaultTo((Object)"etag").asString());
        return options;
    }

    public static List<Resource> configureResources(JsonValue config) {
        JsonValue resourcesConfig = config.required().expect(Map.class);
        LinkedList<Resource> resources = new LinkedList<Resource>();
        for (String resourceId : resourcesConfig.keys()) {
            resources.add(Rest2LdapJsonConfigurator.configureResource(resourceId, resourcesConfig.get(resourceId)));
        }
        return resources;
    }

    public static Router configureEndpoints(File endpointsDirectory, Options options) throws IOException {
        Router pathRouter = new Router();
        File[] endpoints = endpointsDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory() && pathname.canRead();
            }
        });
        if (endpoints == null) {
            throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_INVALID_ENDPOINTS_DIRECTORY.get((Object)endpointsDirectory));
        }
        for (File endpoint : endpoints) {
            RequestHandler endpointHandler = Rest2LdapJsonConfigurator.configureEndpoint(endpoint, options);
            pathRouter.addRoute(org.forgerock.json.resource.RouteMatchers.requestUriMatcher((RoutingMode)RoutingMode.STARTS_WITH, (String)endpoint.getName()), (Object)endpointHandler);
        }
        return pathRouter;
    }

    public static RequestHandler configureEndpoint(File endpointDirectory, Options options) throws IOException {
        Router versionRouter = new Router();
        File[] endpointVersions = endpointDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.canRead() && pathname.getName().endsWith(".json");
            }
        });
        if (endpointVersions == null) {
            throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_INVALID_ENDPOINT_DIRECTORY.get((Object)endpointDirectory));
        }
        final ArrayList<String> supportedVersions = new ArrayList<String>();
        boolean hasWildCardVersion = false;
        for (File endpointVersion : endpointVersions) {
            JsonValue mappingConfig = Rest2LdapJsonConfigurator.readJson(endpointVersion);
            String version = mappingConfig.get("version").defaultTo((Object)"*").asString();
            List<Resource> resourceTypes = Rest2LdapJsonConfigurator.configureResources(mappingConfig.get("resourceTypes"));
            Rest2Ldap rest2Ldap = Rest2Ldap.rest2Ldap(options, resourceTypes);
            String endpointVersionFileName = endpointVersion.getName();
            int endIndex = endpointVersionFileName.lastIndexOf(46);
            String rootResourceType = endpointVersionFileName.substring(0, endIndex);
            RequestHandler handler = rest2Ldap.newRequestHandlerFor(rootResourceType);
            if (version.equals("*")) {
                versionRouter.setDefaultRoute((Object)handler);
                hasWildCardVersion = true;
            } else {
                versionRouter.addRoute(Version.version((String)version), handler);
                supportedVersions.add(version);
            }
            logger.debug(Rest2ldapMessages.INFO_REST2LDAP_CREATING_ENDPOINT.get((Object)endpointDirectory.getName(), (Object)version));
        }
        if (!hasWildCardVersion) {
            versionRouter.setDefaultRoute((Object)new AbstractRequestHandler(){

                @Override
                protected <V> Promise<V, ResourceException> handleRequest(Context context, Request request) {
                    String message = Rest2ldapMessages.ERR_BAD_API_RESOURCE_VERSION.get((Object)request.getResourceVersion(), (Object)org.forgerock.util.Utils.joinAsString((String)", ", (Iterable)supportedVersions)).toString();
                    return new BadRequestException(message).asPromise();
                }
            });
        }
        ResourceApiVersionBehaviourManager behaviourManager = RouteMatchers.newResourceApiVersionBehaviourManager();
        behaviourManager.setWarningEnabled(false);
        return new FilterChain((RequestHandler)versionRouter, new Filter[]{org.forgerock.json.resource.RouteMatchers.resourceApiVersionContextFilter((ResourceApiVersionBehaviourManager)behaviourManager)});
    }

    static JsonValue readJson(File resource) throws IOException {
        try (FileInputStream in = new FileInputStream(resource);){
            JsonValue jsonValue = new JsonValue(Json.readJsonLenient((InputStream)in));
            return jsonValue;
        }
    }

    private static Resource configureResource(String resourceId, JsonValue config) {
        Resource resource = Rest2Ldap.resource(resourceId).isAbstract(config.get("isAbstract").defaultTo((Object)false).asBoolean()).superType(config.get("superType").asString()).objectClasses(config.get("objectClasses").defaultTo(Collections.emptyList()).asList(String.class).toArray(new String[0])).supportedActions(((Set)config.get("supportedActions").defaultTo(Collections.emptyList()).as(JsonValueFunctions.setOf((Function)JsonValueFunctions.enumConstant(Action.class)))).toArray(new Action[0])).resourceTypeProperty((JsonPointer)config.get("resourceTypeProperty").as(JsonValueFunctions.pointer())).includeAllUserAttributesByDefault(config.get("includeAllUserAttributesByDefault").defaultTo((Object)false).asBoolean()).excludedDefaultUserAttributes(config.get("excludedDefaultUserAttributes").defaultTo(Collections.emptyList()).asList(String.class));
        JsonValue properties = config.get("properties").expect(Map.class);
        for (String property : properties.keys()) {
            resource.property(property, Rest2LdapJsonConfigurator.configurePropertyMapper(properties.get(property), property));
        }
        JsonValue subResources = config.get("subResources").expect(Map.class);
        for (String urlTemplate : subResources.keys()) {
            resource.subResource(Rest2LdapJsonConfigurator.configureSubResource(urlTemplate, subResources.get(urlTemplate)));
        }
        return resource;
    }

    private static SubResource configureSubResource(String urlTemplate, JsonValue config) {
        String dnTemplate = config.get("dnTemplate").defaultTo((Object)"").asString();
        Boolean isReadOnly = config.get("isReadOnly").defaultTo((Object)false).asBoolean();
        String resourceId = config.get("resource").required().asString();
        if (config.get("type").required().as(JsonValueFunctions.enumConstant(SubResourceType.class)) == SubResourceType.COLLECTION) {
            String[] glueObjectClasses = config.get("glueObjectClasses").defaultTo(Collections.emptyList()).asList(String.class).toArray(new String[0]);
            SubResourceCollection collection = Rest2Ldap.collectionOf(resourceId).urlTemplate(urlTemplate).dnTemplate(dnTemplate).isReadOnly(isReadOnly).glueObjectClasses(glueObjectClasses);
            JsonValue namingStrategy = config.get("namingStrategy").required();
            switch ((NamingStrategyType)((Object)namingStrategy.get("type").required().as(JsonValueFunctions.enumConstant(NamingStrategyType.class)))) {
                case CLIENTDNNAMING: {
                    collection.useClientDnNaming(namingStrategy.get("dnAttribute").required().asString());
                    break;
                }
                case CLIENTNAMING: {
                    collection.useClientNaming(namingStrategy.get("dnAttribute").required().asString(), namingStrategy.get("idAttribute").required().asString());
                    break;
                }
                case SERVERNAMING: {
                    collection.useServerNaming(namingStrategy.get("dnAttribute").required().asString(), namingStrategy.get("idAttribute").required().asString());
                }
            }
            return collection;
        }
        return Rest2Ldap.singletonOf(resourceId).urlTemplate(urlTemplate).dnTemplate(dnTemplate).isReadOnly(isReadOnly);
    }

    private static PropertyMapper configurePropertyMapper(JsonValue mapper, String defaultLdapAttribute) {
        switch (mapper.get("type").required().asString()) {
            case "resourceType": {
                return Rest2Ldap.resourceType();
            }
            case "constant": {
                return Rest2Ldap.constant(mapper.get("value").getObject());
            }
            case "simple": {
                return ((SimplePropertyMapper)((SimplePropertyMapper)Rest2Ldap.simple(mapper.get("ldapAttribute").defaultTo((Object)defaultLdapAttribute).required().asString()).defaultJsonValue(mapper.get("defaultJsonValue").getObject()).isBinary(mapper.get("isBinary").defaultTo((Object)false).asBoolean()).isRequired(mapper.get("isRequired").defaultTo((Object)false).asBoolean())).isMultiValued(mapper.get("isMultiValued").defaultTo((Object)false).asBoolean())).writability(Rest2LdapJsonConfigurator.parseWritability(mapper));
            }
            case "json": {
                return ((JsonPropertyMapper)((JsonPropertyMapper)Rest2Ldap.json(mapper.get("ldapAttribute").defaultTo((Object)defaultLdapAttribute).required().asString()).defaultJsonValue(mapper.get("defaultJsonValue").getObject()).isRequired(mapper.get("isRequired").defaultTo((Object)false).asBoolean())).isMultiValued(mapper.get("isMultiValued").defaultTo((Object)false).asBoolean())).jsonSchema(mapper.isDefined("schema") ? mapper.get("schema") : null).writability(Rest2LdapJsonConfigurator.parseWritability(mapper));
            }
            case "reference": {
                String ldapAttribute = mapper.get("ldapAttribute").defaultTo((Object)defaultLdapAttribute).required().asString();
                String baseDN = mapper.get("baseDn").required().asString();
                String primaryKey = mapper.get("primaryKey").required().asString();
                PropertyMapper m = Rest2LdapJsonConfigurator.configurePropertyMapper(mapper.get("mapper").required(), primaryKey);
                return ((ReferencePropertyMapper)((ReferencePropertyMapper)Rest2Ldap.reference(ldapAttribute, baseDN, primaryKey, m).isRequired(mapper.get("isRequired").defaultTo((Object)false).asBoolean())).isMultiValued(mapper.get("isMultiValued").defaultTo((Object)false).asBoolean())).searchFilter(mapper.get("searchFilter").defaultTo((Object)"(objectClass=*)").asString()).writability(Rest2LdapJsonConfigurator.parseWritability(mapper));
            }
            case "object": {
                JsonValue properties = mapper.get("properties");
                ObjectPropertyMapper object = Rest2Ldap.object();
                for (String attribute : properties.keys()) {
                    object.property(attribute, Rest2LdapJsonConfigurator.configurePropertyMapper(properties.get(attribute), attribute));
                }
                return object;
            }
        }
        throw Utils.newJsonValueException(mapper, Rest2ldapMessages.ERR_CONFIG_NO_MAPPING_IN_CONFIGURATION.get((Object)"constant, simple, reference, object"));
    }

    private static WritabilityPolicy parseWritability(JsonValue mapper) {
        return (WritabilityPolicy)((Object)mapper.get("writability").defaultTo((Object)"readWrite").as(JsonValueFunctions.enumConstant(WritabilityPolicy.class)));
    }

    public static X509KeyManager configureKeyManager(JsonValue configuration) {
        try {
            return Rest2LdapJsonConfigurator.configureKeyManager(configuration, KeyManagerType.JVM);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException(Rest2ldapMessages.ERR_CONFIG_INVALID_KEY_MANAGER.get((Object)configuration.getPointer(), (Object)e.getLocalizedMessage()).toString(), e);
        }
    }

    private static X509KeyManager configureKeyManager(JsonValue config, KeyManagerType defaultIfMissing) throws GeneralSecurityException, IOException {
        KeyManagerType keyManagerType = (KeyManagerType)((Object)config.get("keyManager").defaultTo((Object)defaultIfMissing).as(JsonValueFunctions.enumConstant(KeyManagerType.class)));
        switch (keyManagerType) {
            case JVM: {
                return KeyManagers.useJvmDefaultKeyStore();
            }
            case FILE: {
                String fileName = config.get("fileBasedKeyManagerFile").required().asString();
                String passwordFile = config.get("fileBasedKeyManagerPasswordFile").asString();
                String password = passwordFile != null ? Rest2LdapJsonConfigurator.readPasswordFromFile(passwordFile) : config.get("fileBasedKeyManagerPassword").asString();
                String type = config.get("fileBasedKeyManagerType").asString();
                String provider = config.get("fileBasedKeyManagerProvider").asString();
                return KeyManagers.useKeyStoreFile((String)fileName, (char[])(password != null ? password.toCharArray() : null), (String)type, (String)provider);
            }
            case PKCS11: {
                String pkcs11PasswordFile = config.get("pkcs11KeyManagerPasswordFile").asString();
                return KeyManagers.usePKCS11Token(pkcs11PasswordFile != null ? Rest2LdapJsonConfigurator.readPasswordFromFile(pkcs11PasswordFile).toCharArray() : null);
            }
        }
        throw new IllegalArgumentException("Unsupported key-manager type: " + (Object)((Object)keyManagerType));
    }

    private static String readPasswordFromFile(String fileName) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(new File(fileName)));){
            String string = reader.readLine();
            return string;
        }
    }

    public static TrustManager configureTrustManager(JsonValue configuration) {
        try {
            return Rest2LdapJsonConfigurator.configureTrustManager(configuration, TrustManagerType.JVM);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException(Rest2ldapMessages.ERR_CONFIG_INVALID_TRUST_MANAGER.get((Object)configuration.getPointer(), (Object)e.getLocalizedMessage()).toString(), e);
        }
    }

    private static TrustManager configureTrustManager(JsonValue config, TrustManagerType defaultIfMissing) throws GeneralSecurityException, IOException {
        TrustManagerType trustManagerType = (TrustManagerType)((Object)config.get("trustManager").defaultTo((Object)defaultIfMissing).as(JsonValueFunctions.enumConstant(TrustManagerType.class)));
        switch (trustManagerType) {
            case TRUSTALL: {
                return TrustManagers.trustAll();
            }
            case JVM: {
                return null;
            }
            case FILE: {
                String fileName = config.get("fileBasedTrustManagerFile").required().asString();
                String passwordFile = config.get("fileBasedTrustManagerPasswordFile").asString();
                String password = passwordFile != null ? Rest2LdapJsonConfigurator.readPasswordFromFile(passwordFile) : config.get("fileBasedTrustManagerPassword").asString();
                String type = config.get("fileBasedTrustManagerType").asString();
                return TrustManagers.checkUsingTrustStore((String)fileName, (char[])(password != null ? password.toCharArray() : null), (String)type);
            }
        }
        throw new IllegalArgumentException("Unsupported trust-manager type: " + (Object)((Object)trustManagerType));
    }

    public static ConnectionFactory configureConnectionFactory(JsonValue configuration, String name, TrustManager trustManager, X509KeyManager keyManager, ClassLoader providerClassLoader) {
        JsonValue normalizedConfiguration = Rest2LdapJsonConfigurator.normalizeConnectionFactory(configuration, name, 0);
        return Rest2LdapJsonConfigurator.configureConnectionFactory(normalizedConfiguration, trustManager, keyManager, providerClassLoader);
    }

    public static ConnectionFactory configureConnectionFactory(JsonValue configuration, String name, TrustManager trustManager, X509KeyManager keyManager) {
        return Rest2LdapJsonConfigurator.configureConnectionFactory(configuration, name, trustManager, keyManager, null);
    }

    private static ConnectionFactory configureConnectionFactory(JsonValue configuration, TrustManager trustManager, X509KeyManager keyManager, ClassLoader providerClassLoader) {
        JsonValue primaryLdapServers;
        ConnectionSecurity connectionSecurity;
        long heartBeatIntervalSeconds = configuration.get("heartBeatIntervalSeconds").defaultTo((Object)30L).asLong();
        Duration heartBeatInterval = Duration.duration((long)Math.max(heartBeatIntervalSeconds, 1L), (TimeUnit)TimeUnit.SECONDS);
        long heartBeatTimeoutMillis = configuration.get("heartBeatTimeoutMilliSeconds").defaultTo((Object)500L).asLong();
        Duration heartBeatTimeout = Duration.duration((long)Math.max(heartBeatTimeoutMillis, 100L), (TimeUnit)TimeUnit.MILLISECONDS);
        Options options = Options.defaultOptions().set(LDAPConnectionFactory.TRANSPORT_PROVIDER_CLASS_LOADER, (Object)providerClassLoader).set(LDAPConnectionFactory.HEARTBEAT_ENABLED, (Object)true).set(LDAPConnectionFactory.HEARTBEAT_INTERVAL, (Object)heartBeatInterval).set(LDAPConnectionFactory.HEARTBEAT_TIMEOUT, (Object)heartBeatTimeout).set(Connections.LOAD_BALANCER_MONITORING_INTERVAL, (Object)heartBeatInterval);
        int connectionPoolSize = Math.max(configuration.get("connectionPoolSize").defaultTo((Object)10).asInteger(), 1);
        if (configuration.isDefined("authentication")) {
            JsonValue authn = configuration.get("authentication");
            if (authn.isDefined("simple")) {
                JsonValue simple = authn.get("simple");
                SimpleBindRequest bindRequest = Requests.newSimpleBindRequest((String)simple.get("bindDn").required().asString(), (char[])simple.get("bindPassword").required().asString().toCharArray());
                options.set(LDAPConnectionFactory.AUTHN_BIND_REQUEST, (Object)bindRequest);
            } else {
                throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_CONFIG_INVALID_AUTHENTICATION.get());
            }
        }
        if ((connectionSecurity = (ConnectionSecurity)((Object)configuration.get("connectionSecurity").defaultTo((Object)ConnectionSecurity.NONE).as(JsonValueFunctions.enumConstant(ConnectionSecurity.class)))) != ConnectionSecurity.NONE) {
            try {
                SSLContextBuilder builder = new SSLContextBuilder();
                builder.setTrustManager(trustManager);
                String sslCertAlias = configuration.get("sslCertAlias").asString();
                builder.setKeyManager((KeyManager)(sslCertAlias != null ? KeyManagers.useSingleCertificate((String)sslCertAlias, (X509KeyManager)keyManager) : keyManager));
                options.set(LDAPConnectionFactory.SSL_CONTEXT, (Object)builder.getSSLContext());
                options.set(LDAPConnectionFactory.SSL_USE_STARTTLS, (Object)(connectionSecurity == ConnectionSecurity.STARTTLS ? 1 : 0));
            }
            catch (GeneralSecurityException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!(primaryLdapServers = configuration.get("primaryLdapServers")).isList() || primaryLdapServers.size() == 0) {
            throw new IllegalArgumentException("No primaryLdapServers");
        }
        ConnectionFactory primary = Rest2LdapJsonConfigurator.parseLdapServers(primaryLdapServers, connectionPoolSize, options);
        JsonValue secondaryLdapServers = configuration.get("secondaryLdapServers");
        ConnectionFactory secondary = null;
        if (secondaryLdapServers.isList()) {
            if (secondaryLdapServers.size() > 0) {
                secondary = Rest2LdapJsonConfigurator.parseLdapServers(secondaryLdapServers, connectionPoolSize, options);
            }
        } else if (!secondaryLdapServers.isNull()) {
            throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_CONFIG_INVALID_SECONDARY_LDAP_SERVER.get());
        }
        if (secondary != null) {
            return Connections.newFailoverLoadBalancer(Arrays.asList(primary, secondary), (Options)options);
        }
        return primary;
    }

    private static JsonValue normalizeConnectionFactory(JsonValue configuration, String name, int depth) {
        if (depth > 100) {
            throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_CONFIG_SERVER_CIRCULAR_DEPENDENCIES.get((Object)name));
        }
        JsonValue current = configuration.get(name).required();
        if (current.isDefined("inheritFrom")) {
            JsonValue parent = Rest2LdapJsonConfigurator.normalizeConnectionFactory(configuration, current.get("inheritFrom").asString(), depth + 1);
            LinkedHashMap normalized = new LinkedHashMap(parent.asMap());
            normalized.putAll(current.asMap());
            normalized.remove("inheritFrom");
            return new JsonValue(normalized);
        }
        return current;
    }

    private static ConnectionFactory parseLdapServers(JsonValue config, int poolSize, Options options) {
        ArrayList<Object> servers = new ArrayList<Object>(config.size());
        for (JsonValue server : config) {
            String host = server.get("hostname").required().asString();
            int port = server.get("port").required().asInteger();
            LDAPConnectionFactory factory = new LDAPConnectionFactory(host, port, options);
            if (poolSize > 1) {
                servers.add(Connections.newCachedConnectionPool((ConnectionFactory)factory, (int)0, (int)poolSize, (long)60L, (TimeUnit)TimeUnit.SECONDS));
                continue;
            }
            servers.add(factory);
        }
        if (servers.size() > 1) {
            return Connections.newRoundRobinLoadBalancer(servers, (Options)options);
        }
        return (ConnectionFactory)servers.get(0);
    }

    private Rest2LdapJsonConfigurator() {
    }

    private static enum KeyManagerType {
        JVM,
        FILE,
        PKCS11;

    }

    private static enum TrustManagerType {
        TRUSTALL,
        JVM,
        FILE;

    }

    private static enum ConnectionSecurity {
        NONE,
        SSL,
        STARTTLS;

    }

    private static enum SubResourceType {
        COLLECTION,
        SINGLETON;

    }

    private static enum NamingStrategyType {
        CLIENTDNNAMING,
        CLIENTNAMING,
        SERVERNAMING;

    }
}

