/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class ResourceTypePropertyMapper
extends PropertyMapper {
    static final ResourceTypePropertyMapper INSTANCE = new ResourceTypePropertyMapper();

    private ResourceTypePropertyMapper() {
    }

    public String toString() {
        return "type()";
    }

    @Override
    boolean isRequired() {
        return true;
    }

    @Override
    boolean isMultiValued() {
        return false;
    }

    @Override
    Promise<List<Attribute>, ResourceException> create(Context context, Resource resource, JsonPointer path, JsonValue v) {
        return Promises.newResultPromise(Collections.singletonList(resource.getObjectClassAttribute()));
    }

    @Override
    void getLdapAttributes(JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
        ldapAttributes.add("objectClass");
    }

    @Override
    Promise<Filter, ResourceException> getLdapFilter(Context context, Resource resource, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        if (subPath.isEmpty()) {
            switch (type) {
                case PRESENT: {
                    return Promises.newResultPromise((Object)Filter.alwaysTrue());
                }
                case EQUAL_TO: {
                    if (valueAssertion instanceof String) {
                        Resource subType = resource.resolveSubTypeFromString((String)valueAssertion);
                        if (subType == null) {
                            return Promises.newResultPromise((Object)Filter.alwaysFalse());
                        }
                        ArrayList<Filter> subFilters = new ArrayList<Filter>();
                        for (ByteString objectClass : subType.getObjectClassAttribute()) {
                            subFilters.add(Filter.equality((String)"objectClass", (Object)objectClass));
                        }
                        return Promises.newResultPromise((Object)Filter.and(subFilters));
                    }
                    return Utils.newBadRequestException(Rest2ldapMessages.ERR_ILLEGAL_FILTER_ASSERTION_VALUE.get(valueAssertion, (Object)path)).asPromise();
                }
            }
            return Promises.newResultPromise((Object)Filter.alwaysFalse());
        }
        return Promises.newResultPromise((Object)Filter.alwaysFalse());
    }

    @Override
    Promise<List<Modification>, ResourceException> patch(Context context, Resource resource, JsonPointer path, PatchOperation operation) {
        return Utils.newBadRequestException(Rest2ldapMessages.ERR_PATCH_READ_ONLY_FIELD.get((Object)path)).asPromise();
    }

    @Override
    Promise<JsonValue, ResourceException> read(Context context, Resource resource, JsonPointer path, Entry e) {
        return Promises.newResultPromise((Object)new JsonValue((Object)resource.getResourceId()));
    }

    @Override
    Promise<List<Modification>, ResourceException> update(Context context, Resource resource, JsonPointer path, Entry e, JsonValue v) {
        if (!Utils.isNullOrEmpty(v) && !v.getObject().equals(resource.getResourceId())) {
            return Utils.newBadRequestException(Rest2ldapMessages.ERR_MODIFY_READ_ONLY_FIELD.get((Object)"update", (Object)path)).asPromise();
        }
        return Promises.newResultPromise(Collections.emptyList());
    }

    @Override
    JsonValue toJsonSchema() {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"string")}));
    }
}

