/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.api.commons.CommonsApi;
import org.forgerock.api.enums.CountPolicy;
import org.forgerock.api.enums.CreateMode;
import org.forgerock.api.enums.PagingMode;
import org.forgerock.api.enums.ParameterSource;
import org.forgerock.api.enums.PatchOperation;
import org.forgerock.api.enums.QueryType;
import org.forgerock.api.enums.Stability;
import org.forgerock.api.models.Action;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.models.Create;
import org.forgerock.api.models.Definitions;
import org.forgerock.api.models.Delete;
import org.forgerock.api.models.Errors;
import org.forgerock.api.models.Items;
import org.forgerock.api.models.Parameter;
import org.forgerock.api.models.Patch;
import org.forgerock.api.models.Paths;
import org.forgerock.api.models.Query;
import org.forgerock.api.models.Read;
import org.forgerock.api.models.Reference;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.Schema;
import org.forgerock.api.models.Services;
import org.forgerock.api.models.Update;
import org.forgerock.api.models.VersionedPath;
import org.forgerock.http.ApiProducer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.Router;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.rest2ldap.Action;
import org.forgerock.opendj.rest2ldap.ObjectPropertyMapper;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.SubResource;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.routing.AbstractRouter;
import org.forgerock.util.i18n.LocalizableString;

public final class Resource {
    private static final String ERROR_ADMIN_LIMIT_EXCEEDED = "#/errors/adminLimitExceeded";
    private static final String ERROR_READ_FOUND_MULTIPLE_ENTRIES = "#/errors/readFoundMultipleEntries";
    private static final String ERROR_PASSWORD_MODIFY_REQUIRES_HTTPS = "#/errors/passwordModifyRequiresHttps";
    private static final String ERROR_PASSWORD_MODIFY_REQUIRES_AUTHENTICATION = "#/errors/passwordModifyRequiresAuthn";
    private static final String ERROR_BAD_REQUEST = CommonsApi.Errors.BAD_REQUEST.getReference();
    private static final String ERROR_FORBIDDEN = CommonsApi.Errors.FORBIDDEN.getReference();
    private static final String ERROR_INTERNAL_SERVER_ERROR = CommonsApi.Errors.INTERNAL_SERVER_ERROR.getReference();
    private static final String ERROR_NOT_FOUND = CommonsApi.Errors.NOT_FOUND.getReference();
    private static final String ERROR_REQUEST_ENTITY_TOO_LARGE = CommonsApi.Errors.REQUEST_ENTITY_TOO_LARGE.getReference();
    private static final String ERROR_REQUEST_TIMEOUT = CommonsApi.Errors.REQUEST_TIMEOUT.getReference();
    private static final String ERROR_UNAUTHORIZED = CommonsApi.Errors.UNAUTHORIZED.getReference();
    private static final String ERROR_UNAVAILABLE = CommonsApi.Errors.UNAVAILABLE.getReference();
    private static final String ERROR_VERSION_MISMATCH = CommonsApi.Errors.VERSION_MISMATCH.getReference();
    private static final String ALL_FIELDS = "*";
    private final String id;
    private boolean isAbstract;
    private String superTypeId;
    private final Attribute objectClasses = new LinkedAttribute("objectClass");
    private final Set<SubResource> subResources = new LinkedHashSet<SubResource>();
    private final Map<String, PropertyMapper> declaredProperties = new LinkedHashMap<String, PropertyMapper>();
    private final Map<String, PropertyMapper> allProperties = new LinkedHashMap<String, PropertyMapper>();
    private JsonPointer resourceTypeProperty;
    private boolean isBuilt = false;
    private Resource superType;
    private final Set<Resource> subTypes = new LinkedHashSet<Resource>();
    private final ObjectPropertyMapper propertyMapper = new ObjectPropertyMapper();
    private final Router subResourceRouter = new Router();
    private volatile Boolean hasSubTypesWithSubResources = null;
    private final Set<Action> supportedActions = new HashSet<Action>();
    private LocalizableMessage description;

    Resource(String id) {
        this.id = id;
    }

    public void description(LocalizableMessage description) {
        this.description = description;
    }

    public String toString() {
        return this.id;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Resource && this.id.equals(((Resource)o).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public Resource superType(String resourceId) {
        this.superTypeId = resourceId;
        return this;
    }

    public Resource isAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
        return this;
    }

    public Resource property(String name, PropertyMapper mapper) {
        this.declaredProperties.put(name, mapper);
        return this;
    }

    public Resource includeAllUserAttributesByDefault(boolean include) {
        this.propertyMapper.includeAllUserAttributesByDefault(include);
        return this;
    }

    public Resource excludedDefaultUserAttributes(String ... attributeNames) {
        return this.excludedDefaultUserAttributes(Arrays.asList(attributeNames));
    }

    public Resource excludedDefaultUserAttributes(Collection<String> attributeNames) {
        this.propertyMapper.excludedDefaultUserAttributes(attributeNames);
        return this;
    }

    public Resource resourceTypeProperty(JsonPointer resourceTypeProperty) {
        this.resourceTypeProperty = resourceTypeProperty;
        return this;
    }

    public Resource objectClass(String objectClass) {
        this.objectClasses.add(new Object[]{objectClass});
        return this;
    }

    public Resource objectClasses(String ... objectClasses) {
        this.objectClasses.add((Object[])objectClasses);
        return this;
    }

    public Resource supportedAction(Action action) {
        this.supportedActions.add(action);
        return this;
    }

    public Resource supportedActions(Action ... actions) {
        this.supportedActions.addAll(Arrays.asList(actions));
        return this;
    }

    public Resource subResource(SubResource subResource) {
        this.subResources.add(subResource);
        return this;
    }

    public Resource subResources(SubResource ... subResources) {
        this.subResources.addAll(Arrays.asList(subResources));
        return this;
    }

    boolean hasSupportedAction(Action action) {
        return this.supportedActions.contains((Object)action);
    }

    boolean hasSubTypes() {
        return !this.subTypes.isEmpty();
    }

    boolean mayHaveSubResources() {
        return !this.subResources.isEmpty() || this.hasSubTypesWithSubResources();
    }

    boolean hasSubTypesWithSubResources() {
        if (this.hasSubTypesWithSubResources == null) {
            for (Resource subType : this.subTypes) {
                if (subType.subResources.isEmpty() && !subType.hasSubTypesWithSubResources()) continue;
                this.hasSubTypesWithSubResources = true;
                return true;
            }
            this.hasSubTypesWithSubResources = false;
        }
        return this.hasSubTypesWithSubResources;
    }

    Set<Resource> getSubTypes() {
        return this.subTypes;
    }

    Resource resolveSubTypeFromJson(JsonValue content) throws ResourceException {
        if (!this.hasSubTypes()) {
            return this;
        }
        JsonValue jsonType = content.get(this.resourceTypeProperty);
        if (jsonType == null || !jsonType.isString()) {
            throw Utils.newBadRequestException(Rest2ldapMessages.ERR_MISSING_TYPE_PROPERTY_IN_CREATE.get((Object)this.resourceTypeProperty));
        }
        String type = jsonType.asString();
        Resource subType = this.resolveSubTypeFromString(type);
        if (subType == null) {
            throw Utils.newBadRequestException(Rest2ldapMessages.ERR_UNRECOGNIZED_TYPE_IN_CREATE.get((Object)type, (Object)this.getAllowedResourceTypes()));
        }
        if (subType.isAbstract) {
            throw Utils.newBadRequestException(Rest2ldapMessages.ERR_ABSTRACT_TYPE_IN_CREATE.get((Object)type, (Object)this.getAllowedResourceTypes()));
        }
        return subType;
    }

    private String getAllowedResourceTypes() {
        ArrayList<String> allowedTypes = new ArrayList<String>();
        this.getAllowedResourceTypes(allowedTypes);
        return org.forgerock.util.Utils.joinAsString((String)", ", allowedTypes);
    }

    private void getAllowedResourceTypes(List<String> allowedTypes) {
        if (!this.isAbstract) {
            allowedTypes.add(this.id);
        }
        for (Resource subType : this.subTypes) {
            subType.getAllowedResourceTypes(allowedTypes);
        }
    }

    Resource resolveSubTypeFromString(String type) {
        if (this.id.equalsIgnoreCase(type)) {
            return this;
        }
        for (Resource subType : this.subTypes) {
            Resource resolvedSubType = subType.resolveSubTypeFromString(type);
            if (resolvedSubType == null) continue;
            return resolvedSubType;
        }
        return null;
    }

    Resource resolveSubTypeFromObjectClasses(Entry entry) {
        if (!this.hasSubTypes()) {
            return this;
        }
        Attribute objectClassesFromEntry = entry.getAttribute("objectClass");
        Resource subType = this.resolveSubTypeFromObjectClasses(objectClassesFromEntry);
        if (subType == null) {
            return this;
        }
        return subType;
    }

    private Resource resolveSubTypeFromObjectClasses(Attribute objectClassesFromEntry) {
        if (!objectClassesFromEntry.containsAll((Collection)this.objectClasses)) {
            return null;
        }
        for (Resource subType : this.subTypes) {
            Resource resolvedSubType = subType.resolveSubTypeFromObjectClasses(objectClassesFromEntry);
            if (resolvedSubType == null) continue;
            return resolvedSubType;
        }
        return this;
    }

    Attribute getObjectClassAttribute() {
        return this.objectClasses;
    }

    RequestHandler getSubResourceRouter() {
        return this.subResourceRouter;
    }

    String getResourceId() {
        return this.id;
    }

    String getServiceId(boolean isReadOnly) {
        StringBuilder serviceId = new StringBuilder(this.getResourceId());
        if (isReadOnly) {
            serviceId.append(":read-only");
        } else {
            serviceId.append(":read-write");
        }
        return serviceId.toString();
    }

    void build(Rest2Ldap rest2Ldap) {
        if (this.isBuilt) {
            return;
        }
        this.isBuilt = true;
        if (this.superTypeId != null) {
            this.superType = rest2Ldap.getResource(this.superTypeId);
            if (this.superType == null) {
                throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_UNRECOGNIZED_RESOURCE_SUPER_TYPE.get((Object)this.id, (Object)this.superTypeId));
            }
            this.superType.build(rest2Ldap);
            this.superType.subTypes.add(this);
            if (this.resourceTypeProperty == null) {
                this.resourceTypeProperty = this.superType.resourceTypeProperty;
            }
            this.objectClasses.addAll((Collection)this.superType.objectClasses);
            this.subResourceRouter.addAllRoutes((AbstractRouter)this.superType.subResourceRouter);
            this.allProperties.putAll(this.superType.allProperties);
        }
        this.allProperties.putAll(this.declaredProperties);
        for (Map.Entry<String, PropertyMapper> property : this.allProperties.entrySet()) {
            this.propertyMapper.property(property.getKey(), property.getValue());
        }
        for (SubResource subResource : this.subResources) {
            subResource.build(rest2Ldap, this.id);
            subResource.addRoutes(this.subResourceRouter);
        }
    }

    PropertyMapper getPropertyMapper() {
        return this.propertyMapper;
    }

    ApiDescription instanceApi(boolean isReadOnly) {
        if (this.allProperties.isEmpty() && this.superType == null && this.subTypes.isEmpty()) {
            return null;
        }
        Resource.Builder resource = org.forgerock.api.models.Resource.resource().title(this.getServiceId(isReadOnly)).description(this.toLS(this.description)).resourceSchema(Resource.schemaRef("#/definitions/" + this.id)).mvccSupported(Boolean.valueOf(this.isMvccSupported()));
        resource.read(Resource.readOperation());
        if (!isReadOnly) {
            resource.update(Resource.updateOperation());
            resource.patch(Resource.patchOperation());
            for (Action action : this.supportedActions) {
                resource.action(this.actions(action));
            }
        }
        return ApiDescription.apiDescription().id("unused").version("unused").definitions(this.definitions()).services(this.services(resource, isReadOnly)).paths(this.paths(isReadOnly)).errors(this.errors()).build();
    }

    ApiDescription collectionApi(boolean isReadOnly) {
        Resource.Builder resource = org.forgerock.api.models.Resource.resource().title(this.getServiceId(isReadOnly)).description(this.toLS(this.description)).resourceSchema(Resource.schemaRef("#/definitions/" + this.id)).mvccSupported(Boolean.valueOf(this.isMvccSupported()));
        resource.items(this.buildItems(isReadOnly));
        if (!isReadOnly) {
            resource.create(Resource.createOperation(CreateMode.ID_FROM_SERVER));
        }
        resource.query(((Query.Builder)((Query.Builder)((Query.Builder)((Query.Builder)((Query.Builder)((Query.Builder)((Query.Builder)((Query.Builder)Query.query().stability(Stability.EVOLVING)).type(QueryType.FILTER).queryableFields(new String[]{ALL_FIELDS}).pagingModes(new PagingMode[]{PagingMode.COOKIE, PagingMode.OFFSET}).countPolicies(new CountPolicy[]{CountPolicy.NONE}).error(Resource.errorRef(ERROR_BAD_REQUEST))).error(Resource.errorRef(ERROR_UNAUTHORIZED))).error(Resource.errorRef(ERROR_FORBIDDEN))).error(Resource.errorRef(ERROR_REQUEST_TIMEOUT))).error(Resource.errorRef(ERROR_ADMIN_LIMIT_EXCEEDED))).error(Resource.errorRef(ERROR_INTERNAL_SERVER_ERROR))).error(Resource.errorRef(ERROR_UNAVAILABLE))).build());
        return ApiDescription.apiDescription().id("unused").version("unused").definitions(this.definitions()).services(this.services(resource, isReadOnly)).paths(this.paths(isReadOnly)).errors(this.errors()).build();
    }

    private Services services(Resource.Builder resource, boolean isReadOnly) {
        String serviceId = this.getServiceId(isReadOnly);
        return Services.services().put(serviceId, resource.build()).build();
    }

    private Paths paths(boolean isReadOnly) {
        String serviceId = this.getServiceId(isReadOnly);
        org.forgerock.api.models.Resource resource = Resource.resourceRef("#/services/" + serviceId);
        return Paths.paths().put("", VersionedPath.versionedPath().put(VersionedPath.UNVERSIONED, resource).build()).build();
    }

    private Definitions definitions() {
        Definitions.Builder definitions = Definitions.definitions();
        for (Resource res : Resource.collectTypeHierarchy(this)) {
            definitions.put(res.id, res.buildJsonSchema());
        }
        return definitions.build();
    }

    private static Iterable<Resource> collectTypeHierarchy(Resource currentType) {
        ArrayList<Resource> typeHierarchy = new ArrayList<Resource>();
        Resource ancestorType = currentType;
        while (ancestorType.superType != null) {
            ancestorType = ancestorType.superType;
            typeHierarchy.add(ancestorType);
        }
        typeHierarchy.add(currentType);
        Resource.addSubTypes(typeHierarchy, currentType);
        return typeHierarchy;
    }

    private static void addSubTypes(List<Resource> typeHierarchy, Resource res) {
        for (Resource subType : res.subTypes) {
            typeHierarchy.add(subType);
            Resource.addSubTypes(typeHierarchy, subType);
        }
    }

    private LocalizableString toLS(LocalizableMessage msg) {
        if (msg != null) {
            return new LocalizableString(msg.toString());
        }
        return null;
    }

    ApiDescription subResourcesApi(ApiProducer<ApiDescription> producer) {
        return (ApiDescription)this.subResourceRouter.api(producer);
    }

    private boolean isMvccSupported() {
        return this.allProperties.containsKey("_rev");
    }

    private Items buildItems(boolean isReadOnly) {
        Items.Builder builder = Items.items();
        builder.pathParameter(Parameter.parameter().name("id").type("string").source(ParameterSource.PATH).required(Boolean.valueOf(true)).build()).read(Resource.readOperation());
        if (!isReadOnly) {
            builder.create(Resource.createOperation(CreateMode.ID_FROM_CLIENT));
            builder.update(Resource.updateOperation());
            builder.delete(Resource.deleteOperation());
            builder.patch(Resource.patchOperation());
            for (Action action : this.supportedActions) {
                builder.action(this.actions(action));
            }
        }
        return builder.build();
    }

    private org.forgerock.api.models.Action actions(Action action) {
        switch (action) {
            case MODIFY_PASSWORD: {
                return Resource.modifyPasswordAction();
            }
            case RESET_PASSWORD: {
                return Resource.resetPasswordAction();
            }
        }
        throw new RuntimeException("Not implemented for action " + (Object)((Object)action));
    }

    private static Create createOperation(CreateMode createMode) {
        return ((Create.Builder)((Create.Builder)((Create.Builder)((Create.Builder)((Create.Builder)((Create.Builder)((Create.Builder)((Create.Builder)((Create.Builder)((Create.Builder)((Create.Builder)Create.create().stability(Stability.EVOLVING)).mode(createMode).error(Resource.errorRef(ERROR_BAD_REQUEST))).error(Resource.errorRef(ERROR_UNAUTHORIZED))).error(Resource.errorRef(ERROR_FORBIDDEN))).error(Resource.errorRef(ERROR_NOT_FOUND))).error(Resource.errorRef(ERROR_REQUEST_TIMEOUT))).error(Resource.errorRef(ERROR_VERSION_MISMATCH))).error(Resource.errorRef(ERROR_REQUEST_ENTITY_TOO_LARGE))).error(Resource.errorRef(ERROR_ADMIN_LIMIT_EXCEEDED))).error(Resource.errorRef(ERROR_INTERNAL_SERVER_ERROR))).error(Resource.errorRef(ERROR_UNAVAILABLE))).build();
    }

    private static Delete deleteOperation() {
        return ((Delete.Builder)((Delete.Builder)((Delete.Builder)((Delete.Builder)((Delete.Builder)((Delete.Builder)((Delete.Builder)((Delete.Builder)((Delete.Builder)((Delete.Builder)((Delete.Builder)((Delete.Builder)Delete.delete().stability(Stability.EVOLVING)).error(Resource.errorRef(ERROR_BAD_REQUEST))).error(Resource.errorRef(ERROR_UNAUTHORIZED))).error(Resource.errorRef(ERROR_FORBIDDEN))).error(Resource.errorRef(ERROR_NOT_FOUND))).error(Resource.errorRef(ERROR_REQUEST_TIMEOUT))).error(Resource.errorRef(ERROR_VERSION_MISMATCH))).error(Resource.errorRef(ERROR_REQUEST_ENTITY_TOO_LARGE))).error(Resource.errorRef(ERROR_READ_FOUND_MULTIPLE_ENTRIES))).error(Resource.errorRef(ERROR_ADMIN_LIMIT_EXCEEDED))).error(Resource.errorRef(ERROR_INTERNAL_SERVER_ERROR))).error(Resource.errorRef(ERROR_UNAVAILABLE))).build();
    }

    private static Patch patchOperation() {
        return ((Patch.Builder)((Patch.Builder)((Patch.Builder)((Patch.Builder)((Patch.Builder)((Patch.Builder)((Patch.Builder)((Patch.Builder)((Patch.Builder)((Patch.Builder)((Patch.Builder)((Patch.Builder)Patch.patch().stability(Stability.EVOLVING)).operations(new PatchOperation[]{PatchOperation.ADD, PatchOperation.REMOVE, PatchOperation.REPLACE, PatchOperation.INCREMENT}).error(Resource.errorRef(ERROR_BAD_REQUEST))).error(Resource.errorRef(ERROR_UNAUTHORIZED))).error(Resource.errorRef(ERROR_FORBIDDEN))).error(Resource.errorRef(ERROR_NOT_FOUND))).error(Resource.errorRef(ERROR_REQUEST_TIMEOUT))).error(Resource.errorRef(ERROR_VERSION_MISMATCH))).error(Resource.errorRef(ERROR_REQUEST_ENTITY_TOO_LARGE))).error(Resource.errorRef(ERROR_READ_FOUND_MULTIPLE_ENTRIES))).error(Resource.errorRef(ERROR_ADMIN_LIMIT_EXCEEDED))).error(Resource.errorRef(ERROR_INTERNAL_SERVER_ERROR))).error(Resource.errorRef(ERROR_UNAVAILABLE))).build();
    }

    private static Read readOperation() {
        return ((Read.Builder)((Read.Builder)((Read.Builder)((Read.Builder)((Read.Builder)((Read.Builder)((Read.Builder)((Read.Builder)((Read.Builder)((Read.Builder)Read.read().stability(Stability.EVOLVING)).error(Resource.errorRef(ERROR_BAD_REQUEST))).error(Resource.errorRef(ERROR_UNAUTHORIZED))).error(Resource.errorRef(ERROR_FORBIDDEN))).error(Resource.errorRef(ERROR_NOT_FOUND))).error(Resource.errorRef(ERROR_REQUEST_TIMEOUT))).error(Resource.errorRef(ERROR_READ_FOUND_MULTIPLE_ENTRIES))).error(Resource.errorRef(ERROR_ADMIN_LIMIT_EXCEEDED))).error(Resource.errorRef(ERROR_INTERNAL_SERVER_ERROR))).error(Resource.errorRef(ERROR_UNAVAILABLE))).build();
    }

    private static Update updateOperation() {
        return ((Update.Builder)((Update.Builder)((Update.Builder)((Update.Builder)((Update.Builder)((Update.Builder)((Update.Builder)((Update.Builder)((Update.Builder)((Update.Builder)((Update.Builder)((Update.Builder)Update.update().stability(Stability.EVOLVING)).error(Resource.errorRef(ERROR_BAD_REQUEST))).error(Resource.errorRef(ERROR_UNAUTHORIZED))).error(Resource.errorRef(ERROR_FORBIDDEN))).error(Resource.errorRef(ERROR_NOT_FOUND))).error(Resource.errorRef(ERROR_REQUEST_TIMEOUT))).error(Resource.errorRef(ERROR_VERSION_MISMATCH))).error(Resource.errorRef(ERROR_REQUEST_ENTITY_TOO_LARGE))).error(Resource.errorRef(ERROR_READ_FOUND_MULTIPLE_ENTRIES))).error(Resource.errorRef(ERROR_ADMIN_LIMIT_EXCEEDED))).error(Resource.errorRef(ERROR_INTERNAL_SERVER_ERROR))).error(Resource.errorRef(ERROR_UNAVAILABLE))).build();
    }

    private static org.forgerock.api.models.Action modifyPasswordAction() {
        return ((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)org.forgerock.api.models.Action.action().stability(Stability.EVOLVING)).name("modifyPassword").request(Resource.passwordModifyRequest()).description("Modify a user password. This action requires HTTPS.")).error(Resource.errorRef(ERROR_BAD_REQUEST))).error(Resource.errorRef(ERROR_UNAUTHORIZED))).error(Resource.errorRef(ERROR_PASSWORD_MODIFY_REQUIRES_HTTPS))).error(Resource.errorRef(ERROR_PASSWORD_MODIFY_REQUIRES_AUTHENTICATION))).error(Resource.errorRef(ERROR_FORBIDDEN))).error(Resource.errorRef(ERROR_NOT_FOUND))).error(Resource.errorRef(ERROR_REQUEST_TIMEOUT))).error(Resource.errorRef(ERROR_VERSION_MISMATCH))).error(Resource.errorRef(ERROR_REQUEST_ENTITY_TOO_LARGE))).error(Resource.errorRef(ERROR_READ_FOUND_MULTIPLE_ENTRIES))).error(Resource.errorRef(ERROR_ADMIN_LIMIT_EXCEEDED))).error(Resource.errorRef(ERROR_INTERNAL_SERVER_ERROR))).error(Resource.errorRef(ERROR_UNAVAILABLE))).build();
    }

    private static Schema passwordModifyRequest() {
        JsonValue jsonSchema = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"object"), JsonValue.field((String)"description", (Object)"Supply the old password and new password."), JsonValue.field((String)"required", (Object)JsonValue.array((Object[])new Object[]{"oldPassword", "newPassword"})), JsonValue.field((String)"properties", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"oldPassword", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"string"), JsonValue.field((String)"name", (Object)"Old Password"), JsonValue.field((String)"description", (Object)"Current password as a UTF-8 string."), JsonValue.field((String)"format", (Object)"password")})), JsonValue.field((String)"newPassword", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"string"), JsonValue.field((String)"name", (Object)"New Password"), JsonValue.field((String)"description", (Object)"New password as a UTF-8 string."), JsonValue.field((String)"format", (Object)"password")}))}))}));
        return Resource.schema(jsonSchema);
    }

    private static org.forgerock.api.models.Action resetPasswordAction() {
        return ((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)((Action.Builder)org.forgerock.api.models.Action.action().stability(Stability.EVOLVING)).name("resetPassword").response(Resource.resetPasswordResponse()).description("Reset a user password to a generated value. This action requires HTTPS.")).error(Resource.errorRef(ERROR_BAD_REQUEST))).error(Resource.errorRef(ERROR_UNAUTHORIZED))).error(Resource.errorRef(ERROR_PASSWORD_MODIFY_REQUIRES_HTTPS))).error(Resource.errorRef(ERROR_PASSWORD_MODIFY_REQUIRES_AUTHENTICATION))).error(Resource.errorRef(ERROR_FORBIDDEN))).error(Resource.errorRef(ERROR_NOT_FOUND))).error(Resource.errorRef(ERROR_REQUEST_TIMEOUT))).error(Resource.errorRef(ERROR_VERSION_MISMATCH))).error(Resource.errorRef(ERROR_REQUEST_ENTITY_TOO_LARGE))).error(Resource.errorRef(ERROR_READ_FOUND_MULTIPLE_ENTRIES))).error(Resource.errorRef(ERROR_ADMIN_LIMIT_EXCEEDED))).error(Resource.errorRef(ERROR_INTERNAL_SERVER_ERROR))).error(Resource.errorRef(ERROR_UNAVAILABLE))).build();
    }

    private static Schema resetPasswordResponse() {
        JsonValue jsonSchema = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"object"), JsonValue.field((String)"properties", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"generatedPassword", (Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"string"), JsonValue.field((String)"description", (Object)"Generated password to communicate to the user.")}))}))}));
        return Resource.schema(jsonSchema);
    }

    private Schema buildJsonSchema() {
        ArrayList<String> requiredFields = new ArrayList<String>();
        JsonValue properties = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]));
        for (Map.Entry<String, PropertyMapper> prop : this.declaredProperties.entrySet()) {
            JsonValue jsonSchema;
            String propertyName = prop.getKey();
            PropertyMapper mapper = prop.getValue();
            if (mapper.isRequired()) {
                requiredFields.add(propertyName);
            }
            if ((jsonSchema = mapper.toJsonSchema()) == null) continue;
            properties.put(propertyName, jsonSchema.getObject());
        }
        JsonValue jsonSchema = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"type", (Object)"object")}));
        String discriminator = this.getDiscriminator();
        if (discriminator != null) {
            jsonSchema.put("discriminator", (Object)discriminator);
        }
        if (!requiredFields.isEmpty()) {
            jsonSchema.put("required", requiredFields);
        }
        if (properties.size() > 0) {
            jsonSchema.put("properties", properties.getObject());
        }
        if (this.superType != null) {
            return Resource.schema(JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"allOf", (Object)JsonValue.array((Object[])new Object[]{JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"$ref", (Object)("#/definitions/" + this.superType.id))}), jsonSchema.getObject()}))})));
        }
        return Resource.schema(jsonSchema);
    }

    private String getDiscriminator() {
        if (this.resourceTypeProperty != null) {
            String propertyName = this.resourceTypeProperty.leaf();
            return this.declaredProperties.containsKey(propertyName) ? propertyName : null;
        }
        return null;
    }

    private Errors errors() {
        return Errors.errors().put("passwordModifyRequiresHttps", Resource.error(403, "Password modify requires a secure connection.")).put("passwordModifyRequiresAuthn", Resource.error(403, "Password modify requires user to be authenticated.")).put("readFoundMultipleEntries", Resource.error(500, "Multiple entries where found when trying to read a single entry.")).put("adminLimitExceeded", Resource.error(500, "The request exceeded an administrative limit.")).build();
    }

    static ApiError error(int code, String description) {
        return ApiError.apiError().code(Integer.valueOf(code)).description(description).build();
    }

    static ApiError error(int code, LocalizableString description) {
        return ApiError.apiError().code(Integer.valueOf(code)).description(description).build();
    }

    static ApiError errorRef(String referenceValue) {
        return ApiError.apiError().reference(Resource.ref(referenceValue)).build();
    }

    static org.forgerock.api.models.Resource resourceRef(String referenceValue) {
        return org.forgerock.api.models.Resource.resource().reference(Resource.ref(referenceValue)).build();
    }

    static Schema schemaRef(String referenceValue) {
        return Schema.schema().reference(Resource.ref(referenceValue)).build();
    }

    private static Schema schema(JsonValue jsonSchema) {
        return Schema.schema().schema(jsonSchema).build();
    }

    static Reference ref(String referenceValue) {
        return Reference.reference().value(referenceValue).build();
    }
}

