/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.HttpApplication;
import org.forgerock.http.HttpApplicationException;
import org.forgerock.http.handler.Handlers;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.util.Json;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.http.CrestHttp;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.rest2ldap.AuthorizationPolicy;
import org.forgerock.opendj.rest2ldap.HttpAuthenticationFilter;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.services.context.Context;
import org.forgerock.util.Factory;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Rest2LDAPHttpApplication
implements HttpApplication {
    private static final Logger LOG = LoggerFactory.getLogger(Rest2LDAPHttpApplication.class);
    private final URL configurationUrl;
    private HttpHandler handler;
    private HttpAuthenticationFilter filter;

    public Rest2LDAPHttpApplication() {
        this.configurationUrl = this.getClass().getResource("/opendj-rest2ldap-config.json");
    }

    public Rest2LDAPHttpApplication(URL configurationURL) {
        Reject.ifNull((Object)configurationURL, (String)"The configuration URL must not be null");
        this.configurationUrl = configurationURL;
    }

    private static JsonValue readJson(URL resource) throws IOException {
        try (InputStream in = resource.openStream();){
            JsonValue jsonValue = new JsonValue(Json.readJsonLenient((InputStream)in));
            return jsonValue;
        }
    }

    public Handler start() throws HttpApplicationException {
        try {
            JsonValue configuration = Rest2LDAPHttpApplication.readJson(this.configurationUrl);
            this.handler = new HttpHandler(configuration);
            this.filter = new HttpAuthenticationFilter(configuration);
            return Handlers.chainOf((Handler)this.handler, (Filter[])new Filter[]{this.filter});
        }
        catch (Exception e) {
            String errorMsg = "Unable to start Rest2Ldap Http Application";
            LOG.error("Unable to start Rest2Ldap Http Application", (Throwable)e);
            this.stop();
            throw new HttpApplicationException("Unable to start Rest2Ldap Http Application", (Throwable)e);
        }
    }

    public Factory<Buffer> getBufferFactory() {
        return null;
    }

    public void stop() {
        Utils.closeSilently((Closeable[])new Closeable[]{this.handler, this.filter});
        this.handler = null;
        this.filter = null;
    }

    private static final class HttpHandler
    implements Handler,
    Closeable {
        private final ConnectionFactory ldapConnectionFactory;
        private final Handler delegate;

        HttpHandler(JsonValue configuration) {
            this.ldapConnectionFactory = HttpHandler.createLdapConnectionFactory(configuration);
            try {
                this.delegate = CrestHttp.newHttpHandler((RequestHandler)HttpHandler.createRouter(configuration, this.ldapConnectionFactory));
            }
            catch (RuntimeException e) {
                Utils.closeSilently((Closeable[])new Closeable[]{this.ldapConnectionFactory});
                throw e;
            }
        }

        private static RequestHandler createRouter(JsonValue configuration, ConnectionFactory ldapConnectionFactory) {
            AuthorizationPolicy authzPolicy = (AuthorizationPolicy)configuration.get("servlet").get("authorizationPolicy").required().asEnum(AuthorizationPolicy.class);
            String proxyAuthzTemplate = configuration.get("servlet").get("proxyAuthzIdTemplate").asString();
            JsonValue mappings = configuration.get("servlet").get("mappings").required();
            Router router = new Router();
            for (String mappingUrl : mappings.keys()) {
                JsonValue mapping = mappings.get(mappingUrl);
                CollectionResourceProvider provider = Rest2LDAP.builder().ldapConnectionFactory(ldapConnectionFactory).authorizationPolicy(authzPolicy).proxyAuthzIdTemplate(proxyAuthzTemplate).configureMapping(mapping).build();
                router.addRoute(Router.uriTemplate((String)mappingUrl), provider);
            }
            return router;
        }

        private static ConnectionFactory createLdapConnectionFactory(JsonValue configuration) {
            String ldapFactoryName = configuration.get("servlet").get("ldapConnectionFactory").asString();
            if (ldapFactoryName != null) {
                return Rest2LDAP.configureConnectionFactory(configuration.get("ldapConnectionFactories").required(), ldapFactoryName);
            }
            return null;
        }

        @Override
        public void close() {
            Utils.closeSilently((Closeable[])new Closeable[]{this.ldapConnectionFactory});
        }

        public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
            return this.delegate.handle(context, request);
        }
    }
}

