/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.PatchOperation;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.rest2ldap.AttributeMapper;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.RequestState;
import org.forgerock.opendj.rest2ldap.Rest2LDAP;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.util.Function;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class ObjectAttributeMapper
extends AttributeMapper {
    private final Map<String, Mapping> mappings = new LinkedHashMap<String, Mapping>();

    ObjectAttributeMapper() {
    }

    public ObjectAttributeMapper attribute(String name, AttributeMapper mapper) {
        this.mappings.put(Utils.toLowerCase(name), new Mapping(name, mapper));
        return this;
    }

    public String toString() {
        return "object(" + this.mappings.values() + ")";
    }

    @Override
    Promise<List<Attribute>, ResourceException> create(RequestState requestState, JsonPointer path, JsonValue v) {
        try {
            Map<String, Mapping> missingMappings = this.checkMapping(path, v);
            ArrayList<Promise<List<Attribute>, ResourceException>> promises = new ArrayList<Promise<List<Attribute>, ResourceException>>();
            if (v != null && !v.isNull()) {
                for (Map.Entry entry : v.asMap().entrySet()) {
                    Mapping mapping = this.getMapping((String)entry.getKey());
                    JsonValue subValue = new JsonValue(entry.getValue());
                    promises.add(mapping.mapper.create(requestState, path.child((String)entry.getKey()), subValue));
                }
            }
            for (Mapping mapping : missingMappings.values()) {
                promises.add(mapping.mapper.create(requestState, path.child(mapping.name), null));
            }
            return Promises.when(promises).then(this.accumulateResults());
        }
        catch (Exception e) {
            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(e)));
        }
    }

    @Override
    void getLDAPAttributes(RequestState requestState, JsonPointer path, JsonPointer subPath, Set<String> ldapAttributes) {
        if (subPath.isEmpty()) {
            for (Mapping mapping : this.mappings.values()) {
                mapping.mapper.getLDAPAttributes(requestState, path.child(mapping.name), subPath, ldapAttributes);
            }
        } else {
            Mapping mapping = this.getMapping(subPath);
            if (mapping != null) {
                mapping.mapper.getLDAPAttributes(requestState, path.child(subPath.get(0)), subPath.relativePointer(), ldapAttributes);
            }
        }
    }

    @Override
    Promise<Filter, ResourceException> getLDAPFilter(RequestState requestState, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        Mapping mapping = this.getMapping(subPath);
        if (mapping != null) {
            return mapping.mapper.getLDAPFilter(requestState, path.child(subPath.get(0)), subPath.relativePointer(), type, operator, valueAssertion);
        }
        return Promises.newResultPromise((Object)Filter.alwaysFalse());
    }

    @Override
    Promise<List<Modification>, ResourceException> patch(RequestState requestState, JsonPointer path, PatchOperation operation) {
        try {
            JsonPointer field = operation.getField();
            JsonValue v = operation.getValue();
            if (field.isEmpty()) {
                this.checkMapping(path, v);
                ArrayList<Promise<List<Modification>, ResourceException>> promises = new ArrayList<Promise<List<Modification>, ResourceException>>();
                if (!v.isNull()) {
                    for (Map.Entry me : v.asMap().entrySet()) {
                        Mapping mapping = this.getMapping((String)me.getKey());
                        JsonValue subValue = new JsonValue(me.getValue());
                        PatchOperation subOperation = PatchOperation.operation((String)operation.getOperation(), (JsonPointer)field, (Object)subValue);
                        promises.add(mapping.mapper.patch(requestState, path.child((String)me.getKey()), subOperation));
                    }
                }
                return Promises.when(promises).then(this.accumulateResults());
            }
            String fieldName = field.get(0);
            Mapping mapping = this.getMapping(fieldName);
            if (mapping == null) {
                throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an unrecognized field '%s'", path.child(fieldName)));
            }
            PatchOperation subOperation = PatchOperation.operation((String)operation.getOperation(), (JsonPointer)field.relativePointer(), (Object)v);
            return mapping.mapper.patch(requestState, path.child(fieldName), subOperation);
        }
        catch (Exception ex) {
            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(ex)));
        }
    }

    @Override
    Promise<JsonValue, ResourceException> read(RequestState requestState, JsonPointer path, Entry e) {
        ArrayList<Promise> promises = new ArrayList<Promise>(this.mappings.size());
        for (final Mapping mapping : this.mappings.values()) {
            promises.add(mapping.mapper.read(requestState, path.child(mapping.name), e).then((Function)new Function<JsonValue, Map.Entry<String, JsonValue>, ResourceException>(){

                public Map.Entry<String, JsonValue> apply(JsonValue value) {
                    return value != null ? new AbstractMap.SimpleImmutableEntry<String, JsonValue>(mapping.name, value) : null;
                }
            }));
        }
        return Promises.when(promises).then((Function)new Function<List<Map.Entry<String, JsonValue>>, JsonValue, ResourceException>(){

            public JsonValue apply(List<Map.Entry<String, JsonValue>> value) {
                if (value.isEmpty()) {
                    return null;
                }
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(value.size());
                for (Map.Entry<String, JsonValue> e : value) {
                    if (e == null) continue;
                    result.put(e.getKey(), e.getValue().getObject());
                }
                return new JsonValue(result);
            }
        });
    }

    @Override
    Promise<List<Modification>, ResourceException> update(RequestState requestState, JsonPointer path, Entry e, JsonValue v) {
        try {
            Map<String, Mapping> missingMappings = this.checkMapping(path, v);
            ArrayList<Promise<List<Modification>, ResourceException>> promises = new ArrayList<Promise<List<Modification>, ResourceException>>();
            if (v != null && !v.isNull()) {
                for (Map.Entry entry : v.asMap().entrySet()) {
                    Mapping mapping = this.getMapping((String)entry.getKey());
                    JsonValue subValue = new JsonValue(entry.getValue());
                    promises.add(mapping.mapper.update(requestState, path.child((String)entry.getKey()), e, subValue));
                }
            }
            for (Mapping mapping : missingMappings.values()) {
                promises.add(mapping.mapper.update(requestState, path.child(mapping.name), e, null));
            }
            return Promises.when(promises).then(this.accumulateResults());
        }
        catch (Exception ex) {
            return Promises.newExceptionPromise((Exception)((Object)Rest2LDAP.asResourceException(ex)));
        }
    }

    private <T> Function<List<List<T>>, List<T>, ResourceException> accumulateResults() {
        return new Function<List<List<T>>, List<T>, ResourceException>(){

            public List<T> apply(List<List<T>> value) {
                switch (value.size()) {
                    case 0: {
                        return Collections.emptyList();
                    }
                    case 1: {
                        return value.get(0);
                    }
                }
                ArrayList attributes = new ArrayList(value.size());
                for (List a : value) {
                    attributes.addAll(a);
                }
                return attributes;
            }
        };
    }

    private Map<String, Mapping> checkMapping(JsonPointer path, JsonValue v) throws ResourceException {
        LinkedHashMap<String, Mapping> missingMappings = new LinkedHashMap<String, Mapping>(this.mappings);
        if (v != null && !v.isNull()) {
            if (v.isMap()) {
                for (String attribute : v.asMap().keySet()) {
                    if (missingMappings.remove(Utils.toLowerCase(attribute)) != null) continue;
                    throw new BadRequestException(Utils.i18n("The request cannot be processed because it included an unrecognized field '%s'", path.child(attribute)));
                }
            } else {
                throw new BadRequestException(Utils.i18n("The request cannot be processed because it included the field '%s' whose value is the wrong type: an object is expected", path));
            }
        }
        return missingMappings;
    }

    private Mapping getMapping(JsonPointer jsonAttribute) {
        return jsonAttribute.isEmpty() ? null : this.getMapping(jsonAttribute.get(0));
    }

    private Mapping getMapping(String jsonAttribute) {
        return this.mappings.get(Utils.toLowerCase(jsonAttribute));
    }

    private static final class Mapping {
        private final AttributeMapper mapper;
        private final String name;

        private Mapping(String name, AttributeMapper mapper) {
            this.name = name;
            this.mapper = mapper;
        }

        public String toString() {
            return this.name + " -> " + this.mapper;
        }
    }
}

