/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.io.Closeable;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;

public class CloseSilentlyFunction<VIN extends Closeable, VOUT, E extends Exception>
implements Function<VIN, VOUT, E> {
    private final Function<VIN, VOUT, E> delegate;

    public CloseSilentlyFunction(Function<VIN, VOUT, E> delegate) {
        this.delegate = Reject.checkNotNull(delegate);
    }

    @Override
    public VOUT apply(VIN value) throws E {
        VOUT VOUT;
        try {
            VOUT = this.delegate.apply(value);
        }
        catch (Throwable throwable) {
            Utils.closeSilently(new Closeable[]{value});
            throw throwable;
        }
        Utils.closeSilently(new Closeable[]{value});
        return VOUT;
    }

    public static <IN extends Closeable, OUT, EX extends Exception> Function<IN, OUT, EX> closeSilently(Function<IN, OUT, EX> delegate) {
        return new CloseSilentlyFunction<IN, OUT, EX>(delegate);
    }
}

