/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openidm.accountchange;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.File;
import java.io.IOException;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class PersistedQueue {
    private final Environment dbEnv;
    private final Database queueDatabase;
    private final int cacheSize;
    private final String queueName;
    private int opsCounter;

    public PersistedQueue(File queueEnvPath, String queueName, int cacheSize) {
        queueEnvPath.mkdirs();
        EnvironmentConfig dbEnvConfig = new EnvironmentConfig();
        dbEnvConfig.setTransactional(false);
        dbEnvConfig.setAllowCreate(true);
        this.dbEnv = new Environment(queueEnvPath, dbEnvConfig);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(true);
        dbConfig.setDeferredWrite(true);
        this.queueDatabase = this.dbEnv.openDatabase(null, queueName, dbConfig);
        this.queueName = queueName;
        this.cacheSize = cacheSize;
        this.opsCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] poll() throws IOException {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        try (Cursor cursor = this.queueDatabase.openCursor(null, null);){
            cursor.getFirst(key, data, LockMode.RMW);
            if (data.getData() == null) {
                String[] stringArray = null;
                return stringArray;
            }
            String res = new String(data.getData(), "UTF-8");
            String dn = new String(key.getData(), "UTF-8");
            cursor.delete();
            ++this.opsCounter;
            if (this.opsCounter >= this.cacheSize) {
                this.queueDatabase.sync();
                this.opsCounter = 0;
            }
            String[] stringArray = new String[]{dn, res};
            return stringArray;
        }
    }

    public synchronized void push(String dn, String element) throws IOException {
        try (Cursor cursor = this.queueDatabase.openCursor(null, null);){
            DatabaseEntry foundChange = new DatabaseEntry();
            DatabaseEntry key = new DatabaseEntry(dn.getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry(element.getBytes("UTF-8"));
            OperationStatus retVal = cursor.getSearchKey(key, foundChange, LockMode.DEFAULT);
            if (OperationStatus.SUCCESS.equals((Object)retVal)) {
                cursor.putCurrent(data);
                ++this.opsCounter;
            } else if (OperationStatus.NOTFOUND.equals((Object)retVal)) {
                this.queueDatabase.put(null, key, data);
                ++this.opsCounter;
            }
            if (this.opsCounter >= this.cacheSize) {
                this.queueDatabase.sync();
                this.opsCounter = 0;
            }
        }
    }

    public long size() {
        return this.queueDatabase.count();
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void close() {
        this.queueDatabase.sync();
        this.queueDatabase.close();
        this.dbEnv.close();
    }
}

