/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto.simple;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.forgerock.util.Reject;

final class HKDFKeyGenerator {
    private static final String MASTER_KEY_ALGORITHM = "HKDF";
    static final String HMAC_ALGORITHM = "HmacSHA256";
    static final int HASH_LEN = 32;
    private static final ThreadLocal<SecureRandom> THREAD_LOCAL_SECURE_RANDOM = new ThreadLocal<SecureRandom>(){

        @Override
        protected SecureRandom initialValue() {
            return new SecureRandom();
        }
    };

    static HKDFMasterKey extractMasterKey(byte[] inputKeyMaterial) {
        byte[] salt = new byte[16];
        THREAD_LOCAL_SECURE_RANDOM.get().nextBytes(salt);
        return HKDFKeyGenerator.extractMasterKey(inputKeyMaterial, salt);
    }

    static HKDFMasterKey extractMasterKey(byte[] inputKeyMaterial, byte[] salt) {
        Reject.ifNull((Object)inputKeyMaterial);
        Reject.ifFalse(inputKeyMaterial.length >= 16, "Input key should be at least 128 bits");
        if (salt == null || salt.length == 0) {
            salt = new byte[32];
        }
        return new HKDFMasterKey(HKDFKeyGenerator.getHmac(new SecretKeySpec(salt, HMAC_ALGORITHM)).doFinal(inputKeyMaterial), salt);
    }

    static Key expandKey(HKDFMasterKey masterKey, String outputKeyAlgorithm, String purpose, int outputKeySize) {
        return HKDFKeyGenerator.expandKey(masterKey, outputKeyAlgorithm, purpose.getBytes(StandardCharsets.UTF_8), outputKeySize);
    }

    static Key expandKey(HKDFMasterKey masterKey, String outputKeyAlgorithm, byte[] info, int outputKeySize) {
        Reject.ifFalse(outputKeySize <= 8160, "Cannot derive more than 8160 bytes of key material");
        byte[] output = new byte[outputKeySize];
        Mac hmac = HKDFKeyGenerator.getHmac(masterKey);
        int block = 1;
        for (int i = 0; i < outputKeySize; i += 32) {
            if (i > 0) {
                hmac.update(output, i - 32, 32);
            }
            hmac.update(info);
            hmac.update((byte)block++);
            System.arraycopy(hmac.doFinal(), 0, output, i, Math.min(32, outputKeySize - i));
            hmac.reset();
        }
        return new SecretKeySpec(output, outputKeyAlgorithm);
    }

    static Key expandKey(HKDFMasterKey masterKey, String outputKeyAlgorithm, int outputKeySize) {
        return HKDFKeyGenerator.expandKey(masterKey, outputKeyAlgorithm, outputKeyAlgorithm, outputKeySize);
    }

    private static Mac getHmac(Key key) {
        try {
            Mac hmac = Mac.getInstance(HMAC_ALGORITHM);
            hmac.init(key);
            return hmac;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid HKDF key", e);
        }
    }

    private HKDFKeyGenerator() {
    }

    static class HKDFMasterKey
    extends SecretKeySpec {
        private static final long serialVersionUID = 1L;
        private final byte[] salt;

        HKDFMasterKey(byte[] keyBytes, byte[] salt) {
            super(keyBytes, HKDFKeyGenerator.MASTER_KEY_ALGORITHM);
            this.salt = salt;
        }

        byte[] getSalt() {
            return this.salt;
        }
    }
}

