/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.crypto.simple;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.forgerock.json.JsonValue;
import org.forgerock.json.crypto.JsonCryptoException;
import org.forgerock.json.crypto.JsonEncryptor;
import org.forgerock.json.crypto.simple.HKDFKeyGenerator;
import org.forgerock.util.encode.Base64;

public class SimpleEncryptor
implements JsonEncryptor {
    public static final String TYPE = "x-simple-encryption";
    static final String MAC_ALGORITHM = "HmacSHA256";
    static final int MAC_KEY_SIZE = 32;
    static final int ASYMMETRIC_AES_KEY_SIZE = 16;
    private final ObjectMapper mapper = new ObjectMapper();
    private String cipher;
    private Key key;
    private String alias;

    public SimpleEncryptor(String cipher, Key key, String alias) {
        this.cipher = cipher;
        this.key = key;
        this.alias = alias;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private Object symmetric(Object object) throws GeneralSecurityException, IOException {
        Cipher symmetric = Cipher.getInstance(this.cipher);
        HKDFKeyGenerator.HKDFMasterKey masterKey = HKDFKeyGenerator.extractMasterKey(this.key.getEncoded());
        Key encryptionKey = HKDFKeyGenerator.expandKey(masterKey, "AES", this.key.getEncoded().length);
        Key macKey = HKDFKeyGenerator.expandKey(masterKey, MAC_ALGORITHM, 32);
        symmetric.init(1, encryptionKey);
        String data = Base64.encode(symmetric.doFinal(this.mapper.writeValueAsBytes(object)));
        byte[] iv = symmetric.getIV();
        byte[] salt = masterKey.getSalt();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cipher", this.cipher);
        result.put("key", this.alias);
        result.put("data", data);
        if (iv != null) {
            result.put("iv", Base64.encode(iv));
        }
        if (salt != null) {
            result.put("salt", Base64.encode(salt));
        }
        result.put("mac", Base64.encode(SimpleEncryptor.mac(result, macKey)));
        return result;
    }

    private Object asymmetric(Object object) throws GeneralSecurityException, IOException {
        String symmetricCipher = "AES/CBC/PKCS5Padding";
        KeyGenerator generator = KeyGenerator.getInstance(MAC_ALGORITHM);
        generator.init(256);
        SecretKey sessionKey = generator.generateKey();
        HKDFKeyGenerator.HKDFMasterKey masterKey = HKDFKeyGenerator.extractMasterKey(sessionKey.getEncoded());
        byte[] salt = masterKey.getSalt();
        Key encryptionKey = HKDFKeyGenerator.expandKey(masterKey, "AES", 16);
        Key macKey = HKDFKeyGenerator.expandKey(masterKey, MAC_ALGORITHM, 32);
        Cipher symmetric = Cipher.getInstance(symmetricCipher);
        symmetric.init(1, encryptionKey);
        byte[] iv = symmetric.getIV();
        String data = Base64.encode(symmetric.doFinal(this.mapper.writeValueAsBytes(object)));
        Cipher asymmetric = Cipher.getInstance(this.cipher);
        asymmetric.init(1, this.key);
        HashMap<String, String> keyObject = new HashMap<String, String>();
        keyObject.put("cipher", this.cipher);
        keyObject.put("key", this.alias);
        keyObject.put("data", Base64.encode(asymmetric.doFinal(sessionKey.getEncoded())));
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("cipher", symmetricCipher);
        result.put("key", keyObject);
        result.put("data", data);
        if (iv != null) {
            result.put("iv", Base64.encode(iv));
        }
        if (salt != null) {
            result.put("salt", Base64.encode(salt));
        }
        result.put("mac", Base64.encode(SimpleEncryptor.mac(result, macKey)));
        return result;
    }

    @Override
    public JsonValue encrypt(JsonValue value) throws JsonCryptoException {
        Object object = value.getObject();
        try {
            return new JsonValue(this.key instanceof SecretKey ? this.symmetric(object) : this.asymmetric(object));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new JsonCryptoException(e);
        }
    }

    static byte[] mac(Map<String, Object> input, Key macKey) {
        try {
            Mac mac = Mac.getInstance(MAC_ALGORITHM);
            mac.init(macKey);
            SimpleEncryptor.updateMac(mac, input);
            return Arrays.copyOfRange(mac.doFinal(), 0, 16);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void updateMac(Mac mac, Map<String, Object> objectMap) {
        for (Map.Entry<String, Object> entry : new TreeMap<String, Object>(objectMap).entrySet()) {
            mac.update(entry.getKey().getBytes(StandardCharsets.UTF_8));
            if (entry.getValue() instanceof Map) {
                SimpleEncryptor.updateMac(mac, (Map)entry.getValue());
                continue;
            }
            mac.update(entry.getValue().toString().getBytes(StandardCharsets.UTF_8));
        }
    }
}

