/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="concat", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public final class ConcatSchemaMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true, defaultValue="${basedir}/resource/schema")
    private String schemaDirectory;
    @Parameter(required=true)
    private String outputDirectory;
    @Parameter(required=true)
    private String outputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String projectBuildDir = this.project.getBuild().getDirectory();
        String outputFilePath = this.outputDirectory + System.getProperty("file.separator") + this.outputFile;
        if (!this.outputDirectory.contains(projectBuildDir)) {
            String errorMsg = String.format("outputDirectory parameter (%s) must be included in ${project.build.directory} (%s)", this.outputDirectory, projectBuildDir);
            this.getLog().error((CharSequence)errorMsg);
            throw new MojoExecutionException(errorMsg);
        }
        this.getLog().info((CharSequence)String.format("Concatenating all ldif files from directory: %s", this.schemaDirectory));
        this.getLog().info((CharSequence)String.format("Concatenated file: %s", outputFilePath));
        new File(outputFilePath).getParentFile().mkdirs();
        TreeSet<String> schemaFileNames = new TreeSet<String>();
        for (File f : new File(this.schemaDirectory).listFiles()) {
            if (!f.isFile()) continue;
            schemaFileNames.add(f.getName());
        }
        LinkedList<String> attributeTypes = new LinkedList<String>();
        LinkedList<String> objectClasses = new LinkedList<String>();
        LinkedList<String> nameForms = new LinkedList<String>();
        LinkedList<String> ditContentRules = new LinkedList<String>();
        LinkedList<String> ditStructureRules = new LinkedList<String>();
        LinkedList<String> matchingRuleUses = new LinkedList<String>();
        LinkedList<String> ldapSyntaxes = new LinkedList<String>();
        int curLineNumber = 0;
        for (String name : schemaFileNames) {
            LinkedList<StringBuilder> lines = new LinkedList<StringBuilder>();
            try {
                BufferedReader reader = new BufferedReader(new FileReader(new File(this.schemaDirectory, name)));
                String line = reader.readLine();
                while (line != null) {
                    ++curLineNumber;
                    if (line.length() > 0 && !line.startsWith("#")) {
                        if (line.startsWith(" ")) {
                            ((StringBuilder)lines.getLast()).append(line.substring(1));
                        } else {
                            lines.add(new StringBuilder(line));
                        }
                    }
                    line = reader.readLine();
                }
                reader.close();
            }
            catch (Exception e) {
                this.getLog().error((CharSequence)String.format("Error while reading schema file %s at line %d: %s", name, curLineNumber, e.getMessage()));
                throw new MojoExecutionException(e.getMessage(), e);
            }
            for (StringBuilder buffer : lines) {
                String line = buffer.toString().trim();
                if (line.endsWith(" )")) {
                    line = line.substring(0, line.length() - 1) + "X-SCHEMA-FILE '" + name + "' )";
                } else {
                    if (!line.endsWith(")")) continue;
                    line = line.substring(0, line.length() - 1) + " X-SCHEMA-FILE '" + name + "' )";
                }
                String lowerLine = line.toLowerCase();
                if (lowerLine.startsWith("attributetypes:")) {
                    attributeTypes.add(line);
                    continue;
                }
                if (lowerLine.startsWith("objectclasses:")) {
                    objectClasses.add(line);
                    continue;
                }
                if (lowerLine.startsWith("nameforms:")) {
                    nameForms.add(line);
                    continue;
                }
                if (lowerLine.startsWith("ditcontentrules:")) {
                    ditContentRules.add(line);
                    continue;
                }
                if (lowerLine.startsWith("ditstructurerules:")) {
                    ditStructureRules.add(line);
                    continue;
                }
                if (lowerLine.startsWith("matchingruleuse:")) {
                    matchingRuleUses.add(line);
                    continue;
                }
                if (!lowerLine.startsWith("ldapsyntaxes:")) continue;
                ldapSyntaxes.add(line);
            }
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(outputFilePath));
            writer.write("dn: cn=schema");
            writer.newLine();
            writer.write("objectClass: top");
            writer.newLine();
            writer.write("objectClass: ldapSubentry");
            writer.newLine();
            writer.write("objectClass: subschema");
            writer.newLine();
            this.writeSchemaElements(ldapSyntaxes, writer);
            this.writeSchemaElements(attributeTypes, writer);
            this.writeSchemaElements(objectClasses, writer);
            this.writeSchemaElements(nameForms, writer);
            this.writeSchemaElements(ditContentRules, writer);
            this.writeSchemaElements(ditStructureRules, writer);
            this.writeSchemaElements(matchingRuleUses, writer);
            writer.close();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)String.format("Error while writing concatenated schema file %s:  %s", this.outputFile, e.getMessage()));
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void writeSchemaElements(List<String> schemaElements, BufferedWriter writer) throws IOException {
        for (String line : schemaElements) {
            writer.write(line);
            writer.newLine();
        }
    }
}

