/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-manifest", defaultPhase=LifecyclePhase.VALIDATE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class GenerateManifestClassPathMojo
extends AbstractMojo {
    private static final int MAX_LINE_LENGTH = 72;
    private static final String HEADER_CLASSPATH = "Class-Path:";
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(required=true)
    private String classPathProperty;
    @Parameter
    private List<String> excludes;
    @Parameter
    private List<String> includes;
    @Parameter
    private List<String> additionalJars;
    @Parameter
    private String productJarName;
    @Parameter
    private String supportedLocales;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            String classPath = this.getClasspath();
            this.getLog().info((CharSequence)String.format("Setting the classpath property: [%s] (debug to see actual value)", this.classPathProperty));
            this.getLog().debug((CharSequence)String.format("Setting the classpath property %s to:\n%s", this.classPathProperty, classPath));
            this.project.getProperties().put(this.classPathProperty, classPath);
        }
        catch (DependencyResolutionRequiredException e) {
            this.getLog().error((CharSequence)String.format("Unable to set the classpath property %s, an error occured", this.classPathProperty));
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }

    private String getClasspath() throws DependencyResolutionRequiredException {
        List<String> classpathItems = this.getClasspathItems();
        StringBuilder classpath = new StringBuilder(HEADER_CLASSPATH);
        for (String item : classpathItems) {
            classpath.append(" ").append(item);
        }
        for (int index = 70; index <= classpath.length(); index += 71) {
            classpath.insert(index, "\n ");
        }
        return classpath.toString();
    }

    private List<String> getClasspathItems() throws DependencyResolutionRequiredException {
        ArrayList<String> classpathItems = new ArrayList<String>();
        for (String artifactFile : this.project.getRuntimeClasspathElements()) {
            Artifact artifact;
            File file = new File(artifactFile);
            if (!file.getAbsoluteFile().isFile() || !this.isAccepted(artifact = this.findArtifactWithFile(this.project.getArtifacts(), file))) continue;
            String artifactString = artifact.getArtifactId() + "." + artifact.getType();
            classpathItems.add(artifactString);
        }
        Collections.sort(classpathItems);
        if (this.productJarName != null) {
            if (this.supportedLocales != null) {
                String[] locales = this.supportedLocales.split(",");
                for (int i = locales.length - 1; i >= 0; --i) {
                    classpathItems.add(0, this.productJarName + "_" + locales[i] + ".jar");
                }
            }
            classpathItems.add(0, this.productJarName + ".jar");
        }
        if (this.additionalJars != null) {
            classpathItems.addAll(this.additionalJars);
        }
        return classpathItems;
    }

    private boolean isAccepted(Artifact artifact) {
        String artifactString = artifact.getGroupId() + ":" + artifact.getArtifactId();
        if (this.includes != null) {
            if (this.containsIgnoreCase(this.includes, artifactString)) {
                return true;
            }
            if (!this.includes.isEmpty()) {
                return false;
            }
        }
        return !this.containsIgnoreCase(this.excludes, artifactString);
    }

    private boolean containsIgnoreCase(List<String> strings, String toFind) {
        if (strings == null) {
            return false;
        }
        for (String s : strings) {
            if (!toFind.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    private Artifact findArtifactWithFile(Set<Artifact> artifacts, File file) {
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null || !artifact.getFile().equals(file)) continue;
            return artifact;
        }
        return null;
    }
}

