/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.maven;

import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-config", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class GenerateConfigMojo
extends AbstractMojo {
    private static final String CONFIGURATION_FILE_SUFFIX = "Configuration.xml";
    @Parameter(required=true, readonly=true, property="project")
    private MavenProject project;
    @Parameter(required=true)
    private String packageName;
    @Parameter(required=true, defaultValue="false")
    private Boolean isExtension;
    private final Map<String, StreamSourceFactory> componentDescriptors = new LinkedHashMap<String, StreamSourceFactory>();
    private TransformerFactory stylesheetFactory;
    private Templates stylesheetMetaJava;
    private Templates stylesheetServerJava;
    private Templates stylesheetClientJava;
    private Templates stylesheetMetaPackageInfo;
    private Templates stylesheetServerPackageInfo;
    private Templates stylesheetClientPackageInfo;
    private Templates stylesheetProfileLDAP;
    private Templates stylesheetProfileCLI;
    private Templates stylesheetMessages;
    private Templates stylesheetManifest;
    private final Queue<Future<?>> tasks = new LinkedList();
    private final URIResolver resolver = new URIResolver(){

        @Override
        public synchronized Source resolve(String href, String base) throws TransformerException {
            if (href.endsWith(".xsl")) {
                String stylesheet = href.startsWith("../") ? "/config/stylesheets/" + href.substring(3) : "/config/stylesheets/" + href;
                GenerateConfigMojo.this.getLog().debug((CharSequence)("#### Resolved stylesheet " + href + " to " + stylesheet));
                return new StreamSource(this.getClass().getResourceAsStream(stylesheet));
            }
            if (href.endsWith(".xml")) {
                if (href.startsWith("org/forgerock/opendj/server/config/")) {
                    String coreXML = "/config/xml/" + href;
                    GenerateConfigMojo.this.getLog().debug((CharSequence)("#### Resolved core XML definition " + href + " to " + coreXML));
                    return new StreamSource(this.getClass().getResourceAsStream(coreXML));
                }
                String extXML = GenerateConfigMojo.this.getXMLDirectory() + "/" + href;
                GenerateConfigMojo.this.getLog().debug((CharSequence)("#### Resolved extension XML definition " + href + " to " + extXML));
                return new StreamSource(new File(extXML));
            }
            throw new TransformerException("Unable to resolve URI " + href);
        }
    };

    public void execute() throws MojoExecutionException {
        if (this.getPackagePath() == null) {
            throw new MojoExecutionException("<packagePath> must be set.");
        }
        if (!this.isXMLPackageDirectoryValid()) {
            throw new MojoExecutionException("The XML definition directory \"" + this.getXMLPackageDirectory() + "\" does not exist.");
        }
        if (((Object)((Object)this)).getClass().getResource(this.getStylesheetDirectory()) == null) {
            throw new MojoExecutionException("The XSLT stylesheet directory \"" + this.getStylesheetDirectory() + "\" does not exist.");
        }
        try {
            this.initializeStylesheets();
            this.getLog().info((CharSequence)"Loading XML descriptors...");
            this.loadXMLDescriptors();
            this.getLog().info((CharSequence)("Found " + this.componentDescriptors.size() + " XML descriptors"));
            this.executeValidateXMLDefinitions();
            this.executeTransformXMLDefinitions();
            this.getLog().info((CharSequence)("Adding source directory \"" + this.getGeneratedSourcesDirectory() + "\" to build path..."));
            this.project.addCompileSourceRoot(this.getGeneratedSourcesDirectory());
            this.project.addResource(this.getGeneratedMavenResources());
        }
        catch (Exception e) {
            throw new MojoExecutionException("XSLT configuration transformation failed", e);
        }
    }

    private Resource getGeneratedMavenResources() {
        String[] generatedResourcesRelativePath = new String[]{"/META-INF/services/**", "/config/**/*.properties"};
        Resource resources = new Resource();
        resources.setDirectory(this.getGeneratedResourcesDirectory());
        for (String generatedResourceRelativePath : generatedResourcesRelativePath) {
            resources.addInclude(generatedResourceRelativePath);
            this.getLog().info((CharSequence)("Adding resource \"" + this.getGeneratedResourcesDirectory() + generatedResourceRelativePath + " to resource path..."));
        }
        return resources;
    }

    private void createTransformTask(final StreamSourceFactory inputFactory, final StreamResult output, final Templates stylesheet, ExecutorService executor, final String ... parameters) throws Exception {
        Future<Void> future = executor.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Transformer transformer = stylesheet.newTransformer();
                transformer.setURIResolver(GenerateConfigMojo.this.resolver);
                for (int i = 0; i < parameters.length; i += 2) {
                    transformer.setParameter(parameters[i], parameters[i + 1]);
                }
                transformer.transform(inputFactory.newStreamSource(), output);
                return null;
            }
        });
        this.tasks.add(future);
    }

    private void createTransformTask(StreamSourceFactory inputFactory, String outputFileName, Templates stylesheet, ExecutorService executor, String ... parameters) throws Exception {
        File outputFile = new File(outputFileName);
        outputFile.getParentFile().mkdirs();
        StreamResult output = new StreamResult(outputFile);
        this.createTransformTask(inputFactory, output, stylesheet, executor, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTransformXMLDefinitions() throws Exception {
        this.getLog().info((CharSequence)"Transforming XML definitions...");
        ExecutorService parallelExecutor = Executors.newFixedThreadPool(16);
        ExecutorService sequentialExecutor = Executors.newSingleThreadExecutor();
        File manifestFile = new File(this.getGeneratedManifestFile());
        manifestFile.getParentFile().mkdirs();
        FileOutputStream manifestFileOutputStream = new FileOutputStream(manifestFile);
        StreamResult manifest = new StreamResult(manifestFileOutputStream);
        try {
            String javaDir = this.getGeneratedSourcesDirectory() + "/" + this.getPackagePath() + "/";
            String metaDir = javaDir + "meta/";
            String serverDir = javaDir + "server/";
            String clientDir = javaDir + "client/";
            String ldapProfileDir = this.getGeneratedProfilesDirectory("ldap") + "/" + this.getPackagePath() + "/meta/";
            String cliProfileDir = this.getGeneratedProfilesDirectory("cli") + "/" + this.getPackagePath() + "/meta/";
            String i18nDir = this.getGeneratedMessagesDirectory() + "/" + this.getPackagePath() + "/meta/";
            for (Map.Entry<String, StreamSourceFactory> entry : this.componentDescriptors.entrySet()) {
                String meta = metaDir + entry.getKey() + "CfgDefn.java";
                this.createTransformTask(entry.getValue(), meta, this.stylesheetMetaJava, parallelExecutor, new String[0]);
                String server = serverDir + entry.getKey() + "Cfg.java";
                this.createTransformTask(entry.getValue(), server, this.stylesheetServerJava, parallelExecutor, new String[0]);
                String client = clientDir + entry.getKey() + "CfgClient.java";
                this.createTransformTask(entry.getValue(), client, this.stylesheetClientJava, parallelExecutor, new String[0]);
                String ldap = ldapProfileDir + entry.getKey() + "CfgDefn.properties";
                this.createTransformTask(entry.getValue(), ldap, this.stylesheetProfileLDAP, parallelExecutor, new String[0]);
                String cli = cliProfileDir + entry.getKey() + "CfgDefn.properties";
                this.createTransformTask(entry.getValue(), cli, this.stylesheetProfileCLI, parallelExecutor, new String[0]);
                String i18n = i18nDir + entry.getKey() + "CfgDefn.properties";
                this.createTransformTask(entry.getValue(), i18n, this.stylesheetMessages, parallelExecutor, new String[0]);
                this.createTransformTask(entry.getValue(), manifest, this.stylesheetManifest, sequentialExecutor, new String[0]);
            }
            LinkedHashMap<String, Templates> profileMap = new LinkedHashMap<String, Templates>();
            profileMap.put("meta", this.stylesheetMetaPackageInfo);
            profileMap.put("server", this.stylesheetServerPackageInfo);
            profileMap.put("client", this.stylesheetClientPackageInfo);
            for (Map.Entry entry : profileMap.entrySet()) {
                StreamSourceFactory sourceFactory = new StreamSourceFactory(){

                    @Override
                    public StreamSource newStreamSource() throws IOException {
                        if (GenerateConfigMojo.this.isExtension.booleanValue()) {
                            return new StreamSource(new File(GenerateConfigMojo.this.getXMLPackageDirectory() + "/Package.xml"));
                        }
                        return new StreamSource(this.getClass().getResourceAsStream("/" + GenerateConfigMojo.this.getXMLPackageDirectory() + "/Package.xml"));
                    }
                };
                String profile = javaDir + "/" + (String)entry.getKey() + "/package-info.java";
                this.createTransformTask(sourceFactory, profile, (Templates)entry.getValue(), parallelExecutor, "type", (String)entry.getKey());
            }
            Future<?> task = this.tasks.poll();
            while (task != null) {
                task.get();
                task = this.tasks.poll();
            }
        }
        finally {
            parallelExecutor.shutdown();
            sequentialExecutor.shutdown();
            manifestFileOutputStream.close();
        }
    }

    private void executeValidateXMLDefinitions() {
        this.getLog().info((CharSequence)"Validating XML definitions...");
    }

    private String getBaseDir() {
        return this.project.getBasedir().toString();
    }

    private String getGeneratedResourcesDirectory() {
        return this.project.getBuild().getDirectory() + "/generated-resources";
    }

    private String getGeneratedManifestFile() {
        return this.getGeneratedResourcesDirectory() + "/META-INF/services/org.forgerock.opendj.config.AbstractManagedObjectDefinition";
    }

    private String getGeneratedMessagesDirectory() {
        return this.getGeneratedResourcesDirectory() + "/config/messages";
    }

    private String getGeneratedProfilesDirectory(String profileName) {
        return this.getGeneratedResourcesDirectory() + "/config/profiles/" + profileName;
    }

    private String getGeneratedSourcesDirectory() {
        return this.project.getBuild().getDirectory() + "/generated-sources/config";
    }

    private String getPackagePath() {
        return this.packageName.replace('.', '/');
    }

    private String getStylesheetDirectory() {
        return "/config/stylesheets";
    }

    private String getXMLDirectory() {
        if (this.isExtension.booleanValue()) {
            return this.getBaseDir() + "/src/main/java";
        }
        return "config/xml";
    }

    private String getXMLPackageDirectory() {
        return this.getXMLDirectory() + "/" + this.getPackagePath();
    }

    private void initializeStylesheets() throws TransformerConfigurationException {
        this.getLog().info((CharSequence)"Loading XSLT stylesheets...");
        this.stylesheetFactory = TransformerFactory.newInstance();
        this.stylesheetFactory.setURIResolver(this.resolver);
        this.stylesheetMetaJava = this.loadStylesheet("metaMO.xsl");
        this.stylesheetMetaPackageInfo = this.loadStylesheet("package-info.xsl");
        this.stylesheetServerJava = this.loadStylesheet("serverMO.xsl");
        this.stylesheetServerPackageInfo = this.loadStylesheet("package-info.xsl");
        this.stylesheetClientJava = this.loadStylesheet("clientMO.xsl");
        this.stylesheetClientPackageInfo = this.loadStylesheet("package-info.xsl");
        this.stylesheetProfileLDAP = this.loadStylesheet("ldapMOProfile.xsl");
        this.stylesheetProfileCLI = this.loadStylesheet("cliMOProfile.xsl");
        this.stylesheetMessages = this.loadStylesheet("messagesMO.xsl");
        this.stylesheetManifest = this.loadStylesheet("manifestMO.xsl");
    }

    private boolean isXMLPackageDirectoryValid() {
        return this.isExtension == false || new File(this.getXMLPackageDirectory()).isDirectory();
    }

    private Templates loadStylesheet(String stylesheet) throws TransformerConfigurationException {
        StreamSource xslt = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream(this.getStylesheetDirectory() + "/" + stylesheet));
        return this.stylesheetFactory.newTemplates(xslt);
    }

    private void loadXMLDescriptors() throws IOException, MojoExecutionException {
        String parentPath = this.getXMLPackageDirectory();
        if (this.isExtension.booleanValue()) {
            this.loadXMLDescriptorsFromFolder(parentPath);
            return;
        }
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(parentPath);
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            this.loadXMLDescriptorsFromFolder(parentPath);
        } else if ("jar".equals(protocol)) {
            this.loadXMLDescriptorsFromJar(parentPath, ((JarURLConnection)url.openConnection()).getJarFile());
        } else {
            String errorMsg = "Impossible to read XML descriptors from path '" + parentPath + "'";
            this.getLog().error((CharSequence)errorMsg);
            throw new MojoExecutionException(errorMsg);
        }
    }

    private void loadXMLDescriptorsFromFolder(String parentPath) {
        File folder = new File(parentPath);
        folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(final File path) {
                String name = path.getName();
                if (path.isFile() && name.endsWith(GenerateConfigMojo.CONFIGURATION_FILE_SUFFIX)) {
                    String key = name.substring(0, name.length() - GenerateConfigMojo.CONFIGURATION_FILE_SUFFIX.length());
                    GenerateConfigMojo.this.componentDescriptors.put(key, new StreamSourceFactory(){

                        @Override
                        public StreamSource newStreamSource() {
                            return new StreamSource(path);
                        }
                    });
                }
                return true;
            }
        });
    }

    private void loadXMLDescriptorsFromJar(String parentPath, final JarFile jar) throws IOException {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            final JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (!name.startsWith(parentPath) || !name.endsWith(CONFIGURATION_FILE_SUFFIX)) continue;
            int startPos = name.lastIndexOf(47) + 1;
            int endPos = name.length() - CONFIGURATION_FILE_SUFFIX.length();
            this.componentDescriptors.put(name.substring(startPos, endPos), new StreamSourceFactory(){

                @Override
                public StreamSource newStreamSource() throws IOException {
                    return new StreamSource(jar.getInputStream(entry));
                }
            });
        }
    }

    private static interface StreamSourceFactory {
        public StreamSource newStreamSource() throws IOException;
    }
}

