/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityResponseControl;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.controls.PasswordExpiredResponseControl;
import org.forgerock.opendj.ldap.controls.PasswordExpiringResponseControl;
import org.forgerock.opendj.ldap.controls.PasswordPolicyErrorType;
import org.forgerock.opendj.ldap.controls.PasswordPolicyResponseControl;
import org.forgerock.opendj.ldap.controls.PasswordPolicyWarningType;
import org.forgerock.opendj.ldap.responses.BindResult;

final class Utils {
    static GenericControl getControl(String argString) throws DecodeException {
        String controlOID = null;
        boolean controlCriticality = false;
        ByteString controlValue = null;
        int idx = argString.indexOf(":");
        controlOID = idx < 0 ? argString : argString.substring(0, idx);
        String lowerOID = StaticUtils.toLowerCase((String)controlOID);
        if ("accountusable".equals(lowerOID) || "accountusability".equals(lowerOID)) {
            controlOID = "1.3.6.1.4.1.42.2.27.9.5.8";
        } else if ("authzid".equals(lowerOID) || "authorizationidentity".equals(lowerOID)) {
            controlOID = "2.16.840.1.113730.3.4.16";
        } else if (!("noop".equals(lowerOID) || "no-op".equals(lowerOID) || "subentries".equals(lowerOID) || "managedsait".equals(lowerOID))) {
            if ("pwpolicy".equals(lowerOID) || "passwordpolicy".equals(lowerOID)) {
                controlOID = "1.3.6.1.4.1.42.2.27.8.5.1";
            } else if ("subtreedelete".equals(lowerOID) || "treedelete".equals(lowerOID)) {
                controlOID = "1.2.840.113556.1.4.805";
            } else if (!("realattrsonly".equals(lowerOID) || "realattributesonly".equals(lowerOID) || "virtualattrsonly".equals(lowerOID) || "virtualattributesonly".equals(lowerOID) || !"effectiverights".equals(lowerOID) && !"geteffectiverights".equals(lowerOID))) {
                controlOID = "1.3.6.1.4.1.42.2.27.9.5.2";
            }
        }
        if (idx < 0) {
            return GenericControl.newControl((String)controlOID);
        }
        String remainder = argString.substring(idx + 1, argString.length());
        if ((idx = remainder.indexOf(":")) == -1) {
            if ("true".equalsIgnoreCase(remainder)) {
                controlCriticality = true;
            } else if ("false".equalsIgnoreCase(remainder)) {
                controlCriticality = false;
            } else {
                throw DecodeException.error((LocalizableMessage)LocalizableMessage.raw((CharSequence)("Invalid format for criticality value:" + remainder), (Object[])new Object[0]));
            }
            return GenericControl.newControl((String)controlOID, (boolean)controlCriticality);
        }
        String critical = remainder.substring(0, idx);
        if ("true".equalsIgnoreCase(critical)) {
            controlCriticality = true;
        } else if ("false".equalsIgnoreCase(critical)) {
            controlCriticality = false;
        } else {
            throw DecodeException.error((LocalizableMessage)LocalizableMessage.raw((CharSequence)("Invalid format for criticality value:" + critical), (Object[])new Object[0]));
        }
        String valString = remainder.substring(idx + 1, remainder.length());
        if (valString.charAt(0) == ':') {
            controlValue = ByteString.valueOfBase64((String)valString.substring(1, valString.length()));
        } else if (valString.charAt(0) == '<') {
            String filePath = valString.substring(1, valString.length());
            try {
                byte[] val = com.forgerock.opendj.cli.Utils.readBytesFromFile((String)filePath);
                controlValue = ByteString.wrap((byte[])val);
            }
            catch (Exception e) {
                return null;
            }
        } else {
            controlValue = ByteString.valueOfUtf8((CharSequence)valString);
        }
        return GenericControl.newControl((String)controlOID, (boolean)controlCriticality, (Object)controlValue);
    }

    static int printErrorMessage(ConsoleApplication app, LdapException ere) {
        if (ere.getResult().getResultCode().intValue() >= 0) {
            app.errPrintln(ToolsMessages.ERR_TOOL_RESULT_CODE.get((Object)ere.getResult().getResultCode().intValue(), (Object)ere.getResult().getResultCode().toString()));
        }
        if (ere.getResult().getDiagnosticMessage() != null && ere.getResult().getDiagnosticMessage().length() > 0) {
            app.errPrintln(ToolsMessages.ERR_TOOL_ERROR_MESSAGE.get((Object)ere.getResult().getDiagnosticMessage()));
        }
        if (ere.getResult().getMatchedDN() != null && ere.getResult().getMatchedDN().length() > 0) {
            app.errPrintln(ToolsMessages.ERR_TOOL_MATCHED_DN.get((Object)ere.getResult().getMatchedDN()));
        }
        if (app.isVerbose() && ere.getResult().getCause() != null) {
            ere.getResult().getCause().printStackTrace(app.getErrorStream());
        }
        return ere.getResult().getResultCode().intValue();
    }

    static void printPasswordPolicyResults(ConsoleApplication app, BindResult result) {
        AuthorizationIdentityResponseControl control;
        try {
            control = (AuthorizationIdentityResponseControl)result.getControl(AuthorizationIdentityResponseControl.DECODER, new DecodeOptions());
            if (control != null) {
                app.println(ToolsMessages.INFO_BIND_AUTHZID_RETURNED.get((Object)control.getAuthorizationID()));
            }
        }
        catch (DecodeException e) {
            app.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
        }
        try {
            control = (PasswordExpiredResponseControl)result.getControl(PasswordExpiredResponseControl.DECODER, new DecodeOptions());
            if (control != null) {
                app.println(ToolsMessages.INFO_BIND_PASSWORD_EXPIRED.get());
            }
        }
        catch (DecodeException e) {
            app.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
        }
        try {
            control = (PasswordExpiringResponseControl)result.getControl(PasswordExpiringResponseControl.DECODER, new DecodeOptions());
            if (control != null) {
                LocalizableMessage timeString = com.forgerock.opendj.cli.Utils.secondsToTimeString((int)control.getSecondsUntilExpiration());
                app.println(ToolsMessages.INFO_BIND_PASSWORD_EXPIRING.get((Object)timeString));
            }
        }
        catch (DecodeException e) {
            app.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
        }
        try {
            control = (PasswordPolicyResponseControl)result.getControl(PasswordPolicyResponseControl.DECODER, new DecodeOptions());
            if (control != null) {
                PasswordPolicyErrorType errorType = control.getErrorType();
                if (errorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
                    app.println(ToolsMessages.INFO_BIND_PASSWORD_EXPIRED.get());
                } else if (errorType == PasswordPolicyErrorType.ACCOUNT_LOCKED) {
                    app.println(ToolsMessages.INFO_BIND_ACCOUNT_LOCKED.get());
                } else if (errorType == PasswordPolicyErrorType.CHANGE_AFTER_RESET) {
                    app.println(ToolsMessages.INFO_BIND_MUST_CHANGE_PASSWORD.get());
                }
                PasswordPolicyWarningType warningType = control.getWarningType();
                if (warningType == PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION) {
                    LocalizableMessage timeString = com.forgerock.opendj.cli.Utils.secondsToTimeString((int)control.getWarningValue());
                    app.println(ToolsMessages.INFO_BIND_PASSWORD_EXPIRING.get((Object)timeString));
                } else if (warningType == PasswordPolicyWarningType.GRACE_LOGINS_REMAINING) {
                    app.println(ToolsMessages.INFO_BIND_GRACE_LOGINS_REMAINING.get((Object)control.getWarningValue()));
                }
            }
        }
        catch (DecodeException e) {
            app.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
        }
    }

    static void setDefaultPerfToolProperties() {
        if (System.getProperty("org.forgerock.opendj.transport.useWorkerThreads") == null) {
            System.setProperty("org.forgerock.opendj.transport.useWorkerThreads", "false");
        }
        if (System.getProperty("org.forgerock.opendj.transport.linger") == null) {
            System.setProperty("org.forgerock.opendj.transport.linger", "0");
        }
    }

    private Utils() {
    }
}

