/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.DataSource;
import com.forgerock.opendj.ldap.tools.PerformanceRunner;
import com.forgerock.opendj.ldap.tools.PerformanceRunnerOptions;
import com.forgerock.opendj.ldap.tools.StatsThread;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.OutputStream;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.util.promise.Promise;

public final class ModRate
extends ConsoleApplication {
    private BooleanArgument verbose;
    private BooleanArgument scriptFriendly;

    public static void main(String[] args) {
        int retCode = new ModRate().run(args);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private ModRate() {
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isScriptFriendly() {
        return this.scriptFriendly.isPresent();
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    private int run(String[] args) {
        ConnectionFactory connectionFactory;
        StringArgument baseDN;
        ModifyPerformanceRunner runner;
        ConnectionFactoryProvider connectionFactoryProvider;
        LocalizableMessage toolDescription = ToolsMessages.INFO_MODRATE_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(ModRate.class.getName(), toolDescription, false, true, 1, 0, "[(attribute:value format string) ...]");
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_MODRATE.get());
        argParser.setDocToolDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_RATE_TOOLS.get());
        try {
            Utils.setDefaultPerfToolProperties();
            connectionFactoryProvider = new ConnectionFactoryProvider(argParser, (ConsoleApplication)this);
            runner = new ModifyPerformanceRunner(new PerformanceRunnerOptions(argParser, this));
            StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
            argParser.addArgument((Argument)propertiesFileArgument);
            argParser.setFilePropertiesArgument(propertiesFileArgument);
            BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
            argParser.addArgument((Argument)noPropertiesFileArgument);
            argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
            baseDN = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"targetDN").shortIdentifier(Character.valueOf('b'))).description(ToolsMessages.INFO_MODRATE_TOOL_DESCRIPTION_TARGETDN.get())).required()).valuePlaceholder(ToolsMessages.INFO_TARGETDN_PLACEHOLDER.get())).buildAndAddToParser(argParser);
            this.verbose = CommonArguments.verboseArgument();
            argParser.addArgument((Argument)this.verbose);
            BooleanArgument showUsage = CommonArguments.showUsageArgument();
            argParser.addArgument((Argument)showUsage);
            argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
            this.scriptFriendly = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"scriptFriendly").shortIdentifier(Character.valueOf('S'))).description(ToolsMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get())).buildAndAddToParser(argParser);
        }
        catch (ArgumentException ae) {
            LocalizableMessage message = ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage());
            this.errPrintln(message);
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        try {
            argParser.parseArguments(args);
            if (argParser.usageOrVersionDisplayed()) {
                return 0;
            }
            connectionFactory = connectionFactoryProvider.getAuthenticatedConnectionFactory();
            runner.setBindRequest(connectionFactoryProvider.getBindRequest());
            runner.validate();
        }
        catch (ArgumentException ae) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        ModifyPerformanceRunner.access$102(runner, argParser.getTrailingArguments().toArray(new String[argParser.getTrailingArguments().size()]));
        runner.baseDN = baseDN.getValue();
        try {
            Object[] data = DataSource.generateData(runner.getDataSources(), null);
            for (String modString : runner.modStrings) {
                String.format(modString, data);
            }
            String.format(runner.baseDN, data);
        }
        catch (Exception ex1) {
            this.errPrintln(LocalizableMessage.raw((CharSequence)("Error formatting filter or base DN: " + ex1), (Object[])new Object[0]));
            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
        }
        return runner.run(connectionFactory);
    }

    private static final class ModifyPerformanceRunner
    extends PerformanceRunner {
        private String baseDN;
        private String[] modStrings;

        private ModifyPerformanceRunner(PerformanceRunnerOptions options) throws ArgumentException {
            super(options);
        }

        @Override
        PerformanceRunner.WorkerThread newWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
            return new ModifyWorkerThread(connection, connectionFactory);
        }

        @Override
        StatsThread newStatsThread(PerformanceRunner performanceRunner, ConsoleApplication app) {
            return new StatsThread(performanceRunner, app);
        }

        static /* synthetic */ String[] access$102(ModifyPerformanceRunner x0, String[] x1) {
            x0.modStrings = x1;
            return x1;
        }

        private final class ModifyWorkerThread
        extends PerformanceRunner.WorkerThread {
            private ModifyRequest mr;
            private Object[] data;

            private ModifyWorkerThread(Connection connection, ConnectionFactory connectionFactory) {
                super(connection, connectionFactory);
            }

            @Override
            public Promise<?, LdapException> performOperation(Connection connection, DataSource[] dataSources, long currentTimeNs) {
                if (dataSources != null) {
                    this.data = DataSource.generateData(dataSources, this.data);
                }
                this.mr = this.newModifyRequest(this.data);
                PerformanceRunner.UpdateStatsResultHandler modRes = new PerformanceRunner.UpdateStatsResultHandler(currentTimeNs);
                this.incrementIterationCount();
                return connection.modifyAsync(this.mr).thenOnResult(modRes).thenOnException(modRes);
            }

            private ModifyRequest newModifyRequest(Object[] data) {
                ModifyRequest mr = data != null ? Requests.newModifyRequest((String)String.format(ModifyPerformanceRunner.this.baseDN, data)) : Requests.newModifyRequest((String)ModifyPerformanceRunner.this.baseDN);
                for (String modString : ModifyPerformanceRunner.this.modStrings) {
                    String formattedString = data != null ? String.format(modString, data) : modString;
                    int colonPos = formattedString.indexOf(58);
                    if (colonPos <= 0) continue;
                    mr.addModification(ModificationType.REPLACE, formattedString.substring(0, colonPos), new Object[]{formattedString.substring(colonPos + 1)});
                }
                return mr;
            }
        }
    }
}

