/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldif.EntryGenerator;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class MakeLDIF
extends ConsoleApplication {
    public static final String OPTION_LONG_CONSTANT = "constant";
    public static final String OPTION_LONG_RESOURCE_PATH = "resourcePath";
    private static final int EXIT_CODE_SUCCESS = 0;
    private static final int EXIT_CODE_FAILURE = 1;
    private long numberOfEntriesWritten;

    public static void main(String[] args) {
        int retCode = new MakeLDIF().run(args);
        System.exit(Utils.filterExitCode((int)retCode));
    }

    int run(String[] args) {
        IntegerArgument wrapColumn;
        StringArgument constants;
        IntegerArgument randomSeed;
        StringArgument ldifFile;
        StringArgument resourcePath;
        LocalizableMessage toolDescription = ToolsMessages.INFO_MAKELDIF_TOOL_DESCRIPTION.get();
        ArgumentParser argParser = new ArgumentParser(MakeLDIF.class.getName(), toolDescription, false, true, 1, 1, "template-file-path");
        argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
        argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_MAKELDIF.get());
        argParser.setDocToolDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_MAKELDIF.get());
        try {
            resourcePath = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_LONG_RESOURCE_PATH).shortIdentifier(Character.valueOf('r'))).description(ToolsMessages.INFO_MAKELDIF_DESCRIPTION_RESOURCE_PATH.get())).docDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_RESOURCE_PATH.get())).valuePlaceholder(ToolsMessages.INFO_PATH_PLACEHOLDER.get())).buildAndAddToParser(argParser);
            ldifFile = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"outputLDIF").shortIdentifier(Character.valueOf('o'))).description(ToolsMessages.INFO_MAKELDIF_DESCRIPTION_LDIF.get())).valuePlaceholder(ToolsMessages.INFO_FILE_PLACEHOLDER.get())).buildAndAddToParser(argParser);
            randomSeed = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"randomSeed").shortIdentifier(Character.valueOf('s'))).description(ToolsMessages.INFO_MAKELDIF_DESCRIPTION_SEED.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_SEED_PLACEHOLDER.get())).buildAndAddToParser(argParser);
            constants = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)OPTION_LONG_CONSTANT).shortIdentifier(Character.valueOf('c'))).description(ToolsMessages.INFO_MAKELDIF_DESCRIPTION_CONSTANT.get())).multiValued()).valuePlaceholder(ToolsMessages.INFO_CONSTANT_PLACEHOLDER.get())).buildAndAddToParser(argParser);
            BooleanArgument showUsage = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"help").shortIdentifier(Character.valueOf('H'))).description(ToolsMessages.INFO_MAKELDIF_DESCRIPTION_HELP.get())).buildAndAddToParser(argParser);
            wrapColumn = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"wrapColumn").shortIdentifier(Character.valueOf('w'))).description(ToolsMessages.INFO_MAKELDIF_DESCRIPTION_WRAP_COLUMN.get())).lowerBound(0).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_MAKELDIF_WRAP_COLUMN_PLACEHOLDER.get())).buildAndAddToParser(argParser);
            argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
        }
        catch (ArgumentException ae) {
            this.errPrintln(ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
            return 1;
        }
        try {
            argParser.parseArguments(args);
        }
        catch (ArgumentException ae) {
            argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
            return 1;
        }
        if (argParser.usageOrVersionDisplayed()) {
            return 0;
        }
        String templatePath = (String)argParser.getTrailingArguments().get(0);
        return this.run(templatePath, resourcePath, ldifFile, randomSeed, constants, wrapColumn);
    }

    /*
     * Exception decompiling
     */
    private int run(String templatePath, StringArgument resourcePath, StringArgument ldifFile, IntegerArgument randomSeedArg, StringArgument constants, IntegerArgument wrapColumn) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private LDIFEntryWriter createLdifWriter(StringArgument ldifFile, IntegerArgument wrapColumn) throws IOException, ArgumentException {
        LDIFEntryWriter writer = ldifFile.isPresent() ? new LDIFEntryWriter((Writer)new BufferedWriter(new FileWriter(ldifFile.getValue()))) : new LDIFEntryWriter((OutputStream)this.getOutputStream());
        return writer.setWrapColumn(wrapColumn.getIntValue());
    }

    static EntryGenerator createGenerator(String templatePath, StringArgument resourcePath, IntegerArgument randomSeedArg, StringArgument constants, boolean generateBranches, ConsoleApplication app) {
        EntryGenerator generator = new EntryGenerator(templatePath).setGenerateBranches(generateBranches);
        if (resourcePath.isPresent()) {
            File resourceDir = new File(resourcePath.getValue());
            if (!resourceDir.exists()) {
                app.errPrintln(ToolsMessages.ERR_LDIF_GEN_TOOL_NO_SUCH_RESOURCE_DIRECTORY.get((Object)resourcePath.getValue()));
                generator.close();
                return null;
            }
            generator.setResourcePath(resourcePath.getValue());
        }
        if (randomSeedArg.isPresent()) {
            try {
                generator.setRandomSeed(randomSeedArg.getIntValue());
            }
            catch (ArgumentException ae) {
                app.errPrintln(ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
                generator.close();
                return null;
            }
        }
        if (constants.isPresent() && !MakeLDIF.addConstantsToGenerator(constants, generator, app)) {
            generator.close();
            return null;
        }
        try {
            generator.hasNext();
        }
        catch (IOException e) {
            app.errPrintln(ToolsMessages.ERR_LDIF_GEN_TOOL_EXCEPTION_DURING_PARSE.get((Object)e.getMessage()));
            generator.close();
            return null;
        }
        return generator;
    }

    private static boolean addConstantsToGenerator(StringArgument constants, EntryGenerator generator, ConsoleApplication app) {
        for (String constant : constants.getValues()) {
            String[] chunks = constant.split("=");
            if (chunks.length != 2) {
                app.errPrintln(ToolsMessages.ERR_CONSTANT_ARG_CANNOT_DECODE.get((Object)constant));
                return false;
            }
            generator.setConstant(chunks[0], (Object)chunks[1]);
        }
        return true;
    }

    private EntryGenerator createGenerator(String templatePath, StringArgument resourcePath, IntegerArgument randomSeedArg, StringArgument constants) {
        return MakeLDIF.createGenerator(templatePath, resourcePath, randomSeedArg, constants, true, this);
    }

    private boolean generateEntries(EntryGenerator generator, LDIFEntryWriter writer, StringArgument ldifFile) {
        try {
            while (generator.hasNext()) {
                Entry entry = generator.readEntry();
                try {
                    writer.writeEntry(entry);
                }
                catch (IOException e) {
                    this.errPrintln(ToolsMessages.ERR_MAKELDIF_ERROR_WRITING_LDIF.get((Object)ldifFile.getValue(), (Object)e.getMessage()));
                    return false;
                }
                if (++this.numberOfEntriesWritten % 1000L != 0L) continue;
                this.errPrintln(ToolsMessages.INFO_MAKELDIF_PROCESSED_N_ENTRIES.get((Object)this.numberOfEntriesWritten));
            }
        }
        catch (Exception e) {
            this.errPrintln(ToolsMessages.ERR_MAKELDIF_EXCEPTION_DURING_PROCESSING.get((Object)e.getMessage()));
            return false;
        }
        return true;
    }

    private MakeLDIF() {
    }

    MakeLDIF(PrintStream out, PrintStream err) {
        super(out, err);
    }
}

