/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.cli.Utils;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizableException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldif.EntryReader;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIF;
import org.forgerock.opendj.ldif.LDIFEntryReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class LDIFSearch
extends ConsoleApplication {
    public static void main(String[] args) {
        int retCode = new LDIFSearch().run(args);
        System.exit(Utils.filterExitCode((int)retCode));
    }

    private LDIFSearch() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) {
        OutputStream outputStream;
        InputStream sourceInputStream;
        SearchRequest search;
        block48: {
            StringArgument outputFilename;
            block47: {
                IntegerArgument timeLimit;
                IntegerArgument sizeLimit;
                BooleanArgument typesOnly;
                StringArgument filename;
                MultiChoiceArgument searchScope;
                StringArgument baseDN;
                LocalizableMessage toolDescription = ToolsMessages.INFO_LDIFSEARCH_TOOL_DESCRIPTION.get();
                ArgumentParser argParser = new ArgumentParser(LDIFSearch.class.getName(), toolDescription, false, true, 1, 0, "source [filter] [attributes ...]");
                argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
                argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDIFSEARCH.get());
                try {
                    outputFilename = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"outputLDIF").shortIdentifier(Character.valueOf('o'))).description(ToolsMessages.INFO_LDIFSEARCH_DESCRIPTION_OUTPUT_FILENAME.get((Object)ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get()))).defaultValue((Object)"stdout")).valuePlaceholder(ToolsMessages.INFO_OUTPUT_LDIF_FILE_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                    baseDN = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"baseDN").shortIdentifier(Character.valueOf('b'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_BASEDN.get())).required()).valuePlaceholder(ToolsMessages.INFO_BASEDN_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                    searchScope = CommonArguments.searchScopeArgument();
                    argParser.addArgument((Argument)searchScope);
                    filename = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"filename").shortIdentifier(Character.valueOf('f'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_FILENAME.get())).valuePlaceholder(ToolsMessages.INFO_FILE_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                    typesOnly = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"typesOnly").shortIdentifier(Character.valueOf('A'))).description(ToolsMessages.INFO_DESCRIPTION_TYPES_ONLY.get())).buildAndAddToParser(argParser);
                    sizeLimit = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"sizeLimit").shortIdentifier(Character.valueOf('z'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_SIZE_LIMIT.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_SIZE_LIMIT_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                    timeLimit = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"timeLimit").shortIdentifier(Character.valueOf('l'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_TIME_LIMIT.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_TIME_LIMIT_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                    BooleanArgument showUsage = CommonArguments.showUsageArgument();
                    argParser.addArgument((Argument)showUsage);
                    argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
                }
                catch (ArgumentException ae) {
                    LocalizableMessage message = ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage());
                    this.errPrintln(message);
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                try {
                    argParser.parseArguments(args);
                    if (argParser.usageOrVersionDisplayed()) {
                        return ResultCode.SUCCESS.intValue();
                    }
                }
                catch (ArgumentException ae) {
                    argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                LinkedList<Filter> filters = new LinkedList<Filter>();
                LinkedList attributes = new LinkedList();
                ArrayList trailingArguments = argParser.getTrailingArguments();
                if (trailingArguments.size() > 1) {
                    List filterAndAttributeStrings = trailingArguments.subList(1, trailingArguments.size());
                    if (!filename.isPresent()) {
                        String filterString = (String)filterAndAttributeStrings.remove(0);
                        try {
                            filters.add(Filter.valueOf((String)filterString));
                        }
                        catch (LocalizedIllegalArgumentException e) {
                            this.errPrintln(e.getMessageObject());
                            return ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                        }
                    }
                    attributes.addAll(filterAndAttributeStrings);
                }
                if (filename.isPresent()) {
                    try (BufferedReader in = new BufferedReader(new FileReader(filename.getValue()));){
                        String line = null;
                        while ((line = in.readLine()) != null) {
                            if ("".equals(line.trim())) continue;
                            filters.add(Filter.valueOf((String)line));
                        }
                    }
                    catch (LocalizedIllegalArgumentException e) {
                        this.errPrintln(e.getMessageObject());
                        return ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                    }
                    catch (IOException e) {
                        this.errPrintln(LocalizableMessage.raw((CharSequence)e.toString(), (Object[])new Object[0]));
                        return ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                    }
                }
                if (filters.isEmpty()) {
                    argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_SEARCH_NO_FILTERS.get());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                try {
                    SearchScope scope = (SearchScope)searchScope.getTypedValue();
                    search = Requests.newSearchRequest((DN)DN.valueOf((String)baseDN.getValue()), (SearchScope)scope, (Filter)((Filter)filters.get(0)), (String[])attributes.toArray(new String[attributes.size()])).setTypesOnly(typesOnly.isPresent()).setTimeLimit(timeLimit.getIntValue()).setSizeLimit(sizeLimit.getIntValue());
                }
                catch (ArgumentException | LocalizedIllegalArgumentException e) {
                    this.errPrintln(((LocalizableException)e).getMessageObject());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                sourceInputStream = null;
                outputStream = null;
                if ("-".equals(trailingArguments.get(0))) break block47;
                try {
                    sourceInputStream = new FileInputStream((String)trailingArguments.get(0));
                }
                catch (FileNotFoundException e) {
                    LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get(trailingArguments.get(0), (Object)e.getLocalizedMessage());
                    this.errPrintln(message);
                    int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, outputStream});
                    return n;
                }
            }
            if (!outputFilename.isPresent() || "-".equals(outputFilename.getValue())) break block48;
            try {
                outputStream = new FileOutputStream(outputFilename.getValue());
            }
            catch (FileNotFoundException e) {
                LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_WRITE.get((Object)outputFilename.getValue(), (Object)e.getLocalizedMessage());
                this.errPrintln(message);
                int n = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, outputStream});
                return n;
            }
        }
        try {
            if (sourceInputStream == null) {
                sourceInputStream = System.in;
            }
            if (outputStream == null) {
                outputStream = System.out;
            }
            try (LDIFEntryReader sourceReader = new LDIFEntryReader(sourceInputStream);
                 LDIFEntryWriter outputWriter = new LDIFEntryWriter(outputStream);){
                LDIF.copyTo((EntryReader)LDIF.search((EntryReader)sourceReader, (SearchRequest)search), (EntryWriter)outputWriter);
            }
        }
        catch (IOException e) {
            int n;
            try {
                if (e instanceof LocalizableException) {
                    this.errPrintln(ToolsMessages.ERR_LDIFSEARCH_FAILED.get((Object)((LocalizableException)e).getMessageObject()));
                } else {
                    this.errPrintln(ToolsMessages.ERR_LDIFSEARCH_FAILED.get((Object)e.getLocalizedMessage()));
                }
                n = ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue();
            }
            catch (Throwable throwable) {
                org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, outputStream});
                throw throwable;
            }
            org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, outputStream});
            return n;
        }
        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{sourceInputStream, outputStream});
        return ResultCode.SUCCESS.intValue();
    }
}

