/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.controls.AccountUsabilityResponseControl;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import com.forgerock.opendj.util.StaticUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.EntryChangeNotificationResponseControl;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.controls.GetEffectiveRightsRequestControl;
import org.forgerock.opendj.ldap.controls.MatchedValuesRequestControl;
import org.forgerock.opendj.ldap.controls.PersistentSearchChangeType;
import org.forgerock.opendj.ldap.controls.PersistentSearchRequestControl;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.controls.ServerSideSortRequestControl;
import org.forgerock.opendj.ldap.controls.ServerSideSortResponseControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.controls.VirtualListViewRequestControl;
import org.forgerock.opendj.ldap.controls.VirtualListViewResponseControl;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class LDAPSearch
extends ConsoleApplication {
    private BooleanArgument verbose;
    private EntryWriter ldifWriter;

    public static void main(String[] args) {
        int retCode = new LDAPSearch().run(args);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private LDAPSearch() {
    }

    LDAPSearch(PrintStream out, PrintStream err) {
        super(out, err);
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    int run(String[] args) {
        int n;
        Connection connection;
        block115: {
            SearchRequest search;
            SearchScope scope;
            BindRequest bindRequest;
            ConnectionFactory connectionFactory;
            BooleanArgument noop;
            BooleanArgument countEntries;
            BooleanArgument dontWrap;
            IntegerArgument timeLimit;
            IntegerArgument sizeLimit;
            BooleanArgument typesOnly;
            MultiChoiceArgument dereferencePolicy;
            IntegerArgument version;
            StringArgument effectiveRightsAttrs;
            StringArgument effectiveRightsUser;
            StringArgument controlStr;
            StringArgument vlvDescriptor;
            StringArgument sortOrder;
            StringArgument matchedValuesFilter;
            StringArgument assertionFilter;
            IntegerArgument simplePageSize;
            StringArgument pSearchInfo;
            StringArgument proxyAuthzID;
            StringArgument filename;
            MultiChoiceArgument searchScope;
            StringArgument baseDN;
            ConnectionFactoryProvider connectionFactoryProvider;
            LocalizableMessage toolDescription = ToolsMessages.INFO_LDAPSEARCH_TOOL_DESCRIPTION.get();
            ArgumentParser argParser = new ArgumentParser(LDAPSearch.class.getName(), toolDescription, false, true, 0, 0, "[filter] [attributes ...]");
            argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
            argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDAPSEARCH.get());
            try {
                connectionFactoryProvider = new ConnectionFactoryProvider(argParser, (ConsoleApplication)this);
                StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
                argParser.addArgument((Argument)propertiesFileArgument);
                argParser.setFilePropertiesArgument(propertiesFileArgument);
                BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
                argParser.addArgument((Argument)noPropertiesFileArgument);
                argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
                baseDN = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"baseDN").shortIdentifier(Character.valueOf('b'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_BASEDN.get())).required()).valuePlaceholder(ToolsMessages.INFO_BASEDN_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                searchScope = CommonArguments.searchScopeArgument();
                argParser.addArgument((Argument)searchScope);
                filename = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"filename").shortIdentifier(Character.valueOf('f'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_FILENAME.get())).valuePlaceholder(ToolsMessages.INFO_FILE_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                proxyAuthzID = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"proxyAs").shortIdentifier(Character.valueOf('Y'))).description(ToolsMessages.INFO_DESCRIPTION_PROXY_AUTHZID.get())).valuePlaceholder(ToolsMessages.INFO_PROXYAUTHID_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                pSearchInfo = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"persistentSearch").shortIdentifier(Character.valueOf('C'))).description(ToolsMessages.INFO_DESCRIPTION_PSEARCH_INFO.get())).docDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_PSEARCH_INFO.get())).valuePlaceholder(ToolsMessages.INFO_PSEARCH_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                simplePageSize = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"simplePageSize").description(ToolsMessages.INFO_DESCRIPTION_SIMPLE_PAGE_SIZE.get())).lowerBound(1).defaultValue((Object)1000)).valuePlaceholder(CliMessages.INFO_NUM_ENTRIES_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                assertionFilter = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"assertionFilter").description(ToolsMessages.INFO_DESCRIPTION_ASSERTION_FILTER.get())).valuePlaceholder(ToolsMessages.INFO_ASSERTION_FILTER_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                matchedValuesFilter = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"matchedValuesFilter").description(ToolsMessages.INFO_DESCRIPTION_MATCHED_VALUES_FILTER.get())).multiValued()).valuePlaceholder(ToolsMessages.INFO_FILTER_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                sortOrder = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"sortOrder").shortIdentifier(Character.valueOf('S'))).description(ToolsMessages.INFO_DESCRIPTION_SORT_ORDER.get())).valuePlaceholder(ToolsMessages.INFO_SORT_ORDER_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                vlvDescriptor = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"virtualListView").shortIdentifier(Character.valueOf('G'))).description(ToolsMessages.INFO_DESCRIPTION_VLV.get())).valuePlaceholder(ToolsMessages.INFO_VLV_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                controlStr = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"control").shortIdentifier(Character.valueOf('J'))).description(ToolsMessages.INFO_DESCRIPTION_CONTROLS.get())).docDescriptionSupplement(ToolsMessages.SUPPLEMENT_DESCRIPTION_CONTROLS.get())).multiValued()).valuePlaceholder(ToolsMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                effectiveRightsUser = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"getEffectiveRightsAuthzid").shortIdentifier(Character.valueOf('g'))).description(ToolsMessages.INFO_DESCRIPTION_EFFECTIVERIGHTS_USER.get())).valuePlaceholder(ToolsMessages.INFO_PROXYAUTHID_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                effectiveRightsAttrs = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"getEffectiveRightsAttribute").shortIdentifier(Character.valueOf('e'))).description(ToolsMessages.INFO_DESCRIPTION_EFFECTIVERIGHTS_ATTR.get())).multiValued()).valuePlaceholder(ToolsMessages.INFO_ATTRIBUTE_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                version = CommonArguments.ldapVersionArgument();
                argParser.addArgument((Argument)version);
                dereferencePolicy = (MultiChoiceArgument)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)MultiChoiceArgument.builder((String)"dereferencePolicy").shortIdentifier(Character.valueOf('a'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_DEREFERENCE_POLICY.get())).allowedValues((Collection)DereferenceAliasesPolicy.values()).defaultValue((Object)DereferenceAliasesPolicy.NEVER)).valuePlaceholder(ToolsMessages.INFO_DEREFERENCE_POLICE_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                typesOnly = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"typesOnly").shortIdentifier(Character.valueOf('A'))).description(ToolsMessages.INFO_DESCRIPTION_TYPES_ONLY.get())).buildAndAddToParser(argParser);
                sizeLimit = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"sizeLimit").shortIdentifier(Character.valueOf('z'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_SIZE_LIMIT.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_SIZE_LIMIT_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                timeLimit = (IntegerArgument)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder((String)"timeLimit").shortIdentifier(Character.valueOf('l'))).description(ToolsMessages.INFO_SEARCH_DESCRIPTION_TIME_LIMIT.get())).defaultValue((Object)0)).valuePlaceholder(ToolsMessages.INFO_TIME_LIMIT_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                dontWrap = (BooleanArgument)((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder((String)"dontWrap").shortIdentifier(Character.valueOf('t'))).description(ToolsMessages.INFO_DESCRIPTION_DONT_WRAP.get())).buildAndAddToParser(argParser);
                countEntries = (BooleanArgument)((BooleanArgument.Builder)BooleanArgument.builder((String)"countEntries").description(ToolsMessages.INFO_DESCRIPTION_COUNT_ENTRIES.get())).buildAndAddToParser(argParser);
                BooleanArgument continueOnError = CommonArguments.continueOnErrorArgument();
                argParser.addArgument((Argument)continueOnError);
                noop = CommonArguments.noOpArgument();
                argParser.addArgument((Argument)noop);
                this.verbose = CommonArguments.verboseArgument();
                argParser.addArgument((Argument)this.verbose);
                BooleanArgument showUsage = CommonArguments.showUsageArgument();
                argParser.addArgument((Argument)showUsage);
                argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
            }
            catch (ArgumentException ae) {
                this.errPrintln(ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            try {
                argParser.parseArguments(args);
                if (argParser.usageOrVersionDisplayed()) {
                    return 0;
                }
                connectionFactory = connectionFactoryProvider.getUnauthenticatedConnectionFactory();
                bindRequest = connectionFactoryProvider.getBindRequest();
            }
            catch (ArgumentException ae) {
                argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            LinkedList<Filter> filters = new LinkedList<Filter>();
            LinkedList attributes = new LinkedList();
            ArrayList filterAndAttributeStrings = argParser.getTrailingArguments();
            if (!filterAndAttributeStrings.isEmpty()) {
                if (!filename.isPresent()) {
                    String filterString = (String)filterAndAttributeStrings.remove(0);
                    try {
                        filters.add(Filter.valueOf((String)filterString));
                    }
                    catch (LocalizedIllegalArgumentException e) {
                        this.errPrintln(e.getMessageObject());
                        return ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                    }
                }
                attributes.addAll(filterAndAttributeStrings);
            }
            if (filename.isPresent()) {
                try (BufferedReader in = new BufferedReader(new FileReader(filename.getValue()));){
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        if ("".equals(line.trim())) continue;
                        filters.add(Filter.valueOf((String)line));
                    }
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.errPrintln(e.getMessageObject());
                    return ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                }
                catch (IOException e) {
                    this.errPrintln(LocalizableMessage.raw((CharSequence)e.toString(), (Object[])new Object[0]));
                    return ResultCode.CLIENT_SIDE_FILTER_ERROR.intValue();
                }
            }
            if (filters.isEmpty()) {
                argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_SEARCH_NO_FILTERS.get());
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            try {
                scope = (SearchScope)searchScope.getTypedValue();
            }
            catch (ArgumentException ex1) {
                this.errPrintln(ex1.getMessageObject());
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            try {
                search = Requests.newSearchRequest((DN)DN.valueOf((String)baseDN.getValue()), (SearchScope)scope, (Filter)((Filter)filters.get(0)), (String[])attributes.toArray(new String[attributes.size()]));
            }
            catch (LocalizedIllegalArgumentException e) {
                this.errPrintln(e.getMessageObject());
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            try {
                int versionNumber = version.getIntValue();
                if (versionNumber != 2 && versionNumber != 3) {
                    this.errPrintln(ToolsMessages.ERR_DESCRIPTION_INVALID_VERSION.get((Object)String.valueOf(versionNumber)));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            catch (ArgumentException ae) {
                this.errPrintln(ToolsMessages.ERR_DESCRIPTION_INVALID_VERSION.get((Object)version.getValue()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            search.setTypesOnly(typesOnly.isPresent());
            try {
                search.setTimeLimit(timeLimit.getIntValue());
                search.setSizeLimit(sizeLimit.getIntValue());
            }
            catch (ArgumentException ex1) {
                this.errPrintln(ex1.getMessageObject());
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            try {
                search.setDereferenceAliasesPolicy((DereferenceAliasesPolicy)dereferencePolicy.getTypedValue());
            }
            catch (ArgumentException ex1) {
                this.errPrintln(ex1.getMessageObject());
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            if (controlStr.isPresent()) {
                for (String ctrlString : controlStr.getValues()) {
                    try {
                        GenericControl ctrl = Utils.getControl(ctrlString);
                        search.addControl((Control)ctrl);
                    }
                    catch (DecodeException de) {
                        this.errPrintln(ToolsMessages.ERR_TOOL_INVALID_CONTROL_STRING.get((Object)ctrlString));
                        ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    }
                }
            }
            if (effectiveRightsUser.isPresent()) {
                String authzID = effectiveRightsUser.getValue();
                if (!authzID.startsWith("dn:")) {
                    this.errPrintln(ToolsMessages.ERR_EFFECTIVERIGHTS_INVALID_AUTHZID.get((Object)authzID));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                GetEffectiveRightsRequestControl effectiveRightsControl = GetEffectiveRightsRequestControl.newControl((boolean)false, (String)authzID.substring(3), (String[])effectiveRightsAttrs.getValues().toArray(new String[effectiveRightsAttrs.getValues().size()]));
                search.addControl((Control)effectiveRightsControl);
            }
            if (proxyAuthzID.isPresent()) {
                ProxiedAuthV2RequestControl proxyControl = ProxiedAuthV2RequestControl.newControl((String)proxyAuthzID.getValue());
                search.addControl((Control)proxyControl);
            }
            if (pSearchInfo.isPresent()) {
                String token;
                String infoString = StaticUtils.toLowerCase((String)pSearchInfo.getValue().trim());
                boolean changesOnly = true;
                boolean returnECs = true;
                StringTokenizer tokenizer = new StringTokenizer(infoString, ":");
                if (!tokenizer.hasMoreTokens()) {
                    this.errPrintln(ToolsMessages.ERR_PSEARCH_MISSING_DESCRIPTOR.get());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                String token2 = tokenizer.nextToken();
                if (!"ps".equals(token2)) {
                    this.errPrintln(ToolsMessages.ERR_PSEARCH_DOESNT_START_WITH_PS.get((Object)infoString));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                ArrayList<PersistentSearchChangeType> ct = new ArrayList<PersistentSearchChangeType>(4);
                if (tokenizer.hasMoreTokens()) {
                    StringTokenizer st = new StringTokenizer(tokenizer.nextToken(), ", ");
                    if (!st.hasMoreTokens()) {
                        ct.add(PersistentSearchChangeType.ADD);
                        ct.add(PersistentSearchChangeType.DELETE);
                        ct.add(PersistentSearchChangeType.MODIFY);
                        ct.add(PersistentSearchChangeType.MODIFY_DN);
                    } else {
                        do {
                            String token3;
                            if ("add".equals(token3 = st.nextToken())) {
                                ct.add(PersistentSearchChangeType.ADD);
                                continue;
                            }
                            if ("delete".equals(token3) || "del".equals(token3)) {
                                ct.add(PersistentSearchChangeType.DELETE);
                                continue;
                            }
                            if ("modify".equals(token3) || "mod".equals(token3)) {
                                ct.add(PersistentSearchChangeType.MODIFY);
                                continue;
                            }
                            if ("modifydn".equals(token3) || "moddn".equals(token3) || "modrdn".equals(token3)) {
                                ct.add(PersistentSearchChangeType.MODIFY_DN);
                                continue;
                            }
                            if ("any".equals(token3) || "all".equals(token3)) {
                                ct.add(PersistentSearchChangeType.ADD);
                                ct.add(PersistentSearchChangeType.DELETE);
                                ct.add(PersistentSearchChangeType.MODIFY);
                                ct.add(PersistentSearchChangeType.MODIFY_DN);
                                continue;
                            }
                            this.errPrintln(ToolsMessages.ERR_PSEARCH_INVALID_CHANGE_TYPE.get((Object)token3));
                            return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                        } while (st.hasMoreTokens());
                    }
                }
                if (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    if ("1".equals(token) || "true".equals(token) || "yes".equals(token)) {
                        changesOnly = true;
                    } else if ("0".equals(token) || "false".equals(token) || "no".equals(token)) {
                        changesOnly = false;
                    } else {
                        this.errPrintln(ToolsMessages.ERR_PSEARCH_INVALID_CHANGESONLY.get((Object)token));
                        return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    }
                }
                if (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    if ("1".equals(token) || "true".equals(token) || "yes".equals(token)) {
                        returnECs = true;
                    } else if ("0".equals(token) || "false".equals(token) || "no".equals(token)) {
                        returnECs = false;
                    } else {
                        this.errPrintln(ToolsMessages.ERR_PSEARCH_INVALID_RETURN_ECS.get((Object)token));
                        return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    }
                }
                PersistentSearchRequestControl psearchControl = PersistentSearchRequestControl.newControl((boolean)true, (boolean)changesOnly, (boolean)returnECs, (PersistentSearchChangeType[])ct.toArray(new PersistentSearchChangeType[ct.size()]));
                search.addControl((Control)psearchControl);
            }
            if (assertionFilter.isPresent()) {
                String filterString = assertionFilter.getValue();
                try {
                    Filter filter = Filter.valueOf((String)filterString);
                    AssertionRequestControl assertionControl = AssertionRequestControl.newControl((boolean)true, (Filter)filter);
                    search.addControl((Control)assertionControl);
                }
                catch (LocalizedIllegalArgumentException le) {
                    this.errPrintln(ToolsMessages.ERR_LDAP_ASSERTION_INVALID_FILTER.get((Object)le.getMessage()));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            if (matchedValuesFilter.isPresent()) {
                List mvFilterStrings = matchedValuesFilter.getValues();
                ArrayList<Filter> mvFilters = new ArrayList<Filter>();
                for (String s : mvFilterStrings) {
                    try {
                        Filter f = Filter.valueOf((String)s);
                        mvFilters.add(f);
                    }
                    catch (LocalizedIllegalArgumentException le) {
                        this.errPrintln(ToolsMessages.ERR_LDAP_MATCHEDVALUES_INVALID_FILTER.get((Object)le.getMessage()));
                        return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    }
                }
                MatchedValuesRequestControl mvc = MatchedValuesRequestControl.newControl((boolean)true, mvFilters);
                search.addControl((Control)mvc);
            }
            if (sortOrder.isPresent()) {
                try {
                    search.addControl((Control)ServerSideSortRequestControl.newControl((boolean)false, (String)sortOrder.getValue()));
                }
                catch (LocalizedIllegalArgumentException le) {
                    this.errPrintln(ToolsMessages.ERR_LDAP_SORTCONTROL_INVALID_ORDER.get((Object)le.getMessageObject()));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            if (vlvDescriptor.isPresent()) {
                if (!sortOrder.isPresent()) {
                    LocalizableMessage message = ToolsMessages.ERR_LDAPSEARCH_VLV_REQUIRES_SORT.get((Object)vlvDescriptor.getLongIdentifier(), (Object)sortOrder.getLongIdentifier());
                    this.errPrintln(message);
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                StringTokenizer tokenizer = new StringTokenizer(vlvDescriptor.getValue(), ":");
                int numTokens = tokenizer.countTokens();
                if (numTokens == 3) {
                    try {
                        int beforeCount = Integer.parseInt(tokenizer.nextToken());
                        int afterCount = Integer.parseInt(tokenizer.nextToken());
                        ByteString assertionValue = ByteString.valueOfUtf8((CharSequence)tokenizer.nextToken());
                        search.addControl((Control)VirtualListViewRequestControl.newAssertionControl((boolean)true, (ByteString)assertionValue, (int)beforeCount, (int)afterCount, null));
                    }
                    catch (Exception e) {
                        this.errPrintln(ToolsMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get());
                        return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    }
                } else if (numTokens == 4) {
                    try {
                        int beforeCount = Integer.parseInt(tokenizer.nextToken());
                        int afterCount = Integer.parseInt(tokenizer.nextToken());
                        int offset = Integer.parseInt(tokenizer.nextToken());
                        int contentCount = Integer.parseInt(tokenizer.nextToken());
                        search.addControl((Control)VirtualListViewRequestControl.newOffsetControl((boolean)true, (int)offset, (int)contentCount, (int)beforeCount, (int)afterCount, null));
                    }
                    catch (Exception e) {
                        this.errPrintln(ToolsMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get());
                        return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    }
                } else {
                    this.errPrintln(ToolsMessages.ERR_LDAPSEARCH_VLV_INVALID_DESCRIPTOR.get());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            int pageSize = 0;
            if (simplePageSize.isPresent()) {
                if (filters.size() > 1) {
                    this.errPrintln(ToolsMessages.ERR_PAGED_RESULTS_REQUIRES_SINGLE_FILTER.get());
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
                try {
                    pageSize = simplePageSize.getIntValue();
                    search.addControl((Control)SimplePagedResultsControl.newControl((boolean)true, (int)pageSize, (ByteString)ByteString.empty()));
                }
                catch (ArgumentException ae) {
                    this.errPrintln(ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            int wrapColumn = 80;
            if (dontWrap.isPresent()) {
                wrapColumn = 0;
            }
            if (noop.isPresent()) {
                return 0;
            }
            connection = connectionFactory.getConnection();
            if (bindRequest != null) {
                Utils.printPasswordPolicyResults(this, connection.bind(bindRequest));
            }
            int filterIndex = 0;
            this.ldifWriter = new LDIFEntryWriter((OutputStream)this.getOutputStream()).setWrapColumn(wrapColumn);
            LDAPSearchResultHandler resultHandler = new LDAPSearchResultHandler();
            while (true) {
                ServerSideSortResponseControl control;
                Result result = connection.search(search, (SearchResultHandler)resultHandler);
                try {
                    control = (ServerSideSortResponseControl)result.getControl(ServerSideSortResponseControl.DECODER, new DecodeOptions());
                    if (control != null && control.getResult() != ResultCode.SUCCESS) {
                        this.println(ToolsMessages.WARN_LDAPSEARCH_SORT_ERROR.get((Object)control.getResult().toString()));
                    }
                }
                catch (DecodeException e) {
                    this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
                }
                try {
                    control = (VirtualListViewResponseControl)result.getControl(VirtualListViewResponseControl.DECODER, new DecodeOptions());
                    if (control != null) {
                        LocalizableMessage msg;
                        if (control.getResult() == ResultCode.SUCCESS) {
                            msg = ToolsMessages.INFO_LDAPSEARCH_VLV_TARGET_OFFSET.get((Object)control.getTargetPosition());
                            this.println(msg);
                            msg = ToolsMessages.INFO_LDAPSEARCH_VLV_CONTENT_COUNT.get((Object)control.getContentCount());
                            this.println(msg);
                        } else {
                            msg = ToolsMessages.WARN_LDAPSEARCH_VLV_ERROR.get((Object)control.getResult().toString());
                            this.println(msg);
                        }
                    }
                }
                catch (DecodeException e) {
                    this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
                }
                try {
                    control = (SimplePagedResultsControl)result.getControl(SimplePagedResultsControl.DECODER, new DecodeOptions());
                    if (control != null && control.getCookie().length() > 0) {
                        if (!this.isQuiet()) {
                            this.pressReturnToContinue();
                        }
                        Iterator iterator = search.getControls().iterator();
                        while (iterator.hasNext()) {
                            if (!"1.2.840.113556.1.4.319".equals(((Control)iterator.next()).getOID())) continue;
                            iterator.remove();
                        }
                        control = SimplePagedResultsControl.newControl((boolean)true, (int)pageSize, (ByteString)control.getCookie());
                        search.addControl((Control)control);
                        continue;
                    }
                }
                catch (DecodeException e) {
                    this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)e.getLocalizedMessage()));
                }
                this.errPrintln();
                this.errPrintln(ToolsMessages.ERR_TOOL_RESULT_CODE.get((Object)result.getResultCode().intValue(), (Object)result.getResultCode().toString()));
                if (result.getDiagnosticMessage() != null && result.getDiagnosticMessage().length() > 0) {
                    this.errPrintln(LocalizableMessage.raw((CharSequence)result.getDiagnosticMessage(), (Object[])new Object[0]));
                }
                if (result.getMatchedDN() != null && result.getMatchedDN().length() > 0) {
                    this.errPrintln(ToolsMessages.ERR_TOOL_MATCHED_DN.get((Object)result.getMatchedDN()));
                }
                if (++filterIndex >= filters.size()) break;
                search.setFilter((Filter)filters.get(filterIndex));
            }
            if (countEntries.isPresent() && !this.isQuiet()) {
                this.println(ToolsMessages.INFO_LDAPSEARCH_MATCHING_ENTRY_COUNT.get((Object)resultHandler.entryCount));
                this.println();
            }
            n = 0;
            if (connection == null) break block115;
            connection.close();
        }
        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{this.ldifWriter});
        return n;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (LdapException ere) {
                        int n2 = Utils.printErrorMessage(this, ere);
                        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{this.ldifWriter});
                        return n2;
                    }
                }
                catch (Throwable throwable3) {
                    org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{this.ldifWriter});
                    throw throwable3;
                }
            }
        }
    }

    private class LDAPSearchResultHandler
    implements SearchResultHandler {
        private int entryCount;

        private LDAPSearchResultHandler() {
        }

        public boolean handleEntry(SearchResultEntry entry) {
            EntryChangeNotificationResponseControl control;
            ++this.entryCount;
            try {
                control = (EntryChangeNotificationResponseControl)entry.getControl(EntryChangeNotificationResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_PSEARCH_CHANGE_TYPE.get((Object)control.getChangeType().toString()));
                    DN previousDN = control.getPreviousName();
                    if (previousDN != null) {
                        LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_PSEARCH_PREVIOUS_DN.get((Object)previousDN.toString()));
                    }
                }
            }
            catch (DecodeException de) {
                LDAPSearch.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            try {
                control = (AccountUsabilityResponseControl)entry.getControl(AccountUsabilityResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_HEADER.get());
                    if (control.isUsable()) {
                        LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_IS_USABLE.get());
                        if (control.getSecondsBeforeExpiration() > 0) {
                            int timeToExp = control.getSecondsBeforeExpiration();
                            LocalizableMessage timeToExpStr = com.forgerock.opendj.cli.Utils.secondsToTimeString((int)timeToExp);
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_TIME_UNTIL_EXPIRATION.get((Object)timeToExpStr));
                        }
                    } else {
                        LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_NOT_USABLE.get());
                        if (control.isInactive()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_ACCT_INACTIVE.get());
                        }
                        if (control.isReset()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_PW_RESET.get());
                        }
                        if (control.isExpired()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_PW_EXPIRED.get());
                            if (control.getRemainingGraceLogins() > 0) {
                                LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_REMAINING_GRACE.get((Object)control.getRemainingGraceLogins()));
                            }
                        }
                        if (control.isLocked()) {
                            LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_LOCKED.get());
                            if (control.getSecondsBeforeUnlock() > 0) {
                                int timeToUnlock = control.getSecondsBeforeUnlock();
                                LocalizableMessage timeToUnlockStr = com.forgerock.opendj.cli.Utils.secondsToTimeString((int)timeToUnlock);
                                LDAPSearch.this.println(ToolsMessages.INFO_LDAPSEARCH_ACCTUSABLE_TIME_UNTIL_UNLOCK.get((Object)timeToUnlockStr));
                            }
                        }
                    }
                }
            }
            catch (DecodeException de) {
                LDAPSearch.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            try {
                LDAPSearch.this.ldifWriter.writeEntry((Entry)entry);
                LDAPSearch.this.ldifWriter.flush();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            return true;
        }

        public boolean handleReference(SearchResultReference reference) {
            LDAPSearch.this.println(LocalizableMessage.raw((CharSequence)reference.toString(), (Object[])new Object[0]));
            return true;
        }
    }
}

