/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.tools;

import com.forgerock.opendj.cli.Argument;
import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.ArgumentParser;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CommonArguments;
import com.forgerock.opendj.cli.ConnectionFactoryProvider;
import com.forgerock.opendj.cli.ConsoleApplication;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.StringArgument;
import com.forgerock.opendj.cli.ToolVersionHandler;
import com.forgerock.opendj.ldap.tools.ToolsMessages;
import com.forgerock.opendj.ldap.tools.Utils;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadResponseControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadResponseControl;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;
import org.forgerock.opendj.ldif.EntryWriter;
import org.forgerock.opendj.ldif.LDIFChangeRecordReader;
import org.forgerock.opendj.ldif.LDIFEntryWriter;

public final class LDAPModify
extends ConsoleApplication {
    private Connection connection;
    private EntryWriter writer;
    private Collection<Control> controls;
    private BooleanArgument verbose;

    public static void main(String[] args) {
        int retCode = new LDAPModify().run(args);
        System.exit(com.forgerock.opendj.cli.Utils.filterExitCode((int)retCode));
    }

    private LDAPModify() {
    }

    public boolean isInteractive() {
        return false;
    }

    public boolean isVerbose() {
        return this.verbose.isPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int run(String[] args) {
        LDIFChangeRecordReader reader;
        block37: {
            LinkedList<String> attributes;
            StringTokenizer tokenizer;
            BindRequest bindRequest;
            ConnectionFactory connectionFactory;
            BooleanArgument noop;
            BooleanArgument continueOnError;
            IntegerArgument version;
            StringArgument controlStr;
            StringArgument postReadAttributes;
            StringArgument preReadAttributes;
            StringArgument assertionFilter;
            StringArgument proxyAuthzID;
            StringArgument filename;
            ConnectionFactoryProvider connectionFactoryProvider;
            LocalizableMessage toolDescription = ToolsMessages.INFO_LDAPMODIFY_TOOL_DESCRIPTION.get();
            ArgumentParser argParser = new ArgumentParser(LDAPModify.class.getName(), toolDescription, false);
            argParser.setVersionHandler(ToolVersionHandler.newSdkVersionHandler());
            argParser.setShortToolDescription(ToolsMessages.REF_SHORT_DESC_LDAPMODIFY.get());
            try {
                connectionFactoryProvider = new ConnectionFactoryProvider(argParser, (ConsoleApplication)this);
                StringArgument propertiesFileArgument = CommonArguments.propertiesFileArgument();
                argParser.addArgument((Argument)propertiesFileArgument);
                argParser.setFilePropertiesArgument(propertiesFileArgument);
                BooleanArgument noPropertiesFileArgument = CommonArguments.noPropertiesFileArgument();
                argParser.addArgument((Argument)noPropertiesFileArgument);
                argParser.setNoPropertiesFileArgument(noPropertiesFileArgument);
                filename = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"filename").shortIdentifier(Character.valueOf('f'))).description(ToolsMessages.INFO_LDAPMODIFY_DESCRIPTION_FILENAME.get())).valuePlaceholder(ToolsMessages.INFO_FILE_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                proxyAuthzID = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"proxyAs").shortIdentifier(Character.valueOf('Y'))).description(ToolsMessages.INFO_DESCRIPTION_PROXY_AUTHZID.get())).valuePlaceholder(ToolsMessages.INFO_PROXYAUTHID_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                assertionFilter = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"assertionFilter").description(ToolsMessages.INFO_DESCRIPTION_ASSERTION_FILTER.get())).valuePlaceholder(ToolsMessages.INFO_ASSERTION_FILTER_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                preReadAttributes = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"preReadAttributes").description(ToolsMessages.INFO_DESCRIPTION_PREREAD_ATTRS.get())).valuePlaceholder(ToolsMessages.INFO_ATTRIBUTE_LIST_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                postReadAttributes = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"postReadAttributes").description(ToolsMessages.INFO_DESCRIPTION_POSTREAD_ATTRS.get())).valuePlaceholder(ToolsMessages.INFO_ATTRIBUTE_LIST_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                controlStr = (StringArgument)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder((String)"control").shortIdentifier(Character.valueOf('J'))).description(ToolsMessages.INFO_DESCRIPTION_CONTROLS.get())).multiValued()).valuePlaceholder(ToolsMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get())).buildAndAddToParser(argParser);
                version = CommonArguments.ldapVersionArgument();
                argParser.addArgument((Argument)version);
                continueOnError = CommonArguments.continueOnErrorArgument();
                argParser.addArgument((Argument)continueOnError);
                noop = CommonArguments.noOpArgument();
                argParser.addArgument((Argument)noop);
                this.verbose = CommonArguments.verboseArgument();
                argParser.addArgument((Argument)this.verbose);
                BooleanArgument showUsage = CommonArguments.showUsageArgument();
                argParser.addArgument((Argument)showUsage);
                argParser.setUsageArgument((Argument)showUsage, (OutputStream)this.getOutputStream());
            }
            catch (ArgumentException ae) {
                this.errPrintln(ToolsMessages.ERR_CANNOT_INITIALIZE_ARGS.get((Object)ae.getMessage()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            try {
                argParser.parseArguments(args);
                if (argParser.usageOrVersionDisplayed()) {
                    return 0;
                }
                connectionFactory = connectionFactoryProvider.getUnauthenticatedConnectionFactory();
                bindRequest = connectionFactoryProvider.getBindRequest();
            }
            catch (ArgumentException ae) {
                argParser.displayMessageAndUsageReference(this.getErrStream(), ToolsMessages.ERR_ERROR_PARSING_ARGS.get((Object)ae.getMessage()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            try {
                int versionNumber = version.getIntValue();
                if (versionNumber != 2 && versionNumber != 3) {
                    this.errPrintln(ToolsMessages.ERR_DESCRIPTION_INVALID_VERSION.get((Object)String.valueOf(versionNumber)));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            catch (ArgumentException ae) {
                this.errPrintln(ToolsMessages.ERR_DESCRIPTION_INVALID_VERSION.get((Object)version.getValue()));
                return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
            }
            this.controls = new LinkedList<Control>();
            if (controlStr.isPresent()) {
                for (String ctrlString : controlStr.getValues()) {
                    try {
                        GenericControl ctrl = Utils.getControl(ctrlString);
                        this.controls.add((Control)ctrl);
                    }
                    catch (DecodeException de) {
                        this.errPrintln(ToolsMessages.ERR_TOOL_INVALID_CONTROL_STRING.get((Object)ctrlString));
                        ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                    }
                }
            }
            if (proxyAuthzID.isPresent()) {
                ProxiedAuthV2RequestControl proxyControl = ProxiedAuthV2RequestControl.newControl((String)proxyAuthzID.getValue());
                this.controls.add((Control)proxyControl);
            }
            if (assertionFilter.isPresent()) {
                String filterString = assertionFilter.getValue();
                try {
                    Filter filter = Filter.valueOf((String)filterString);
                    AssertionRequestControl assertionControl = AssertionRequestControl.newControl((boolean)true, (Filter)filter);
                    this.controls.add((Control)assertionControl);
                }
                catch (LocalizedIllegalArgumentException le) {
                    this.errPrintln(ToolsMessages.ERR_LDAP_ASSERTION_INVALID_FILTER.get((Object)le.getMessage()));
                    return ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                }
            }
            if (preReadAttributes.isPresent()) {
                String valueStr = preReadAttributes.getValue();
                tokenizer = new StringTokenizer(valueStr, ", ");
                attributes = new LinkedList<String>();
                while (tokenizer.hasMoreTokens()) {
                    attributes.add(tokenizer.nextToken());
                }
                this.controls.add((Control)PreReadRequestControl.newControl((boolean)true, attributes));
            }
            if (postReadAttributes.isPresent()) {
                String valueStr = postReadAttributes.getValue();
                tokenizer = new StringTokenizer(valueStr, ", ");
                attributes = new LinkedList();
                while (tokenizer.hasMoreTokens()) {
                    attributes.add(tokenizer.nextToken());
                }
                PostReadRequestControl control = PostReadRequestControl.newControl((boolean)true, attributes);
                this.controls.add((Control)control);
            }
            this.writer = new LDIFEntryWriter((OutputStream)this.getOutputStream());
            VisitorImpl visitor = new VisitorImpl();
            reader = null;
            try {
                int n;
                if (!noop.isPresent()) {
                    try {
                        this.connection = connectionFactory.getConnection();
                        if (bindRequest != null) {
                            Utils.printPasswordPolicyResults(this, this.connection.bind(bindRequest));
                        }
                    }
                    catch (LdapException ere) {
                        int control = Utils.printErrorMessage(this, ere);
                        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{reader, this.connection});
                        return control;
                    }
                }
                if (filename.isPresent()) {
                    try {
                        reader = new LDIFChangeRecordReader((InputStream)new FileInputStream(filename.getValue()));
                    }
                    catch (Exception e) {
                        LocalizableMessage message = ToolsMessages.ERR_LDIF_FILE_CANNOT_OPEN_FOR_READ.get((Object)filename.getValue(), (Object)e.getLocalizedMessage());
                        this.errPrintln(message);
                        int n2 = ResultCode.CLIENT_SIDE_PARAM_ERROR.intValue();
                        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{reader, this.connection});
                        return n2;
                    }
                } else {
                    reader = new LDIFChangeRecordReader(this.getInputStream());
                }
                while (true) {
                    if (!reader.hasNext()) break block37;
                    ChangeRecord cr = reader.readChangeRecord();
                    int result = (Integer)cr.accept((ChangeRecordVisitor)visitor, null);
                    if (result == 0 || continueOnError.isPresent()) break block38;
                    n = result;
                    break;
                }
                {
                    catch (IOException ioe) {
                        this.errPrintln(ToolsMessages.ERR_LDIF_FILE_READ_ERROR.get((Object)filename.getValue(), (Object)ioe.getLocalizedMessage()));
                        int n3 = ResultCode.CLIENT_SIDE_LOCAL_ERROR.intValue();
                        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{reader, this.connection});
                        return n3;
                    }
                }
                {
                    block38: {
                        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{reader, this.connection});
                        return n;
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{reader, this.connection});
                throw throwable;
            }
        }
        org.forgerock.util.Utils.closeSilently((Closeable[])new Closeable[]{reader, this.connection});
        return ResultCode.SUCCESS.intValue();
    }

    private class VisitorImpl
    implements ChangeRecordVisitor<Integer, Void> {
        private VisitorImpl() {
        }

        public Integer visitChangeRecord(Void aVoid, AddRequest change) {
            for (Control control : LDAPModify.this.controls) {
                change.addControl(control);
            }
            String opType = "ADD";
            LDAPModify.this.println(ToolsMessages.INFO_PROCESSING_OPERATION.get((Object)"ADD", (Object)change.getName().toString()));
            if (LDAPModify.this.connection != null) {
                try {
                    Result r = LDAPModify.this.connection.add(change);
                    this.printResult("ADD", change.getName().toString(), r);
                    return r.getResultCode().intValue();
                }
                catch (LdapException ere) {
                    return Utils.printErrorMessage(LDAPModify.this, ere);
                }
            }
            return ResultCode.SUCCESS.intValue();
        }

        public Integer visitChangeRecord(Void aVoid, DeleteRequest change) {
            for (Control control : LDAPModify.this.controls) {
                change.addControl(control);
            }
            String opType = "DELETE";
            LDAPModify.this.println(ToolsMessages.INFO_PROCESSING_OPERATION.get((Object)"DELETE", (Object)change.getName().toString()));
            if (LDAPModify.this.connection != null) {
                try {
                    Result r = LDAPModify.this.connection.delete(change);
                    this.printResult("DELETE", change.getName().toString(), r);
                    return r.getResultCode().intValue();
                }
                catch (LdapException ere) {
                    return Utils.printErrorMessage(LDAPModify.this, ere);
                }
            }
            return ResultCode.SUCCESS.intValue();
        }

        public Integer visitChangeRecord(Void aVoid, ModifyDNRequest change) {
            for (Control control : LDAPModify.this.controls) {
                change.addControl(control);
            }
            String opType = "MODIFY DN";
            LDAPModify.this.println(ToolsMessages.INFO_PROCESSING_OPERATION.get((Object)"MODIFY DN", (Object)change.getName().toString()));
            if (LDAPModify.this.connection != null) {
                try {
                    Result r = LDAPModify.this.connection.modifyDN(change);
                    this.printResult("MODIFY DN", change.getName().toString(), r);
                    return r.getResultCode().intValue();
                }
                catch (LdapException ere) {
                    return Utils.printErrorMessage(LDAPModify.this, ere);
                }
            }
            return ResultCode.SUCCESS.intValue();
        }

        public Integer visitChangeRecord(Void aVoid, ModifyRequest change) {
            for (Control control : LDAPModify.this.controls) {
                change.addControl(control);
            }
            String opType = "MODIFY";
            LDAPModify.this.println(ToolsMessages.INFO_PROCESSING_OPERATION.get((Object)"MODIFY", (Object)change.getName().toString()));
            if (LDAPModify.this.connection != null) {
                try {
                    Result r = LDAPModify.this.connection.modify(change);
                    this.printResult("MODIFY", change.getName().toString(), r);
                    return r.getResultCode().intValue();
                }
                catch (LdapException ere) {
                    return Utils.printErrorMessage(LDAPModify.this, ere);
                }
            }
            return ResultCode.SUCCESS.intValue();
        }

        private void printResult(String operationType, String name, Result r) {
            PreReadResponseControl control;
            if (r.getResultCode() != ResultCode.SUCCESS && r.getResultCode() != ResultCode.REFERRAL) {
                LocalizableMessage msg = ToolsMessages.INFO_OPERATION_FAILED.get((Object)operationType);
                LDAPModify.this.errPrintln(msg);
                LDAPModify.this.errPrintln(ToolsMessages.ERR_TOOL_RESULT_CODE.get((Object)r.getResultCode().intValue(), (Object)r.getResultCode()));
                if (r.getDiagnosticMessage() != null && r.getDiagnosticMessage().length() > 0) {
                    LDAPModify.this.errPrintln(LocalizableMessage.raw((CharSequence)r.getDiagnosticMessage(), (Object[])new Object[0]));
                }
                if (r.getMatchedDN() != null && r.getMatchedDN().length() > 0) {
                    LDAPModify.this.errPrintln(ToolsMessages.ERR_TOOL_MATCHED_DN.get((Object)r.getMatchedDN()));
                }
            } else {
                LDAPModify.this.println(ToolsMessages.INFO_OPERATION_SUCCESSFUL.get((Object)operationType, (Object)name));
                if (r.getDiagnosticMessage() != null && r.getDiagnosticMessage().length() > 0) {
                    LDAPModify.this.errPrintln(LocalizableMessage.raw((CharSequence)r.getDiagnosticMessage(), (Object[])new Object[0]));
                }
                if (r.getReferralURIs() != null) {
                    for (String uri : r.getReferralURIs()) {
                        LDAPModify.this.println(LocalizableMessage.raw((CharSequence)uri, (Object[])new Object[0]));
                    }
                }
            }
            try {
                control = (PreReadResponseControl)r.getControl(PreReadResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPModify.this.println(ToolsMessages.INFO_LDAPMODIFY_PREREAD_ENTRY.get());
                    LDAPModify.this.writer.writeEntry(control.getEntry());
                }
            }
            catch (DecodeException de) {
                LDAPModify.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            try {
                control = (PostReadResponseControl)r.getControl(PostReadResponseControl.DECODER, new DecodeOptions());
                if (control != null) {
                    LDAPModify.this.println(ToolsMessages.INFO_LDAPMODIFY_POSTREAD_ENTRY.get());
                    LDAPModify.this.writer.writeEntry(control.getEntry());
                }
            }
            catch (DecodeException de) {
                LDAPModify.this.errPrintln(ToolsMessages.ERR_DECODE_CONTROL_FAILURE.get((Object)de.getLocalizedMessage()));
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }
}

